/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.Contact;
import at.emini.physics2D.PhysicsEventListener;
import at.emini.physics2D.Script;
import at.emini.physics2D.Shape;
import at.emini.physics2D.UserData;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class Event {
    public static final int TYPE_BODY_POSITION = 0;
    public static final int TYPE_BODY_VELOCITY = 1;
    public static final int TYPE_BODY_ROTATION = 2;
    public static final int TYPE_BODY_ANGULARVELOCITY = 3;
    public static final int TYPE_BODY_COLLISION = 4;
    public static final int TYPE_BODY_COLLISION_RELATIVE = 6;
    public static final int TYPE_BODY_SENSOR = 5;
    public static final int TYPE_CONSTRAINT_FORCE = 10;
    private int b;
    int a = -1;
    private boolean c = false;
    private int d;
    private int e;
    private int f;
    private int g;
    private Object h;
    private Body i;
    private Shape j;
    private Constraint k;
    private Script l;
    private Vector m = null;
    private UserData n = null;
    private static FXMatrix o = new FXMatrix();
    private static FXVector p = new FXVector();
    private static FXVector q = new FXVector();

    public static Event createBodyEvent(Body body, Shape shape, int n, int n2, int n3, int n4, int n5) {
        return new Event(body, shape, null, n, n2, n3, n4, n5, null);
    }

    public static Event createCollisionRelativeEvent(Body body, Shape shape, int n, int n2) {
        long l = (long)n * 52707178L / 180L;
        n = FXUtil.wrapAngleFX((int)((long)n2 * 52707178L / 180L - l) / 2);
        n = FXUtil.wrapAngleFX((int)(l + (long)n));
        o.setRotationMatrix(n);
        o.mult(FXVector.M_UNITY, p);
        o.setRotationMatrix((int)l);
        o.mult(FXVector.M_UNITY, q);
        n2 = (int)((long)Event.p.xFX * (long)Event.q.xFX + (long)Event.p.yFX * (long)Event.q.yFX >> 12);
        return new Event(body, shape, null, 6, n, n2, 0, 0, null);
    }

    public static Event createBodySensorEvent(Body body, Shape shape, Body body2) {
        body2.a(0);
        return new Event(body, shape, null, 5, 0, 0, 0, 0, body2);
    }

    public static Event createConstraintEvent(Constraint constraint, int n, int n2, int n3) {
        return new Event(null, null, constraint, n, n2, n3, 0, 0, null);
    }

    private Event(Body body, Shape shape, Constraint constraint, int n, int n2, int n3, int n4, int n5, Object object) {
        this.a = -1;
        this.b = n;
        this.h = object;
        switch (n) {
            case 2: 
            case 3: {
                this.d = n2 * 52707178 / 180;
                this.e = n3 * 52707178 / 180;
                break;
            }
            case 1: {
                this.d = n2 * n2 << 12;
                this.e = n3 * n3 << 12;
                break;
            }
            case 6: {
                this.d = n2;
                this.e = n3;
                break;
            }
            default: {
                this.d = n2 << 12;
                this.e = n3 << 12;
                this.f = n4 << 12;
                this.g = n5 << 12;
            }
        }
        this.i = body;
        this.j = shape;
        this.k = constraint;
    }

    private Event(Event event, Body[] bodyArray) {
        this(bodyArray != null && event.i != null ? bodyArray[event.i.o] : event.i, event.j, event.k, event.b, 0, 0, 0, 0, event.h != null && event.h instanceof Body && bodyArray != null && ((Body)event.h).o >= 0 ? bodyArray[((Body)event.h).o] : event.h);
        this.d = event.d;
        this.e = event.e;
        this.f = event.f;
        this.g = event.g;
        if (event.n != null) {
            this.n = event.n.copy();
        }
        this.setTriggerOnce(event.c);
    }

    private Event(int n) {
        this.b = n;
    }

    public Event copy(Body[] bodyArray) {
        return new Event(this, bodyArray);
    }

    public static Event loadEvent(PhysicsFileReader physicsFileReader, World world, UserData userData) {
        int n;
        int n2 = physicsFileReader.next();
        int n3 = physicsFileReader.getVersion();
        if ((n3 & 0xFF00) < 1024) {
            physicsFileReader.next();
        }
        Event event = new Event(n2);
        if ((n3 & 0xFF00) >= 1024) {
            event.setTriggerOnce(physicsFileReader.next() > 0);
        }
        if ((n = physicsFileReader.next()) >= 0 && n != 255) {
            event.i = world.getBodies()[n];
        }
        if ((n = physicsFileReader.next()) >= 0 && n != 255) {
            event.j = (Shape)world.getShapeSet().getShapes().elementAt(n);
        }
        if ((n3 & 0xFF00) >= 1024 && (n3 = physicsFileReader.next()) >= 0 && n3 != 255) {
            event.k = world.getConstraints()[n3];
        }
        event.d = physicsFileReader.nextIntFX();
        event.e = physicsFileReader.nextIntFX();
        event.f = physicsFileReader.nextIntFX();
        event.g = physicsFileReader.nextIntFX();
        if (event.b == 5) {
            Body body = Body.loadBody(physicsFileReader, world.a.getShapes(), userData);
            event.h = body;
        }
        if (physicsFileReader.getVersion() > 1792) {
            String string = physicsFileReader.nextString();
            if (userData != null) {
                event.n = userData.createNewUserData(string, 3);
            }
        }
        return event;
    }

    public int getIdentifier() {
        return this.a;
    }

    public int type() {
        return this.b;
    }

    public void setScript(Script script) {
        this.l = script;
    }

    public void setBodyFilter(Body body) {
        this.i = body;
    }

    public Body getBodyFilter() {
        return this.i;
    }

    public void setShapeFilter(Shape shape) {
        this.j = shape;
    }

    public Shape getShapeFilter() {
        return this.j;
    }

    public Object getTargetObject() {
        return this.h;
    }

    public Constraint getConstraintFilter() {
        return this.k;
    }

    public void setTriggerOnce(boolean bl) {
        this.c = bl;
        if (bl) {
            this.m = new Vector();
            return;
        }
        this.m = null;
    }

    public boolean getTriggerOnce() {
        return this.c;
    }

    public boolean checkEvent(World world, PhysicsEventListener physicsEventListener) {
        if (physicsEventListener == null) {
            return false;
        }
        boolean bl = false;
        switch (this.b) {
            case 10: {
                if (this.k != null) {
                    bl = this.a(this.k, physicsEventListener);
                    break;
                }
                for (int i = 0; i < world.h; ++i) {
                    bl |= this.a(world.i[i], physicsEventListener);
                }
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                if (this.i != null) {
                    bl = this.a(world, this.i, physicsEventListener);
                    break;
                }
                for (int i = 0; i < world.b; ++i) {
                    bl |= this.a(world, world.c[i], physicsEventListener);
                }
                break;
            }
            case 5: {
                if (this.i != null) {
                    bl = this.a(world, this.i, physicsEventListener);
                    break;
                }
                Body[] bodyArray = world.c;
                Body body = (Body)this.h;
                for (int i = 0; i < world.b; ++i) {
                    if (!bodyArray[i].e || bodyArray[i].l > body.m || body.l > bodyArray[i].m || bodyArray[i].j > body.k || body.j > bodyArray[i].k) continue;
                    bl |= this.a(world, bodyArray[i], physicsEventListener);
                }
                break;
            }
        }
        return bl;
    }

    private final boolean a(World world, Body body, PhysicsEventListener physicsEventListener) {
        if (this.j != null && body.h != this.j) {
            return false;
        }
        Object object = null;
        boolean bl = false;
        block0 : switch (this.b) {
            case 0: {
                if (this.d > body.a.xFX || body.a.xFX > this.f || this.e > body.a.yFX || body.a.yFX > this.g) break;
                bl = true;
                object = body;
                break;
            }
            case 1: {
                int n = body.b.lengthSquareFX();
                if (this.d > n || n > this.e) break;
                bl = true;
                object = body;
                break;
            }
            case 2: {
                if (this.d > body.c || body.c > this.e) break;
                bl = true;
                object = body;
                break;
            }
            case 3: {
                if (this.d > body.d || body.d > this.e) break;
                bl = true;
                object = body;
                break;
            }
            case 4: {
                Contact[] contactArray = body.getContacts();
                for (int i = 0; i < contactArray.length && contactArray[i] != null; ++i) {
                    if (!(this.d > 0 && contactArray[i].e.yFX < body.a.yFX || this.e > 0 && contactArray[i].e.xFX > body.a.xFX || this.f > 0 && contactArray[i].e.yFX > body.a.yFX) && (this.g <= 0 || contactArray[i].e.xFX >= body.a.xFX)) continue;
                    bl = true;
                    object = contactArray[i];
                    break block0;
                }
                break;
            }
            case 6: {
                int n = FXUtil.wrapAngleFX(this.d + body.rotation2FX());
                o.setRotationMatrix(n);
                o.mult(FXVector.M_UNITY, p);
                Contact[] contactArray = body.getContacts();
                for (n = 0; n < contactArray.length && contactArray[n] != null; ++n) {
                    q.assignDiff(body.a, contactArray[n].e);
                    q.normalize();
                    if ((long)Event.p.xFX * (long)Event.q.xFX + (long)Event.p.yFX * (long)Event.q.yFX >> 12 >= (long)this.e) {
                        bl = true;
                        object = contactArray[n];
                        break block0;
                    }
                    if (contactArray[n].isSingle()) continue;
                    q.assignDiff(body.a, contactArray[n].f);
                    q.normalize();
                    if ((long)Event.p.xFX * (long)Event.q.xFX + (long)Event.p.yFX * (long)Event.q.yFX >> 12 < (long)this.e) continue;
                    bl = true;
                    object = contactArray[n];
                    break block0;
                }
                break;
            }
            case 5: {
                if (Collision.detectCollision(body, (Body)this.h) == null) break;
                bl = true;
                object = body;
            }
        }
        if (bl) {
            if (!this.c || this.a(object)) {
                if (this.l == null) {
                    physicsEventListener.eventTriggered(this, object);
                } else {
                    this.l.applyToBody(body, world);
                }
            }
        } else if (this.c) {
            this.b(object);
        }
        return bl;
    }

    private final boolean a(Constraint constraint, PhysicsEventListener physicsEventListener) {
        switch (this.b) {
            case 10: {
                int n = constraint.getImpulseFX();
                if (this.d <= n && n <= this.e) {
                    if (!this.c || this.a(constraint)) {
                        physicsEventListener.eventTriggered(this, constraint);
                    }
                    return true;
                }
                if (!this.c) break;
                this.b(constraint);
            }
        }
        return false;
    }

    private boolean a(Object object) {
        if (this.m.contains(object)) {
            return false;
        }
        this.m.addElement(object);
        return true;
    }

    private void b(Object object) {
        this.m.removeElement(object);
    }

    public UserData getUserData() {
        return this.n;
    }

    public void setUserData(UserData userData) {
        this.n = userData;
    }
}

