/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.dataaccess;

import de.kugihan.dictionaryformids.dataaccess.CsvFileCache;
import de.kugihan.dictionaryformids.dataaccess.DfMInputStream;
import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.general.DictionaryInterruptedException;
import de.kugihan.dictionaryformids.general.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;

public class CsvFile {
    public static boolean selectedBypassCharsetDecoding = false;
    public boolean endOfDictionaryReached = false;
    protected fileStorage fileStorageObj;
    protected int position = 0;
    protected int columnNumber = 0;
    protected char separatorCharacter;
    protected String fileName;
    protected int maxSizeOfFileData;
    protected String charEncoding;
    static CsvFileCache fileCache = new CsvFileCache();

    public CsvFile(String string, char c, String string2, int n) throws DictionaryException {
        this.setParams(string, c, string2, n);
        this.readCsvFileComplete();
    }

    public CsvFile(String string, char c, String string2, int n, int n2) throws DictionaryException {
        this.setParams(string, c, string2, n);
        this.readCsvFileLine(n2);
    }

    private void setParams(String string, char c, String string2, int n) {
        this.separatorCharacter = c;
        this.charEncoding = string2;
        this.maxSizeOfFileData = n;
        this.fileName = string;
    }

    public void readCsvFileComplete() throws DictionaryException {
        byte[] byArray = new byte[this.maxSizeOfFileData];
        try {
            int n;
            long l = System.currentTimeMillis();
            InputStream inputStream = DfMInputStream.getDfMInputStream().getInputStream(this.fileName);
            Util.getUtil().logTime("open file", l);
            l = System.currentTimeMillis();
            if (inputStream != null) {
                int n2;
                n = 0;
                do {
                    if ((n2 = inputStream.read(byArray, n, byArray.length - n)) != -1) {
                        n += n2;
                    }
                    if (n != byArray.length) continue;
                    int n3 = inputStream.read();
                    if (n3 == -1) break;
                    Util.getUtil().log("Warning: buffer size too small for file " + this.fileName);
                    break;
                } while (n2 != -1);
            } else {
                throw new DictionaryException("Could not open file " + this.fileName);
            }
            inputStream.close();
            Util.getUtil().logTime("read file", l);
            l = System.currentTimeMillis();
            this.fileStorageObj = selectedBypassCharsetDecoding ? new byteFileStorage(byArray, n) : new stringFileStorage(byArray, n, this.charEncoding);
            Util.getUtil().logTime("parse file", l);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new DictionaryInterruptedException(interruptedIOException);
        }
        catch (IOException iOException) {
            throw new DictionaryException(iOException);
        }
    }

    public void readCsvFileLine(int n) throws DictionaryException {
        if (!selectedBypassCharsetDecoding) {
            try {
                InputStream inputStream = fileCache.getCsvFile(this.fileName, n, this);
                long l = System.currentTimeMillis();
                int n2 = 0;
                StringBuffer stringBuffer = new StringBuffer();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, this.charEncoding);
                boolean bl = false;
                do {
                    int n3;
                    if ((n3 = inputStreamReader.read()) != 10 && n3 != -1) {
                        stringBuffer.append((char)n3);
                        ++n2;
                        continue;
                    }
                    bl = true;
                } while (!bl);
                Util.getUtil().logTime("read/parse file-line", l);
                this.fileStorageObj = new stringFileStorage(stringBuffer);
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new DictionaryInterruptedException(interruptedIOException);
            }
            catch (IOException iOException) {
                throw new DictionaryException(iOException);
            }
        } else {
            this.readCsvFileComplete();
            this.setPosition(n);
        }
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public final void skipRestOfLine() {
        int n = this.fileStorageObj.getCharactersInFile();
        boolean bl = false;
        if (this.position < n) {
            do {
                char c = this.fileStorageObj.readCharacterAt(this.position);
                if (this.position == n - 1) {
                    bl = true;
                    this.endOfDictionaryReached = true;
                    continue;
                }
                if (c == '\n') {
                    this.columnNumber = 0;
                    bl = true;
                    ++this.position;
                    continue;
                }
                ++this.position;
            } while (!bl);
        }
    }

    public final StringBuffer getWord() {
        int n = this.fileStorageObj.getCharactersInFile();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        stringBuffer.setLength(0);
        if (this.position < n) {
            do {
                char c;
                if ((c = this.fileStorageObj.readCharacterAt(this.position)) == '\n') {
                    this.columnNumber = 0;
                    bl = true;
                    ++this.position;
                } else if (c == this.separatorCharacter) {
                    ++this.columnNumber;
                    bl = true;
                    ++this.position;
                } else {
                    if (c != '\r') {
                        stringBuffer.append(c);
                    }
                    ++this.position;
                }
                if (this.position != n) continue;
                bl = true;
                this.endOfDictionaryReached = true;
            } while (!bl);
        }
        return stringBuffer;
    }

    public void setPositionBefore(String string) {
        int n;
        block6: {
            int n2 = this.fileStorageObj.getCharactersInFile();
            n = 0;
            int n3 = n2 / 2;
            int n4 = n2 - 1;
            int n5 = 0;
            while (true) {
                ++n5;
                while (n3 < n2 && this.fileStorageObj.readCharacterAt(n3) != '\n') {
                    ++n3;
                }
                if (++n3 >= n2) break block6;
                this.position = n3;
                StringBuffer stringBuffer = this.getWord();
                int n6 = string.compareTo(stringBuffer.toString());
                if (n6 < 0) {
                    if (n3 != n4) {
                        n4 = n3;
                        n3 -= (n3 - n) / 2;
                        continue;
                    }
                    break block6;
                }
                if (n6 > 0) {
                    if (n3 != n4) {
                        n = n3;
                        n3 += (n4 - n3) / 2;
                        continue;
                    }
                    break block6;
                }
                if (n6 == 0) break;
            }
            n = n3;
        }
        this.position = n;
        Util.getUtil().log("pos before: " + this.position, 3);
    }

    public class stringFileStorage
    implements fileStorage {
        int charactersInFile;
        public String stringStorage;

        public stringFileStorage(StringBuffer stringBuffer) throws IOException {
            this.stringStorage = stringBuffer.toString();
            this.charactersInFile = this.stringStorage.length();
        }

        public stringFileStorage(byte[] byArray, int n, String string) throws IOException {
            this.stringStorage = new String(byArray, 0, n, string);
            this.charactersInFile = this.stringStorage.length();
        }

        public int getCharactersInFile() {
            return this.charactersInFile;
        }

        public char readCharacterAt(int n) {
            return this.stringStorage.charAt(n);
        }
    }

    public class byteFileStorage
    implements fileStorage {
        int charactersInFile;
        byte[] byteStorage;

        public byteFileStorage(byte[] byArray, int n) {
            this.byteStorage = byArray;
            this.charactersInFile = n;
        }

        public int getCharactersInFile() {
            return this.charactersInFile;
        }

        public char readCharacterAt(int n) {
            return (char)this.byteStorage[n];
        }
    }

    public static interface fileStorage {
        public int getCharactersInFile();

        public char readCharacterAt(int var1);
    }
}

