/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.dataaccess;

import de.kugihan.dictionaryformids.dataaccess.CsvFile;
import de.kugihan.dictionaryformids.dataaccess.DfMInputStream;
import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.general.Util;
import java.io.IOException;
import java.io.InputStream;

class CsvFileCache {
    protected InputStream cachedFile = null;
    protected String fileName = null;
    protected int lastPositionInStream;

    CsvFileCache() {
    }

    synchronized InputStream getCsvFile(String string, int n, CsvFile csvFile) throws IOException, DictionaryException {
        long l = System.currentTimeMillis();
        InputStream inputStream = null;
        if (this.cachedFile != null && this.fileName.equals(string)) {
            System.out.println("cache hit " + string);
            int n2 = n - this.lastPositionInStream;
            if (n2 < 0) {
                DfMInputStream.getDfMInputStream().getInputStream(string);
                n2 = n;
            } else {
                this.cachedFile.reset();
            }
            long l2 = this.cachedFile.skip(n2);
            if (l2 != (long)n2) {
                throw new DictionaryException("CSV file: skipped only " + l2 + " bytes");
            }
            this.lastPositionInStream = n;
            inputStream = this.cachedFile;
        } else {
            this.fileName = string;
            this.lastPositionInStream = n;
            if (this.cachedFile != null) {
                this.cachedFile.close();
            }
            inputStream = DfMInputStream.getDfMInputStream().getInputStream(this.fileName);
            Util.getUtil().logTime("open file", l);
            l = System.currentTimeMillis();
            if (inputStream != null) {
                long l3 = inputStream.skip(n);
                Util.getUtil().logTime("position file", l);
                if (l3 != (long)n) {
                    throw new DictionaryException("CSV file: skipped only " + l3 + " bytes");
                }
                if (inputStream.markSupported()) {
                    inputStream.mark(20000);
                }
            } else {
                throw new DictionaryException("Could not open file " + this.fileName);
            }
        }
        return inputStream;
    }
}

