/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.dataaccess;

import de.kugihan.dictionaryformids.dataaccess.DictionaryUpdateIF;
import de.kugihan.dictionaryformids.dataaccess.LanguageDefinition;
import de.kugihan.dictionaryformids.dataaccess.content.ContentDefinition;
import de.kugihan.dictionaryformids.dataaccess.content.FontStyle;
import de.kugihan.dictionaryformids.dataaccess.content.PredefinedContent;
import de.kugihan.dictionaryformids.dataaccess.content.RGBColour;
import de.kugihan.dictionaryformids.dataaccess.content.SelectionMode;
import de.kugihan.dictionaryformids.general.DictionaryClassNotLoadedException;
import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.general.Util;
import de.kugihan.dictionaryformids.hmi_j2me.DictionarySettings;
import de.kugihan.dictionaryformids.translation.normation.Normation;

public class DictionaryDataFile {
    public static int numberOfAvailableLanguages;
    public static int numberOfInputLanguages;
    public static LanguageDefinition[] supportedLanguages;
    public static String infoText;
    public static String dictionaryAbbreviation;
    public static String pathNameFonts;
    public static String pathNameDataFiles;
    public static String prefixSearchListFile;
    public static String suffixSearchListFile;
    public static String searchListCharEncoding;
    public static char searchListFileSeparationCharacter;
    public static int searchListFileMaxSize;
    public static String prefixIndexFile;
    public static String suffixIndexFile;
    public static String indexCharEncoding;
    public static char indexFileSeparationCharacter;
    public static char indexFileSeparatorFileNumberToPosition;
    public static char indexFileSeparatorFilePositionToSearchIndicator;
    public static char indexFileSeparatorIndexEntries;
    public static int indexFileMaxSize;
    public static String prefixDictionaryFile;
    public static String suffixDictionaryFile;
    public static String dictionaryCharEncoding;
    public static char dictionaryFileSeparationCharacter;
    public static int dictionaryFileMaxSize;
    public static String applicationFileNamePrefix;
    public static String propertyFileName;
    public static char contentFontColourSeparationCharacter;
    public static String dictionaryGenerationInputCharEncoding;
    public static char dictionaryGenerationSeparatorCharacter;
    public static long dictionaryGenerationMinNumberOfEntriesPerDictionaryFile;
    public static long dictionaryGenerationMinNumberOfEntriesPerIndexFile;
    public static String fileEncodingFormat;
    public static String dictionaryPath;
    static /* synthetic */ Class class$de$kugihan$dictionaryformids$translation$normation$Normation;

    public static void initValues(boolean bl) throws DictionaryException {
        Object object;
        String string;
        String string2;
        Util util = Util.getUtil();
        util.openProperties();
        infoText = util.getDictionaryPropertyString("infoText");
        dictionaryAbbreviation = util.getDictionaryPropertyString("dictionaryAbbreviation", true);
        DictionaryDataFile.checkForEmptyProperty(dictionaryAbbreviation);
        numberOfAvailableLanguages = util.getDictionaryPropertyInt("numberOfAvailableLanguages");
        numberOfInputLanguages = 0;
        supportedLanguages = new LanguageDefinition[numberOfAvailableLanguages];
        for (int i = 0; i < numberOfAvailableLanguages; ++i) {
            string2 = String.valueOf(i + 1);
            String string3 = "language" + string2;
            string = util.getDictionaryPropertyString(string3 + "DisplayText");
            object = util.getDictionaryPropertyString(string3 + "FilePostfix");
            boolean bl2 = util.getDictionaryPropertyBooleanDefault(string3 + "IsSearchable", true);
            if (bl2) {
                ++numberOfInputLanguages;
            }
            boolean bl3 = util.getDictionaryPropertyBooleanDefault(string3 + "HasSeparateDictionaryFile", false);
            boolean bl4 = util.getDictionaryPropertyBooleanDefault(string3 + "GenerateIndex", true);
            String string4 = util.getDictionaryPropertyString(string3 + "NormationClassName", true);
            DictionaryDataFile.checkForEmptyProperty(string4);
            String string5 = util.getDictionaryPropertyString(string3 + "DictionaryUpdateClassName", true);
            DictionaryDataFile.checkForEmptyProperty(string5);
            String string6 = null;
            if (bl) {
                string6 = util.getDictionaryPropertyString("dictionaryGenerationLanguage" + string2 + "ExpressionSplitString", true);
                DictionaryDataFile.checkForEmptyProperty(string6);
            }
            boolean bl5 = false;
            ContentDefinition[] contentDefinitionArray = null;
            int n = 1;
            String string7 = util.getDictionaryPropertyString(string3 + "NumberOfContentDeclarations", true);
            if (string7 != null) {
                n = Integer.valueOf(string7) + 1;
                bl5 = true;
            }
            contentDefinitionArray = new ContentDefinition[n];
            contentDefinitionArray[0] = PredefinedContent.getContentNoDefinitionProvided();
            for (int j = 0; j < n; ++j) {
                String string8;
                String string9;
                Object object2;
                String string10;
                String string11 = String.valueOf(j);
                if (string11.length() == 1) {
                    string11 = '0' + string11;
                } else if (string11.length() > 2) {
                    throw new DictionaryException("Number of contents too big");
                }
                String string12 = string3 + "Content" + string11;
                String string13 = string12 + "DisplayText";
                String string14 = util.getDictionaryPropertyString(string13, true);
                if (string14 == null) {
                    if (j == 0) continue;
                    util.propertyNotFound(string13);
                }
                ContentDefinition contentDefinition = string14.startsWith("content") ? PredefinedContent.getPredefinedContent(string14) : new ContentDefinition(string14);
                String string15 = util.getDictionaryPropertyString(string12 + "FontColour", true);
                if (string15 != null) {
                    RGBColour rGBColour = DictionaryDataFile.determineRGBColourFromProperty(string15, string12);
                    contentDefinition.setFontColour(rGBColour);
                }
                if ((string10 = util.getDictionaryPropertyString(string12 + "FontStyle", true)) != null) {
                    object2 = null;
                    if (Util.stringEqualIgnoreCase(string10, "plain")) {
                        object2 = PredefinedContent.fontStylePlain;
                    } else if (Util.stringEqualIgnoreCase(string10, "underlined")) {
                        object2 = PredefinedContent.fontStyleUnderlined;
                    } else if (Util.stringEqualIgnoreCase(string10, "bold")) {
                        object2 = PredefinedContent.fontStyleBold;
                    } else if (Util.stringEqualIgnoreCase(string10, "italic")) {
                        object2 = PredefinedContent.fontStyleItalic;
                    } else {
                        DictionaryDataFile.throwContentException("Incorrect font style", string12);
                    }
                    contentDefinition.setFontStyle((FontStyle)object2);
                }
                if ((string9 = util.getDictionaryPropertyString((String)(object2 = new String(string12 + "DisplaySelectable")), true)) != null) {
                    boolean bl6 = util.getBooleanFromProperty((String)object2, string9);
                    contentDefinition.setDisplaySelectable(bl6);
                }
                if ((string8 = util.getDictionaryPropertyString(string12 + "SelectionMode", true)) != null) {
                    SelectionMode selectionMode = null;
                    if (Util.stringEqualIgnoreCase(string8, "none")) {
                        selectionMode = PredefinedContent.selectionModeNone;
                    } else if (Util.stringEqualIgnoreCase(string8, "single")) {
                        selectionMode = PredefinedContent.selectionModeSingle;
                    } else if (Util.stringEqualIgnoreCase(string8, "all")) {
                        selectionMode = PredefinedContent.selectionModeAll;
                    } else {
                        DictionaryDataFile.throwContentException("Incorrect selection mode", string12);
                    }
                    contentDefinition.setSelectionMode(selectionMode);
                }
                contentDefinitionArray[j] = contentDefinition;
            }
            DictionaryDataFile.supportedLanguages[i] = new LanguageDefinition(string, (String)object, bl2, bl3, string4, bl5, contentDefinitionArray, string5, bl4, string6);
        }
        searchListCharEncoding = util.getDictionaryPropertyString("searchListCharEncoding");
        Util.setDeviceCharEncoding(searchListCharEncoding);
        searchListFileSeparationCharacter = util.getDictionaryPropertyChar("searchListFileSeparationCharacter");
        searchListFileMaxSize = util.getDictionaryPropertyIntDefault("searchListFileMaxSize", 10000);
        indexCharEncoding = util.getDictionaryPropertyString("indexCharEncoding");
        Util.setDeviceCharEncoding(indexCharEncoding);
        indexFileSeparationCharacter = util.getDictionaryPropertyChar("indexFileSeparationCharacter");
        indexFileMaxSize = util.getDictionaryPropertyIntDefault("indexFileMaxSize", 10000);
        dictionaryCharEncoding = util.getDictionaryPropertyString("dictionaryCharEncoding");
        Util.setDeviceCharEncoding(dictionaryCharEncoding);
        dictionaryFileSeparationCharacter = util.getDictionaryPropertyChar("dictionaryFileSeparationCharacter");
        dictionaryFileMaxSize = util.getDictionaryPropertyIntDefault("dictionaryFileMaxSize", 10000);
        String string16 = "backgroundColour";
        string2 = util.getDictionaryPropertyString(string16, true);
        if (string2 == null) {
            DictionarySettings.setUseBackgroundColour(false);
            DictionarySettings.setBackgroundColour(null);
        } else {
            DictionarySettings.setUseBackgroundColour(true);
            if (Util.stringEqualIgnoreCase(string2, "backgroundColourDefault")) {
                DictionarySettings.setBackgroundColour(PredefinedContent.backgroundColourDefault);
            } else {
                DictionarySettings.setBackgroundColour(DictionaryDataFile.determineRGBColourFromProperty(string2, string16));
            }
        }
        if (bl) {
            dictionaryGenerationInputCharEncoding = util.getDictionaryPropertyStringDefault("dictionaryGenerationInputCharEncoding", "ISO-8859-1");
            dictionaryGenerationSeparatorCharacter = util.getDictionaryPropertyCharDefault("dictionaryGenerationSeparatorCharacter", '\t');
            dictionaryGenerationMinNumberOfEntriesPerDictionaryFile = util.getDictionaryPropertyIntDefault("dictionaryGenerationMinNumberOfEntriesPerDictionaryFile", 200);
            dictionaryGenerationMinNumberOfEntriesPerIndexFile = util.getDictionaryPropertyIntDefault("dictionaryGenerationMinNumberOfEntriesPerIndexFile", 500);
        }
        if ((fileEncodingFormat = util.getDictionaryPropertyString("fileEncodingFormat", true)) == null) {
            fileEncodingFormat = new String("plain_format1");
        }
        util.closeProperties();
        for (int i = 0; i < numberOfAvailableLanguages; ++i) {
            DictionaryUpdateIF dictionaryUpdateIF;
            string = DictionaryDataFile.supportedLanguages[i].normationClassName;
            DictionaryDataFile.supportedLanguages[i].normationObj = object = (Normation)DictionaryDataFile.getObjectForClass(string, (class$de$kugihan$dictionaryformids$translation$normation$Normation == null ? DictionaryDataFile.class$("de.kugihan.dictionaryformids.translation.normation.Normation") : class$de$kugihan$dictionaryformids$translation$normation$Normation).getName(), "de.kugihan.dictionaryformids.translation.normation", "de.kugihan.dictionaryformids.translation");
            if (!bl) continue;
            String string17 = DictionaryDataFile.supportedLanguages[i].dictionaryUpdateClassName;
            DictionaryDataFile.supportedLanguages[i].dictionaryUpdateObj = dictionaryUpdateIF = (DictionaryUpdateIF)DictionaryDataFile.getObjectForClass(string17, "de.kugihan.dictionaryformids.dictgen.dictionaryupdate.DictionaryUpdate", "de.kugihan.dictionaryformids.dictgen.dictionaryupdate", "de.kugihan.dictionaryformids.dictgen");
        }
    }

    protected static Object getObjectForClass(String string, String string2, String string3, String string4) throws DictionaryException {
        Object obj;
        if (string == null) {
            string = string2;
        }
        try {
            Class<?> clazz = Class.forName(string);
            obj = clazz.newInstance();
        }
        catch (Exception exception) {
            try {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.delete(0, string4.length());
                String string5 = string3 + stringBuffer.toString();
                Class<?> clazz = Class.forName(string5);
                obj = clazz.newInstance();
            }
            catch (Exception exception2) {
                throw new DictionaryClassNotLoadedException("Class could not be loaded: " + string);
            }
        }
        return obj;
    }

    public static int determineColourComponent(String string, String string2) throws DictionaryException {
        String string3 = string.trim();
        int n = 0;
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            DictionaryDataFile.throwContentException("RGB value is incorrect: " + numberFormatException.getMessage(), string2);
        }
        if (n > 255) {
            DictionaryDataFile.throwContentException("RGB value is bigger than 255", string2);
        }
        return n;
    }

    protected static RGBColour determineRGBColourFromProperty(String string, String string2) throws DictionaryException {
        String[] stringArray = Util.stringSplit(string, contentFontColourSeparationCharacter);
        if (stringArray.length != 3) {
            DictionaryDataFile.throwContentException("3 components reqired for font colour (red, green, blue)", string2);
        }
        int n = DictionaryDataFile.determineColourComponent(stringArray[0], string2);
        int n2 = DictionaryDataFile.determineColourComponent(stringArray[1], string2);
        int n3 = DictionaryDataFile.determineColourComponent(stringArray[2], string2);
        return new RGBColour(n, n2, n3);
    }

    protected static void throwContentException(String string, String string2) throws DictionaryException {
        throw new DictionaryException(string2 + ": " + string);
    }

    static void checkForEmptyProperty(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
    }

    public static void setDictionaryNotAvailable() {
        numberOfAvailableLanguages = 0;
    }

    public static String getPathDataFiles() {
        return "/" + pathNameDataFiles + "/";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        pathNameFonts = "fonts";
        pathNameDataFiles = "dictionary";
        prefixSearchListFile = "searchlist";
        suffixSearchListFile = ".csv";
        prefixIndexFile = "index";
        suffixIndexFile = ".csv";
        indexFileSeparatorFileNumberToPosition = (char)45;
        indexFileSeparatorFilePositionToSearchIndicator = (char)45;
        indexFileSeparatorIndexEntries = (char)44;
        prefixDictionaryFile = "directory";
        suffixDictionaryFile = ".csv";
        applicationFileNamePrefix = "DictionaryForMIDs";
        propertyFileName = applicationFileNamePrefix + ".properties";
        contentFontColourSeparationCharacter = (char)44;
    }
}

