/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.general;

import de.kugihan.dictionaryformids.dataaccess.DictionaryDataFile;
import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.hmi_j2me.DictionaryForMIDs;
import de.kugihan.dictionaryformids.hmi_j2me.uidisplaytext.LanguageUI;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class SettingsStore {
    private RecordStore mobileDictionaryStore;
    private static SettingsStore instanceSettingsStore = null;
    private final int rms_index_defaultValuesSet;
    private final int rms_index_structureVersion;
    private final int rms_index_inputLanguage;
    private final int rms_index_outputLanguage;
    private final int rms_index_showStatistic;
    private final int rms_index_bypassCharsetDecoding;
    private final int rms_index_incrementalSearchEnabled;
    private final int rms_index_maxHits;
    private final int rms_index_fontSize;
    private final int rms_index_uiLanguage;
    private final int rms_index_showTranslationList;
    private final int rms_index_findExactMatches;
    private final int rms_index_addAtBeginNoSearchSubExpressionCharacter;
    private final int rms_index_addAtEndWildcardAnySeriesOfCharacter;
    private final int rms_index_colouredItems;
    private final int rms_index_useBitmapFont;
    private final int rms_index_dictionaryPath;
    private final int rms_max_index;
    private final String rmsStoreName;

    public static SettingsStore getSettingsStore() throws DictionaryException {
        if (instanceSettingsStore == null) {
            instanceSettingsStore = new SettingsStore();
        }
        return instanceSettingsStore;
    }

    public SettingsStore() throws DictionaryException {
        this.rms_index_defaultValuesSet = 1;
        this.rms_index_structureVersion = 2;
        this.rms_index_inputLanguage = 3;
        this.rms_index_outputLanguage = 4;
        this.rms_index_showStatistic = 5;
        this.rms_index_bypassCharsetDecoding = 6;
        this.rms_index_incrementalSearchEnabled = 7;
        this.rms_index_maxHits = 8;
        this.rms_index_fontSize = 9;
        this.rms_index_uiLanguage = 10;
        this.rms_index_showTranslationList = 11;
        this.rms_index_findExactMatches = 12;
        this.rms_index_addAtBeginNoSearchSubExpressionCharacter = 13;
        this.rms_index_addAtEndWildcardAnySeriesOfCharacter = 14;
        this.rms_index_colouredItems = 15;
        this.rms_index_useBitmapFont = 16;
        this.rms_index_dictionaryPath = 17;
        this.rms_max_index = 17;
        this.rmsStoreName = "DictionaryForMIDs";
        try {
            this.mobileDictionaryStore = RecordStore.openRecordStore((String)"DictionaryForMIDs", (boolean)true);
            boolean bl = false;
            if (this.mobileDictionaryStore.getNumRecords() < 17) {
                bl = true;
            } else {
                int n = this.getIntValue(2);
                if (n != DictionaryForMIDs.versionRMSStructure) {
                    bl = true;
                }
            }
            if (bl) {
                this.mobileDictionaryStore.closeRecordStore();
                RecordStore.deleteRecordStore((String)"DictionaryForMIDs");
                this.mobileDictionaryStore = RecordStore.openRecordStore((String)"DictionaryForMIDs", (boolean)true);
                this.addBooleanValue(false);
                this.addIntValue(DictionaryForMIDs.versionRMSStructure);
                this.addIntValue(-1);
                this.addBooleanArrayValue(new boolean[0]);
                this.addBooleanValue(false);
                this.addBooleanValue(false);
                this.addBooleanValue(false);
                this.addIntValue(30);
                this.addIntValue(0);
                this.addIntValue(0);
                this.addBooleanValue(false);
                this.addBooleanValue(false);
                this.addBooleanValue(false);
                this.addBooleanValue(false);
                this.addBooleanValue(DictionaryForMIDs.useMIDP20);
                this.addBooleanValue(false);
                this.addStringValue("");
            }
        }
        catch (RecordStoreException recordStoreException) {
            throw new DictionaryException(recordStoreException);
        }
    }

    public void setDefaultValues() throws DictionaryException {
        int n;
        int n2 = -1;
        int n3 = -1;
        for (int n4 = 0; n4 < DictionaryDataFile.numberOfAvailableLanguages; n4 = (int)((byte)(n4 + 1))) {
            if (n2 != -1) {
                n3 = n4;
                break;
            }
            if (!DictionaryDataFile.supportedLanguages[n4].isSearchable || n2 != -1) continue;
            n2 = n4;
        }
        if (n2 == -1) {
            throw new DictionaryException("No searchable languages defined");
        }
        if (n3 == -1) {
            n3 = 0;
        }
        this.setInputLanguage(n2);
        boolean[] blArray = new boolean[DictionaryDataFile.numberOfAvailableLanguages];
        for (n = 0; n < DictionaryDataFile.numberOfAvailableLanguages; ++n) {
            boolean bl;
            blArray[n] = bl = n == n3;
        }
        this.setOutputLanguage(blArray);
        n = 0;
        String string = System.getProperty("microedition.locale");
        if (string != null) {
            int n5 = string.indexOf(45);
            if (n5 == -1) {
                n5 = string.length();
            }
            String string2 = string.substring(0, n5);
            String[] stringArray = LanguageUI.getUI().getLanguageCode();
            for (int n6 = 0; n6 < stringArray.length; n6 = (int)((byte)(n6 + 1))) {
                if (!string2.equals(stringArray[n6])) continue;
                n = n6;
                break;
            }
        }
        this.setUILanguage(n);
        this.setDefaultValuesSet(true);
    }

    public void initValues() {
    }

    public void closeSettingsStore() throws DictionaryException {
        try {
            this.mobileDictionaryStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            throw new DictionaryException(recordStoreException);
        }
    }

    public boolean getDefaultValuesSet() throws DictionaryException {
        return this.getBooleanValue(1);
    }

    public void setDefaultValuesSet(boolean bl) throws DictionaryException {
        this.setBooleanValue(1, bl);
    }

    public int getInputLanguage() throws DictionaryException {
        return this.getIntValue(3);
    }

    public void setInputLanguage(int n) throws DictionaryException {
        this.setIntValue(3, n);
    }

    public boolean[] getOutputLanguage() throws DictionaryException {
        return this.getBooleanArrayValue(4, DictionaryDataFile.numberOfAvailableLanguages);
    }

    public void setOutputLanguage(boolean[] blArray) throws DictionaryException {
        this.setBooleanArrayValue(4, blArray);
    }

    public boolean getShowStatistic() throws DictionaryException {
        return this.getBooleanValue(5);
    }

    public void setShowStatistic(boolean bl) throws DictionaryException {
        this.setBooleanValue(5, bl);
    }

    public boolean getBypassCharsetDecoding() throws DictionaryException {
        return this.getBooleanValue(6);
    }

    public void setBypassCharsetDecoding(boolean bl) throws DictionaryException {
        this.setBooleanValue(6, bl);
    }

    public boolean getIncrementalSearchEnabled() throws DictionaryException {
        return this.getBooleanValue(7);
    }

    public void setIncrementalSearchEnabled(boolean bl) throws DictionaryException {
        this.setBooleanValue(7, bl);
    }

    public int getMaxHits() throws DictionaryException {
        return this.getIntValue(8);
    }

    public void setMaxHits(int n) throws DictionaryException {
        this.setIntValue(8, n);
    }

    public int getFontSize() throws DictionaryException {
        return this.getIntValue(9);
    }

    public void setFontSize(int n) throws DictionaryException {
        this.setIntValue(9, n);
    }

    public int getUILanguage() throws DictionaryException {
        return this.getIntValue(10);
    }

    public void setUILanguage(int n) throws DictionaryException {
        this.setIntValue(10, n);
    }

    public boolean getShowTranslationList() throws DictionaryException {
        return this.getBooleanValue(11);
    }

    public void setShowTranslationList(boolean bl) throws DictionaryException {
        this.setBooleanValue(11, bl);
    }

    public boolean getFindExactMatches() throws DictionaryException {
        return this.getBooleanValue(12);
    }

    public void setFindExactMatches(boolean bl) throws DictionaryException {
        this.setBooleanValue(12, bl);
    }

    public boolean getAddAtBeginNoSearchSubExpressionCharacter() throws DictionaryException {
        return this.getBooleanValue(13);
    }

    public void setAddAtBeginNoSearchSubExpressionCharacter(boolean bl) throws DictionaryException {
        this.setBooleanValue(13, bl);
    }

    public boolean getAddAtEndWildcardAnySeriesOfCharacter() throws DictionaryException {
        return this.getBooleanValue(14);
    }

    public void setAddAtEndWildcardAnySeriesOfCharacter(boolean bl) throws DictionaryException {
        this.setBooleanValue(14, bl);
    }

    public boolean getColouredItems() throws DictionaryException {
        return this.getBooleanValue(15);
    }

    public void setColouredItems(boolean bl) throws DictionaryException {
        this.setBooleanValue(15, bl);
    }

    public boolean getUseBitmapFont() throws DictionaryException {
        return this.getBooleanValue(16);
    }

    public void setDictionaryPath(String string) throws DictionaryException {
        this.setStringValue(17, string);
    }

    public String getDictionaryPath() throws DictionaryException {
        return this.getStringValue(17);
    }

    public void setUseBitmapFont(boolean bl) throws DictionaryException {
        this.setBooleanValue(16, bl);
    }

    protected void addIntValue(int n) throws DictionaryException {
        try {
            this.checkByteValueRange(n);
            this.mobileDictionaryStore.addRecord(new byte[]{(byte)n}, 0, 1);
        }
        catch (RecordStoreException recordStoreException) {
            throw new DictionaryException(recordStoreException);
        }
    }

    protected int getIntValue(int n) throws DictionaryException {
        byte by;
        try {
            byte[] byArray = this.mobileDictionaryStore.getRecord(n);
            by = byArray[0];
        }
        catch (RecordStoreException recordStoreException) {
            throw new DictionaryException(recordStoreException);
        }
        return by;
    }

    protected void setIntValue(int n, int n2) throws DictionaryException {
        try {
            this.checkByteValueRange(n2);
            this.mobileDictionaryStore.setRecord(n, new byte[]{(byte)n2}, 0, 1);
        }
        catch (RecordStoreException recordStoreException) {
            throw new DictionaryException(recordStoreException);
        }
    }

    void checkByteValueRange(int n) throws DictionaryException {
        if (n > 127) {
            throw new DictionaryException("SettingStore maximum value is 127");
        }
        if (n < -128) {
            throw new DictionaryException("SettingStore minimum value is -128");
        }
    }

    protected void addBooleanValue(boolean bl) throws DictionaryException {
        try {
            this.mobileDictionaryStore.addRecord(new byte[]{this.convertBooleanToByte(bl)}, 0, 1);
        }
        catch (RecordStoreException recordStoreException) {
            throw new DictionaryException(recordStoreException);
        }
    }

    protected boolean getBooleanValue(int n) throws DictionaryException {
        boolean bl;
        try {
            byte[] byArray = this.mobileDictionaryStore.getRecord(n);
            bl = this.convertByteToBoolean(byArray[0]);
        }
        catch (RecordStoreException recordStoreException) {
            throw new DictionaryException(recordStoreException);
        }
        return bl;
    }

    protected void setBooleanValue(int n, boolean bl) throws DictionaryException {
        try {
            this.mobileDictionaryStore.setRecord(n, new byte[]{this.convertBooleanToByte(bl)}, 0, 1);
        }
        catch (RecordStoreException recordStoreException) {
            throw new DictionaryException(recordStoreException);
        }
    }

    protected void addBooleanArrayValue(boolean[] blArray) throws DictionaryException {
        try {
            byte[] byArray = this.getBooleanArrayRecord(blArray);
            this.mobileDictionaryStore.addRecord(byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            throw new DictionaryException(recordStoreException);
        }
    }

    protected boolean[] getBooleanArrayValue(int n, int n2) throws DictionaryException {
        boolean[] blArray = new boolean[n2];
        try {
            byte[] byArray = this.mobileDictionaryStore.getRecord(n);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            for (int i = 0; i < n2; ++i) {
                boolean bl;
                blArray[i] = bl = dataInputStream.readBoolean();
            }
        }
        catch (RecordStoreException recordStoreException) {
            throw new DictionaryException(recordStoreException);
        }
        catch (IOException iOException) {
            throw new DictionaryException(iOException);
        }
        return blArray;
    }

    protected void setBooleanArrayValue(int n, boolean[] blArray) throws DictionaryException {
        try {
            byte[] byArray = this.getBooleanArrayRecord(blArray);
            this.mobileDictionaryStore.setRecord(n, byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            throw new DictionaryException(recordStoreException);
        }
    }

    protected byte[] getBooleanArrayRecord(boolean[] blArray) throws DictionaryException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            for (int i = 0; i < blArray.length; ++i) {
                dataOutputStream.writeBoolean(blArray[i]);
            }
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new DictionaryException(iOException);
        }
    }

    protected boolean convertByteToBoolean(byte by) throws DictionaryException {
        boolean bl;
        if (by == 0) {
            bl = false;
        } else if (by == 1) {
            bl = true;
        } else {
            throw new DictionaryException("Invalid byte-value in SettingsStore");
        }
        return bl;
    }

    protected byte convertBooleanToByte(boolean bl) throws DictionaryException {
        byte by = bl ? (byte)1 : 0;
        return by;
    }

    protected void addStringValue(String string) throws DictionaryException {
        try {
            byte[] byArray = string.getBytes();
            this.mobileDictionaryStore.addRecord(byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            throw new DictionaryException(recordStoreException);
        }
    }

    protected String getStringValue(int n) throws DictionaryException {
        String string;
        try {
            byte[] byArray = this.mobileDictionaryStore.getRecord(n);
            string = byArray != null ? new String(byArray) : new String("");
        }
        catch (RecordStoreException recordStoreException) {
            throw new DictionaryException(recordStoreException);
        }
        return string;
    }

    protected void setStringValue(int n, String string) throws DictionaryException {
        try {
            byte[] byArray = string.getBytes();
            this.mobileDictionaryStore.setRecord(n, byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            throw new DictionaryException(recordStoreException);
        }
    }
}

