/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.general;

import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.general.DictionaryInterruptedException;

public abstract class Util {
    private static Util utilObj;
    public static final int logLevel0 = 0;
    public static final int logLevel1 = 1;
    public static final int logLevel2 = 2;
    public static final int logLevel3 = 3;
    public static final int logLevelMin = 0;
    public static final int logLevelMax = 3;
    protected int logLevel = 0;
    public static final char wildcardAnySeriesOfCharacter = '*';
    public static final char wildcardAnySingleCharacter = '?';
    public static final char noSearchSubExpressionCharacter = '/';

    public static Util getUtil() {
        return utilObj;
    }

    public static void setUtil(Util util) {
        utilObj = util;
    }

    protected abstract void outputMessage(String var1);

    public void log(String string, int n) {
        if (this.logLevel >= n) {
            this.outputMessage(string + "\n");
        }
    }

    public void log(String string) {
        this.log(string, 0);
    }

    public void logDebug(String string) {
        this.log(string, 1);
    }

    public void log(Throwable throwable) {
        if (!(throwable instanceof DictionaryInterruptedException)) {
            this.outputMessage("Thrown " + throwable.toString() + " / " + throwable.getMessage() + "\n");
            throwable.printStackTrace();
        }
    }

    public void logTime(String string, long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        this.log("Time for " + string + ": " + l3, 2);
    }

    public void setLogLevel(int n) {
        this.logLevel = n;
    }

    public static void memCheck(String string) {
        if (Util.getUtil().logLevel > 1) {
            System.gc();
            Util.getUtil().log(string + ": " + String.valueOf(Runtime.getRuntime().freeMemory()));
        }
    }

    public static boolean isSeparatorCharacter(char c) {
        return Util.charIsLineWhitespace(c) || Util.charIsPunctuation(c);
    }

    public static StringBuffer removePunctuation(StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (!Util.charIsPunctuation(c) || Util.charIsSearchSpecialCharacter(c) && bl) {
                stringBuffer2.append(c);
                continue;
            }
            stringBuffer2.append(' ');
        }
        return stringBuffer2;
    }

    public static StringBuffer convertToLowerCase(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < stringBuffer.length(); ++i) {
            stringBuffer2.append(Character.toLowerCase(stringBuffer.charAt(i)));
        }
        return stringBuffer2;
    }

    public static void firstWord(StringBuffer stringBuffer) {
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (!Util.charIsLineWhitespace(stringBuffer.charAt(i)) && !Util.charIsPunctuation(stringBuffer.charAt(i))) continue;
            stringBuffer.setLength(i);
            break;
        }
    }

    public static boolean charIsLineWhitespace(char c) {
        boolean bl = c == '\t' || c == ' ';
        return bl;
    }

    public static boolean isWhitespace(char c) {
        boolean bl = c == '\t' || c == '\n' || c == ' ' || c == '\f' || c == '\u001c' || c == '\u001d' || c == '\u001e' || c == '\u001f';
        return bl;
    }

    public static StringBuffer filterSuperflousWhitespaces(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        StringBuffer stringBuffer2 = new StringBuffer(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (Util.charIsLineWhitespace(c)) {
                if (stringBuffer2.length() != 0 && i != stringBuffer.length() - 1 && !bl) {
                    stringBuffer2.append(c);
                }
                bl = true;
                continue;
            }
            stringBuffer2.append(c);
            bl = false;
        }
        return stringBuffer2;
    }

    public void convertFieldAndLineSeparatorChars(StringBuffer stringBuffer) {
        int n = 0;
        int n2 = stringBuffer.length();
        while (n < n2) {
            char c = stringBuffer.charAt(n);
            if (c == '\\') {
                if (++n < n2) {
                    c = stringBuffer.charAt(n);
                    if (c == '\\') {
                        stringBuffer.deleteCharAt(n);
                    } else if (c == 'n') {
                        stringBuffer.setCharAt(n - 1, '\n');
                        stringBuffer.deleteCharAt(n);
                    } else if (c == 't') {
                        stringBuffer.setCharAt(n - 1, '\t');
                        stringBuffer.deleteCharAt(n);
                    }
                }
                n2 = stringBuffer.length();
                continue;
            }
            ++n;
        }
    }

    public void replaceFieldAndLineSeparatorChars(StringBuffer stringBuffer) {
        int n = 0;
        int n2 = stringBuffer.length();
        while (n < n2) {
            char c = stringBuffer.charAt(n);
            if (c == '\\') {
                if (++n < n2) {
                    c = stringBuffer.charAt(n);
                    if (c == '\\') {
                        stringBuffer.deleteCharAt(n);
                    } else if (c == 'n') {
                        stringBuffer.setCharAt(n - 1, ' ');
                        stringBuffer.deleteCharAt(n);
                    } else if (c == 't') {
                        stringBuffer.setCharAt(n - 1, ' ');
                        stringBuffer.deleteCharAt(n);
                    }
                }
                n2 = stringBuffer.length();
                continue;
            }
            ++n;
        }
    }

    static boolean charIsSearchSpecialCharacter(char c) {
        return c == '*' || c == '?';
    }

    public static String removeSuperflousSearchCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() >= 2) {
            if (stringBuffer.charAt(0) == '/' && stringBuffer.charAt(1) == '/') {
                stringBuffer.deleteCharAt(0);
                continue;
            }
            if (stringBuffer.charAt(stringBuffer.length() - 1) != '/' || stringBuffer.charAt(stringBuffer.length() - 2) != '/') break;
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        if (stringBuffer.length() == 1 && stringBuffer.charAt(0) == '/') {
            stringBuffer.deleteCharAt(0);
        }
        int n = 0;
        while (stringBuffer.length() > n + 1) {
            if (stringBuffer.charAt(n) == '*' && stringBuffer.charAt(n + 1) == '*') {
                stringBuffer.deleteCharAt(n);
                continue;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static boolean charIsPunctuation(char c) {
        String string = "!\"$\u00a7$%&/()=?\u00b4`\\{}[]^\u00b0+*~#'-_.:,;<>|@";
        return string.indexOf(c) != -1;
    }

    public static boolean stringEqualIgnoreCase(String string, String string2) {
        boolean bl = false;
        if (string.length() == string2.length()) {
            int n;
            int n2 = string.length();
            for (n = 0; n < n2 && Character.toUpperCase(string.charAt(n)) == Character.toUpperCase(string2.charAt(n)); ++n) {
            }
            if (n == n2) {
                bl = true;
            }
        }
        return bl;
    }

    public static String[] stringSplit(String string, char c) {
        int n = 1;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        String[] stringArray = new String[n];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i <= n2; ++i) {
            if (i != n2 && string.charAt(i) != c) continue;
            if (n4 < n2) {
                stringArray[n3] = string.substring(n4, i);
                n4 = i + 1;
            } else {
                stringArray[n3] = new String("");
            }
            ++n3;
        }
        return stringArray;
    }

    public void openProperties() throws DictionaryException {
    }

    public void closeProperties() throws DictionaryException {
    }

    public abstract String getDictionaryProperty(String var1);

    public String getDictionaryPropertyString(String string, boolean bl) throws DictionaryException {
        String string2 = this.getDictionaryProperty(string);
        if (string2 == null && !bl) {
            this.propertyNotFound(string);
        }
        return string2;
    }

    public void propertyNotFound(String string) throws DictionaryException {
        String string2 = "Property " + string + " not found";
        throw new DictionaryException(string2);
    }

    public String getDictionaryPropertyString(String string) throws DictionaryException {
        return this.getDictionaryPropertyString(string, false);
    }

    public int getDictionaryPropertyInt(String string) throws DictionaryException {
        String string2 = this.getDictionaryPropertyString(string);
        int n = Integer.valueOf(string2);
        return n;
    }

    public char getDictionaryPropertyChar(String string) throws DictionaryException {
        String string2 = this.getDictionaryPropertyString(string);
        char c = this.getCharValueFromProperty(string, string2);
        return c;
    }

    public char getCharValueFromProperty(String string, String string2) throws DictionaryException {
        char c = '\t';
        if (!string2.startsWith("'") || !string2.endsWith("'")) {
            String string3 = "Property " + string + " must start with ' and end with ' ";
            this.log(string3);
            throw new DictionaryException(string3);
        }
        String string4 = string2.substring(1, string2.length() - 1);
        boolean bl = false;
        if (string4.startsWith("\\")) {
            if (string4.length() != 2) {
                bl = true;
            } else if (string4.endsWith("t")) {
                c = '\t';
            } else {
                bl = true;
            }
        } else if (string4.length() != 1) {
            bl = true;
        } else {
            c = string4.charAt(0);
        }
        if (bl) {
            String string5 = "Property " + string + " must contain one character or \\t";
            this.log(string5);
            throw new DictionaryException(string5);
        }
        return c;
    }

    public String getDictionaryPropertyStringDefault(String string, String string2) throws DictionaryException {
        String string3 = this.getDictionaryPropertyString(string, true);
        String string4 = string3 != null ? string3 : string2;
        return string4;
    }

    public char getDictionaryPropertyCharDefault(String string, char c) throws DictionaryException {
        String string2 = this.getDictionaryPropertyString(string, true);
        char c2 = string2 != null ? this.getCharValueFromProperty(string, string2) : c;
        return c2;
    }

    public int getDictionaryPropertyIntDefault(String string, int n) throws DictionaryException {
        String string2 = this.getDictionaryPropertyString(string, true);
        int n2 = string2 != null ? Integer.valueOf(string2) : n;
        return n2;
    }

    public boolean getDictionaryPropertyBooleanDefault(String string, boolean bl) throws DictionaryException {
        String string2 = this.getDictionaryPropertyString(string, true);
        boolean bl2 = string2 != null ? this.getBooleanFromProperty(string, string2) : bl;
        return bl2;
    }

    public boolean getBooleanFromProperty(String string, String string2) throws DictionaryException {
        boolean bl;
        if (Util.stringEqualIgnoreCase(string2, "true")) {
            bl = true;
        } else if (Util.stringEqualIgnoreCase(string2, "false")) {
            bl = false;
        } else {
            String string3 = "Property " + string + " must be true or false";
            this.log(string3);
            throw new DictionaryException(string3);
        }
        return bl;
    }

    public static void determineCharEncoding() throws DictionaryException {
    }

    public static void setDeviceCharEncoding(String string) {
    }
}

