/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.hmi_common.content;

import de.kugihan.dictionaryformids.dataaccess.DictionaryDataFile;
import de.kugihan.dictionaryformids.dataaccess.content.ContentDefinition;
import de.kugihan.dictionaryformids.dataaccess.content.PredefinedContent;
import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.hmi_common.content.StringColourItemText;
import de.kugihan.dictionaryformids.hmi_common.content.StringColourItemTextPart;
import de.kugihan.dictionaryformids.hmi_j2me.DictionarySettings;
import java.util.Stack;

public class ContentParser {
    StringColourItemText stringColourItemText;
    Stack contentHierarchy = new Stack();
    StringBuffer text = new StringBuffer();

    public StringColourItemText determineItemsFromContent(String string, int n, boolean bl) throws DictionaryException {
        this.stringColourItemText = new StringColourItemText();
        ContentDefinition[] contentDefinitionArray = DictionaryDataFile.supportedLanguages[n].contents;
        this.pushNewContent(contentDefinitionArray[0], n, bl);
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            int n3 = string.charAt(i);
            if (DictionaryDataFile.supportedLanguages[n].contentDefinitionAvailable) {
                int n4;
                if (n3 == 91) {
                    if (i + 2 >= n2) {
                        this.throwContentFormatException("Start of content ([) without complete content number");
                    }
                    n4 = this.getStartContentDigitValue(string.charAt(i + 1)) * 10 + this.getStartContentDigitValue(string.charAt(i + 2));
                    i += 2;
                    this.addStringColourItemTextPart();
                    if (n4 < 1 || n4 >= contentDefinitionArray.length) {
                        this.throwContentFormatException("Incorrect content number: " + n4);
                    }
                    this.pushNewContent(contentDefinitionArray[n4], n, bl);
                    continue;
                }
                if (n3 == 93) {
                    this.addStringColourItemTextPart();
                    this.popContent();
                    continue;
                }
                if (n3 == 92) {
                    if (i + 1 >= n2) continue;
                    n4 = string.charAt(i + 1);
                    if (n4 == 91 || n4 == 93) {
                        ++i;
                        n3 = n4;
                    }
                    this.addText((char)n3);
                    continue;
                }
                this.addText((char)n3);
                continue;
            }
            this.addText((char)n3);
        }
        this.addStringColourItemTextPart();
        return this.stringColourItemText;
    }

    void pushNewContent(ContentDefinition contentDefinition, int n, boolean bl) throws DictionaryException {
        if (bl && contentDefinition == PredefinedContent.getContentNoDefinitionProvided()) {
            if (n == DictionarySettings.getInputLanguage()) {
                contentDefinition = PredefinedContent.getContentInputLanguage();
            } else if (n == DictionarySettings.determineOutputLanguage()) {
                contentDefinition = PredefinedContent.getContentOutputLanguage();
            }
        }
        this.contentHierarchy.push(contentDefinition);
        this.text.setLength(0);
    }

    void popContent() throws DictionaryException {
        this.contentHierarchy.pop();
        if (this.contentHierarchy.isEmpty()) {
            this.throwContentFormatException("End of content without start of content");
        }
    }

    void addText(char c) {
        this.text.append(c);
    }

    void addStringColourItemTextPart() {
        if (this.text.length() > 0) {
            ContentDefinition contentDefinition = this.getTopContent();
            StringColourItemTextPart stringColourItemTextPart = this.getItemTextPartFromContent(this.text.toString(), contentDefinition);
            this.stringColourItemText.addItemTextPart(stringColourItemTextPart);
        }
        this.text.setLength(0);
    }

    ContentDefinition getTopContent() {
        return (ContentDefinition)this.contentHierarchy.peek();
    }

    StringColourItemTextPart getItemTextPartFromContent(String string, ContentDefinition contentDefinition) {
        StringColourItemTextPart stringColourItemTextPart = new StringColourItemTextPart(string, contentDefinition.fontColour, contentDefinition.fontStyle, contentDefinition.selectionMode);
        return stringColourItemTextPart;
    }

    int getStartContentDigitValue(char c) throws DictionaryException {
        if (!Character.isDigit(c)) {
            this.throwContentFormatException("Start of content ([) is not followed by 2 digits");
        }
        return Character.digit(c, 10);
    }

    void throwContentFormatException(String string) throws DictionaryException {
        throw new DictionaryException("Error in content format: " + string);
    }

    public StringBuffer getTextFromStringColourItemText(StringColourItemText stringColourItemText) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringColourItemText.size(); ++i) {
            stringBuffer.append(stringColourItemText.getItemTextPart(i).getText());
        }
        return stringBuffer;
    }
}

