/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.hmi_j2me;

import de.kugihan.dictionaryformids.dataaccess.CsvFile;
import de.kugihan.dictionaryformids.dataaccess.DictionaryDataFile;
import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.general.SettingsStore;
import de.kugihan.dictionaryformids.general.Util;
import de.kugihan.dictionaryformids.hmi_j2me.DictionaryForMIDs;
import de.kugihan.dictionaryformids.hmi_j2me.DictionarySettings;
import de.kugihan.dictionaryformids.hmi_j2me.SelectDictionaryPath;
import de.kugihan.dictionaryformids.hmi_j2me.lcdui_extension.DfMChoiceGroup;
import de.kugihan.dictionaryformids.hmi_j2me.lcdui_extension.DfMCommand;
import de.kugihan.dictionaryformids.hmi_j2me.lcdui_extension.DfMForm;
import de.kugihan.dictionaryformids.hmi_j2me.mainform.MainForm;
import de.kugihan.dictionaryformids.hmi_j2me.mainform.bitmapfont.BitMapFontCanvas;
import de.kugihan.dictionaryformids.hmi_j2me.uidisplaytext.LanguageUI;
import de.kugihan.dictionaryformids.hmi_j2me.uidisplaytext.UIDisplayTextItem;
import de.kugihan.dictionaryformids.hmi_j2me.uidisplaytext.UIDisplayTextItems;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.TextField;

public class DictionarySettingForm
extends DfMForm
implements CommandListener,
ItemCommandListener,
ItemStateListener {
    DfMCommand applyCommand;
    DfMCommand cancelCommand;
    Command selectDictionaryPathCommand = new Command("List root devices", 8, 4);
    Form callingForm;
    Display display;
    ChoiceGroup inputLanguageChoiceGroup;
    ChoiceGroup outputLanguageChoiceGroup;
    ChoiceGroup searchChoiceGroup;
    ChoiceGroup displayChoiceGroup;
    ChoiceGroup fontSizeChoiceGroup;
    ChoiceGroup uiLanguageChoiceGroup;
    ChoiceGroup performanceChoiceGroup;
    static TextField dictionaryPathTextField = null;
    protected final int indexFontSizeCGDefault;
    protected final int indexFontSizeCGSmall;
    protected final int indexFontSizeCGMedium;
    protected final int indexFontSizeCGLarge;
    protected final int indexSearchCGIncrementalSearchEnabled;
    protected final int indexSearchCGFindExactMatches;
    protected final int indexSearchCGEndWildcardAnySeriesOfCharacter;
    protected final int indexSearchCGBeginNoSearchSubExpressionCharacter;
    protected final int indexDisplayCGShowTranslationList;
    protected final int indexDisplayCGColouredItems;
    protected final int indexDisplayCGShowStatistic;
    protected final int indexDisplayCGUseBitmapFont;
    protected final int indexPerfCGBypassCharsetDecoding;
    private boolean bitmapFontExists;

    public DictionarySettingForm(Display display, Form form) throws DictionaryException {
        super("Settings");
        UIDisplayTextItem[] uIDisplayTextItemArray;
        this.indexFontSizeCGDefault = 0;
        this.indexFontSizeCGSmall = 1;
        this.indexFontSizeCGMedium = 2;
        this.indexFontSizeCGLarge = 3;
        this.indexSearchCGIncrementalSearchEnabled = 0;
        this.indexSearchCGFindExactMatches = 1;
        this.indexSearchCGEndWildcardAnySeriesOfCharacter = 2;
        this.indexSearchCGBeginNoSearchSubExpressionCharacter = 3;
        this.indexDisplayCGShowTranslationList = 0;
        this.indexDisplayCGColouredItems = 1;
        this.indexDisplayCGShowStatistic = 2;
        this.indexDisplayCGUseBitmapFont = 3;
        this.indexPerfCGBypassCharsetDecoding = 0;
        this.callingForm = form;
        this.display = display;
        this.setupCommands();
        this.setCommandListener(this);
        this.bitmapFontExists = new BitMapFontCanvas("blah", 50).fontExists();
        UIDisplayTextItem[] uIDisplayTextItemArray2 = new UIDisplayTextItem[DictionaryDataFile.numberOfInputLanguages];
        int n = 0;
        for (int i = 0; i < DictionaryDataFile.numberOfAvailableLanguages; ++i) {
            if (!DictionaryDataFile.supportedLanguages[i].isSearchable) continue;
            String string = DictionaryDataFile.supportedLanguages[i].languageDisplayText;
            LanguageUI languageUI = LanguageUI.getUI();
            StringBuffer stringBuffer = new StringBuffer();
            LanguageUI.getUI().getClass();
            uIDisplayTextItemArray2[n] = languageUI.getUIDisplayTextItem(stringBuffer.append("Language").append(string).toString(), string);
            ++n;
        }
        if (n == 0 && DictionaryDataFile.numberOfAvailableLanguages > 0) {
            throw new DictionaryException("No searchable languages defined");
        }
        this.inputLanguageChoiceGroup = new DfMChoiceGroup(UIDisplayTextItems.SettingsFromLanguage, 1, uIDisplayTextItemArray2);
        if (DictionarySettings.isDictionaryAvailable()) {
            DictionarySettings.setInputLanguage(SettingsStore.getSettingsStore().getInputLanguage());
        }
        this.append((Item)this.inputLanguageChoiceGroup);
        UIDisplayTextItem[] uIDisplayTextItemArray3 = new UIDisplayTextItem[DictionaryDataFile.numberOfAvailableLanguages];
        for (int i = 0; i < DictionaryDataFile.numberOfAvailableLanguages; ++i) {
            uIDisplayTextItemArray = DictionaryDataFile.supportedLanguages[i].languageDisplayText;
            LanguageUI languageUI = LanguageUI.getUI();
            StringBuffer stringBuffer = new StringBuffer();
            LanguageUI.getUI().getClass();
            uIDisplayTextItemArray3[i] = languageUI.getUIDisplayTextItem(stringBuffer.append("Language").append((String)uIDisplayTextItemArray).toString(), (String)uIDisplayTextItemArray);
        }
        this.outputLanguageChoiceGroup = new DfMChoiceGroup(UIDisplayTextItems.SettingsToLanguage, 1, uIDisplayTextItemArray3);
        if (DictionarySettings.isDictionaryAvailable()) {
            DictionarySettings.setOutputLanguage(SettingsStore.getSettingsStore().getOutputLanguage());
        }
        this.append((Item)this.outputLanguageChoiceGroup);
        UIDisplayTextItem[] uIDisplayTextItemArray4 = new UIDisplayTextItem[]{UIDisplayTextItems.SettingsIncrementalSearchEnabled, UIDisplayTextItems.SettingsFindMatchWordOnly, UIDisplayTextItems.SettingsEndWildcardAnySeriesOfCharacter, UIDisplayTextItems.SettingsBeginNoSearchSubExpressionCharacter};
        UIDisplayTextItems.SettingsEndWildcardAnySeriesOfCharacter.setParameterValue(1, String.valueOf('*'));
        UIDisplayTextItems.SettingsBeginNoSearchSubExpressionCharacter.setParameterValue(1, String.valueOf('/'));
        this.searchChoiceGroup = new DfMChoiceGroup(UIDisplayTextItems.SettingsSearchOptions, 2, uIDisplayTextItemArray4);
        DictionarySettings.setIncrementalSearchEnabled(SettingsStore.getSettingsStore().getIncrementalSearchEnabled());
        DictionarySettings.setFindExactMatches(SettingsStore.getSettingsStore().getFindExactMatches());
        DictionarySettings.setAddAtEndWildcardAnySeriesOfCharacter(SettingsStore.getSettingsStore().getAddAtEndWildcardAnySeriesOfCharacter());
        DictionarySettings.setAddAtBeginNoSearchSubExpressionCharacter(SettingsStore.getSettingsStore().getAddAtBeginNoSearchSubExpressionCharacter());
        this.append((Item)this.searchChoiceGroup);
        uIDisplayTextItemArray = this.bitmapFontExists ? new UIDisplayTextItem[]{UIDisplayTextItems.SettingsShowTranslationList, UIDisplayTextItems.SettingsColouredItems, UIDisplayTextItems.SettingsShowStatistics, UIDisplayTextItems.SettingsUseBitmapFont} : new UIDisplayTextItem[]{UIDisplayTextItems.SettingsShowTranslationList, UIDisplayTextItems.SettingsColouredItems, UIDisplayTextItems.SettingsShowStatistics};
        this.displayChoiceGroup = new DfMChoiceGroup(UIDisplayTextItems.SettingsDisplayOptions, 2, uIDisplayTextItemArray);
        DictionarySettings.setShowTranslationList(SettingsStore.getSettingsStore().getShowTranslationList());
        this.displayChoiceGroup.setSelectedIndex(0, DictionarySettings.getShowTranslationList());
        DictionarySettings.setColouredItems(SettingsStore.getSettingsStore().getColouredItems());
        DictionarySettings.setShowStatistic(SettingsStore.getSettingsStore().getShowStatistic());
        if (this.bitmapFontExists) {
            DictionarySettings.setUseBitmapFont(SettingsStore.getSettingsStore().getUseBitmapFont());
        }
        this.append((Item)this.displayChoiceGroup);
        if (DictionarySettings.isUseFileAccessJSR75()) {
            dictionaryPathTextField = new TextField("Dictionary path", null, 300, 4);
            this.append((Item)dictionaryPathTextField);
            dictionaryPathTextField.setDefaultCommand(this.selectDictionaryPathCommand);
            dictionaryPathTextField.setItemCommandListener((ItemCommandListener)this);
        }
        UIDisplayTextItem[] uIDisplayTextItemArray5 = new UIDisplayTextItem[]{UIDisplayTextItems.SettingsFontDeviceDefault, UIDisplayTextItems.SettingsFontSmall, UIDisplayTextItems.SettingsFontMedium, UIDisplayTextItems.SettingsFontLarge};
        if (DictionaryForMIDs.useMIDP20) {
            this.fontSizeChoiceGroup = new DfMChoiceGroup(UIDisplayTextItems.SettingsFontSize, 4, uIDisplayTextItemArray5);
            DictionarySettings.setFontSize(SettingsStore.getSettingsStore().getFontSize());
            this.append((Item)this.fontSizeChoiceGroup);
        }
        String[] stringArray = LanguageUI.getUI().getLanguageTitle();
        if (DictionaryForMIDs.useMIDP20) {
            this.uiLanguageChoiceGroup = new DfMChoiceGroup(UIDisplayTextItems.SettingsUILanguage, 4, stringArray, null);
            DictionarySettings.setUILanguage(SettingsStore.getSettingsStore().getUILanguage());
            this.append((Item)this.uiLanguageChoiceGroup);
        }
        UIDisplayTextItem[] uIDisplayTextItemArray6 = new UIDisplayTextItem[]{UIDisplayTextItems.SettingsBypassCharsetDecoding};
        this.performanceChoiceGroup = new DfMChoiceGroup(UIDisplayTextItems.SettingsPerformanceOptions, 2, uIDisplayTextItemArray6);
        CsvFile.selectedBypassCharsetDecoding = SettingsStore.getSettingsStore().getBypassCharsetDecoding();
        this.append((Item)this.performanceChoiceGroup);
        this.setItemsToSettingValues();
        this.setItemStateListener(this);
    }

    protected void setItemsToSettingValues() {
        this.setInputLanguageChoiceGroup();
        this.setOutputLanguageChoiceGroup();
        this.searchChoiceGroup.setSelectedIndex(0, DictionarySettings.isIncrementalSearchEnabled());
        this.searchChoiceGroup.setSelectedIndex(1, DictionarySettings.isFindExactMatches());
        this.searchChoiceGroup.setSelectedIndex(2, DictionarySettings.isAddAtEndWildcardAnySeriesOfCharacter());
        this.searchChoiceGroup.setSelectedIndex(3, DictionarySettings.isAddAtBeginNoSearchSubExpressionCharacter());
        this.displayChoiceGroup.setSelectedIndex(1, DictionarySettings.isColouredItems());
        this.displayChoiceGroup.setSelectedIndex(2, DictionarySettings.getShowStatistic());
        if (this.bitmapFontExists) {
            this.displayChoiceGroup.setSelectedIndex(3, DictionarySettings.getUseBitmapFont());
        }
        if (DictionarySettings.isUseFileAccessJSR75()) {
            dictionaryPathTextField.setString(DictionaryDataFile.dictionaryPath);
        }
        if (DictionaryForMIDs.useMIDP20) {
            this.fontSizeChoiceGroup.setSelectedIndex(DictionarySettings.getFontSize(), true);
        }
        if (DictionaryForMIDs.useMIDP20) {
            this.uiLanguageChoiceGroup.setSelectedIndex(DictionarySettings.getUILanguage(), true);
        }
        this.performanceChoiceGroup.setSelectedIndex(0, CsvFile.selectedBypassCharsetDecoding);
    }

    public void setupCommands() throws DictionaryException {
        super.setupCommands();
        this.applyCommand = this.updateCommand(this.applyCommand, UIDisplayTextItems.CommandApply, 4, 4);
        this.cancelCommand = this.updateCommand(this.cancelCommand, UIDisplayTextItems.CommandCancel, 3, 5);
        if (dictionaryPathTextField != null) {
            dictionaryPathTextField.setDefaultCommand(this.selectDictionaryPathCommand);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            if (command == this.applyCommand) {
                this.saveSettings();
            } else if (command == this.cancelCommand) {
                this.cancelSettings();
            } else {
                throw new DictionaryException("Unexpected Command");
            }
            this.display.setCurrent((Displayable)this.callingForm);
        }
        catch (DictionaryException dictionaryException) {
            Util.getUtil().log(dictionaryException);
        }
    }

    public void commandAction(Command command, Item item) {
        try {
            if (command == this.selectDictionaryPathCommand) {
                SelectDictionaryPath selectDictionaryPath = new SelectDictionaryPath();
                selectDictionaryPath.start();
            }
        }
        catch (Throwable throwable) {
            Util.getUtil().log(throwable);
        }
    }

    public void itemStateChanged(Item item) {
        if (item == this.inputLanguageChoiceGroup) {
            this.selectNextOutputLanguage();
        }
        try {
            if (item == this.uiLanguageChoiceGroup) {
                this.setUILanguage(false);
            }
        }
        catch (DictionaryException dictionaryException) {
            Util.getUtil().log(dictionaryException);
        }
    }

    protected void saveSettings() throws DictionaryException {
        int n;
        int n2 = this.inputLanguageChoiceGroupToSettings(this.inputLanguageChoiceGroup.getSelectedIndex());
        this.setInputLanguage(n2);
        boolean[] blArray = new boolean[DictionaryDataFile.numberOfAvailableLanguages];
        this.outputLanguageChoiceGroup.getSelectedFlags(blArray);
        this.setOutputLanguage(blArray);
        if (DictionaryForMIDs.useMIDP20 && (n = this.fontSizeChoiceGroup.getSelectedIndex()) != DictionarySettings.getFontSize()) {
            DictionarySettings.setFontSize(n);
            SettingsStore.getSettingsStore().setFontSize(DictionarySettings.getFontSize());
            MainForm.applicationMainForm.updateFonts();
        }
        this.setUILanguage(true);
        boolean[] blArray2 = new boolean[this.searchChoiceGroup.size()];
        this.searchChoiceGroup.getSelectedFlags(blArray2);
        boolean bl = DictionarySettings.isIncrementalSearchEnabled();
        DictionarySettings.setIncrementalSearchEnabled(blArray2[0]);
        SettingsStore.getSettingsStore().setIncrementalSearchEnabled(DictionarySettings.isIncrementalSearchEnabled());
        if (bl != DictionarySettings.isIncrementalSearchEnabled()) {
            MainForm.applicationMainForm.updateIncrementalSearchSetting();
        }
        DictionarySettings.setFindExactMatches(blArray2[1]);
        SettingsStore.getSettingsStore().setFindExactMatches(DictionarySettings.isFindExactMatches());
        DictionarySettings.setAddAtEndWildcardAnySeriesOfCharacter(blArray2[2]);
        SettingsStore.getSettingsStore().setAddAtEndWildcardAnySeriesOfCharacter(DictionarySettings.isAddAtEndWildcardAnySeriesOfCharacter());
        DictionarySettings.setAddAtBeginNoSearchSubExpressionCharacter(blArray2[3]);
        SettingsStore.getSettingsStore().setAddAtBeginNoSearchSubExpressionCharacter(DictionarySettings.isAddAtBeginNoSearchSubExpressionCharacter());
        boolean[] blArray3 = new boolean[this.displayChoiceGroup.size()];
        this.displayChoiceGroup.getSelectedFlags(blArray3);
        boolean bl2 = DictionarySettings.getShowTranslationList();
        DictionarySettings.setShowTranslationList(blArray3[0]);
        SettingsStore.getSettingsStore().setShowTranslationList(DictionarySettings.getShowTranslationList());
        if (bl2 != DictionarySettings.getShowTranslationList()) {
            MainForm.applicationMainForm.refreshAllTranslationResults();
        }
        boolean bl3 = DictionarySettings.isColouredItems();
        DictionarySettings.setColouredItems(blArray3[1]);
        SettingsStore.getSettingsStore().setColouredItems(DictionarySettings.isColouredItems());
        if (bl3 != DictionarySettings.isColouredItems()) {
            MainForm.applicationMainForm.updateMainFormItemsObj();
        }
        DictionarySettings.setShowStatistic(blArray3[2]);
        SettingsStore.getSettingsStore().setShowStatistic(DictionarySettings.getShowStatistic());
        MainForm.applicationMainForm.displayStatisticItems();
        if (this.bitmapFontExists) {
            boolean bl4 = DictionarySettings.getUseBitmapFont();
            DictionarySettings.setUseBitmapFont(blArray3[3]);
            SettingsStore.getSettingsStore().setUseBitmapFont(DictionarySettings.getUseBitmapFont());
            if (bl4 != DictionarySettings.getUseBitmapFont()) {
                MainForm.applicationMainForm.refreshAllTranslationResults();
            }
        }
        if (DictionarySettings.isUseFileAccessJSR75()) {
            DictionaryDataFile.dictionaryPath = dictionaryPathTextField.getString();
            SettingsStore.getSettingsStore().setDictionaryPath(DictionaryDataFile.dictionaryPath);
        }
        boolean[] blArray4 = new boolean[this.performanceChoiceGroup.size()];
        this.performanceChoiceGroup.getSelectedFlags(blArray4);
        CsvFile.selectedBypassCharsetDecoding = blArray4[0];
        SettingsStore.getSettingsStore().setBypassCharsetDecoding(CsvFile.selectedBypassCharsetDecoding);
    }

    protected void cancelSettings() throws DictionaryException {
        int n;
        int n2 = this.uiLanguageChoiceGroup.getSelectedIndex();
        if (n2 != (n = SettingsStore.getSettingsStore().getUILanguage())) {
            this.uiLanguageChoiceGroup.setSelectedIndex(n, true);
            this.setUILanguage(false);
        }
        this.setItemsToSettingValues();
    }

    public int getFontSize() throws DictionaryException {
        int n;
        if (DictionarySettings.getFontSize() == 0) {
            n = Font.getDefaultFont().getSize();
        } else if (DictionarySettings.getFontSize() == 3) {
            n = 16;
        } else if (DictionarySettings.getFontSize() == 2) {
            n = 0;
        } else if (DictionarySettings.getFontSize() == 1) {
            n = 8;
        } else {
            throw new DictionaryException("Invalid font size index");
        }
        return n;
    }

    public void setUILanguage(boolean bl) throws DictionaryException {
        if (DictionaryForMIDs.useMIDP20) {
            int n = this.uiLanguageChoiceGroup.getSelectedIndex();
            if (n != DictionarySettings.getUILanguage()) {
                DictionarySettings.setUILanguage(n);
                LanguageUI.getUI().setUILanguage(n);
                MainForm.applicationMainForm.refreshAllForms();
            }
            if (bl && n != SettingsStore.getSettingsStore().getUILanguage()) {
                SettingsStore.getSettingsStore().setUILanguage(DictionarySettings.getUILanguage());
            }
        }
    }

    public void setInputLanguage(int n) throws DictionaryException {
        int n2;
        if (DictionarySettings.isDictionaryAvailable() && (n2 = DictionarySettings.getInputLanguage()) != n) {
            DictionarySettings.setInputLanguage(n);
            SettingsStore.getSettingsStore().setInputLanguage(DictionarySettings.getInputLanguage());
            this.setInputLanguageChoiceGroup();
            MainForm.applicationMainForm.updateSelectedLanguage();
        }
    }

    public void setOutputLanguage(boolean[] blArray) throws DictionaryException {
        if (DictionarySettings.isDictionaryAvailable()) {
            boolean bl = false;
            boolean[] blArray2 = DictionarySettings.getOutputLanguage();
            for (int i = 0; i < blArray.length; ++i) {
                if (blArray2[i] == blArray[i]) continue;
                bl = true;
                break;
            }
            if (bl) {
                DictionarySettings.setOutputLanguage(blArray);
                SettingsStore.getSettingsStore().setOutputLanguage(DictionarySettings.getOutputLanguage());
                this.setOutputLanguageChoiceGroup();
                MainForm.applicationMainForm.updateSelectedLanguage();
            }
        }
    }

    protected void setInputLanguageChoiceGroup() {
        if (DictionarySettings.isDictionaryAvailable()) {
            int n = this.inputLanguageSettingsToChoiceGroup(DictionarySettings.getInputLanguage());
            this.inputLanguageChoiceGroup.setSelectedIndex(n, true);
        }
    }

    protected void setOutputLanguageChoiceGroup() {
        if (DictionarySettings.isDictionaryAvailable()) {
            this.outputLanguageChoiceGroup.setSelectedFlags(DictionarySettings.getOutputLanguage());
        }
    }

    public void selectNextInputLanguage() throws DictionaryException {
        int n = DictionarySettings.getInputLanguage();
        int n2 = DictionaryDataFile.numberOfAvailableLanguages;
        for (int i = DictionaryDataFile.numberOfAvailableLanguages - 1; i >= 0 && (i != n || n2 == DictionaryDataFile.numberOfAvailableLanguages); --i) {
            if (!DictionaryDataFile.supportedLanguages[i].isSearchable) continue;
            n2 = i;
        }
        this.setInputLanguage(n2);
        this.selectNextOutputLanguage();
        boolean[] blArray = new boolean[DictionaryDataFile.numberOfAvailableLanguages];
        this.outputLanguageChoiceGroup.getSelectedFlags(blArray);
        this.setOutputLanguage(blArray);
    }

    protected void selectNextOutputLanguage() {
        int n = this.inputLanguageChoiceGroup.getSelectedIndex();
        boolean[] blArray = new boolean[DictionaryDataFile.numberOfAvailableLanguages];
        this.outputLanguageChoiceGroup.getSelectedFlags(blArray);
        if (blArray[n]) {
            blArray[n] = false;
            int n2 = n + 1;
            if (n2 == this.inputLanguageChoiceGroup.size()) {
                n2 = 0;
            }
            blArray[n2] = true;
            this.outputLanguageChoiceGroup.setSelectedFlags(blArray);
        }
    }

    public int inputLanguageSettingsToChoiceGroup(int n) {
        int n2 = -1;
        for (int i = 0; i <= n; ++i) {
            if (!DictionaryDataFile.supportedLanguages[i].isSearchable) continue;
            ++n2;
        }
        return n2;
    }

    public int inputLanguageChoiceGroupToSettings(int n) {
        int n2 = -1;
        int n3 = -1;
        while (n3 < n) {
            if (!DictionaryDataFile.supportedLanguages[++n2].isSearchable) continue;
            ++n3;
        }
        return n2;
    }
}

