/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.hmi_j2me.mainform;

import de.kugihan.dictionaryformids.dataaccess.DictionaryDataFile;
import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.general.SettingsStore;
import de.kugihan.dictionaryformids.general.Util;
import de.kugihan.dictionaryformids.hmi_common.content.ContentParser;
import de.kugihan.dictionaryformids.hmi_common.content.StringColourItemText;
import de.kugihan.dictionaryformids.hmi_j2me.DictionaryForMIDs;
import de.kugihan.dictionaryformids.hmi_j2me.DictionarySettingForm;
import de.kugihan.dictionaryformids.hmi_j2me.DictionarySettings;
import de.kugihan.dictionaryformids.hmi_j2me.lcdui_extension.DfMAlert;
import de.kugihan.dictionaryformids.hmi_j2me.lcdui_extension.DfMCommand;
import de.kugihan.dictionaryformids.hmi_j2me.lcdui_extension.DfMForm;
import de.kugihan.dictionaryformids.hmi_j2me.lcdui_extension.DfMStringItem;
import de.kugihan.dictionaryformids.hmi_j2me.lcdui_extension.DfMTextField;
import de.kugihan.dictionaryformids.hmi_j2me.lcdui_extension.StringColourItem;
import de.kugihan.dictionaryformids.hmi_j2me.mainform.MainFormItems;
import de.kugihan.dictionaryformids.hmi_j2me.mainform.MainFormItemsColoured;
import de.kugihan.dictionaryformids.hmi_j2me.mainform.MainFormItemsSimple;
import de.kugihan.dictionaryformids.hmi_j2me.mainform.WordHistory;
import de.kugihan.dictionaryformids.hmi_j2me.mainform.bitmapfont.BitMapFontCanvas;
import de.kugihan.dictionaryformids.hmi_j2me.uidisplaytext.LanguageUI;
import de.kugihan.dictionaryformids.hmi_j2me.uidisplaytext.UIDisplayTextItem;
import de.kugihan.dictionaryformids.hmi_j2me.uidisplaytext.UIDisplayTextItems;
import de.kugihan.dictionaryformids.translation.SingleTranslation;
import de.kugihan.dictionaryformids.translation.TranslationExecution;
import de.kugihan.dictionaryformids.translation.TranslationExecutionCallback;
import de.kugihan.dictionaryformids.translation.TranslationResult;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.midlet.MIDlet;

public class MainForm
extends DfMForm
implements CommandListener,
ItemStateListener,
ItemCommandListener,
TranslationExecutionCallback {
    public static MainForm applicationMainForm;
    MainFormItems mainFormItemsObj;
    protected final int indexOfToBeTranslatedWordTextField;
    protected int indexOfFirstTranslationItem = 0;
    protected int indexOfLastTranslationItem = -1;
    public int indexOfSelectedItem = -1;
    private String translatedWord = null;
    public int systemBackgroundColour;
    public int stringColourItemWidth;
    DfMStringItem translationResultStatus;
    DfMStringItem responseTimeItem;
    DfMStringItem freeMemoryItem;
    DfMStringItem statisticItem;
    DfMTextField toBeTranslatedWordTextField;
    DfMCommand exitCommand = null;
    DfMCommand settingsCommand = null;
    DfMCommand helpCommand = null;
    DfMCommand infoCommand = null;
    DfMCommand translateCommand = null;
    DfMCommand newWordCommand = null;
    DfMCommand backWordCommand = null;
    DfMCommand forwardWordCommand = null;
    DfMCommand changeInputLanguageCommand = null;
    DfMCommand backToTranslationList = null;
    public Display display;
    DictionaryForMIDs dictionaryForMIDsMidlet;
    DictionarySettingForm dictionarySettingFormObj = null;
    ContentParser contentParserObj;
    WordHistory wordHistoryObj;
    TranslationResult lastResultOfTranslation = null;
    boolean translationListIsShown = false;
    boolean sonyEricssonWorkaroundRequired = false;

    public MainForm(DictionaryForMIDs dictionaryForMIDs) {
        super(DictionaryForMIDs.applicationName);
        this.indexOfToBeTranslatedWordTextField = 0;
        applicationMainForm = this;
        this.dictionaryForMIDsMidlet = dictionaryForMIDs;
        this.display = Display.getDisplay((MIDlet)this.dictionaryForMIDsMidlet);
        this.contentParserObj = new ContentParser();
        this.wordHistoryObj = new WordHistory();
        this.systemBackgroundColour = this.display.getColor(0);
    }

    public void initialiseForm() throws DictionaryException {
        this.updateMainFormItemsObj();
        this.translationResultStatus = new DfMStringItem();
        if (DictionaryForMIDs.useMIDP20) {
            this.translationResultStatus.setLayout(16640);
        }
        this.append((Item)this.translationResultStatus);
        this.responseTimeItem = new DfMStringItem();
        if (DictionaryForMIDs.useMIDP20) {
            this.responseTimeItem.setLayout(16640);
        }
        this.append((Item)this.responseTimeItem);
        this.statisticItem = new DfMStringItem();
        if (DictionaryForMIDs.useMIDP20) {
            this.statisticItem.setLayout(16640);
        }
        this.append((Item)this.statisticItem);
        this.freeMemoryItem = new DfMStringItem();
        if (DictionaryForMIDs.useMIDP20) {
            this.freeMemoryItem.setLayout(16640);
        }
        this.append((Item)this.freeMemoryItem);
        this.setupCommands();
        Util.getUtil().log("Display elements created", 3);
        this.dictionarySettingFormObj = new DictionarySettingForm(this.display, this);
        Util.getUtil().log("Settingsform created", 3);
        this.updateSelectedLanguage();
        this.updateFonts();
        this.displayStatisticItems();
        this.checkForSonyEricssonWorkaround();
    }

    public void startForm() {
        this.setCommandListener(this);
        this.updateIncrementalSearchSetting();
        this.display.setCurrent((Displayable)this);
        TranslationExecution.setTranslationExecutionCallback(this);
    }

    public void setupCommands() throws DictionaryException {
        super.setupCommands();
        this.settingsCommand = this.updateCommand(this.settingsCommand, UIDisplayTextItems.CommandSettings, 1, 6);
        this.helpCommand = this.updateCommand(this.helpCommand, UIDisplayTextItems.CommandHelp, 1, 8);
        this.infoCommand = this.updateCommand(this.infoCommand, UIDisplayTextItems.CommandInfo, 1, 9);
        this.translateCommand = this.updateCommand(this.translateCommand, UIDisplayTextItems.CommandTranslate, 8, 1);
        this.newWordCommand = this.updateCommand(this.newWordCommand, UIDisplayTextItems.CommandNewWord, 1, 3);
        this.forwardWordCommand = this.updateCommand(this.forwardWordCommand, UIDisplayTextItems.CommandForwardWord, 1, 5);
        this.backWordCommand = this.updateCommand(this.backWordCommand, UIDisplayTextItems.CommandBackWord, 1, 4);
        this.changeInputLanguageCommand = this.updateCommand(this.changeInputLanguageCommand, UIDisplayTextItems.CommandChangeInputLanguage, 1, 2);
        this.exitCommand = this.updateCommand(this.exitCommand, UIDisplayTextItems.CommandExit, 1, 7);
        if (this.translationListIsShown) {
            for (int i = this.indexOfFirstTranslationItem; i <= this.indexOfLastTranslationItem; ++i) {
                this.get(i).setDefaultCommand((Command)this.translateCommand);
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            if (command == this.exitCommand) {
                this.dictionaryForMIDsMidlet.notifyDestroyed();
            } else if (command == this.translateCommand) {
                this.translateToBeTranslatedWordTextField(false);
            } else if (command == this.settingsCommand) {
                this.dictionarySetting();
            } else if (command == this.newWordCommand) {
                this.newWord();
            } else if (command == this.forwardWordCommand) {
                this.wordHistoryObj.doForwardWord();
            } else if (command == this.backWordCommand) {
                this.wordHistoryObj.doBackWord();
            } else if (command == this.changeInputLanguageCommand) {
                this.changeInputLanguage();
            } else if (command == this.helpCommand) {
                this.showHelp();
            } else if (command == this.infoCommand) {
                this.showInfo();
            }
        }
        catch (Throwable throwable) {
            Util.getUtil().log(throwable);
        }
    }

    public void commandAction(Command command, Item item) {
        try {
            if (command == this.translateCommand) {
                this.displayTranslationForListItem(item);
            }
        }
        catch (Throwable throwable) {
            Util.getUtil().log(throwable);
        }
    }

    public void itemStateChanged(Item item) {
        try {
            if (item == this.toBeTranslatedWordTextField) {
                this.translateToBeTranslatedWordTextField(true);
            }
        }
        catch (Throwable throwable) {
            Util.getUtil().log(throwable);
        }
    }

    public void translateToBeTranslatedWordTextField(boolean bl) throws DictionaryException {
        this.translateWord(this.toBeTranslatedWordTextField.getString(), bl);
    }

    public void translateWord(String string, boolean bl) throws DictionaryException {
        if (DictionarySettings.isUseFileAccessJSR75()) {
            bl = true;
        }
        TranslationExecution.executeTranslation(this.addSearchCharacters(string), bl);
        this.setFocusToBeTranslatedWordTextField();
        this.translatedWord = string;
        this.indexOfSelectedItem = -1;
    }

    public void translateSelectedWord(String string) throws DictionaryException {
        this.toBeTranslatedWordTextField.setString(string);
        this.translateWord(string, false);
    }

    public void setCurrentSelectedItem(int n, String string, boolean bl) {
        if (n != this.indexOfSelectedItem) {
            if (this.indexOfSelectedItem != -1) {
                StringColourItem stringColourItem = (StringColourItem)this.get(this.indexOfSelectedItem);
                stringColourItem.clearSelectedWord();
            }
            this.indexOfSelectedItem = n;
        }
        if (string == null) {
            this.toBeTranslatedWordTextField.setString(this.translatedWord);
        } else {
            this.toBeTranslatedWordTextField.setString(string);
        }
        if (bl) {
            this.display.setCurrentItem(this.get(n));
        }
    }

    public void setSelectedWordNextItem(int n) {
        for (int i = n + 1; i <= this.indexOfLastTranslationItem; ++i) {
            StringColourItem stringColourItem = (StringColourItem)this.get(i);
            if (!stringColourItem.isSelectableWord()) continue;
            stringColourItem.selectNextWord();
            break;
        }
    }

    public void setSelectedWordPrevItem(int n) {
        for (int i = n - 1; i > 0; --i) {
            StringColourItem stringColourItem = (StringColourItem)this.get(i);
            if (!stringColourItem.isSelectableWord()) continue;
            stringColourItem.selectPrevWord();
            break;
        }
    }

    public void updateStringColourItemWidth(int n, int n2, int n3) {
        StringColourItemText stringColourItemText = ((StringColourItem)this.get(n)).getColourItem();
        this.delete(n);
        this.insert(n, (Item)new StringColourItem(stringColourItemText, n2, n3, n, this));
        this.stringColourItemWidth = n2;
    }

    public void newWord() {
        this.toBeTranslatedWordTextField.setString("");
        this.setFocusToBeTranslatedWordTextField();
    }

    public void setFocusToBeTranslatedWordTextField() {
        if (DictionaryForMIDs.useMIDP20) {
            this.display.setCurrentItem((Item)this.toBeTranslatedWordTextField);
        }
    }

    public void changeInputLanguage() throws DictionaryException {
        this.dictionarySettingFormObj.selectNextInputLanguage();
    }

    public void dictionarySetting() {
        Display.getDisplay((MIDlet)this.dictionaryForMIDsMidlet).setCurrent((Displayable)this.dictionarySettingFormObj);
    }

    public void showHelp() throws DictionaryException {
        UIDisplayTextItem uIDisplayTextItem = UIDisplayTextItems.HelpTextContent;
        uIDisplayTextItem.setAllParameterValues(new String[]{String.valueOf('*'), String.valueOf('?'), String.valueOf('/'), String.valueOf('/')});
        DfMAlert dfMAlert = new DfMAlert(UIDisplayTextItems.CommandHelp, uIDisplayTextItem, AlertType.INFO);
        dfMAlert.setTimeout(-2);
        Display.getDisplay((MIDlet)this.dictionaryForMIDsMidlet).setCurrent((Alert)dfMAlert, (Displayable)this);
    }

    public void showInfo() throws DictionaryException {
        String string = DictionaryForMIDs.versionStatus;
        string = string == null ? new String("") : "/ " + string;
        UIDisplayTextItem uIDisplayTextItem = UIDisplayTextItems.InfoTextContent;
        String[] stringArray = new String[5];
        stringArray[0] = DictionaryDataFile.infoText;
        stringArray[1] = DictionaryForMIDs.applicationName;
        stringArray[2] = "Gert Nuber (dict@kugihan.de)";
        stringArray[3] = "http://dictionarymid.sourceforge.net";
        stringArray[4] = DictionaryForMIDs.versionNumber + string;
        uIDisplayTextItem.setAllParameterValues(stringArray);
        DfMAlert dfMAlert = new DfMAlert(UIDisplayTextItems.CommandInfo, uIDisplayTextItem, AlertType.INFO);
        dfMAlert.setTimeout(-2);
        Display.getDisplay((MIDlet)this.dictionaryForMIDsMidlet).setCurrent((Alert)dfMAlert, (Displayable)this);
    }

    public void displayStatisticItems() throws DictionaryException {
        if (DictionarySettings.getShowStatistic()) {
            this.responseTimeItem.setLabel(UIDisplayTextItems.StatisticResponseTimeInMS);
            this.statisticItem.setLabel(UIDisplayTextItems.StatisticHits);
            this.freeMemoryItem.setLabel(UIDisplayTextItems.StatisticFreeMemory);
            this.freeMemoryItem.setText(String.valueOf(Runtime.getRuntime().freeMemory()));
        } else {
            this.statisticItem.setLabel(UIDisplayTextItems.EmptyText);
            this.statisticItem.setText(null);
            this.responseTimeItem.setLabel(UIDisplayTextItems.EmptyText);
            this.responseTimeItem.setText(null);
            this.freeMemoryItem.setLabel(UIDisplayTextItems.EmptyText);
            this.freeMemoryItem.setText(null);
        }
    }

    public void updateMainFormItemsObj() throws DictionaryException {
        boolean bl;
        this.deletePreviousTranslationResult();
        if (this.toBeTranslatedWordTextField != null) {
            this.delete(0);
        }
        this.mainFormItemsObj = (bl = SettingsStore.getSettingsStore().getColouredItems()) ? new MainFormItemsColoured(this) : new MainFormItemsSimple(this);
        this.toBeTranslatedWordTextField = this.mainFormItemsObj.createToBeTranslatedWordTextField();
        this.updateSelectedLanguage();
        this.insert(0, (Item)this.toBeTranslatedWordTextField);
        this.indexOfFirstTranslationItem = 1;
        this.refreshAllTranslationResults();
        if (DictionaryForMIDs.useMIDP20) {
            this.display.setCurrentItem((Item)this.toBeTranslatedWordTextField);
        }
    }

    public void updateFonts() throws DictionaryException {
        if (!DictionarySettings.getUseBitmapFont()) {
            this.mainFormItemsObj.updateFonts();
        }
    }

    public void updateSelectedLanguage() throws DictionaryException {
        if (DictionarySettings.numberOfSearchableInputLanguages() == 1) {
            this.toBeTranslatedWordTextField.setLabel(UIDisplayTextItems.WordForTranslation);
        } else if (DictionarySettings.isDictionaryAvailable() && this.dictionarySettingFormObj != null) {
            StringBuffer stringBuffer = new StringBuffer();
            LanguageUI.getUI().getClass();
            StringBuffer stringBuffer2 = stringBuffer.append("UIDisplayTextItems.");
            LanguageUI.getUI().getClass();
            String string = stringBuffer2.append("Language").append(DictionaryDataFile.supportedLanguages[DictionarySettings.getInputLanguage()].languageDisplayText).toString();
            StringBuffer stringBuffer3 = new StringBuffer();
            LanguageUI.getUI().getClass();
            StringBuffer stringBuffer4 = stringBuffer3.append("UIDisplayTextItems.");
            LanguageUI.getUI().getClass();
            String string2 = stringBuffer4.append("Language").append(DictionaryDataFile.supportedLanguages[DictionarySettings.determineOutputLanguage()].languageDisplayText).toString();
            UIDisplayTextItems.FromLanguageToLanguage.setAllParameterValues(new String[]{string, string2});
            this.toBeTranslatedWordTextField.setLabel(UIDisplayTextItems.FromLanguageToLanguage);
        }
    }

    public void refreshAllForms() throws DictionaryException {
        this.redisplayLabels();
        this.dictionarySettingFormObj.redisplayLabels();
    }

    public void updateIncrementalSearchSetting() {
        if (!DictionarySettings.isIncrementalSearchEnabled()) {
            this.setItemStateListener(null);
        } else {
            this.setItemStateListener(this);
        }
    }

    protected String addSearchCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.length() > 0) {
            if (DictionarySettings.isAddAtEndWildcardAnySeriesOfCharacter() && stringBuffer.charAt(stringBuffer.length() - 1) != '*') {
                stringBuffer.append('*');
            }
            if (DictionarySettings.isFindExactMatches()) {
                if (stringBuffer.charAt(0) != '/') {
                    stringBuffer.insert(0, '/');
                }
                if (stringBuffer.charAt(stringBuffer.length() - 1) != '/') {
                    stringBuffer.append('/');
                }
            }
            if (DictionarySettings.isAddAtBeginNoSearchSubExpressionCharacter() && stringBuffer.charAt(0) != '/') {
                stringBuffer.insert(0, '/');
            }
        }
        return stringBuffer.toString();
    }

    public void displayTranslationForListItem(Item item) throws DictionaryException {
        int n;
        TranslationExecution.cancelLastTranslation();
        int n2 = -1;
        for (n = this.indexOfFirstTranslationItem; n <= this.indexOfLastTranslationItem; ++n) {
            if (this.get(n) != item) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            throw new DictionaryException("Translation list item not found");
        }
        n = n2 - this.indexOfFirstTranslationItem;
        SingleTranslation singleTranslation = (SingleTranslation)this.lastResultOfTranslation.translations.elementAt(n);
        this.deletePreviousTranslationResult();
        this.displaySingleTranslation(singleTranslation, true);
        this.translationResultStatus.setLabel(UIDisplayTextItems.EmptyText);
        this.setFocusToBeTranslatedWordTextField();
    }

    public void deletePreviousTranslationResult() {
        for (int i = this.indexOfFirstTranslationItem; i <= this.indexOfLastTranslationItem; ++i) {
            this.delete(this.indexOfFirstTranslationItem);
        }
        this.indexOfLastTranslationItem = this.indexOfFirstTranslationItem - 1;
    }

    public void newTranslationResult(TranslationResult translationResult) {
        try {
            Object object;
            this.indexOfLastTranslationItem = this.indexOfFirstTranslationItem - 1;
            this.stringColourItemWidth = this.getWidth();
            UIDisplayTextItem uIDisplayTextItem = UIDisplayTextItems.EmptyText;
            if (translationResult.translationFound) {
                object = translationResult.translations.elements();
                while (object.hasMoreElements()) {
                    SingleTranslation singleTranslation = (SingleTranslation)object.nextElement();
                    this.displaySingleTranslation(singleTranslation, false);
                }
                this.wordHistoryObj.saveHistoryWord();
            } else {
                uIDisplayTextItem = UIDisplayTextItems.TranslationMessageNotFound;
            }
            if (translationResult.translationBreakOccurred) {
                switch (translationResult.translationBreakReason) {
                    case 2: {
                        uIDisplayTextItem = UIDisplayTextItems.TranslationMessageMaxExecutionTimeReached;
                    }
                    case 3: {
                        uIDisplayTextItem = UIDisplayTextItems.TranslationMessageMaxNrOfHitsReached;
                    }
                }
            }
            this.translationResultStatus.setLabel(uIDisplayTextItem);
            Util.memCheck("results displayed: ");
            if (DictionarySettings.getShowStatistic()) {
                object = String.valueOf(translationResult.numberOfHits);
                this.statisticItem.setText((String)object);
                this.responseTimeItem.setText(String.valueOf(translationResult.executionTime));
                System.gc();
                this.freeMemoryItem.setText(String.valueOf(Runtime.getRuntime().freeMemory()));
            }
            this.lastResultOfTranslation = translationResult;
            this.applySonyEricssonWorkaround();
        }
        catch (Throwable throwable) {
            Util.getUtil().log(throwable);
        }
    }

    void displaySingleTranslation(SingleTranslation singleTranslation, boolean bl) throws DictionaryException {
        Object object;
        Object object2;
        String string = singleTranslation.fromText.toString();
        String string2 = singleTranslation.toText.toString();
        boolean bl2 = DictionarySettings.getUseBitmapFont();
        StringColourItemText stringColourItemText = this.contentParserObj.determineItemsFromContent(string, DictionarySettings.getInputLanguage(), true);
        StringColourItemText stringColourItemText2 = this.contentParserObj.determineItemsFromContent(string2, DictionarySettings.determineOutputLanguage(), true);
        if (bl2) {
            int n = this.getWidth();
            object2 = new BitMapFontCanvas(this.contentParserObj.getTextFromStringColourItemText(stringColourItemText).toString(), n);
            object = new BitMapFontCanvas(this.contentParserObj.getTextFromStringColourItemText(stringColourItemText2).toString(), n);
        } else {
            object2 = this.mainFormItemsObj.createTranslationItem(stringColourItemText, true);
            object = this.mainFormItemsObj.createTranslationItem(stringColourItemText2, false);
        }
        this.addTranslationItem((Item)object2);
        if (DictionarySettings.getShowTranslationList() && !bl) {
            this.translationListIsShown = true;
            object2.setDefaultCommand((Command)this.translateCommand);
            object2.setItemCommandListener((ItemCommandListener)this);
        } else {
            this.translationListIsShown = false;
            this.addTranslationItem((Item)object);
        }
    }

    void addTranslationItem(Item item) {
        ++this.indexOfLastTranslationItem;
        this.insert(this.indexOfLastTranslationItem, item);
    }

    public void refreshAllTranslationResults() throws DictionaryException {
        this.deletePreviousTranslationResult();
        if (this.lastResultOfTranslation != null) {
            int n = this.lastResultOfTranslation.translations.size();
            for (int i = 0; i < n; ++i) {
                SingleTranslation singleTranslation = (SingleTranslation)this.lastResultOfTranslation.translations.elementAt(i);
                this.displaySingleTranslation(singleTranslation, false);
            }
        }
    }

    void checkForSonyEricssonWorkaround() {
        String string = System.getProperty("microedition.platform");
        if (string != null && string.startsWith("SonyEricsson") && !string.startsWith("SonyEricssonP")) {
            this.sonyEricssonWorkaroundRequired = true;
        }
    }

    void applySonyEricssonWorkaround() {
        if (this.sonyEricssonWorkaroundRequired) {
            this.showSonyEricssonWorkaroundInfo();
        }
    }

    public void showSonyEricssonWorkaroundInfo() {
        String string = new String("SE workaround");
        Alert alert = new Alert("workaround", string, null, AlertType.INFO);
        alert.setTimeout(10);
        Display.getDisplay((MIDlet)this.dictionaryForMIDsMidlet).setCurrent(alert, (Displayable)this);
    }
}

