/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.hmi_j2me.mainform.bitmapfont;

import de.kugihan.dictionaryformids.hmi_j2me.mainform.bitmapfont.BitMapFontViewer;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public final class BitMapFont {
    private static Hashtable fontsByUrl = new Hashtable();
    private String fontUrl;
    private Image fontImage;
    private boolean hasMixedCase;
    private byte[] characterWidths;
    private short[] xPositions;
    private String characterMap;
    private int fontHeight;
    private int spaceIndex;

    private BitMapFont(String string) {
        this.fontUrl = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitMapFontViewer getViewer(String string, int n) throws Exception {
        Object object;
        if (this.fontImage == null) {
            InputStream inputStream = null;
            try {
                String string2;
                inputStream = this.getClass().getResourceAsStream(this.fontUrl);
                if (inputStream == null) {
                    BitMapFontViewer bitMapFontViewer = null;
                    return bitMapFontViewer;
                }
                object = new DataInputStream(inputStream);
                this.hasMixedCase = ((DataInputStream)object).readBoolean();
                this.characterMap = string2 = ((DataInputStream)object).readUTF();
                this.spaceIndex = string2.indexOf(32);
                int n2 = string2.length();
                this.characterWidths = new byte[n2];
                this.xPositions = new short[n2];
                short s = 0;
                for (int i = 0; i < n2; ++i) {
                    byte by;
                    this.characterWidths[i] = by = ((DataInputStream)object).readByte();
                    this.xPositions[i] = s;
                    s = (short)(s + by);
                }
                this.fontImage = Image.createImage((InputStream)inputStream);
                this.fontHeight = this.fontImage.getHeight();
                this.fontUrl = null;
            }
            catch (IOException iOException) {
                System.out.println("Unable to load bitmap-font [" + this.fontUrl + "]" + iOException);
                BitMapFontViewer bitMapFontViewer = null;
                return bitMapFontViewer;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    System.out.println("Unable to close bitmap-font stream" + iOException);
                }
            }
        }
        if (!this.hasMixedCase) {
            string = string.toLowerCase();
        }
        int n3 = string.length();
        object = new int[n3];
        for (int i = n3 - 1; i >= 0; --i) {
            String string3 = string.substring(i, i + 1);
            object[i] = this.characterMap.indexOf(string3);
            if (object[i] != -1) continue;
            object[i] = this.characterMap.indexOf("?");
            System.out.println("BitMapFont: " + string3 + " not found - substituting with ?");
        }
        return new BitMapFontViewer(this.fontImage, (int[])object, this.xPositions, this.characterWidths, this.fontHeight, this.spaceIndex, 1, n);
    }

    public static BitMapFont getInstance(String string) {
        BitMapFont bitMapFont = (BitMapFont)fontsByUrl.get(string);
        if (bitMapFont == null) {
            bitMapFont = new BitMapFont(string);
            fontsByUrl.put(string, bitMapFont);
        }
        return bitMapFont;
    }
}

