/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.hmi_j2me.mainform.bitmapfont;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BitMapFontViewer {
    protected static final byte ABSOLUTE_LINE_BREAK = -2;
    protected static final byte ARTIFICAL_LINE_BREAK = -3;
    private final Image image;
    private int linesPainted;
    private final short[] xPositions;
    private final byte[] usedCharactersWidths;
    private final int fontHeight;
    private int verticalPadding;
    private final int spaceIndex;
    private int height;
    private int width;
    private int numberOfLines;
    private short[] lineWidths;
    private final int[] indeces;
    private final byte[] actualCharacterWidths;
    private final short[] originalLineIndeces;
    private int orientation;
    private int maxWidthPixels;

    public BitMapFontViewer(Image image, int[] nArray, short[] sArray, byte[] byArray, int n, int n2, int n3, int n4) {
        this.image = image;
        this.maxWidthPixels = n4;
        this.indeces = nArray;
        this.actualCharacterWidths = byArray;
        this.spaceIndex = n2;
        this.lineWidths = new short[20];
        this.originalLineIndeces = new short[20];
        this.verticalPadding = n3;
        this.xPositions = new short[nArray.length];
        this.usedCharactersWidths = new byte[nArray.length];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            byte by;
            int n8 = nArray[i];
            if (n8 == -2) {
                if (n5 > n6) {
                    n6 = n5;
                }
                this.originalLineIndeces[n7] = (short)i;
                this.lineWidths[n7] = n5;
                n5 = 0;
                this.usedCharactersWidths[i] = -2;
                n7 = (short)(n7 + 1);
                continue;
            }
            this.xPositions[i] = sArray[n8];
            this.usedCharactersWidths[i] = by = byArray[n8];
            n5 = (short)(n5 + by);
        }
        this.lineWidths[n7] = n5;
        if (n5 > n6) {
            n6 = n5;
        }
        this.numberOfLines = n7 + 1;
        this.height = this.numberOfLines * (n + n3) - n3;
        this.width = n6;
        this.fontHeight = n;
        this.calculateLines(0);
    }

    public int getLinesPainted() {
        return this.linesPainted;
    }

    public void calculateLines(int n) {
        int n2 = n;
        this.linesPainted = 1;
        for (int i = 0; i < this.xPositions.length; ++i) {
            byte by = this.usedCharactersWidths[i];
            if (n + by > this.maxWidthPixels) {
                ++this.linesPainted;
                n = n2;
                --i;
                continue;
            }
            n += by;
        }
    }

    public void paint(int n, int n2, Graphics graphics) {
        boolean bl;
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        int n5 = graphics.getClipWidth();
        int n6 = graphics.getClipHeight();
        int n7 = n3 + n5;
        int n8 = n;
        boolean bl2 = this.orientation == 8;
        boolean bl3 = bl = this.orientation == 1;
        if (bl) {
            n = n8 - this.lineWidths[0] / 2;
        } else if (bl2) {
            n = n8 - this.lineWidths[0];
        }
        int n9 = 0;
        for (int i = 0; i < this.xPositions.length; ++i) {
            byte by = this.usedCharactersWidths[i];
            if (by == 0) continue;
            if (n + by > this.maxWidthPixels) {
                n = bl ? n8 - this.lineWidths[n9] / 2 : (bl2 ? n8 - this.lineWidths[++n9] : n8);
                n2 += this.fontHeight + this.verticalPadding;
                --i;
                continue;
            }
            if (n >= n7) continue;
            graphics.clipRect(n, n2, (int)by, this.fontHeight);
            int n10 = n - this.xPositions[i];
            graphics.drawImage(this.image, n10, n2, 20);
            n += by;
            graphics.setClip(n3, n4, n5, n6);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void layout(int n, int n2, int n3, int n4) {
        this.orientation = n4;
        this.verticalPadding = n3;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        int n9 = 0;
        int n10 = 0;
        for (int i = 0; i < this.usedCharactersWidths.length; ++i) {
            byte by = this.usedCharactersWidths[i];
            if (by == -3) {
                this.usedCharactersWidths[i] = by = this.actualCharacterWidths[this.indeces[i]];
            } else if (by == -2) {
                this.lineWidths[n5] = n6;
                if (n6 > n7) {
                    n7 = n6;
                }
                n10 = i + 1;
                ++n5;
                n6 = 0;
                continue;
            }
            int n11 = this.indeces[i];
            if (n11 == this.spaceIndex) {
                n8 = i;
                n9 = n6;
            }
            if ((n6 = (int)((short)(n6 + by))) > n && n8 > n10) {
                this.usedCharactersWidths[n8] = -3;
                n10 = n8 + 1;
                this.lineWidths[n5] = (short)n9;
                if (n9 > n7) {
                    n7 = (short)n9;
                }
                n6 = (short)(n6 - n9);
                ++n5;
            }
            n = n2;
        }
        this.lineWidths[n5] = n6;
        if (n6 > n7) {
            n7 = n6;
        }
        this.numberOfLines = n5 + 1;
        this.width = n7;
        this.height = this.numberOfLines * (this.fontHeight + n3) - n3;
    }

    public int getFontHeigth() {
        return this.fontHeight;
    }

    public int getNumberOfLines() {
        return this.numberOfLines;
    }
}

