/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.translation;

import de.kugihan.dictionaryformids.dataaccess.CsvFile;
import de.kugihan.dictionaryformids.dataaccess.DictionaryDataFile;
import de.kugihan.dictionaryformids.dataaccess.LanguageDefinition;
import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.general.Util;
import de.kugihan.dictionaryformids.hmi_j2me.DictionarySettings;
import de.kugihan.dictionaryformids.translation.SearchIndicator;
import de.kugihan.dictionaryformids.translation.SearchedWord;
import de.kugihan.dictionaryformids.translation.SingleTranslation;
import de.kugihan.dictionaryformids.translation.TranslationResult;
import de.kugihan.dictionaryformids.translation.normation.Normation;
import java.util.Vector;

public class Translation {
    boolean searchSubExpressionStart = true;
    boolean searchSubExpressionEnd = true;
    public static final char wildcardAnySeriesOfCharacter = '*';
    public static final char wildcardAnySingleCharacter = '?';
    public static final char noSearchSubExpressionCharacter = '/';
    TranslationResult resultOfTranslation = new TranslationResult();
    long startTime;
    volatile boolean translationIsCancelled = false;

    public Translation(boolean bl, boolean bl2) {
        this.searchSubExpressionStart = bl;
        this.searchSubExpressionEnd = bl2;
    }

    static int positionFirstWildcardCharacter(String string) {
        int n = string.indexOf(42);
        int n2 = string.indexOf(63);
        int n3 = n2 == -1 && n == -1 ? -1 : (n2 == -1 && n > -1 ? n : (n2 > -1 && n == -1 ? n2 : (n2 < n ? n2 : n)));
        return n3;
    }

    static String expressionTillWildcard(String string) {
        return string.substring(0, Translation.positionFirstWildcardCharacter(string));
    }

    public TranslationResult getTranslationResult(String string) {
        this.resultOfTranslation.numberOfHits = 0L;
        this.startTime = System.currentTimeMillis();
        Util.memCheck("start translation: ");
        try {
            Normation normation = DictionaryDataFile.supportedLanguages[DictionarySettings.getInputLanguage()].normationObj;
            Vector vector = normation.searchWord(string);
            for (int i = 0; i < vector.size(); ++i) {
                SearchedWord searchedWord = (SearchedWord)vector.elementAt(i);
                String string2 = searchedWord.word;
                String string3 = normation.normateWord(new StringBuffer(string2), true).toString();
                if (string3.length() <= 0) continue;
                this.searchTranslationForNormatedWord(string3);
            }
        }
        catch (Throwable throwable) {
            Util.getUtil().log(throwable);
        }
        long l = System.currentTimeMillis();
        this.resultOfTranslation.executionTime = l - this.startTime;
        Util.memCheck("end translation: ");
        return this.resultOfTranslation;
    }

    public void searchTranslationForNormatedWord(String string) throws DictionaryException {
        boolean bl = Translation.positionFirstWildcardCharacter(string) >= 0;
        String string2 = bl ? Translation.expressionTillWildcard(string) : string;
        int n = string2.length();
        String string3 = DictionaryDataFile.supportedLanguages[DictionarySettings.getInputLanguage()].languageFilePostfix;
        String string4 = DictionaryDataFile.getPathDataFiles() + DictionaryDataFile.prefixSearchListFile + string3 + DictionaryDataFile.suffixSearchListFile;
        CsvFile csvFile = new CsvFile(string4, DictionaryDataFile.searchListFileSeparationCharacter, DictionaryDataFile.searchListCharEncoding, DictionaryDataFile.searchListFileMaxSize);
        Util.memCheck("searchfile open: ");
        String string5 = null;
        boolean bl2 = false;
        csvFile.setPositionBefore(string2);
        while (!csvFile.endOfDictionaryReached) {
            int n2;
            String string6 = csvFile.getWord().toString();
            if (bl) {
                String string7;
                n2 = n;
                int n3 = string6.length();
                if (n3 < n) {
                    n2 = n3;
                }
                if ((string7 = string6.substring(0, n2)).startsWith(string2)) {
                    if (!bl2 && string5 != null && this.searchInIndexFileBreakCondition(string, string5) || this.searchInIndexFileBreakCondition(string, string5 = csvFile.getWord().toString())) break;
                    bl2 = true;
                    continue;
                }
                if (string7.compareTo(string2) > 0) {
                    if (bl2 || string5 == null || !this.searchInIndexFileBreakCondition(string, string5)) break;
                    break;
                }
                string5 = csvFile.getWord().toString();
                continue;
            }
            if (string6.compareTo(string2) >= 0) {
                if (string5 != null && this.searchInIndexFileBreakCondition(string, string5)) break;
                n2 = 0;
                if (string6.startsWith(string2)) {
                    if (string6.length() > string2.length()) {
                        if (string6.charAt(string2.length()) == ' ') {
                            n2 = 1;
                        }
                    } else {
                        n2 = 1;
                    }
                }
                if (n2 == 0) break;
                string5 = csvFile.getWord().toString();
                continue;
            }
            string5 = csvFile.getWord().toString();
        }
        if (csvFile.endOfDictionaryReached && !bl2) {
            this.searchInIndexFileBreakCondition(string, string5);
        }
        csvFile = null;
    }

    public boolean searchInIndexFileBreakCondition(String string, String string2) throws DictionaryException {
        if (this.translationBreakCondition()) {
            return true;
        }
        this.searchInIndexFile(string, string2);
        return this.translationBreakCondition();
    }

    public void searchInIndexFile(String string, String string2) throws DictionaryException {
        Util.getUtil().logDebug("indexFileNumber " + string2);
        String string3 = DictionaryDataFile.supportedLanguages[DictionarySettings.getInputLanguage()].languageFilePostfix;
        String string4 = DictionaryDataFile.getPathDataFiles() + DictionaryDataFile.prefixIndexFile + string3 + string2 + DictionaryDataFile.suffixIndexFile;
        boolean bl = Translation.positionFirstWildcardCharacter(string) >= 0;
        String string5 = string;
        String string6 = bl ? Translation.expressionTillWildcard(string) : string;
        int n = string6.length();
        String string7 = null;
        Util.getUtil().logDebug("indexFileName " + string4);
        CsvFile csvFile = new CsvFile(string4, DictionaryDataFile.indexFileSeparationCharacter, DictionaryDataFile.indexCharEncoding, DictionaryDataFile.indexFileMaxSize);
        Util.memCheck("indexfile open: ");
        csvFile.setPositionBefore(string6);
        while (!csvFile.endOfDictionaryReached) {
            String string8;
            String string9 = csvFile.getWord().toString();
            if (!bl) {
                if (string9.compareTo(string5) < 0) {
                    csvFile.skipRestOfLine();
                    continue;
                }
                if (!string9.startsWith(string5)) break;
                if (this.noWildcardMatchRest(string5, string9)) {
                    string7 = csvFile.getWord().toString();
                    this.getDictionaryEntry(string7);
                    continue;
                }
                csvFile.skipRestOfLine();
                continue;
            }
            int n2 = n;
            int n3 = string9.length();
            if (n3 < n) {
                n2 = n3;
            }
            if (string6.compareTo(string8 = string9.substring(0, n2)) < 0) break;
            if (this.wildcardMatch(string9, 0, string9.length(), string5, 0, string5.length())) {
                string7 = csvFile.getWord().toString();
                this.getDictionaryEntry(string7);
                continue;
            }
            csvFile.skipRestOfLine();
        }
    }

    public final boolean wildcardMatch(String string, int n, int n2, String string2, int n3, int n4) {
        boolean bl = false;
        if (n3 == n4) {
            bl = n == n2 ? true : (n2 > n && this.searchSubExpressionEnd ? string.charAt(n) == ' ' : false);
        } else if (n == n2) {
            boolean bl2 = true;
            for (int i = n3; i < n4; ++i) {
                if (string2.charAt(i) == '*') continue;
                bl2 = false;
                break;
            }
            bl = bl2;
        } else {
            char c = string.charAt(n);
            char c2 = string2.charAt(n3);
            if (c2 == '?') {
                bl = this.wildcardMatch(string, n + 1, n2, string2, n3 + 1, n4);
            } else if (c2 == '*') {
                for (int i = n; i <= n2 && !(bl = this.wildcardMatch(string, i, n2, string2, n3 + 1, n4)); ++i) {
                }
            } else if (c2 == c) {
                bl = this.wildcardMatch(string, n + 1, n2, string2, n3 + 1, n4);
            }
        }
        return bl;
    }

    public boolean noWildcardMatchRest(String string, String string2) {
        int n;
        int n2 = string.length();
        if (n2 == (n = string2.length())) {
            return true;
        }
        return n > n2 && this.searchSubExpressionEnd && string2.charAt(n2) == ' ';
    }

    public void getDictionaryEntry(String string) throws DictionaryException {
        int n;
        int n2 = 0;
        do {
            int n3 = (n = string.indexOf(DictionaryDataFile.indexFileSeparatorIndexEntries, n2)) == -1 ? string.length() : n;
            String string2 = string.substring(n2, n3);
            n2 = n3 + 1;
            int n4 = string2.indexOf(DictionaryDataFile.indexFileSeparatorFileNumberToPosition);
            String string3 = string2.substring(0, n4);
            int n5 = string2.indexOf(DictionaryDataFile.indexFileSeparatorFilePositionToSearchIndicator, n4 + 1);
            if (n5 == -1) {
                throw new DictionaryException("Indexfile has no searchindicator - use DictionaryGeneration 2.4.4 or newer");
            }
            int n6 = Integer.valueOf(string2.substring(n4 + 1, n5));
            SearchIndicator searchIndicator = new SearchIndicator(string2.charAt(n5 + 1));
            if (!this.searchSubExpressionStart && !searchIndicator.isBeginOfExpression()) continue;
            LanguageDefinition languageDefinition = DictionaryDataFile.supportedLanguages[DictionarySettings.getInputLanguage()];
            String string4 = languageDefinition.hasSeparateDictionaryFile ? languageDefinition.languageFilePostfix : "";
            if (this.translationBreakCondition()) break;
            String string5 = DictionaryDataFile.getPathDataFiles() + DictionaryDataFile.prefixDictionaryFile + string4 + string3 + DictionaryDataFile.suffixDictionaryFile;
            Util.getUtil().logDebug("dictionaryFileName " + string5);
            Util.getUtil().logDebug("position " + String.valueOf(n6));
            this.getTranslation(string5, n6, searchIndicator.isBeginOfExpression());
        } while (n > 0);
    }

    public void getTranslation(String string, int n, boolean bl) throws DictionaryException {
        CsvFile csvFile = new CsvFile(string, DictionaryDataFile.dictionaryFileSeparationCharacter, DictionaryDataFile.dictionaryCharEncoding, DictionaryDataFile.dictionaryFileMaxSize, n);
        Util.memCheck("dictionaryfile open: ");
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        int n2 = DictionarySettings.determineOutputLanguage();
        for (int i = 0; i < DictionaryDataFile.numberOfAvailableLanguages; ++i) {
            StringBuffer stringBuffer3 = csvFile.getWord();
            if (DictionarySettings.getInputLanguage() == i) {
                stringBuffer = stringBuffer3;
            }
            if (n2 != i) continue;
            stringBuffer2 = stringBuffer3;
        }
        this.addTranslation(stringBuffer, stringBuffer2, bl);
        csvFile = null;
    }

    public void addTranslation(StringBuffer stringBuffer, StringBuffer stringBuffer2, boolean bl) {
        if (stringBuffer2 == null) {
            stringBuffer2 = new StringBuffer();
        }
        if (stringBuffer2.length() > 0) {
            Util.getUtil().convertFieldAndLineSeparatorChars(stringBuffer2);
            boolean bl2 = false;
            if (stringBuffer2.equals("???")) {
                bl2 = true;
            }
            if (!bl2) {
                Util.getUtil().convertFieldAndLineSeparatorChars(stringBuffer);
                SingleTranslation singleTranslation = new SingleTranslation(stringBuffer, stringBuffer2);
                if (bl) {
                    this.resultOfTranslation.translations.insertElementAt(singleTranslation, 0);
                } else {
                    this.resultOfTranslation.translations.addElement(singleTranslation);
                }
                this.resultOfTranslation.translationFound = true;
                ++this.resultOfTranslation.numberOfHits;
            }
        }
    }

    boolean translationBreakCondition() {
        if (this.resultOfTranslation.numberOfHits >= (long)DictionarySettings.getMaxHits()) {
            this.resultOfTranslation.translationBreakOccurred = true;
            this.resultOfTranslation.translationBreakReason = 3;
            return true;
        }
        if (System.currentTimeMillis() - this.startTime >= (long)DictionarySettings.getDurationForCancelSearch()) {
            this.resultOfTranslation.translationBreakOccurred = true;
            this.resultOfTranslation.translationBreakReason = 2;
            return true;
        }
        if (this.translationIsCancelled) {
            this.resultOfTranslation.translationBreakOccurred = true;
            this.resultOfTranslation.translationBreakReason = 1;
            return true;
        }
        return false;
    }

    public void cancelTranslation() {
        this.translationIsCancelled = true;
    }
}

