/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.translation;

import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.general.Util;
import de.kugihan.dictionaryformids.hmi_j2me.DictionarySettings;
import de.kugihan.dictionaryformids.translation.Translation;
import de.kugihan.dictionaryformids.translation.TranslationExecution;
import de.kugihan.dictionaryformids.translation.TranslationResult;

class TranslationThread
implements Runnable {
    protected volatile boolean translationIsCancelled = false;
    protected Translation translate = null;
    protected Thread ownExecutionThread;
    protected String toBeTranslatedWordText;
    protected boolean executeInBackground;

    public TranslationThread(String string, boolean bl) {
        this.toBeTranslatedWordText = string;
        this.executeInBackground = bl;
    }

    public void setOwnExecutionThread(Thread thread) {
        this.ownExecutionThread = thread;
    }

    public void run() {
        try {
            this.doTranslation();
        }
        catch (Throwable throwable) {
            Util.getUtil().log(throwable);
        }
    }

    public void runInForeground() throws DictionaryException {
        this.doTranslation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTranslation() throws DictionaryException {
        TranslationThread translationThread = this;
        synchronized (translationThread) {
            if (!this.translationIsCancelled) {
                TranslationExecution.translationResultHMIObj.deletePreviousTranslationResult();
            }
        }
        if (this.executeInBackground) {
            this.ownExecutionThread.setPriority(3);
        }
        this.toBeTranslatedWordText = Util.removeSuperflousSearchCharacters(this.toBeTranslatedWordText);
        if (this.toBeTranslatedWordText.length() > 0) {
            boolean bl = true;
            boolean bl2 = true;
            if (this.toBeTranslatedWordText.charAt(0) == '/') {
                bl = false;
                this.toBeTranslatedWordText = this.toBeTranslatedWordText.length() > 1 ? this.toBeTranslatedWordText.substring(1) : new String("");
            } else {
                bl = true;
            }
            if (this.toBeTranslatedWordText.length() > 0 && this.toBeTranslatedWordText.charAt(this.toBeTranslatedWordText.length() - 1) == '/') {
                bl2 = false;
                this.toBeTranslatedWordText = this.toBeTranslatedWordText.substring(0, this.toBeTranslatedWordText.length() - 1);
            } else {
                bl2 = true;
            }
            this.translate = new Translation(bl, bl2);
            TranslationResult translationResult = null;
            if (!this.translationIsCancelled) {
                translationResult = this.translate.getTranslationResult(this.toBeTranslatedWordText);
            }
            TranslationThread translationThread2 = this;
            synchronized (translationThread2) {
                if (!this.translationIsCancelled) {
                    TranslationExecution.translationResultHMIObj.newTranslationResult(translationResult);
                }
            }
            this.translate = null;
        }
    }

    public synchronized void cancelTranslation() {
        this.translationIsCancelled = true;
        if (this.translate != null) {
            this.translate.cancelTranslation();
        }
        if (DictionarySettings.isCldc11()) {
            this.ownExecutionThread.interrupt();
        }
    }
}

