/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.translation.normation;

import de.kugihan.dictionaryformids.general.Util;
import de.kugihan.dictionaryformids.translation.SearchedWord;
import de.kugihan.dictionaryformids.translation.normation.Normation;
import de.kugihan.dictionaryformids.translation.normation.normationjpn.Parser;
import java.util.Vector;

public class NormationJpn
extends Normation {
    Parser parserObj = new Parser();
    private final int HIRAGANA;
    private final int KATAKANA;

    public NormationJpn() {
        this.HIRAGANA = 0;
        this.KATAKANA = 1;
    }

    public Vector searchWord(String string) {
        Vector<SearchedWord> vector = new Vector<SearchedWord>(2);
        string = Util.convertToLowerCase(new StringBuffer(string)).toString();
        int n = 0;
        char c = string.charAt(n);
        while (c == '*' || c == '?') {
            c = string.charAt(++n);
        }
        if (this.isRomaji(c)) {
            String string2 = this.parserObj.convert(string, 0, true);
            vector.addElement(new SearchedWord(string2));
            String string3 = this.parserObj.convert(string, 1, true);
            vector.addElement(new SearchedWord(string3));
        } else if (this.isHiragana(c)) {
            vector.addElement(new SearchedWord(string));
            String string4 = this.parserObj.convert(string, 0, false);
            String string5 = this.parserObj.convert(string4, 1, true);
            vector.addElement(new SearchedWord(string5));
        } else if (this.isKatakana(c)) {
            vector.addElement(new SearchedWord(string));
            String string6 = this.parserObj.convert(string, 1, false);
            String string7 = this.parserObj.convert(string6, 0, true);
            vector.addElement(new SearchedWord(string7));
        } else {
            System.err.println("Illegal input string in normationjpn.");
        }
        return vector;
    }

    public boolean isRomaji(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public boolean isHiragana(char c) {
        return c >= '\u3040' && c <= '\u309f';
    }

    public boolean isKatakana(char c) {
        return c >= '\u30a0' && c <= '\u30ff';
    }
}

