/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.translation.normation.normationjpn;

import de.kugihan.dictionaryformids.dataaccess.CsvFile;
import de.kugihan.dictionaryformids.general.DictionaryException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class LookupTable {
    private Hashtable romajiToHiraganaTable = null;
    private Hashtable romajiToKatakanaTable = null;
    private Hashtable katakanaToRomajiTable = null;
    private Hashtable hiraganaToRomajiTable = null;
    private final int maxSize;

    public LookupTable() {
        this.maxSize = 20480;
    }

    private Hashtable initialiseTable(String string, boolean bl) throws UnsupportedEncodingException, IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            String string2;
            CsvFile csvFile = new CsvFile(string, '=', "UTF-8", 20480);
            csvFile.readCsvFileComplete();
            while (!(string2 = csvFile.getWord().toString()).equals("")) {
                String string3 = csvFile.getWord().toString();
                if (!bl) {
                    hashtable.put(string2, string3);
                    continue;
                }
                hashtable.put(string3, string2);
            }
        }
        catch (DictionaryException dictionaryException) {
            System.out.println(dictionaryException);
        }
        return hashtable;
    }

    public Hashtable getRomajiToHiraganaTable() {
        if (this.romajiToHiraganaTable == null) {
            try {
                this.romajiToHiraganaTable = this.initialiseTable("/char_lists/romaji_hiragana_utf8.txt", false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.romajiToHiraganaTable;
    }

    public Hashtable getRomajiToKatakanaTable() {
        if (this.romajiToKatakanaTable == null) {
            try {
                this.romajiToKatakanaTable = this.initialiseTable("/char_lists/romaji_katakana_utf8.txt", false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.romajiToKatakanaTable;
    }

    public Hashtable getHiraganaToRomajiTable() {
        if (this.hiraganaToRomajiTable == null) {
            try {
                this.hiraganaToRomajiTable = this.initialiseTable("/char_lists/romaji_hiragana_utf8.txt", true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.hiraganaToRomajiTable;
    }

    public Hashtable getKatakanaToRomajiTable() {
        if (this.katakanaToRomajiTable == null) {
            try {
                this.katakanaToRomajiTable = this.initialiseTable("/char_lists/romaji_katakana_utf8.txt", true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.katakanaToRomajiTable;
    }
}

