/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.DeviceControl;
import com.nokia.mid.ui.FullCanvas;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas
extends FullCanvas {
    static final int KEY_UP_1 = -1;
    static final int KEY_DOWN_1 = -2;
    static final int KEY_LEFT_1 = -3;
    static final int KEY_RIGHT_1 = -4;
    static final int KEY_FIRE_1 = -5;
    static final int KEY_SOFT_1 = -6;
    static final int KEY_SOFT_2 = -7;
    static final int INIT = 0;
    static final int MENU = 1;
    static final int EXPLAIN = 2;
    static final int STORY = 3;
    static final int OPENING = 4;
    static final int PLAYING = 5;
    static final int GAME_END = 6;
    static final int GAME_OVER = 7;
    static final int FINAL_ENDING = 8;
    static final int DRAW_PAUSE = 9;
    static final int PAUSE_HELP = 10;
    static final int CREATE_BALL = 0;
    static final int READY = 1;
    static final int JUMP = 2;
    static final int FLY = 3;
    static final int SUCCESS = 4;
    static final int EXPLODE = 5;
    static final int SCROLL = 6;
    static final int BONUS = 7;
    static final int BONUS_SUCCESS = 8;
    static final int BONUS_FAIL = 9;
    static final int ENDING_ANI = 10;
    public static int menuItemHeight;
    public static int menuItemStartY;
    static final int[] MENU_ITEM;
    public static boolean lightEnable;
    public static boolean vibration;
    public static boolean sound;
    public static boolean keyEnable;
    static int menuIndex;
    public static int state;
    public static int playState;
    public static Image backImg;
    public static Image ballImg;
    public static Image basketImg;
    public static Image letterImg;
    public static Image mountainImg;
    public static Image cannonImg;
    public static Image gunportImg;
    public static Image planeImg;
    public static Image statusImg;
    public static Image inject1Img;
    public static Image inject2Img;
    public static Image endingImg;
    public static Image menuImg;
    public static Image finalImg;
    public static Image stageImg;
    public static Image greatFireImg;
    public static Image titleImg;
    Image offImage;
    Image offImage2;
    Graphics offScreen;
    Graphics offScreen2;
    public static Cannon midlet;
    public static GeneralThread generalThread;
    public static Vector vector;
    public static boolean needAllClear;
    public static boolean checkSuccess;
    public static boolean isBonus;
    public static boolean bonusSuccess;
    public static int endingLineNb;
    public static int endingMaxLine;
    public static int basket1X;
    public static int basket1Y;
    public static int basket1Velo;
    public static int v1X;
    public static int v1Y;
    public static int bound1X1;
    public static int bound1X2;
    public static int fix1Y;
    public static int fix2Y;
    public static int basket2Velo;
    public static int basket2X;
    public static int basket2Y;
    public static int v2X;
    public static int v2Y;
    public static int bound2X1;
    public static int bound2X2;
    public static boolean centerVary1;
    public static boolean centerVary2;
    public static int basket3X;
    public static int basket3Y;
    public static int distance2;
    public static int v3Y;
    public static int add;
    public static int tempCurHeight;
    public static int tempBallY;
    public static int tempBasket1Y;
    public static int tempBasket2Y;
    public static int tempBasket3Y;
    public static int ballX;
    public static int ballY;
    public static int ballVelo;
    public static int ballType;
    public static int distance;
    public static int stateCount;
    public static int curBasket;
    public static int curHeight;
    public static int curStage;
    public static int life;
    public static int time;
    public static final int JUMP_VELO = -20;
    public static final int ACCEL = 4;
    public static final int STD_HEIGHT = 52;
    public static int LAND_HEIGHT;
    public static int THIS_HEIGHT;
    public static int BASKET_WIDTH;
    public static int STATUS_HEIGHT;
    public static int LCD_WIDTH;
    public static int LCD_HEIGHT;
    public static int WIDTH;
    public static int HEIGHT;
    public static int MAX_BASKET;
    public static int BG_HEIGHT;
    public static int MOUNTAIN_HEIGHT;
    public static int[][] explodePos;
    public static String[][] OPENING_STR;
    public static String[] HOWTOPLAY_TEXT;
    public static String[] STORY_TEXT;
    public static String ENDING_STR;
    public static final int[][] BASKET_INFO;
    byte[] airplane3 = new byte[]{2, 74, 58, 64, 4, 0, 37, 28, -78, 48, 45, 2, 48, 45, 2, 48, 45, 2, 48, 45, 2, 48, 45, 2, 48, 45, 2, 48, 45, 2, 48, 45, 0, 0};
    byte[] bonus = new byte[]{2, 74, 58, 64, 4, 0, 11, 28, -126, -51, 43, 18, -51, 0};
    byte[] boom = new byte[]{2, 74, 58, 64, 4, 0, 7, 28, -78, -51, 0};
    byte[] b_success = new byte[]{2, 74, 58, 64, 4, 0, 53, 28, 70, -92, 24, 70, -92, 24, 66, 4, 40, -125, 21, 32, -62, 16, 33, 67, 21, 32, -60, -109, -87, 6, 16, -127, 10, 32, -59, 72, 48, -124, 8, 81, 36, 90, 0};
    byte[] end_drop = new byte[]{2, 74, 58, 64, 4, 0, 35, 28, -78, -76, 39, 66, 52, 57, 67, 84, 49, 66, -12, 43, 66, 116, 35, 67, -108, 53, 67, 20, 47, 66, -76, 0};
    byte[] end_shoot = new byte[]{2, 74, 58, 64, 4, 0, 5, 28, 93, -96, 0};
    byte[] ending = new byte[]{2, 74, 58, 64, 4, 0, 113, 28, 70, -124, 32, -126, -12, 33, 66, 20, 73, 26, 16, -126, 11, -48, -124, 18, 70, -124, 40, 66, -120, 47, 66, 16, 73, 26, 16, -126, 11, -48, -123, 8, 81, 36, 104, 66, 8, 47, 66, 16, 73, 26, 16, -95, 10, 32, -67, 8, 65, 36, 104, -125, 116, 47, 67, 116, 73, 26, 32, -35, 18, 70, -120, 55, 68, -111, -96, 0};
    byte[] gain = new byte[]{2, 74, 58, 64, 4, 0, 9, 22, -126, 45, 35, 64, 0};
    byte[] gameover = new byte[]{2, 74, 58, 64, 4, 0, 15, 28, 69, -88, 56, -45, 77, 56, -45, 5, 0};
    byte[] intro = new byte[]{2, 74, 58, 64, 4, 0, -51, 28, 70, -124, 32, -126, -12, 33, 66, 20, 73, 26, 16, -126, 11, -48, -124, 18, 70, -124, 40, 66, -120, 47, 66, 16, 73, 26, 16, -126, 11, -48, -123, 8, 81, 36, 104, 66, 8, 47, 66, 16, 73, 26, 16, -95, 10, 32, -67, 8, 65, 36, 104, 66, 8, 47, 66, 20, 33, 68, -111, -95, 8, 17, -95, 8, 17, -95, 10, 16, -94, 11, -48, -124, 18, 70, -124, 32, -126, -12, 33, 66, 20, 73, 26, 16, -126, 11, -48, -124, 18, 70, -124, 40, 66, -120, 47, 66, 16, 73, 26, 16, -126, 11, -48, -123, 8, 81, 36, 104, 66, 8, 47, 66, 16, 73, 26, 21, -94, 11, -47, 37, 104, 70, -123, 104, 70, -123, 104, 0};
    byte[] shoot = new byte[]{2, 74, 58, 64, 4, 0, 7, 28, -125, 69, 0};
    byte[] success = new byte[]{2, 74, 58, 64, 4, 0, 9, 28, -125, 112, 37, 0, 0};
    public static Sound airplane3Sound;
    public static Sound bonusSound;
    public static Sound boomSound;
    public static Sound b_successSound;
    public static Sound end_dropSound;
    public static Sound end_shootSound;
    public static Sound endingSound;
    public static Sound gainSound;
    public static Sound gameoverSound;
    public static Sound introSound;
    public static Sound shootSound;
    public static Sound successSound;
    public static boolean pauseParam;
    public static boolean alive;
    public static boolean airplane3Ing;
    public static boolean bonusIng;
    public static boolean boomIng;
    public static boolean b_successIng;
    public static boolean end_dropIng;
    public static boolean end_shootIng;
    public static boolean endingIng;
    public static boolean gainIng;
    public static boolean gameoverIng;
    public static boolean introIng;
    public static boolean shootIng;
    public static boolean successIng;
    public static int storyStart;
    public static int storyEnd;

    public void playSound(int n) {
        if (sound) {
            airplane3Sound.stop();
            bonusSound.stop();
            boomSound.stop();
            b_successSound.stop();
            end_dropSound.stop();
            end_shootSound.stop();
            endingSound.stop();
            gainSound.stop();
            gameoverSound.stop();
            introSound.stop();
            shootSound.stop();
            successSound.stop();
            switch (n) {
                case 0: {
                    if (airplane3Ing) break;
                    airplane3Sound.play(1);
                    airplane3Ing = true;
                    break;
                }
                case 1: {
                    if (bonusIng) break;
                    bonusSound.play(1);
                    bonusIng = true;
                    break;
                }
                case 2: {
                    if (boomIng) break;
                    boomSound.play(1);
                    boomIng = true;
                    break;
                }
                case 3: {
                    if (b_successIng) break;
                    b_successSound.play(1);
                    b_successIng = true;
                    break;
                }
                case 4: {
                    if (end_dropIng) break;
                    end_dropSound.play(1);
                    end_dropIng = true;
                    break;
                }
                case 5: {
                    if (end_shootIng) break;
                    end_shootSound.play(1);
                    end_shootIng = true;
                    break;
                }
                case 6: {
                    if (endingIng) break;
                    endingSound.play(1);
                    endingIng = true;
                    break;
                }
                case 7: {
                    if (gainIng) break;
                    gainSound.play(1);
                    gainIng = true;
                    break;
                }
                case 8: {
                    if (gameoverIng) break;
                    gameoverSound.play(1);
                    gameoverIng = true;
                    break;
                }
                case 9: {
                    if (introIng) break;
                    introSound.play(1);
                    introIng = true;
                    break;
                }
                case 10: {
                    if (shootIng) break;
                    shootSound.play(1);
                    shootIng = true;
                    break;
                }
                case 11: {
                    if (successIng) break;
                    successSound.play(1);
                    successIng = true;
                    break;
                }
            }
        }
    }

    public void startCanvas() {
        this.gameInitialize();
    }

    public void showNotify() {
        pauseParam = true;
        this.show();
    }

    void doPauseApp() {
        pauseParam = false;
    }

    public GameCanvas(Cannon cannon) {
        midlet = cannon;
        LCD_WIDTH = this.getWidth();
        LCD_HEIGHT = this.getHeight();
        STATUS_HEIGHT = 22;
        WIDTH = LCD_WIDTH;
        HEIGHT = LCD_HEIGHT - STATUS_HEIGHT;
        THIS_HEIGHT = HEIGHT / 2;
        LAND_HEIGHT = (HEIGHT - 10) * 3 * 52 / (4 * THIS_HEIGHT);
        menuItemHeight = (LCD_HEIGHT - 14) / 5;
        menuItemStartY = 7 + menuItemHeight;
        endingMaxLine = (LCD_HEIGHT - 100) / 13;
        this.offImage = Image.createImage((int)WIDTH, (int)LCD_HEIGHT);
        this.offScreen = this.offImage.getGraphics();
        this.offImage2 = Image.createImage((int)WIDTH, (int)HEIGHT);
        this.offScreen2 = this.offImage2.getGraphics();
        try {
            titleImg = Image.createImage((String)"/title_e.png");
            endingImg = Image.createImage((String)"/ending.png");
            System.gc();
            greatFireImg = Image.createImage((String)"/greatfire.png");
            backImg = Image.createImage((String)"/back.png");
            finalImg = Image.createImage((String)"/final.png");
            menuImg = Image.createImage((String)"/menu_e2.png");
            mountainImg = Image.createImage((String)"/mountain.png");
            stageImg = Image.createImage((String)"/stage.png");
            ballImg = Image.createImage((String)"/ball.png");
            basketImg = Image.createImage((String)"/basket.png");
            letterImg = Image.createImage((String)"/letter_e2.png");
            cannonImg = Image.createImage((String)"/cannon.png");
            gunportImg = Image.createImage((String)"/gunport.png");
            planeImg = Image.createImage((String)"/plane.png");
            inject1Img = Image.createImage((String)"/inject1.png");
            inject2Img = Image.createImage((String)"/inject2.png");
            statusImg = Image.createImage((String)"/status.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        vector = new Vector();
        airplane3Sound = new Sound(this.airplane3, 1);
        airplane3Sound.init(this.airplane3, 1);
        bonusSound = new Sound(this.bonus, 1);
        bonusSound.init(this.bonus, 1);
        boomSound = new Sound(this.boom, 1);
        boomSound.init(this.boom, 1);
        b_successSound = new Sound(this.b_success, 1);
        b_successSound.init(this.b_success, 1);
        end_dropSound = new Sound(this.end_drop, 1);
        end_dropSound.init(this.end_drop, 1);
        end_shootSound = new Sound(this.end_shoot, 1);
        end_shootSound.init(this.end_shoot, 1);
        endingSound = new Sound(this.ending, 1);
        endingSound.init(this.ending, 1);
        gainSound = new Sound(this.gain, 1);
        gainSound.init(this.gain, 1);
        gameoverSound = new Sound(this.gameover, 1);
        gameoverSound.init(this.gameover, 1);
        shootSound = new Sound(this.shoot, 1);
        shootSound.init(this.shoot, 1);
        successSound = new Sound(this.success, 1);
        successSound.init(this.success, 1);
        introSound = new Sound(this.intro, 1);
        introSound.init(this.intro, 1);
        generalThread = new GeneralThread();
        generalThread.setPriority(10);
        generalThread.start();
    }

    public void stringParser(Vector vector, Font font, String string, int n) {
        Font font2 = font;
        vector.removeAllElements();
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 <= string.length()) {
            String string2;
            n3 = string.indexOf(" ", n4 + 1);
            if (n3 < 0) {
                n3 = string.length() + 1;
                string2 = string.substring(n2);
            } else {
                string2 = string.substring(n2, n3);
            }
            if (font2.stringWidth(string2) < n && n3 <= string.length()) {
                n4 = n3;
                continue;
            }
            if (font2.stringWidth(string2) < n) {
                n4 = n3;
            }
            if (n4 > string.length()) {
                vector.addElement(string.substring(n2));
            } else {
                vector.addElement(string.substring(n2, n4));
            }
            n2 = n4;
        }
    }

    public void gameInitialize() {
        STATUS_HEIGHT = 22;
        WIDTH = LCD_WIDTH;
        HEIGHT = LCD_HEIGHT - STATUS_HEIGHT;
        THIS_HEIGHT = HEIGHT / 2;
        LAND_HEIGHT = (HEIGHT - 10) * 3 * 52 / (4 * THIS_HEIGHT);
        menuItemHeight = (LCD_HEIGHT - 14) / 5;
        menuItemStartY = 7 + menuItemHeight;
        endingMaxLine = (LCD_HEIGHT - 100) / 13;
        curBasket = 0;
        curHeight = 0;
        BASKET_WIDTH = 15;
        MAX_BASKET = 20;
        BG_HEIGHT = 208;
        MOUNTAIN_HEIGHT = 33;
        curStage = 0;
        playState = 0;
        life = 20;
    }

    public void show() {
        switch (state) {
            case 0: {
                Drawer.clearScreen(this.offScreen);
                this.repaint();
                this.playSound(9);
                break;
            }
            case 1: {
                menuIndex = 0;
                this.drawFrame();
                this.repaint();
            }
        }
    }

    private void drawBorder() {
        Drawer.drawLine(this.offScreen, 5, 5, WIDTH - 5, 5, Drawer.rgbPixel(255, 252, 0));
        Drawer.drawLine(this.offScreen, 5, LCD_HEIGHT - 5, WIDTH - 5, LCD_HEIGHT - 5, Drawer.rgbPixel(255, 152, 0));
        Drawer.drawLine(this.offScreen, 5, 5, 5, LCD_HEIGHT - 5, Drawer.rgbPixel(255, 252, 0));
        Drawer.drawLine(this.offScreen, WIDTH - 5, 6, WIDTH - 5, LCD_HEIGHT - 5, Drawer.rgbPixel(255, 152, 0));
    }

    private void drawExplain() {
        Drawer.drawFillRect(this.offScreen, 0, 0, WIDTH, HEIGHT + 22, Drawer.rgbPixel(255, 192, 0));
        Drawer.drawFillRect(this.offScreen, 10, 35, WIDTH - 20, LCD_HEIGHT - 50, Drawer.rgbPixel(255, 242, 0));
        Drawer.drawRect(this.offScreen, 10, 35, WIDTH - 20, LCD_HEIGHT - 50, Drawer.rgbPixel(194, 190, 125));
        Drawer.drawClipImage(this.offScreen, menuImg, 10, 7 + (menuItemHeight - 16) / 2, MENU_ITEM[1] & 0xFF, 13, 0, MENU_ITEM[1] >> 10 & 0xFF);
        this.drawBorder();
        int n = WIDTH - 140 >> 1;
        int n2 = LCD_HEIGHT - 143 >> 1;
        int n3 = 0;
        while (n3 < HOWTOPLAY_TEXT.length) {
            Drawer.drawString(this.offScreen, n + 5, n2 + n3 * 15, HOWTOPLAY_TEXT[n3]);
            ++n3;
        }
    }

    private void drawStory() {
        Drawer.drawFillRect(this.offScreen, 0, 0, WIDTH, HEIGHT + 22, Drawer.rgbPixel(255, 192, 0));
        Drawer.drawFillRect(this.offScreen, 10, 35, WIDTH - 20, LCD_HEIGHT - 45, Drawer.rgbPixel(255, 242, 0));
        Drawer.drawRect(this.offScreen, 10, 35, WIDTH - 20, LCD_HEIGHT - 45, Drawer.rgbPixel(194, 190, 125));
        Drawer.drawFillRect(this.offScreen, WIDTH - 18, storyStart * 8 + 42, 4, 13, Drawer.rgbPixel(255, 152, 0));
        this.drawBorder();
        Drawer.drawClipImage(this.offScreen, menuImg, 10, 7 + (menuItemHeight - 16) / 2, MENU_ITEM[2] & 0xFF, 13, 0, MENU_ITEM[2] >> 10 & 0xFF);
        int n = WIDTH - 140 >> 1;
        int n2 = LCD_HEIGHT - 143 >> 1;
        int n3 = 0;
        int n4 = storyStart;
        while (n4 < storyEnd) {
            Drawer.drawString(this.offScreen, n - 2, n2 + n3 * 15, STORY_TEXT[n4]);
            ++n3;
            ++n4;
        }
    }

    private void drawFrame() {
        Drawer.drawFillRect(this.offScreen, 0, 0, WIDTH, HEIGHT + 22, Drawer.rgbPixel(255, 192, 0));
        Drawer.drawClipImage(this.offScreen, menuImg, WIDTH - 106 >> 1, 7 + (menuItemHeight - 16) / 2, 110, 16, 0, 52);
        Drawer.drawClipImage(this.offScreen, menuImg, WIDTH - 106 >> 1, menuItemStartY + menuIndex * menuItemHeight + (menuItemHeight - 18) / 2, 110, 16, 0, 68);
        this.drawBorder();
        Drawer.drawClipImage(this.offScreen, menuImg, WIDTH - 75 >> 1, menuItemStartY + 0 * menuItemHeight + (menuItemHeight - 16) / 2 + 1, MENU_ITEM[0] & 0xFF, 13, 0, MENU_ITEM[0] >> 10 & 0xFF);
        Drawer.drawClipImage(this.offScreen, menuImg, WIDTH - 75 >> 1, menuItemStartY + 1 * menuItemHeight + (menuItemHeight - 16) / 2 + 1, MENU_ITEM[1] & 0xFF, 13, 0, MENU_ITEM[1] >> 10 & 0xFF);
        Drawer.drawClipImage(this.offScreen, menuImg, WIDTH - 75 >> 1, menuItemStartY + 2 * menuItemHeight + (menuItemHeight - 16) / 2 + 1, MENU_ITEM[2] & 0xFF, 13, 0, MENU_ITEM[2] >> 10 & 0xFF);
        Drawer.drawClipImage(this.offScreen, menuImg, WIDTH - 75 >> 1, menuItemStartY + 3 * menuItemHeight + (menuItemHeight - 16) / 2 + 1, MENU_ITEM[3] & 0xFF, 13, 0, MENU_ITEM[3] >> 10 & 0xFF);
        if (sound) {
            Drawer.drawClipImage(this.offScreen, menuImg, 110, menuItemStartY + 3 * menuItemHeight + (menuItemHeight - 16) / 2 + 1, MENU_ITEM[4] & 0xFF, 13, 49, MENU_ITEM[4] >> 10 & 0xFF);
        } else {
            Drawer.drawClipImage(this.offScreen, menuImg, 110, menuItemStartY + 3 * menuItemHeight + (menuItemHeight - 16) / 2 + 1, MENU_ITEM[5] & 0xFF, 13, 66, MENU_ITEM[5] >> 10 & 0xFF);
        }
    }

    private void drawBack() {
        int n = (WIDTH - 140) / 2;
        int n2 = (LCD_HEIGHT - 140) / 2;
        Drawer.drawFillRect(this.offScreen, 0, 0, WIDTH, LCD_HEIGHT, 8438015);
        Drawer.drawImage(this.offScreen, 0, LCD_HEIGHT - MOUNTAIN_HEIGHT, mountainImg);
        Drawer.drawImage(this.offScreen, 0, STATUS_HEIGHT + curHeight % BG_HEIGHT - BG_HEIGHT, backImg);
        Drawer.drawImage(this.offScreen, 0, STATUS_HEIGHT + curHeight % BG_HEIGHT, backImg);
        Drawer.drawImage(this.offScreen2, 0, -STATUS_HEIGHT, this.offImage);
        this.drawStatusWin();
        this.drawRoundBox(n, n2, 140, 140);
        Drawer.drawClipImage(this.offScreen, menuImg, (WIDTH - 110) / 2, n2 + 9, 110, 16, 0, 68);
        Drawer.drawClipImage(this.offScreen, stageImg, (WIDTH - 110) / 2 + 17, n2 + 10, 9, 12, 9 * curStage, 0);
        Drawer.drawClipImage(this.offScreen, stageImg, (WIDTH - 110) / 2 + 29, n2 + 10, 62, 12, 27, 0);
    }

    private void drawOpening() {
        int n = (WIDTH - 140) / 2;
        int n2 = (LCD_HEIGHT - 140) / 2;
        Drawer.clearScreen(this.offScreen);
        this.drawBack();
        Font font = this.offScreen.getFont();
        this.offScreen.setFont(Font.getFont((int)font.getFace(), (int)1, (int)font.getStyle()));
        Drawer.drawString(this.offScreen, (WIDTH - this.offScreen.getFont().stringWidth("*MISSION*")) / 2, n2 + 30, "*MISSION*");
        Drawer.drawString(this.offScreen, n + 7, n2 + 90, " -BOMB : ");
        Drawer.drawClipImage(this.offScreen, ballImg, n + 70, n2 + 100, 15, 15, 0, 15 * curStage);
        Drawer.drawString(this.offScreen, n + 7, n2 + 53 + 0, OPENING_STR[curStage][0]);
        this.offScreen.setFont(font);
        Drawer.drawString(this.offScreen, n + 7, n2 + 53 + 16, OPENING_STR[curStage][1]);
    }

    private void drawRoundBox(int n, int n2, int n3, int n4) {
        Drawer.drawFillRect(this.offScreen, n + 2, n2 + 2, n3 - 4, n4 - 4, Drawer.rgbPixel(255, 192, 0));
        Drawer.drawLine(this.offScreen, n + 4, n2 + 0, n + 4, n2 + n4, Drawer.rgbPixel(128, 0, 0));
        Drawer.drawLine(this.offScreen, n + 0, n2 + 4, n + n3, n2 + 4, Drawer.rgbPixel(128, 0, 0));
        Drawer.drawLine(this.offScreen, n + 0, n2 + n4 - 5, n + n3, n2 + n4 - 5, Drawer.rgbPixel(128, 0, 0));
        Drawer.drawLine(this.offScreen, n + n3 - 5, n2 + 0, n + n3 - 5, n2 + n4, Drawer.rgbPixel(128, 0, 0));
        Drawer.drawFillRect(this.offScreen, n + 2, n2 + 0, 2, n4, Drawer.rgbPixel(255, 192, 0));
        Drawer.drawFillRect(this.offScreen, n + 0, n2 + 2, n3, 2, Drawer.rgbPixel(255, 192, 0));
        Drawer.drawFillRect(this.offScreen, n + n3 - 4, n2 + 0, 2, n4, Drawer.rgbPixel(255, 192, 0));
        Drawer.drawFillRect(this.offScreen, n + 0, n2 + n4 - 4, n3, 2, Drawer.rgbPixel(255, 192, 0));
    }

    public void playStart() {
        this.initialize();
        Drawer.drawFillRect(this.offScreen, 0, 0, WIDTH, LCD_HEIGHT, 8438015);
        Drawer.drawImage(this.offScreen, 0, LCD_HEIGHT - MOUNTAIN_HEIGHT, mountainImg);
        Drawer.drawImage(this.offScreen, 0, STATUS_HEIGHT + curHeight % BG_HEIGHT - BG_HEIGHT, backImg);
        Drawer.drawImage(this.offScreen, 0, STATUS_HEIGHT + curHeight % BG_HEIGHT, backImg);
        Drawer.drawImage(this.offScreen2, 0, -STATUS_HEIGHT, this.offImage);
        this.drawStatusWin();
        this.setBasketInfo();
        this.repaint();
        playState = 0;
    }

    public void initialize() {
        time = 150;
        curHeight = 0;
        curBasket = 0;
        isBonus = false;
    }

    public void drawStatusWin() {
        Drawer.drawImage(this.offScreen, 0, 0, statusImg);
        this.drawLife();
        this.drawTime(time / 10);
        this.drawHeight();
    }

    public void drawLife() {
        Drawer.drawFillRect(this.offScreen, 4, 4, 39, 14, Drawer.rgbPixel(255, 204, 0));
        if (life > 8) {
            Drawer.drawClipImage(this.offScreen, letterImg, 10, 7, 6, 7, 66, 12);
            Drawer.drawClipImage(this.offScreen, letterImg, 18, 7, 5, 7, 66, 21);
            Drawer.drawClipImage(this.offScreen, letterImg, 25, 7, 7, 8, 7 * (life / 10), 0);
            Drawer.drawClipImage(this.offScreen, letterImg, 33, 7, 7, 8, 7 * (life % 10), 0);
        } else {
            int n = 0;
            while (n < life) {
                Drawer.drawClipImage(this.offScreen, letterImg, 7 + 9 * (n % 4), 4 + 7 * (n / 4), 6, 7, 66, 12);
                ++n;
            }
        }
    }

    public void drawTime(int n) {
        Drawer.drawFillRect(this.offScreen, 157, 7, 14, 8, Drawer.rgbPixel(255, 204, 0));
        Drawer.drawClipImage(this.offScreen, letterImg, 157, 7, 7, 8, 7 * (n / 10), 0);
        Drawer.drawClipImage(this.offScreen, letterImg, 164, 7, 7, 8, 7 * (n % 10), 0);
    }

    public void drawHeight() {
        int n = curBasket * 5;
        boolean bl = false;
        int n2 = n / 100;
        Drawer.drawFillRect(this.offScreen, 52, 7, 18, 8, Drawer.rgbPixel(255, 204, 0));
        if (n2 != 0) {
            Drawer.drawClipImage(this.offScreen, letterImg, 52, 7, 7, 8, 7 * n2, 0);
            bl = true;
        }
        if ((n2 = n % 100 / 10) != 0 || bl) {
            Drawer.drawClipImage(this.offScreen, letterImg, 56, 7, 7, 8, 7 * n2, 0);
        }
        n2 = n % 10;
        Drawer.drawClipImage(this.offScreen, letterImg, 63, 7, 7, 8, 7 * n2, 0);
    }

    public void setBasketInfo() {
        if (curBasket > 0) {
            basket1X = basket2X;
            basket1Y = basket2Y;
            v1X = v2X;
            bound1X1 = bound2X1;
            bound1X2 = bound2X2;
            v1Y = v2Y;
            fix1Y = basket1Y;
            centerVary1 = centerVary2;
        } else {
            basket1X = WIDTH * (BASKET_INFO[curStage][curBasket] >> 10 & 0xF) / 8 - BASKET_WIDTH / 2;
            fix1Y = basket1Y = LAND_HEIGHT;
            v1X = (BASKET_INFO[curStage][curBasket] >> 6 & 0xF) - 8;
            v1Y = (BASKET_INFO[curStage][curBasket] >> 2 & 0xF) - 8;
            bound1X1 = WIDTH * (BASKET_INFO[curStage][curBasket] >> 25 & 0xF) / 4;
            bound1X2 = WIDTH * (BASKET_INFO[curStage][curBasket] >> 21 & 0xF) / 4;
            centerVary1 = (BASKET_INFO[curStage][curBasket] & 3) == 1;
        }
        v2X = (BASKET_INFO[curStage][curBasket + 1] >> 6 & 0xF) - 8;
        v2Y = (BASKET_INFO[curStage][curBasket + 1] >> 2 & 0xF) - 8;
        basket2X = WIDTH * (BASKET_INFO[curStage][curBasket + 1] >> 10 & 0xF) / 8 - BASKET_WIDTH / 2;
        distance = BASKET_INFO[curStage][curBasket + 1] >> 14 & 0x7F;
        if (basket2X < 0) {
            basket2X = basket1X;
            v2Y = v1Y;
            v2X = v1X;
            basket2Y -= distance;
        } else {
            basket2Y = LAND_HEIGHT - distance - Math.abs(WIDTH / 2 - basket2X) * v2Y / 4;
        }
        fix2Y = basket2Y;
        bound2X1 = WIDTH * (BASKET_INFO[curStage][curBasket + 1] >> 25 & 0xF) / 4;
        bound2X2 = WIDTH * (BASKET_INFO[curStage][curBasket + 1] >> 21 & 0xF) / 4;
        centerVary2 = (BASKET_INFO[curStage][curBasket + 1] & 3) == 1;
    }

    public void setMoreBasketInfo() {
        v3Y = (BASKET_INFO[curStage][curBasket + 2] >> 2 & 0xF) - 8;
        basket3X = WIDTH * (BASKET_INFO[curStage][curBasket + 2] >> 10 & 0xF) / 8 - BASKET_WIDTH / 2;
        distance2 = BASKET_INFO[curStage][curBasket + 2] >> 14 & 0x7F;
        if (basket3X < 0) {
            basket3X = basket2X;
            v3Y = v2Y;
            basket3Y = basket2Y - distance2;
        } else {
            basket3Y = LAND_HEIGHT - distance2 - distance - Math.abs(WIDTH / 2 - basket3X) * v3Y / 4;
        }
    }

    private void itemSelected(int n) {
        switch (n) {
            case 0: {
                state = 4;
                this.drawOpening();
                this.repaint();
                break;
            }
            case 1: {
                state = 2;
                this.drawExplain();
                this.repaint();
                break;
            }
            case 2: {
                state = 3;
                storyStart = 0;
                storyEnd = 10;
                this.drawStory();
                this.repaint();
                break;
            }
            case 3: {
                sound = !sound;
                this.drawFrame();
            }
        }
    }

    public void paint(Graphics graphics) {
        switch (state) {
            case 0: {
                Drawer.drawFillRect(this.offScreen, 0, 0, WIDTH, HEIGHT + 22, Drawer.rgbPixel(255, 192, 0));
                Drawer.drawImage(graphics, LCD_WIDTH - 176 >> 1, LCD_HEIGHT - 208 >> 1, titleImg);
                break;
            }
            default: {
                if (needAllClear) {
                    Drawer.clearScreen(graphics);
                }
                Drawer.drawImage(graphics, (LCD_WIDTH - WIDTH) / 2, 0, this.offImage);
            }
        }
    }

    public void soundStateChanged(Sound sound, int n) {
    }

    public void keyPressed(int n) {
        if (!keyEnable) {
            return;
        }
        block0 : switch (state) {
            case 0: {
                switch (n) {
                    case -6: 
                    case -5: {
                        state = 1;
                        this.drawFrame();
                        break;
                    }
                    case -7: {
                        midlet.exitGame();
                    }
                }
                this.repaint();
                break;
            }
            case 2: {
                switch (n) {
                    case -6: 
                    case -5: {
                        break;
                    }
                    case -7: {
                        state = 1;
                        this.drawFrame();
                        this.repaint();
                    }
                }
                break;
            }
            case 3: {
                switch (n) {
                    case -6: 
                    case -5: {
                        break;
                    }
                    case -7: {
                        state = 1;
                        this.drawFrame();
                        this.repaint();
                        break;
                    }
                    case -1: {
                        if (storyStart > 0) {
                            --storyStart;
                            --storyEnd;
                        }
                        this.drawStory();
                        this.repaint();
                        break;
                    }
                    case -2: {
                        if (storyEnd < 27) {
                            ++storyStart;
                            ++storyEnd;
                        }
                        this.drawStory();
                        this.repaint();
                    }
                }
                break;
            }
            case 1: {
                switch (n) {
                    case -1: {
                        menuIndex = menuIndex <= 0 ? 0 : --menuIndex;
                        this.drawFrame();
                        break;
                    }
                    case -2: {
                        menuIndex = menuIndex >= 3 ? 3 : ++menuIndex;
                        this.drawFrame();
                        break;
                    }
                    case -5: {
                        this.itemSelected(menuIndex);
                        break;
                    }
                    case -6: {
                        break;
                    }
                    case -7: {
                        state = 0;
                        this.show();
                    }
                }
                this.repaint();
                break;
            }
            case 4: {
                this.playStart();
                state = 5;
                break;
            }
            case 5: {
                if (playState == 1) {
                    switch (n) {
                        case -5: {
                            generalThread.setJumpInit();
                        }
                    }
                }
                switch (n) {
                    case -6: {
                        break;
                    }
                    case -7: {
                        DeviceControl.stopVibra();
                        state = 1;
                        stateCount = 0;
                        this.gameInitialize();
                        Drawer.drawFillRect(this.offScreen, 0, 0, LCD_WIDTH, LCD_HEIGHT, -2);
                        this.drawFrame();
                        this.repaint();
                    }
                }
                break;
            }
            case 10: {
                this.drawStatusWin();
                state = 5;
                break;
            }
            case 8: {
                switch (n) {
                    case -5: {
                        break block0;
                    }
                    case -6: {
                        state = 1;
                        stateCount = 0;
                        this.gameInitialize();
                        Drawer.drawFillRect(this.offScreen, 0, 0, LCD_WIDTH, LCD_HEIGHT, -2);
                        this.drawFrame();
                        this.repaint();
                        break block0;
                    }
                }
            }
        }
    }

    public void keyReleased(int n) {
    }

    public void drawBallFirst1() {
        int n = STATUS_HEIGHT + basket1Y * THIS_HEIGHT / 52;
        int n2 = STATUS_HEIGHT + basket2Y * THIS_HEIGHT / 52;
        if (curBasket == MAX_BASKET - 1) {
            Drawer.drawClipImage(this.offScreen, ballImg, basket1X, n, 15, 15, 0, 15 * curStage);
            Drawer.drawImage(this.offScreen, basket1X, n, basketImg);
            Drawer.drawImage(this.offScreen, basket2X - 2, n2, gunportImg);
        } else if (curBasket == MAX_BASKET) {
            Drawer.drawImage(this.offScreen, basket1X - 2, n, gunportImg);
            Drawer.drawClipImage(this.offScreen, inject1Img, basket1X - 2 + 5, n, 10, 8, 10 * curStage, 0);
            Drawer.drawImage(this.offScreen, basket2X - 15, n2, planeImg);
        } else {
            Drawer.drawClipImage(this.offScreen, ballImg, basket1X, n, 15, 15, 0, 15 * curStage);
            Drawer.drawImage(this.offScreen, basket1X, n, basketImg);
            Drawer.drawImage(this.offScreen, basket2X, n2, basketImg);
        }
    }

    public void drawBallFirst2() {
        int n = STATUS_HEIGHT + basket1Y * THIS_HEIGHT / 52;
        int n2 = STATUS_HEIGHT + basket2Y * THIS_HEIGHT / 52;
        if (curBasket == MAX_BASKET - 1) {
            Drawer.drawImage(this.offScreen, basket1X, n, basketImg);
            Drawer.drawImage(this.offScreen, basket2X - 2, n2, gunportImg);
            Drawer.drawClipImage(this.offScreen, inject1Img, basket2X - 2 + 5, n2, 10, 8, 10 * curStage, 0);
        } else if (curBasket == MAX_BASKET) {
            Drawer.drawImage(this.offScreen, basket1X - 2, n, gunportImg);
            Drawer.drawImage(this.offScreen, basket2X - 15, n2, planeImg);
            Drawer.drawClipImage(this.offScreen, inject2Img, basket2X - 15 + 17, n2, 12, 9, 12 * curStage, 0);
        } else {
            Drawer.drawClipImage(this.offScreen, ballImg, basket2X, n2, 15, 15, 0, 15 * curStage);
            Drawer.drawImage(this.offScreen, basket1X, n, basketImg);
            Drawer.drawImage(this.offScreen, basket2X, n2, basketImg);
        }
    }

    public void drawBasketFirst() {
        int n = STATUS_HEIGHT + basket1Y * THIS_HEIGHT / 52;
        int n2 = STATUS_HEIGHT + basket2Y * THIS_HEIGHT / 52;
        if (curBasket == MAX_BASKET - 1) {
            Drawer.drawImage(this.offScreen, basket1X, n, basketImg);
            Drawer.drawImage(this.offScreen, basket2X - 2, n2, gunportImg);
        } else if (curBasket == MAX_BASKET) {
            Drawer.drawImage(this.offScreen, basket1X - 2, n, gunportImg);
            Drawer.drawImage(this.offScreen, basket2X - 15, n2, planeImg);
        } else {
            Drawer.drawImage(this.offScreen, basket1X, n, basketImg);
            Drawer.drawImage(this.offScreen, basket2X, n2, basketImg);
        }
        Drawer.drawClipImage(this.offScreen, ballImg, ballX, STATUS_HEIGHT + ballY * THIS_HEIGHT / 52, 15, 15, 15 * ballType, 15 * curStage);
    }

    public void drawEndingBg() {
        Drawer.drawFillRect(this.offScreen, 0, 0, WIDTH, LCD_HEIGHT, 8438015);
        Drawer.drawImage(this.offScreen, 0, LCD_HEIGHT - BG_HEIGHT - 50, backImg);
    }

    public void nextStage() {
        stateCount = 0;
        if (curStage < 2) {
            ++curStage;
            state = 4;
            this.drawOpening();
        } else {
            stateCount = 0;
            endingLineNb = -endingMaxLine + 1;
            this.stringParser(vector, this.offScreen.getFont(), ENDING_STR, WIDTH - 5);
            state = 8;
        }
    }

    public void pause(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void soundInit() {
        airplane3Ing = false;
        bonusIng = false;
        boomIng = false;
        b_successIng = false;
        end_dropIng = false;
        end_shootIng = false;
        endingIng = false;
        gainIng = false;
        gameoverIng = false;
        shootIng = false;
        successIng = false;
    }

    static {
        MENU_ITEM = new int[]{82, 13380, 26669, 39983, 39949, 39949};
        lightEnable = false;
        vibration = true;
        sound = true;
        keyEnable = true;
        state = -1;
        needAllClear = false;
        checkSuccess = false;
        curBasket = 0;
        curHeight = 0;
        BASKET_WIDTH = 15;
        MAX_BASKET = 20;
        BG_HEIGHT = 208;
        MOUNTAIN_HEIGHT = 33;
        explodePos = new int[][]{{5, -25}, {-60, -35}, {60, -30}, {-30, -28}, {30, -28}};
        OPENING_STR = new String[][]{{" -TARGET : ", "     Armored Troop"}, {" -TARGET : ", "     Air-Force Base"}, {" -LAST TARGET : ", "  Presidential Mansion"}};
        HOWTOPLAY_TEXT = new String[]{"The Goal of game is to", "lift up Cannon balls to ", "the Main Cannon, using", "moving baskets.", "SHOOT-OK key"};
        STORY_TEXT = new String[]{"Borong nation and", "Chorong nation. The weak", "Chorong always gets", "attacked by the strong", "neighbor Borong, so", "that Chorong decides to", "develop a new weapon.", "After numerous failures,", "Chorong finally succeeds", "in developing a new bomb,", "which range could attack", "Borong. But the bomb had", "a serious fault that it", "had to be dropped from a", "high place in order to", "explode successfully.", "So the Chorong nation", "installed the cannon on", "the highest place. But", "the problem was how to", "move the bombs up there..", "Will the Chorong nation", "successfully move the", "bomb and revenge the", "Borong?? Everything is", "up to you.", "Good Luck!"};
        ENDING_STR = "The enemy Striked his Flag!! Finally We escaped from pressure of the enemy,and Winned the Peace!!";
        BASKET_INFO = new int[][]{{9245216, 9248160, 9242400, 9247264, 9247264, 9248032, 9242272, 9248032, 9243168, 9243168, 9242400, 9241376, 9242272, 9248032, 42802592, 9247264, 9247264, 9247904, 9247264, 9242400, 9245216, 13436576}, {9245216, 9248032, 9242528, 9248164, 5048096, 7144736, 9243168, 9247904, 9248160, 9242404, 9243168, 9243168, 9242396, 9248032, 76356896, 9247904, 9242396, 9247264, 9242404, 9248164, 9245216, 13436576}, {9245216, 9241888, 9248036, 9248032, 5048224, 9242396, 9247264, 9242528, 9248160, 9242396, 9241372, 9247264, 9242397, 9248032, 40703264, 9248028, 9242400, 9242405, 40703392, 9242532, 9245216, 13436576}};
        pauseParam = true;
        alive = true;
        airplane3Ing = false;
        bonusIng = false;
        boomIng = false;
        b_successIng = false;
        end_dropIng = false;
        end_shootIng = false;
        endingIng = false;
        gainIng = false;
        gameoverIng = false;
        introIng = false;
        shootIng = false;
        successIng = false;
        storyStart = 0;
        storyEnd = 10;
    }

    public class GeneralThread
    extends Thread {
        int move1Y;
        int move2Y;

        public void setJumpInit() {
            GameCanvas.this.soundInit();
            GameCanvas.this.playSound(10);
            playState = 2;
            stateCount = 0;
            ballVelo = -20;
            checkSuccess = false;
        }

        public void run() {
            while (alive) {
                if (pauseParam) {
                    if (state == 5) {
                        if (playState != 6 && playState != 7 && playState != 10) {
                            boolean bl;
                            Drawer.drawImage(GameCanvas.this.offScreen, 0, STATUS_HEIGHT, GameCanvas.this.offImage2);
                            if (basket1X + v1X < bound1X1 || basket1X + v1X / 2 > bound1X2 - BASKET_WIDTH) {
                                v1X *= -1;
                                v1Y *= -1;
                            } else if (centerVary1) {
                                bl = WIDTH / 2 - 7 - basket1X == 0;
                                boolean bl2 = bl = bl || WIDTH / 2 - 7 - basket1X < 0 && WIDTH / 2 - 7 - basket1X + Math.abs(v1X) > 0;
                                if (bl) {
                                    v1Y *= -1;
                                }
                            }
                            if (basket2X + v2X < bound2X1 || basket2X + v2X > bound2X2 - BASKET_WIDTH) {
                                v2X *= -1;
                                v2Y *= -1;
                            } else if (centerVary2) {
                                bl = WIDTH / 2 - 7 - basket2X == 0;
                                boolean bl3 = bl = bl || WIDTH / 2 - 7 - basket2X < 0 && WIDTH / 2 - 7 - basket2X + Math.abs(v2X) > 0;
                                if (bl) {
                                    v2Y *= -1;
                                }
                            }
                            this.move1Y += Math.abs(v1X) * v1Y;
                            this.move2Y += Math.abs(v2X) * v2Y;
                            basket1X += v1X;
                            basket1Y = fix1Y + this.move1Y / 4;
                            basket2X += v2X;
                            basket2Y = fix2Y + this.move2Y / 4;
                            if (--time % 10 == 0) {
                                GameCanvas.this.drawTime(time / 10);
                            }
                            if (time < 0) {
                                time = 9;
                                playState = 5;
                                stateCount = 0;
                            }
                        }
                        switch (playState) {
                            case 0: {
                                if (++stateCount < 2) {
                                    ballX = LCD_WIDTH + 5;
                                    GameCanvas.this.drawBasketFirst();
                                } else {
                                    ballX = basket1X;
                                    ballY = basket1Y - 12 + (stateCount - 3) * 3;
                                    ballType = 0;
                                    GameCanvas.this.drawBasketFirst();
                                    if (stateCount < 5) {
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, letterImg, ballX - 5, STATUS_HEIGHT + ballY * THIS_HEIGHT / 52 - 21, 25, 23, 55, 57);
                                    }
                                    if (stateCount >= 5) {
                                        stateCount = 0;
                                        ballY = basket1Y;
                                        playState = 1;
                                    }
                                }
                                GameCanvas.this.playSound(7);
                                break;
                            }
                            case 1: {
                                ballX = basket1X;
                                GameCanvas.this.drawBallFirst1();
                                break;
                            }
                            case 2: {
                                ballX = basket1X;
                                ballY = basket1Y += 3;
                                ballType = 0;
                                GameCanvas.this.drawBallFirst1();
                                playState = 3;
                                stateCount = 0;
                                ballY = basket1Y -= 3;
                                break;
                            }
                            case 3: {
                                GameCanvas.this.playSound(4);
                                ballY += ballVelo;
                                ballVelo += 4;
                                if (++ballType > 4) {
                                    ballType = 0;
                                }
                                if (!checkSuccess && ballVelo >= 0 && ballY + ballVelo >= basket2Y) {
                                    checkSuccess = true;
                                    if (ballX > basket2X - 6 && ballX < basket2X + 6) {
                                        stateCount = 0;
                                        playState = isBonus ? 8 : 4;
                                    }
                                } else if (isBonus && ballY + ballVelo >= basket1Y) {
                                    stateCount = 0;
                                    playState = 9;
                                } else if ((ballY + ballVelo) * THIS_HEIGHT / 52 > HEIGHT) {
                                    stateCount = 0;
                                    playState = 5;
                                }
                                GameCanvas.this.drawBasketFirst();
                                break;
                            }
                            case 4: {
                                if (stateCount == 0) {
                                    basket2Y += 2;
                                } else if (stateCount == 2) {
                                    basket2Y -= 2;
                                }
                                GameCanvas.this.playSound(11);
                                ballY = basket2Y;
                                ballX = basket2X;
                                ballType = 0;
                                if (++stateCount > 3) {
                                    stateCount = -1;
                                    playState = 6;
                                    GameCanvas.this.setMoreBasketInfo();
                                    tempCurHeight = curHeight;
                                    tempBallY = ballY;
                                    tempBasket1Y = basket1Y;
                                    tempBasket2Y = basket2Y;
                                    tempBasket3Y = basket3Y;
                                }
                                GameCanvas.this.drawBallFirst2();
                                break;
                            }
                            case 5: {
                                GameCanvas.this.playSound(2);
                                DeviceControl.startVibra((int)100, (long)1000L);
                                if (++stateCount != 2 || vibration) {
                                    // empty if block
                                }
                                GameCanvas.this.drawBasketFirst();
                                if (ballY * THIS_HEIGHT / 52 > HEIGHT) {
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, menuImg, ballX - 7, LCD_HEIGHT - 15, 29, 29, 79, 12);
                                } else {
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, menuImg, ballX - 7, STATUS_HEIGHT + ballY * THIS_HEIGHT / 52 - 11, 29, 29, 79, 12);
                                }
                                if (stateCount <= 3) break;
                                if (--life < 0) {
                                    stateCount = 3;
                                    ballX = LCD_WIDTH + 1;
                                    state = 7;
                                    break;
                                }
                                stateCount = 0;
                                time = 150;
                                GameCanvas.this.drawLife();
                                GameCanvas.this.drawTime(time / 10);
                                playState = 0;
                                break;
                            }
                            case 6: {
                                if (++stateCount == 6) {
                                    ++curBasket;
                                    time = 150;
                                    GameCanvas.this.setBasketInfo();
                                    Drawer.drawFillRect(GameCanvas.this.offScreen, 0, 0, WIDTH, LCD_HEIGHT, 8438015);
                                    Drawer.drawImage(GameCanvas.this.offScreen, 0, LCD_HEIGHT - MOUNTAIN_HEIGHT, mountainImg);
                                    Drawer.drawImage(GameCanvas.this.offScreen, 0, STATUS_HEIGHT + curHeight % BG_HEIGHT - BG_HEIGHT, backImg);
                                    Drawer.drawImage(GameCanvas.this.offScreen, 0, STATUS_HEIGHT + curHeight % BG_HEIGHT, backImg);
                                    GameCanvas.this.drawStatusWin();
                                    Drawer.drawImage(GameCanvas.this.offScreen2, 0, -STATUS_HEIGHT, GameCanvas.this.offImage);
                                    GameCanvas.this.drawBallFirst1();
                                    ++stateCount;
                                    break;
                                }
                                if (stateCount >= 7) {
                                    stateCount = 0;
                                    this.move2Y = 0;
                                    this.move1Y = 0;
                                    if (curBasket == MAX_BASKET) {
                                        playState = 7;
                                        if (curStage >= 2) break;
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, letterImg, (WIDTH - 58) / 2, STATUS_HEIGHT + (HEIGHT - 32) / 2, 58, 14, 3, 8);
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, letterImg, (WIDTH - 64) / 2, STATUS_HEIGHT + (HEIGHT - 32) / 2 + 18, 64, 14, 0, 22);
                                        break;
                                    }
                                    playState = 1;
                                    break;
                                }
                                if (stateCount < 1) break;
                                add = stateCount * distance / 5;
                                curHeight = tempCurHeight + stateCount * (distance * THIS_HEIGHT / 52) / 5;
                                ballY = tempBallY + add;
                                basket1Y = tempBasket1Y + add;
                                basket2Y = tempBasket2Y + add;
                                basket3Y = tempBasket3Y + add;
                                Drawer.drawFillRect(GameCanvas.this.offScreen, 0, 0, WIDTH, LCD_HEIGHT, 8438015);
                                Drawer.drawImage(GameCanvas.this.offScreen, 0, LCD_HEIGHT - MOUNTAIN_HEIGHT, mountainImg);
                                Drawer.drawImage(GameCanvas.this.offScreen, 0, STATUS_HEIGHT + curHeight % BG_HEIGHT - BG_HEIGHT, backImg);
                                Drawer.drawImage(GameCanvas.this.offScreen, 0, STATUS_HEIGHT + curHeight % BG_HEIGHT, backImg);
                                if (curBasket == MAX_BASKET - 2) {
                                    Drawer.drawImage(GameCanvas.this.offScreen, basket3X - 2, STATUS_HEIGHT + basket3Y * THIS_HEIGHT / 52, gunportImg);
                                } else if (curBasket == MAX_BASKET - 1) {
                                    Drawer.drawImage(GameCanvas.this.offScreen, basket3X - 15, STATUS_HEIGHT + basket3Y * THIS_HEIGHT / 52, planeImg);
                                } else {
                                    Drawer.drawImage(GameCanvas.this.offScreen, basket3X, STATUS_HEIGHT + basket3Y * THIS_HEIGHT / 52, basketImg);
                                }
                                GameCanvas.this.drawBallFirst2();
                                GameCanvas.this.drawStatusWin();
                                break;
                            }
                            case 7: {
                                if (++stateCount == 7) {
                                    GameCanvas.this.playSound(0);
                                    isBonus = true;
                                    playState = 1;
                                    break;
                                }
                                GameCanvas.this.playSound(1);
                                break;
                            }
                            case 8: {
                                GameCanvas.this.playSound(3);
                                if (++stateCount < 10) {
                                    GameCanvas.this.drawBallFirst2();
                                    if (curStage >= 2) break;
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, letterImg, (WIDTH - 80) / 2, STATUS_HEIGHT + (HEIGHT - 15) / 2, 80, 15, 0, 36);
                                    if (curStage == 1) {
                                        Drawer.drawFillRect(GameCanvas.this.offScreen, (WIDTH - 80) / 2 + 61, STATUS_HEIGHT + (HEIGHT - 15) / 2, 9, 11, 8438015);
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, letterImg, (WIDTH - 80) / 2 + 61, STATUS_HEIGHT + (HEIGHT - 15) / 2, 9, 11, 71, 25);
                                    }
                                    if (stateCount != 4) break;
                                    life = curStage == 0 ? (life += 3) : (life += 7);
                                    GameCanvas.this.drawLife();
                                    break;
                                }
                                stateCount = -10;
                                bonusSuccess = true;
                                playState = 10;
                                break;
                            }
                            case 9: {
                                if (++stateCount < 10) {
                                    GameCanvas.this.drawBallFirst1();
                                    if (curStage >= 2) break;
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, letterImg, (WIDTH - 52) / 2, STATUS_HEIGHT + (HEIGHT - 15) / 2, 52, 15, 0, 51);
                                    break;
                                }
                                stateCount = -10;
                                bonusSuccess = false;
                                playState = 10;
                                break;
                            }
                            case 10: {
                                if (++stateCount < 10) {
                                    if (stateCount == -9) {
                                        GameCanvas.this.drawEndingBg();
                                        Drawer.drawFillRect(GameCanvas.this.offScreen, 0, LCD_HEIGHT - 10, WIDTH, 11, Drawer.rgbPixel(0, 160, 0));
                                        Drawer.drawImage(GameCanvas.this.offScreen, 0, LCD_HEIGHT - 40, mountainImg);
                                        Drawer.drawImage(GameCanvas.this.offScreen2, 0, -STATUS_HEIGHT, GameCanvas.this.offImage);
                                        ballX = 40;
                                        ballY = LCD_HEIGHT - 50;
                                    } else {
                                        Drawer.drawImage(GameCanvas.this.offScreen, 0, STATUS_HEIGHT, GameCanvas.this.offImage2);
                                    }
                                    if (bonusSuccess) {
                                        Drawer.drawImage(GameCanvas.this.offScreen, WIDTH * stateCount / 10, 25, planeImg);
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, inject2Img, WIDTH * stateCount / 10 + 17, 25, 12, 9, 12 * curStage, 0);
                                        if (stateCount >= 0) break;
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, letterImg, (WIDTH - 53) / 2, (LCD_HEIGHT - 15) / 2, 53, 15, 0, 66);
                                        break;
                                    }
                                    if (stateCount == 3) {
                                        Drawer.drawImage(GameCanvas.this.offScreen, 7, LCD_HEIGHT - 45, cannonImg);
                                    } else {
                                        Drawer.drawImage(GameCanvas.this.offScreen, 10, LCD_HEIGHT - 45, cannonImg);
                                    }
                                    if (stateCount > 4) {
                                        ballX += (WIDTH - 3 - ballX) / (10 - stateCount);
                                        ballY += (25 - ballY) / (10 - stateCount);
                                    }
                                    if (stateCount > 3) {
                                        if (curStage < 2) {
                                            if (++ballType > 4) {
                                                ballType = 0;
                                            }
                                        } else {
                                            ballType = 4;
                                        }
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, ballImg, ballX, ballY, 15, 15, 15 * ballType, 15 * curStage);
                                    }
                                    if (stateCount >= 0) break;
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, letterImg, (WIDTH - 53) / 2, (LCD_HEIGHT - 15) / 2, 53, 15, 0, 66);
                                    break;
                                }
                                if (stateCount < 35) {
                                    if (stateCount == 10) {
                                        GameCanvas.this.drawEndingBg();
                                        try {
                                            endingImg = Image.createImage((String)("/ending" + curStage + ".png"));
                                        }
                                        catch (Exception exception) {
                                            System.out.println("exception!!!!!!");
                                        }
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, endingImg, 0, LCD_HEIGHT - 40, 176, 40, 0, 40 * curStage);
                                        Drawer.drawImage(GameCanvas.this.offScreen2, 0, -STATUS_HEIGHT, GameCanvas.this.offImage);
                                        ballX = -3;
                                        ballY = 25;
                                    } else {
                                        Drawer.drawImage(GameCanvas.this.offScreen, 0, STATUS_HEIGHT, GameCanvas.this.offImage2);
                                    }
                                    if (bonusSuccess) {
                                        Drawer.drawImage(GameCanvas.this.offScreen, WIDTH * (stateCount - 10) / 8, 25, planeImg);
                                        if (stateCount < 14) {
                                            Drawer.drawClipImage(GameCanvas.this.offScreen, inject2Img, WIDTH * (stateCount - 10) / 8 + 17, 25, 12, 9, 12 * curStage, 0);
                                            break;
                                        }
                                        if (stateCount < 17) {
                                            Drawer.drawClipImage(GameCanvas.this.offScreen, ballImg, WIDTH * 3 / 8, 25 + (LCD_HEIGHT - 20 - 25) * (stateCount - 14) / 3, 15, 15, 0, 15 * curStage);
                                            break;
                                        }
                                        if (stateCount < 23) {
                                            int n = 0;
                                            while (n < stateCount - 17) {
                                                Drawer.drawClipImage(GameCanvas.this.offScreen, menuImg, WIDTH * 1 / 2 + explodePos[n][0] - 7, 25 + (LCD_HEIGHT - 25) + explodePos[n][1], 29, 29, 79, 12);
                                                ++n;
                                            }
                                            break;
                                        }
                                        Drawer.drawImage(GameCanvas.this.offScreen, 0, LCD_HEIGHT - (40 + curStage * 20), greatFireImg);
                                        break;
                                    }
                                    if (stateCount < 17) {
                                        if (curStage < 2) {
                                            if (++ballType > 4) {
                                                ballType = 0;
                                            }
                                        } else {
                                            ballType = 3;
                                        }
                                        if (stateCount > 10) {
                                            ballX += (WIDTH / 2 - ballX) / (17 - stateCount);
                                            ballY += (LCD_HEIGHT - 20 - ballY) / (17 - stateCount);
                                        }
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, ballImg, ballX, ballY, 15, 15, 15 * ballType, 15 * curStage);
                                        break;
                                    }
                                    if (stateCount < 23) {
                                        int n = 0;
                                        while (n < stateCount - 17) {
                                            Drawer.drawClipImage(GameCanvas.this.offScreen, menuImg, WIDTH * 3 / 8 + explodePos[n][0] - 7, 25 + (LCD_HEIGHT - 25) + explodePos[n][1], 29, 29, 79, 12);
                                            ++n;
                                        }
                                        break;
                                    }
                                    Drawer.drawImage(GameCanvas.this.offScreen, 0, LCD_HEIGHT - (40 + curStage * 20), greatFireImg);
                                    break;
                                }
                                GameCanvas.this.nextStage();
                            }
                        }
                        GameCanvas.this.repaint();
                        GameCanvas.this.pause(100);
                        continue;
                    }
                    if (state == 7) {
                        GameCanvas.this.playSound(8);
                        GameCanvas.this.drawBack();
                        Font font = GameCanvas.this.offScreen.getFont();
                        GameCanvas.this.offScreen.setFont(Font.getFont((int)font.getFace(), (int)1, (int)font.getStyle()));
                        String string = "GAME OVER";
                        int n = 0;
                        while (n <= string.length()) {
                            Drawer.drawString(GameCanvas.this.offScreen, (WIDTH - GameCanvas.this.offScreen.getFont().stringWidth("GAME OVER")) / 2, (LCD_HEIGHT - 12) / 2, -2, -5, string.substring(0, n));
                            GameCanvas.this.repaint();
                            GameCanvas.this.pause(300);
                            ++n;
                        }
                        GameCanvas.this.offScreen.setFont(font);
                        GameCanvas.this.pause(1000);
                        stateCount = 0;
                        GameCanvas.this.gameInitialize();
                        state = 1;
                        Drawer.clearScreen(GameCanvas.this.offScreen);
                        GameCanvas.this.show();
                        continue;
                    }
                    if (state == 8) {
                        GameCanvas.this.playSound(6);
                        if (stateCount == 0) {
                            Drawer.clearScreen(GameCanvas.this.offScreen);
                            Drawer.drawImage(GameCanvas.this.offScreen, 0, 0, finalImg);
                            stateCount = 1;
                        }
                        if (stateCount == 1) {
                            Drawer.drawFillRect(GameCanvas.this.offScreen, 0, 63, WIDTH, LCD_HEIGHT - 63, -2);
                            int n = 0;
                            while (n < endingMaxLine) {
                                if (n + endingLineNb >= 0 && n + endingLineNb < vector.size()) {
                                    Drawer.drawString(GameCanvas.this.offScreen, 4, 63 + 13 * n, (String)vector.elementAt(n + endingLineNb));
                                }
                                ++n;
                            }
                            GameCanvas.this.repaint();
                            GameCanvas.this.pause(1000);
                            if (n + endingLineNb >= vector.size() + 2) {
                                stateCount = 2;
                                Drawer.drawString(GameCanvas.this.offScreen, (WIDTH - GameCanvas.this.offScreen.getFont().stringWidth("-THE END-")) / 2, 63 + 13 * (endingMaxLine - 1), "-THE END-");
                                GameCanvas.this.repaint();
                                continue;
                            }
                            ++endingLineNb;
                            continue;
                        }
                        GameCanvas.this.pause(300);
                        continue;
                    }
                    GameCanvas.this.pause(300);
                    continue;
                }
                GameCanvas.this.pause(200);
            }
        }
    }
}

