/*
 * Decompiled with CFR 0.152.
 */
package BurgerKing;

import BurgerKing.BurgerDisplay;
import BurgerKing.BurgerMIDlet;
import BurgerKing.GameEffect;
import com.nokia.mid.ui.FullCanvas;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class BurgerCanvas
extends FullCanvas
implements Runnable {
    private int speed;
    private int density;
    private int numberOfPiece;
    private int numberOfCorrectPiece;
    private long timeOfEachFrame;
    private int score;
    private int level;
    private int numberOfStick;
    private Thread activeThread = null;
    private final BurgerMIDlet burgerMIDlet;
    private final BurgerDisplay burgerDisplay;
    private final GameEffect gameEffect;
    private final Random random;
    private final int TOPLINE;
    private final int BASELINE;
    private int screenWidth;
    private int screenHeight;
    private int userAnswer;
    private int stageOfTheGame;
    private int heightOfTheBurger;
    private int[] xPositionOfEachPiece;
    private int[] yPositionOfEachPiece;
    private boolean[] isTruth;
    private int[] typeOfEachPiece;
    private boolean[] isStickTogether;
    private int[] correctAnswer;
    private final int[] stackHeight;

    public BurgerCanvas(BurgerMIDlet burgerMIDlet) {
        this.TOPLINE = 26;
        this.BASELINE = 195;
        this.burgerMIDlet = burgerMIDlet;
        this.burgerDisplay = new BurgerDisplay();
        this.random = new Random();
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.timeOfEachFrame = 100L;
        this.stackHeight = new int[]{7, 16, 5, 4, 4, 4, 5, 5, 6};
        this.gameEffect = BurgerCanvas.createGameEffect();
    }

    public void paint(Graphics g) {
        if (this.xPositionOfEachPiece != null && this.xPositionOfEachPiece.length == this.numberOfPiece || this.stageOfTheGame == 10 || this.stageOfTheGame == 20 || this.stageOfTheGame == 60) {
            this.burgerDisplay.drawScreen(this.stageOfTheGame, this.xPositionOfEachPiece, this.yPositionOfEachPiece, this.isTruth, this.typeOfEachPiece, this.numberOfPiece, this.score, g);
        }
    }

    public void run() {
        Thread tempThread = this.activeThread;
        while (tempThread == this.activeThread) {
            long timeStart = System.currentTimeMillis();
            switch (this.stageOfTheGame) {
                case 10: {
                    this.repaint();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.stageOfTheGame = 20;
                    this.repaint();
                    break;
                }
                case 30: {
                    this.randomThePiece();
                    this.stageOfTheGame = 40;
                    break;
                }
                case 40: {
                    for (int i = 1; i < this.numberOfPiece; ++i) {
                        if (this.yPositionOfEachPiece[i] - 26 >= this.density && i != this.numberOfPiece - 1 && this.yPositionOfEachPiece[i + 1] == -1 && !this.isStickTogether[i + 1]) {
                            this.yPositionOfEachPiece[i + 1] = 26 - this.speed;
                        }
                        if (this.yPositionOfEachPiece[i] == -1 || this.isStickTogether[i]) continue;
                        this.yPositionOfEachPiece[i] = this.yPositionOfEachPiece[i] + this.speed;
                    }
                    this.isGameOver();
                    break;
                }
                case 50: {
                    this.stageOfTheGame = 40;
                    break;
                }
            }
            long timeTaken = System.currentTimeMillis() - timeStart;
            if (timeTaken < this.timeOfEachFrame) {
                try {
                    BurgerCanvas burgerCanvas = this;
                    synchronized (burgerCanvas) {
                        this.wait(this.timeOfEachFrame - timeTaken);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.stageOfTheGame != 40 && this.stageOfTheGame != 60) continue;
            this.repaint();
        }
    }

    public synchronized void start() {
        this.speed = 1;
        this.density = 50;
        this.numberOfCorrectPiece = 3;
        this.numberOfPiece = 8;
        this.stageOfTheGame = 10;
        this.score = 0;
        this.level = 1;
        this.numberOfStick = 0;
        if (this.activeThread == null) {
            this.activeThread = new Thread(this);
            this.activeThread.start();
        }
    }

    public void keyPressed(int keyCode) {
        switch (this.stageOfTheGame) {
            case 10: {
                break;
            }
            case 20: {
                if (keyCode == -7) break;
                this.start();
                this.stageOfTheGame = 30;
                break;
            }
            case 30: {
                break;
            }
            case 60: {
                if (keyCode == -7) break;
                this.start();
                this.stageOfTheGame = 30;
                break;
            }
        }
        if (keyCode == -7) {
            this.burgerMIDlet.quitGame();
        }
        if (this.stageOfTheGame == 10 || this.stageOfTheGame == 20 || this.stageOfTheGame == 60) {
            this.repaint();
        }
        switch (keyCode) {
            case 52: {
                int i;
                boolean canMove = true;
                for (i = 0; i < this.numberOfPiece; ++i) {
                    if (!this.isStickTogether[i] || this.yPositionOfEachPiece[i] == -1 || this.xPositionOfEachPiece[i] != 0) continue;
                    canMove = false;
                }
                if (!canMove) break;
                this.xPositionOfEachPiece[0] = this.xPositionOfEachPiece[0] - 14;
                for (i = 1; i < this.numberOfPiece; ++i) {
                    if (!this.isStickTogether[i]) continue;
                    int n = i;
                    this.xPositionOfEachPiece[n] = this.xPositionOfEachPiece[n] - 14;
                }
                break;
            }
            case 54: {
                int i;
                boolean canMove = true;
                for (i = 0; i < this.numberOfPiece; ++i) {
                    if (!this.isStickTogether[i] || this.yPositionOfEachPiece[i] == -1 || this.xPositionOfEachPiece[i] != 84) continue;
                    canMove = false;
                }
                if (!canMove) break;
                this.xPositionOfEachPiece[0] = this.xPositionOfEachPiece[0] + 14;
                for (i = 1; i < this.numberOfPiece; ++i) {
                    if (!this.isStickTogether[i]) continue;
                    int n = i;
                    this.xPositionOfEachPiece[n] = this.xPositionOfEachPiece[n] + 14;
                }
                break;
            }
            default: {
                this.userAnswer = -1;
                break;
            }
        }
        this.repaint();
    }

    private synchronized void randomThePiece() {
        this.xPositionOfEachPiece = new int[this.numberOfPiece];
        this.yPositionOfEachPiece = new int[this.numberOfPiece];
        this.isTruth = new boolean[this.numberOfPiece];
        this.typeOfEachPiece = new int[this.numberOfPiece];
        this.isStickTogether = new boolean[this.numberOfPiece];
        this.correctAnswer = new int[this.numberOfCorrectPiece + 1];
        this.typeOfEachPiece[0] = 0;
        this.yPositionOfEachPiece[0] = 195;
        this.xPositionOfEachPiece[0] = 42;
        this.isTruth[0] = true;
        this.isStickTogether[0] = true;
        this.typeOfEachPiece[this.numberOfPiece - 1] = 1;
        this.yPositionOfEachPiece[this.numberOfPiece - 1] = -1;
        this.xPositionOfEachPiece[this.numberOfPiece - 1] = this.rand(7) * 14;
        this.isTruth[this.numberOfPiece - 1] = true;
        this.isStickTogether[this.numberOfPiece - 1] = false;
        for (int i = 1; i <= this.numberOfPiece - 2; ++i) {
            this.typeOfEachPiece[i] = this.rand(7) + 2;
            this.yPositionOfEachPiece[i] = -1;
            this.xPositionOfEachPiece[i] = this.rand(7) * 14;
            this.isStickTogether[i] = false;
            this.isTruth[i] = false;
        }
        switch (this.numberOfCorrectPiece) {
            case 3: {
                this.correctAnswer[0] = 0;
                this.correctAnswer[1] = this.typeOfEachPiece[1];
                this.correctAnswer[2] = this.typeOfEachPiece[3];
                this.correctAnswer[3] = this.typeOfEachPiece[5];
                this.isTruth[1] = true;
                this.isTruth[3] = true;
                this.isTruth[5] = true;
                break;
            }
            case 5: {
                this.correctAnswer[0] = 0;
                this.correctAnswer[1] = this.typeOfEachPiece[1];
                this.correctAnswer[2] = this.typeOfEachPiece[3];
                this.correctAnswer[3] = this.typeOfEachPiece[5];
                this.correctAnswer[4] = this.typeOfEachPiece[7];
                this.correctAnswer[5] = this.typeOfEachPiece[9];
                this.isTruth[1] = true;
                this.isTruth[3] = true;
                this.isTruth[5] = true;
                this.isTruth[7] = true;
                this.isTruth[9] = true;
                break;
            }
            case 7: {
                this.correctAnswer[0] = 0;
                this.correctAnswer[1] = this.typeOfEachPiece[1];
                this.correctAnswer[2] = this.typeOfEachPiece[3];
                this.correctAnswer[3] = this.typeOfEachPiece[5];
                this.correctAnswer[4] = this.typeOfEachPiece[7];
                this.correctAnswer[5] = this.typeOfEachPiece[9];
                this.correctAnswer[6] = this.typeOfEachPiece[11];
                this.correctAnswer[7] = this.typeOfEachPiece[13];
                this.isTruth[1] = true;
                this.isTruth[3] = true;
                this.isTruth[5] = true;
                this.isTruth[7] = true;
                this.isTruth[9] = true;
                this.isTruth[11] = true;
                this.isTruth[13] = true;
            }
        }
        this.heightOfTheBurger = 195;
        this.yPositionOfEachPiece[1] = 26;
    }

    private synchronized void isGameOver() {
        block8: {
            boolean isFinish = this.yPositionOfEachPiece[this.numberOfPiece - 1] != -1 && this.yPositionOfEachPiece[this.numberOfPiece - 1] + this.stackHeight[1] >= this.heightOfTheBurger;
            for (int i = 1; i < this.numberOfPiece; ++i) {
                if (this.yPositionOfEachPiece[i] + this.stackHeight[this.typeOfEachPiece[i]] < this.heightOfTheBurger || this.isStickTogether[i]) continue;
                int xPosDiff = this.xPositionOfEachPiece[i] - this.xPositionOfEachPiece[0];
                if (xPosDiff <= 0 && xPosDiff > -42 || xPosDiff > 0 && xPosDiff < 42) {
                    this.isStickTogether[i] = true;
                    ++this.numberOfStick;
                    if (this.correctAnswer[0] != this.numberOfCorrectPiece && this.numberOfStick - 1 == this.correctAnswer[0] && this.typeOfEachPiece[i] == this.correctAnswer[this.correctAnswer[0] + 1] && xPosDiff == 0 || i == this.numberOfPiece - 1 && xPosDiff == 0 && this.numberOfStick - 1 == this.numberOfCorrectPiece) {
                        if (i != this.numberOfPiece - 1) {
                            this.correctAnswer[0] = this.correctAnswer[0] + 1;
                        }
                        this.score += 100;
                        this.gameEffect.PlayCorrectSound();
                    } else {
                        this.gameEffect.PlayWrongSound();
                    }
                    this.heightOfTheBurger -= this.stackHeight[this.typeOfEachPiece[i]];
                    this.yPositionOfEachPiece[i] = this.heightOfTheBurger;
                    continue;
                }
                this.yPositionOfEachPiece[i] = -1;
                this.isStickTogether[i] = true;
            }
            if (!isFinish) break block8;
            if (this.numberOfStick - 1 == this.numberOfCorrectPiece && this.correctAnswer[0] == this.numberOfCorrectPiece && this.isStickTogether[this.numberOfPiece - 1] && this.xPositionOfEachPiece[0] == this.xPositionOfEachPiece[this.numberOfPiece - 1]) {
                if (this.level == 6) {
                    this.level = 0;
                }
                ++this.level;
                this.stageOfTheGame = 30;
                this.levelUp();
                this.gameEffect.vibrate();
                this.gameEffect.flashLights();
            } else {
                this.stageOfTheGame = 60;
                this.gameEffect.vibrate();
            }
        }
    }

    private synchronized void levelUp() {
        switch (this.level) {
            case 1: {
                ++this.speed;
                this.density = 50;
                this.numberOfCorrectPiece = 3;
                this.numberOfPiece = 8;
                this.randomThePiece();
                break;
            }
            case 2: {
                this.density -= 5;
                this.randomThePiece();
                break;
            }
            case 3: {
                this.numberOfCorrectPiece = 5;
                this.numberOfPiece = 12;
                this.randomThePiece();
                break;
            }
            case 4: {
                this.density -= 5;
                this.randomThePiece();
                break;
            }
            case 5: {
                this.numberOfCorrectPiece = 7;
                this.numberOfPiece = 16;
                this.randomThePiece();
                break;
            }
            case 6: {
                this.density -= 5;
                this.randomThePiece();
            }
        }
        try {
            BurgerCanvas burgerCanvas = this;
            synchronized (burgerCanvas) {
                this.wait(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.numberOfStick = 0;
        this.stageOfTheGame = 40;
    }

    private int rand(int iRange) {
        return (this.random.nextInt() << 1 >>> 1) % iRange;
    }

    private static GameEffect createGameEffect() {
        GameEffect pEffect;
        try {
            Class.forName("com.nokia.mid.sound.Sound");
            Class.forName("com.nokia.mid.sound.SoundListener");
            Class.forName("com.nokia.mid.ui.DeviceControl");
            Class<?> pClass = Class.forName("BurgerKing.NokiaGameEffect");
            pEffect = (GameEffect)pClass.newInstance();
        }
        catch (Exception e) {
            pEffect = new GameEffect();
        }
        return pEffect;
    }
}

