/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.MenuBar;
import com.sun.lwuit.RunnableWrapper;
import com.sun.lwuit.VirtualKeyboard;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.impl.ImplementationFactory;
import com.sun.lwuit.impl.LWUITImplementation;
import com.sun.lwuit.impl.VirtualKeyboardInterface;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Display {
    private EventDispatcher errorHandler;
    boolean lwuitExited;
    public static final String SOUND_TYPE_ALARM = "alarm";
    public static final String SOUND_TYPE_CONFIRMATION = "confirmation";
    public static final String SOUND_TYPE_ERROR = "error";
    public static final String SOUND_TYPE_INFO = "info";
    public static final String SOUND_TYPE_WARNING = "warning";
    public static final String SOUND_TYPE_BUTTON_PRESS = "press";
    public static final int KEYBOARD_TYPE_UNKNOWN = 0;
    public static final int KEYBOARD_TYPE_NUMERIC = 1;
    public static final int KEYBOARD_TYPE_QWERTY = 2;
    public static final int KEYBOARD_TYPE_VIRTUAL = 3;
    public static final int KEYBOARD_TYPE_HALF_QWERTY = 4;
    private static final int POINTER_PRESSED = 1;
    private static final int POINTER_RELEASED = 2;
    private static final int POINTER_DRAGGED = 3;
    private static final int POINTER_HOVER = 8;
    private static final int POINTER_HOVER_RELEASED = 11;
    private static final int POINTER_HOVER_PRESSED = 12;
    private static final int KEY_PRESSED = 4;
    private static final int KEY_RELEASED = 5;
    private static final int KEY_LONG_PRESSED = 6;
    private static final int SIZE_CHANGED = 7;
    private static final int HIDE_NOTIFY = 9;
    private static final int SHOW_NOTIFY = 10;
    public static final int DENSITY_VERY_LOW = 10;
    public static final int DENSITY_LOW = 20;
    public static final int DENSITY_MEDIUM = 30;
    public static final int DENSITY_HIGH = 40;
    public static final int DENSITY_VERY_HIGH = 50;
    public static final int DENSITY_HD = 60;
    private boolean pureTouch;
    private Graphics lwuitGraphics;
    private boolean touchScreen;
    private Hashtable localProperties;
    private boolean noSleep = false;
    private boolean autoFoldVKBOnFormSwitch = true;
    private int framerateLock = 30;
    private boolean lightMode;
    public static final int GAME_FIRE = 8;
    public static final int GAME_LEFT = 2;
    public static final int GAME_RIGHT = 5;
    public static final int GAME_UP = 1;
    public static final int GAME_DOWN = 6;
    public static final int KEY_POUND = 35;
    private static final Display INSTANCE = new Display();
    static int transitionDelay = -1;
    private LWUITImplementation impl;
    private boolean lwuitRunning = false;
    private Vector pendingSerialCalls = new Vector();
    private Thread edt;
    private Vector animationQueue;
    private boolean thirdSoftButton = false;
    private boolean editingText;
    public static final int SHOW_DURING_EDIT_IGNORE = 1;
    public static final int SHOW_DURING_EDIT_EXCEPTION = 2;
    public static final int SHOW_DURING_EDIT_ALLOW_DISCARD = 3;
    public static final int SHOW_DURING_EDIT_ALLOW_SAVE = 4;
    public static final int SHOW_DURING_EDIT_SET_AS_NEXT = 5;
    private int showDuringEdit;
    static final Object lock = new Object();
    private Vector inputEvents = new Vector();
    private boolean longPointerCharged;
    private boolean pointerPressedAndNotReleasedOrDragged;
    private int pointerX;
    private int pointerY;
    private boolean keyRepeatCharged;
    private boolean longPressCharged;
    private long longKeyPressTime;
    private int longPressInterval = 800;
    private long nextKeyRepeatEvent;
    private int keyRepeatValue;
    private int keyRepeatInitialIntervalTime = 800;
    private int keyRepeatNextIntervalTime = 10;
    private boolean lastInteractionWasKeypad;
    private boolean processingSerialCalls;
    private int PATHLENGTH;
    private float[] dragPathX;
    private float[] dragPathY;
    private long[] dragPathTime;
    private int dragPathOffset = 0;
    private int dragPathLength = 0;
    private boolean allowMinimizing;
    public static final int COMMAND_BEHAVIOR_DEFAULT = 1;
    public static final int COMMAND_BEHAVIOR_SOFTKEY = 2;
    public static final int COMMAND_BEHAVIOR_TOUCH_MENU = 3;
    public static final int COMMAND_BEHAVIOR_BUTTON_BAR = 4;
    public static final int COMMAND_BEHAVIOR_BUTTON_BAR_TITLE_BACK = 5;
    public static final int COMMAND_BEHAVIOR_BUTTON_BAR_TITLE_RIGHT = 6;
    public static final int COMMAND_BEHAVIOR_NATIVE = 10;
    private int commandBehavior = 1;
    private static String selectedVirtualKeyboard = "LWUIT_VirtualKeyboard";
    private static Hashtable virtualKeyboards = new Hashtable();
    long time;
    private int previousKeyPressed;
    private int lastKeyPressed;

    private Display() {
    }

    Vector getAnimationQueue() {
        return this.animationQueue;
    }

    public static void init(Object object) {
        if (!Display.INSTANCE.lwuitRunning) {
            Display.INSTANCE.lwuitRunning = true;
            Display.INSTANCE.impl = ImplementationFactory.getInstance().createImplementation();
            Display.INSTANCE.impl.setDisplayLock(lock);
            Display.INSTANCE.impl.init(object);
            Display.INSTANCE.lwuitGraphics = new Graphics(Display.INSTANCE.impl.getNativeGraphics());
            Display.INSTANCE.impl.setLWUITGraphics(Display.INSTANCE.lwuitGraphics);
            if (Display.INSTANCE.impl.isThirdSoftButton()) {
                Display.INSTANCE.thirdSoftButton = true;
            }
            if (Display.INSTANCE.impl.getSoftkeyCount() > 0) {
                MenuBar.leftSK = Display.INSTANCE.impl.getSoftkeyCode(0)[0];
                if (Display.INSTANCE.impl.getSoftkeyCount() > 1) {
                    MenuBar.rightSK = Display.INSTANCE.impl.getSoftkeyCode(1)[0];
                    if (Display.INSTANCE.impl.getSoftkeyCode(1).length > 1) {
                        MenuBar.rightSK2 = Display.INSTANCE.impl.getSoftkeyCode(1)[1];
                    }
                }
                MenuBar.backSK = Display.INSTANCE.impl.getBackKeyCode();
                MenuBar.backspaceSK = Display.INSTANCE.impl.getBackspaceKeyCode();
                MenuBar.clearSK = Display.INSTANCE.impl.getClearKeyCode();
            }
            int n = INSTANCE.getDisplayWidth();
            int n2 = INSTANCE.getDisplayHeight();
            int n3 = INSTANCE.numColors();
            Display.INSTANCE.PATHLENGTH = Display.INSTANCE.impl.getDragPathLength();
            Display.INSTANCE.dragPathX = new float[Display.INSTANCE.PATHLENGTH];
            Display.INSTANCE.dragPathY = new float[Display.INSTANCE.PATHLENGTH];
            Display.INSTANCE.dragPathTime = new long[Display.INSTANCE.PATHLENGTH];
            boolean bl = Display.INSTANCE.lightMode = n3 > 65536 && (long)(n * n2 * 30) > Runtime.getRuntime().totalMemory();
            if (Display.INSTANCE.edt == null) {
                Display.INSTANCE.touchScreen = Display.INSTANCE.impl.isTouchDevice();
                Display.INSTANCE.edt = new Thread((Runnable)new RunnableWrapper(null, 3), "EDT");
                Display.INSTANCE.edt.setPriority(6);
                Display.INSTANCE.edt.start();
            }
            UIManager.getInstance();
            VirtualKeyboard virtualKeyboard = new VirtualKeyboard();
            INSTANCE.registerVirtualKeyboard(virtualKeyboard);
        } else {
            Display.INSTANCE.impl.confirmControlView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deinitialize() {
        Display.INSTANCE.lwuitRunning = false;
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
    }

    public static boolean isInitialized() {
        return Display.INSTANCE.lwuitRunning;
    }

    public static Display getInstance() {
        return INSTANCE;
    }

    public int getDragStartPercentage() {
        return this.getImplementation().getDragStartPercentage();
    }

    public void setDragStartPercentage(int n) {
        this.getImplementation().setDragStartPercentage(n);
    }

    LWUITImplementation getImplementation() {
        return this.impl;
    }

    public void setFramerate(int n) {
        this.framerateLock = 1000 / n;
    }

    public void vibrate(int n) {
        this.impl.vibrate(n);
    }

    public void flashBacklight(int n) {
        this.impl.flashBacklight(n);
    }

    public void setShowDuringEditBehavior(int n) {
        this.showDuringEdit = n;
    }

    public int getShowDuringEditBehavior() {
        return this.showDuringEdit;
    }

    public int getFrameRate() {
        return 1000 / this.framerateLock;
    }

    public boolean isEdt() {
        return this.edt == Thread.currentThread();
    }

    void playDialogSound(int n) {
        this.impl.playDialogSound(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSerially(Runnable runnable) {
        Object object = lock;
        synchronized (object) {
            this.pendingSerialCalls.addElement(runnable);
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSeriallyAndWait(Runnable runnable) {
        RunnableWrapper runnableWrapper = new RunnableWrapper(runnable, 0);
        this.callSerially(runnableWrapper);
        Object object = lock;
        synchronized (object) {
            while (!runnableWrapper.isDone()) {
                try {
                    lock.wait(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSeriallyAndWait(Runnable runnable, int n) {
        RunnableWrapper runnableWrapper = new RunnableWrapper(runnable, 0);
        this.callSerially(runnableWrapper);
        Object object = lock;
        synchronized (object) {
            long l = System.currentTimeMillis();
            while (!runnableWrapper.isDone()) {
                try {
                    lock.wait(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - l < (long)n) continue;
                return;
            }
        }
    }

    void flushEdt() {
        if (!this.isEdt()) {
            return;
        }
        while (!this.shouldEDTSleepNoFormAnimation()) {
            this.edtLoopImpl();
        }
        while (this.animationQueue != null && this.animationQueue.size() > 0) {
            this.edtLoopImpl();
        }
    }

    private void restoreMenu(Form form) {
        if (form != null) {
            form.restoreMenu();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintTransitionAnimation() {
        Animation animation = (Animation)this.animationQueue.elementAt(0);
        if (!animation.animate()) {
            this.animationQueue.removeElementAt(0);
            if (animation instanceof Transition) {
                Form form = (Form)((Transition)animation).getSource();
                this.restoreMenu(form);
                if (this.animationQueue.size() > 0) {
                    animation = (Animation)this.animationQueue.elementAt(0);
                    if (animation instanceof Transition) {
                        ((Transition)animation).initTransition();
                    }
                } else {
                    Form form2 = (Form)((Transition)animation).getDestination();
                    this.restoreMenu(form2);
                    if (form == null || form == this.impl.getCurrentForm() || form == this.getCurrent()) {
                        this.setCurrentForm(form2);
                    }
                    ((Transition)animation).cleanup();
                }
                return;
            }
        }
        animation.paint(this.lwuitGraphics);
        this.impl.flushGraphics();
        if (transitionDelay > 0) {
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait(transitionDelay);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mainEDTLoop() {
        Object object;
        block17: {
            this.impl.initEDT();
            try {
                object = lock;
                synchronized (object) {
                    while (this.impl.getCurrentForm() == null) {
                        if (this.shouldEDTSleep()) {
                            lock.wait();
                        }
                        if (this.animationQueue != null && this.animationQueue.size() > 0) {
                            this.paintTransitionAnimation();
                            continue;
                        }
                        this.processSerialCalls();
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (this.impl.handleEDTException(throwable)) break block17;
                if (this.errorHandler != null) {
                    this.errorHandler.fireActionEvent(new ActionEvent(throwable));
                }
                Dialog.show("Error", "An internal application error occurred: " + throwable.toString(), "OK", null);
            }
        }
        while (this.lwuitRunning) {
            try {
                object = lock;
                synchronized (object) {
                    if (this.shouldEDTSleep()) {
                        this.impl.edtIdle(true);
                        lock.wait();
                        this.impl.edtIdle(false);
                    }
                }
                this.edtLoopImpl();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (this.impl.handleEDTException(throwable)) continue;
                if (this.errorHandler != null) {
                    this.errorHandler.fireActionEvent(new ActionEvent(throwable));
                    continue;
                }
                Dialog.show("Error", "An internal application error occurred: " + throwable.toString(), "OK", null);
            }
        }
        Display.INSTANCE.impl.deinitialize();
        Display.INSTANCE.edt = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void edtLoopImpl() {
        Object object;
        block11: {
            try {
                if (this.animationQueue == null || this.animationQueue.size() == 0) {
                    if (this.noSleep) break block11;
                    Object object2 = lock;
                    synchronized (object2) {
                        lock.wait(Math.max(1L, (long)this.framerateLock - this.time));
                        break block11;
                    }
                }
                this.paintTransitionAnimation();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        long l = System.currentTimeMillis();
        while (this.inputEvents.size() > 0) {
            object = (int[])this.inputEvents.elementAt(0);
            this.inputEvents.removeElementAt(0);
            this.handleEvent((int[])object);
        }
        this.lwuitGraphics.setGraphics(this.impl.getNativeGraphics());
        this.impl.paintDirty();
        object = this.impl.getCurrentForm();
        if (object != null) {
            ((Form)object).repaintAnimations();
            long l2 = System.currentTimeMillis();
            if (this.keyRepeatCharged && this.nextKeyRepeatEvent <= l2) {
                ((Form)object).keyRepeated(this.keyRepeatValue);
                this.nextKeyRepeatEvent = l2 + (long)this.keyRepeatNextIntervalTime;
            }
            if (this.longPressCharged && (long)this.longPressInterval <= l2 - this.longKeyPressTime) {
                this.longPressCharged = false;
                ((Form)object).longKeyPress(this.keyRepeatValue);
            }
            if (this.longPointerCharged && (long)this.longPressInterval <= l2 - this.longKeyPressTime) {
                this.longPointerCharged = false;
                ((Form)object).longPointerPress(this.pointerX, this.pointerY);
            }
            this.processSerialCalls();
        }
        this.time = System.currentTimeMillis() - l;
    }

    boolean hasNoSerialCallsPending() {
        return this.pendingSerialCalls.size() == 0;
    }

    public void onEditingComplete(Component component, String string) {
        component.onEditComplete(string);
        component.fireActionEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processSerialCalls() {
        this.processingSerialCalls = true;
        int n = this.pendingSerialCalls.size();
        if (n > 0) {
            Object[] objectArray = null;
            Object object = lock;
            synchronized (object) {
                n = this.pendingSerialCalls.size();
                objectArray = new Runnable[n];
                this.pendingSerialCalls.copyInto(objectArray);
                if (n == this.pendingSerialCalls.size()) {
                    this.pendingSerialCalls.removeAllElements();
                } else {
                    for (int i = 0; i < n; ++i) {
                        this.pendingSerialCalls.removeElementAt(0);
                    }
                }
            }
            for (int i = 0; i < n; ++i) {
                objectArray[i].run();
            }
            Object object2 = lock;
            synchronized (object2) {
                lock.notify();
            }
        }
        this.processingSerialCalls = false;
    }

    boolean isProcessingSerialCalls() {
        return this.processingSerialCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyDisplay() {
        Object object = lock;
        synchronized (object) {
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndBlock(Runnable runnable) {
        if (this.isEdt()) {
            RunnableWrapper runnableWrapper = new RunnableWrapper(runnable, 1);
            RunnableWrapper.pushToThreadPool(runnableWrapper);
            Object object = lock;
            synchronized (object) {
                try {
                    lock.wait(2L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            while (!runnableWrapper.isDone() && this.lwuitRunning) {
                this.edtLoopImpl();
            }
            if (runnableWrapper.getErr() != null) {
                throw runnableWrapper.getErr();
            }
        } else {
            runnable.run();
        }
    }

    public boolean isTouchScreenDevice() {
        return this.touchScreen;
    }

    public void setTouchScreenDevice(boolean bl) {
        this.touchScreen = bl;
    }

    public void setNoSleep(boolean bl) {
        this.noSleep = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrent(Form form, boolean bl) {
        if (this.edt == null) {
            throw new IllegalStateException("Initialize must be invoked before setCurrent!");
        }
        if (this.autoFoldVKBOnFormSwitch && !(form instanceof Dialog)) {
            this.setShowVirtualKeyboard(false);
        }
        if (this.editingText) {
            switch (this.showDuringEdit) {
                case 3: {
                    break;
                }
                case 4: {
                    this.impl.saveTextEditingState();
                    break;
                }
                case 2: {
                    throw new IllegalStateException("Show during edit");
                }
                case 1: {
                    return;
                }
                case 5: {
                    this.impl.setCurrentForm(form);
                    return;
                }
            }
        }
        if (!this.isEdt()) {
            this.callSerially(new RunnableWrapper(form, null, bl));
            return;
        }
        Form form2 = this.impl.getCurrentForm();
        if (form2 != null && form2.isInitialized()) {
            form2.deinitializeImpl();
        }
        if (!form.isInitialized()) {
            form.initComponentImpl();
        }
        if (form.getWidth() != this.getDisplayWidth() || form.getHeight() != this.getDisplayHeight()) {
            form.setSize(new Dimension(this.getDisplayWidth(), this.getDisplayHeight()));
            form.setShouldCalcPreferredSize(true);
            form.layoutContainer();
        }
        Object object = lock;
        synchronized (object) {
            Object object2;
            boolean bl2 = false;
            if (this.animationQueue != null && this.animationQueue.size() > 0 && (object2 = this.animationQueue.lastElement()) instanceof Transition) {
                form2 = (Form)((Transition)object2).getDestination();
                this.impl.setCurrentForm(form2);
            }
            if (form2 != null) {
                if (form2 instanceof Dialog && ((Dialog)form2).isMenu()) {
                    object2 = form2.getTransitionOutAnimator();
                    if (object2 != null && ((Dialog)form2).getPreviousForm() != null) {
                        this.initTransition(((Transition)object2).copy(false), form2, ((Dialog)form2).getPreviousForm());
                    }
                    form2 = ((Dialog)form2).getPreviousForm();
                    this.impl.setCurrentForm(form2);
                }
                if (form != form2 && (form2 != null && form2.getTransitionOutAnimator() != null || form.getTransitionInAnimator() != null)) {
                    if (this.animationQueue == null) {
                        this.animationQueue = new Vector();
                    }
                    if (form2 != null && !(form instanceof Dialog)) {
                        object2 = form2.getTransitionOutAnimator();
                        if (form2 != null && object2 != null) {
                            bl2 = this.initTransition(((Transition)object2).copy(bl), form2, form);
                        }
                    }
                    if (form2 != null && !(form2 instanceof Dialog) && (object2 = form.getTransitionInAnimator()) != null) {
                        bl2 = this.initTransition(((Transition)object2).copy(bl), form2, form);
                    }
                }
            }
            lock.notify();
            if (!bl2) {
                if (this.animationQueue == null || this.animationQueue.size() == 0) {
                    this.setCurrentForm(form);
                } else {
                    object2 = CommonTransitions.createEmpty();
                    this.initTransition((Transition)object2, form2, form);
                }
            }
        }
    }

    private boolean initTransition(Transition transition, Form form, Form form2) {
        try {
            form2.setVisible(true);
            transition.init(form, form2);
            this.animationQueue.addElement(transition);
            if (this.animationQueue.size() == 1) {
                transition.initTransition();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            transition.cleanup();
            this.animationQueue.removeElement(transition);
            return false;
        }
        return true;
    }

    void setCurrentForm(Form form) {
        boolean bl = false;
        Form form2 = this.impl.getCurrentForm();
        if (form2 != null) {
            form2.setVisible(false);
        } else {
            bl = true;
        }
        form2 = form;
        this.impl.setCurrentForm(form2);
        form2.setVisible(true);
        if (bl || !this.allowMinimizing) {
            this.impl.confirmControlView();
        }
        int n = form2.getWidth();
        int n2 = form2.getHeight();
        if (this.isEdt() && (n != this.impl.getDisplayWidth() || n2 != this.impl.getDisplayHeight())) {
            form2.sizeChangedInternal(this.impl.getDisplayWidth(), this.impl.getDisplayHeight());
        } else {
            this.repaint(form2);
        }
        this.lastKeyPressed = 0;
        this.previousKeyPressed = 0;
        form.onShowCompletedImpl();
    }

    public void setTransitionYield(int n) {
        transitionDelay = n;
    }

    public void editString(Component component, int n, int n2, String string) {
        this.editingText = true;
        this.keyRepeatCharged = false;
        this.longPressCharged = false;
        this.lastKeyPressed = 0;
        this.previousKeyPressed = 0;
        this.impl.editString(component, n, n2, string);
        this.editingText = false;
    }

    public boolean minimizeApplication() {
        return this.getImplementation().minimizeApplication();
    }

    public boolean isMinimized() {
        return this.getImplementation().isMinimized();
    }

    public void restoreMinimizedApplication() {
        this.getImplementation().restoreMinimizedApplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInputEvent(int[] nArray) {
        Object object = lock;
        synchronized (object) {
            this.inputEvents.addElement(nArray);
            lock.notify();
        }
    }

    private int[] createPointerEvent(int[] nArray, int[] nArray2, int n) {
        if (nArray.length == 1) {
            return new int[]{n, nArray[0], nArray2[0]};
        }
        int[] nArray3 = new int[1 + nArray.length * 2];
        nArray3[0] = n;
        int n2 = 1;
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[n2] = nArray[i];
            nArray3[++n2] = nArray2[i];
            ++n2;
        }
        return nArray3;
    }

    private int[] createKeyEvent(int n, boolean bl) {
        if (bl) {
            return new int[]{4, n};
        }
        return new int[]{5, n};
    }

    public void keyPressed(int n) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createKeyEvent(n, true));
        this.lastInteractionWasKeypad = this.lastInteractionWasKeypad || n != MenuBar.leftSK && n != MenuBar.clearSK && n != MenuBar.backSK;
        this.longPressCharged = this.keyRepeatCharged = n >= 0 || this.getGameAction(n) > 0 || n == this.impl.getClearKeyCode();
        this.longKeyPressTime = System.currentTimeMillis();
        this.keyRepeatValue = n;
        this.nextKeyRepeatEvent = System.currentTimeMillis() + (long)this.keyRepeatInitialIntervalTime;
        this.previousKeyPressed = this.lastKeyPressed;
        this.lastKeyPressed = n;
    }

    public void keyReleased(int n) {
        this.keyRepeatCharged = false;
        this.longPressCharged = false;
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        if (n != this.lastKeyPressed) {
            if (n != this.previousKeyPressed) {
                return;
            }
            this.previousKeyPressed = 0;
        } else {
            this.lastKeyPressed = 0;
        }
        this.addInputEvent(this.createKeyEvent(n, false));
    }

    void keyRepeatedInternal(int n) {
    }

    public void pointerDragged(int[] nArray, int[] nArray2) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.longPointerCharged = false;
        this.addInputEvent(this.createPointerEvent(nArray, nArray2, 3));
    }

    public void pointerHover(int[] nArray, int[] nArray2) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createPointerEvent(nArray, nArray2, 8));
    }

    public void pointerHoverPressed(int[] nArray, int[] nArray2) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createPointerEvent(nArray, nArray2, 12));
    }

    public void pointerHoverReleased(int[] nArray, int[] nArray2) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createPointerEvent(nArray, nArray2, 11));
    }

    public void pointerPressed(int[] nArray, int[] nArray2) {
        this.touchScreen = true;
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.lastInteractionWasKeypad = false;
        this.longPointerCharged = true;
        this.pointerPressedAndNotReleasedOrDragged = true;
        this.longKeyPressTime = System.currentTimeMillis();
        this.pointerX = nArray[0];
        this.pointerY = nArray2[0];
        this.addInputEvent(this.createPointerEvent(nArray, nArray2, 1));
    }

    public void pointerReleased(int[] nArray, int[] nArray2) {
        this.longPointerCharged = false;
        this.pointerPressedAndNotReleasedOrDragged = false;
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createPointerEvent(nArray, nArray2, 2));
    }

    public void sizeChanged(int n, int n2) {
        Form form = this.impl.getCurrentForm();
        if (form == null) {
            return;
        }
        if (n == form.getWidth() && n2 == form.getHeight()) {
            return;
        }
        this.addInputEvent(this.createSizeChangedEvent(n, n2));
    }

    private int[] createSizeChangedEvent(int n, int n2) {
        return new int[]{7, n, n2};
    }

    public void hideNotify() {
        this.keyRepeatCharged = false;
        this.longPressCharged = false;
        this.longPointerCharged = false;
        this.pointerPressedAndNotReleasedOrDragged = false;
        this.addInputEvent(new int[]{9});
    }

    public void showNotify() {
        this.addInputEvent(new int[]{10});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shouldEDTSleepNoFormAnimation() {
        boolean bl;
        Object object = lock;
        synchronized (object) {
            bl = this.inputEvents.size() == 0 && this.hasNoSerialCallsPending() && (!this.keyRepeatCharged || !this.longPressCharged);
        }
        return bl;
    }

    private void updateDragSpeedStatus(int[] nArray) {
        this.dragPathX[this.dragPathOffset] = this.pointerEvent(1, nArray)[0];
        this.dragPathY[this.dragPathOffset] = this.pointerEvent(2, nArray)[0];
        this.dragPathTime[this.dragPathOffset] = System.currentTimeMillis();
        if (this.dragPathLength < this.PATHLENGTH) {
            ++this.dragPathLength;
        }
        ++this.dragPathOffset;
        if (this.dragPathOffset >= this.PATHLENGTH) {
            this.dragPathOffset = 0;
        }
    }

    private void handleEvent(int[] nArray) {
        Form form = this.getCurrentUpcomingForm(true);
        if (form == null) {
            return;
        }
        switch (nArray[0]) {
            case 4: {
                form.keyPressed(nArray[1]);
                break;
            }
            case 5: {
                form.keyReleased(nArray[1]);
                break;
            }
            case 1: {
                this.dragPathLength = 0;
                form.pointerPressed(this.pointerEvent(1, nArray), this.pointerEvent(2, nArray));
                break;
            }
            case 2: {
                form.pointerReleased(this.pointerEvent(1, nArray), this.pointerEvent(2, nArray));
                break;
            }
            case 3: {
                this.updateDragSpeedStatus(nArray);
                this.pointerPressedAndNotReleasedOrDragged = false;
                form.pointerDragged(this.pointerEvent(1, nArray), this.pointerEvent(2, nArray));
                break;
            }
            case 8: {
                this.updateDragSpeedStatus(nArray);
                form.pointerHover(this.pointerEvent(1, nArray), this.pointerEvent(2, nArray));
                break;
            }
            case 11: {
                form.pointerHoverReleased(this.pointerEvent(1, nArray), this.pointerEvent(2, nArray));
                break;
            }
            case 12: {
                form.pointerHoverPressed(this.pointerEvent(1, nArray), this.pointerEvent(2, nArray));
                break;
            }
            case 7: {
                form.sizeChangedInternal(nArray[1], nArray[2]);
                break;
            }
            case 9: {
                form.hideNotify();
                break;
            }
            case 10: {
                form.showNotify();
            }
        }
    }

    private int[] pointerEvent(int n, int[] nArray) {
        int[] nArray2 = new int[nArray.length / 2];
        int n2 = 0;
        for (int i = n; i < nArray.length; i += 2) {
            nArray2[n2] = nArray[i];
            ++n2;
        }
        return nArray2;
    }

    boolean shouldEDTSleep() {
        Form form = this.impl.getCurrentForm();
        return !(form != null && form.hasAnimations() || this.animationQueue != null && this.animationQueue.size() != 0 || this.inputEvents.size() != 0 || this.impl.hasPendingPaints() || !this.hasNoSerialCallsPending() || this.keyRepeatCharged || this.longPointerCharged);
    }

    Object getVideoControl(Object object) {
        return this.impl.getVideoControl(object);
    }

    Form getCurrentInternal() {
        return this.impl.getCurrentForm();
    }

    Form getCurrentUpcoming() {
        return this.getCurrentUpcomingForm(false);
    }

    private Form getCurrentUpcomingForm(boolean bl) {
        Form form = null;
        if (this.animationQueue != null) {
            int n = this.animationQueue.size();
            for (int i = 0; i < n; ++i) {
                Object e = this.animationQueue.elementAt(i);
                if (!(e instanceof Transition)) continue;
                form = (Form)((Transition)e).getDestination();
            }
        }
        if (form == null) {
            if (bl) {
                Form form2 = this.impl.getCurrentForm();
                if (form2 instanceof Dialog && ((Dialog)form2).isDisposed()) {
                    return this.getCurrent();
                }
                return form2;
            }
            return this.getCurrent();
        }
        return form;
    }

    public Form getCurrent() {
        Form form = this.impl.getCurrentForm();
        if (form != null && form instanceof Dialog && (((Dialog)form).isMenu() || ((Dialog)form).isDisposed())) {
            Form form2 = form.getPreviousForm();
            if (form2 != null) {
                return form2;
            }
            if (this.animationQueue != null) {
                int n = this.animationQueue.size();
                for (int i = 0; i < n; ++i) {
                    Object e = this.animationQueue.elementAt(i);
                    if (!(e instanceof Transition)) continue;
                    return (Form)((Transition)e).getDestination();
                }
            }
        }
        return form;
    }

    public int numAlphaLevels() {
        return this.impl.numAlphaLevels();
    }

    public int numColors() {
        return this.impl.numColors();
    }

    public int getDisplayWidth() {
        return this.impl.getDisplayWidth();
    }

    public int getDisplayHeight() {
        return this.impl.getDisplayHeight();
    }

    void repaint(Animation animation) {
        this.impl.repaint(animation);
    }

    public int getGameAction(int n) {
        return this.impl.getGameAction(n);
    }

    public int getKeyCode(int n) {
        return this.impl.getKeyCode(n);
    }

    public boolean isThirdSoftButton() {
        return this.thirdSoftButton;
    }

    public void setThirdSoftButton(boolean bl) {
        this.thirdSoftButton = bl;
    }

    public void setShowVirtualKeyboard(boolean bl) {
        if (this.isTouchScreenDevice()) {
            this.getDefaultVirtualKeyboard().showKeyboard(bl);
        }
    }

    public boolean isVirtualKeyboardShowing() {
        if (!this.isTouchScreenDevice()) {
            return false;
        }
        return this.getDefaultVirtualKeyboard().isVirtualKeyboardShowing();
    }

    public String[] getSupportedVirtualKeyboard() {
        String[] stringArray = new String[virtualKeyboards.size()];
        int n = 0;
        Enumeration enumeration = virtualKeyboards.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public void registerVirtualKeyboard(VirtualKeyboardInterface virtualKeyboardInterface) {
        virtualKeyboards.put(virtualKeyboardInterface.getVirtualKeyboardName(), virtualKeyboardInterface);
    }

    public void setDefaultVirtualKeyboard(VirtualKeyboardInterface virtualKeyboardInterface) {
        selectedVirtualKeyboard = virtualKeyboardInterface.getVirtualKeyboardName();
        if (!virtualKeyboards.containsKey(selectedVirtualKeyboard)) {
            this.registerVirtualKeyboard(virtualKeyboardInterface);
        }
    }

    public VirtualKeyboardInterface getDefaultVirtualKeyboard() {
        return (VirtualKeyboardInterface)virtualKeyboards.get(selectedVirtualKeyboard);
    }

    public int getKeyboardType() {
        return this.impl.getKeyboardType();
    }

    public boolean isNativeInputSupported() {
        return false;
    }

    public boolean isMultiTouch() {
        return this.impl.isMultiTouch();
    }

    public boolean isClickTouchScreen() {
        return this.impl.isClickTouchScreen();
    }

    public float getDragSpeed(boolean bl) {
        float f = bl ? this.impl.getDragSpeed(this.dragPathY, this.dragPathTime, this.dragPathOffset, this.dragPathLength) : this.impl.getDragSpeed(this.dragPathX, this.dragPathTime, this.dragPathOffset, this.dragPathLength);
        return f;
    }

    public boolean isBidiAlgorithm() {
        return this.impl.isBidiAlgorithm();
    }

    public void setBidiAlgorithm(boolean bl) {
        this.impl.setBidiAlgorithm(bl);
    }

    public String convertBidiLogicalToVisual(String string) {
        return this.impl.convertBidiLogicalToVisual(string);
    }

    public int getCharLocation(String string, int n) {
        return this.impl.getCharLocation(string, n);
    }

    public boolean isRTL(char c) {
        return this.impl.isRTL(c);
    }

    public InputStream getResourceAsStream(Class clazz, String string) {
        return this.impl.getResourceAsStream(clazz, string);
    }

    public void addEdtErrorHandler(ActionListener actionListener) {
        if (this.errorHandler == null) {
            this.errorHandler = new EventDispatcher();
        }
        this.errorHandler.addListener(actionListener);
    }

    public void removeEdtErrorHandler(ActionListener actionListener) {
        if (this.errorHandler != null) {
            this.errorHandler.removeListener(actionListener);
            Vector vector = this.errorHandler.getListenerVector();
            if (vector == null || vector.size() == 0) {
                this.errorHandler = null;
            }
        }
    }

    public void setAllowMinimizing(boolean bl) {
        this.allowMinimizing = bl;
    }

    public boolean isAllowMinimizing() {
        return this.allowMinimizing;
    }

    public boolean shouldRenderSelection() {
        return !this.pureTouch || this.pointerPressedAndNotReleasedOrDragged || this.lastInteractionWasKeypad;
    }

    public boolean isPureTouch() {
        return this.pureTouch;
    }

    public void setPureTouch(boolean bl) {
        this.pureTouch = bl;
    }

    public boolean isNativeCommands() {
        return this.getCommandBehavior() == 10;
    }

    public void setNativeCommands(boolean bl) {
        this.setCommandBehavior(10);
    }

    public void exitApplication() {
        this.lwuitExited = true;
        this.impl.exitApplication();
    }

    public void showNativeScreen(Object object) {
        this.impl.showNativeScreen(object);
    }

    public boolean isAutoFoldVKBOnFormSwitch() {
        return this.autoFoldVKBOnFormSwitch;
    }

    public void setAutoFoldVKBOnFormSwitch(boolean bl) {
        this.autoFoldVKBOnFormSwitch = bl;
    }

    public int getCommandBehavior() {
        return this.commandBehavior;
    }

    public void setCommandBehavior(int n) {
        this.commandBehavior = n;
        this.impl.notifyCommandBehavior(n);
    }

    public String getProperty(String string, String string2) {
        String string3;
        if (this.localProperties != null && (string3 = (String)this.localProperties.get(string)) != null) {
            return string3;
        }
        return this.impl.getProperty(string, string2);
    }

    public void setProperty(String string, String string2) {
        if (this.localProperties == null) {
            this.localProperties = new Hashtable();
            this.localProperties.put(string, string2);
        }
    }

    public void execute(String string) {
        this.impl.execute(string);
    }

    public int getDeviceDensity() {
        return this.impl.getDeviceDensity();
    }

    public void playBuiltinSound(String string) {
        this.impl.playBuiltinSound(string);
    }

    public void installBuiltinSound(String string, InputStream inputStream) throws IOException {
        this.impl.installBuiltinSound(string, inputStream);
    }

    public boolean isBuiltinSoundAvailable(String string) {
        return this.impl.isBuiltinSoundAvailable(string);
    }

    public void setBuiltinSoundsEnabled(boolean bl) {
        this.impl.setBuiltinSoundsEnabled(bl);
    }

    public boolean isBuiltinSoundsEnabled() {
        return this.impl.isBuiltinSoundsEnabled();
    }

    public Object createAudio(String string) throws IOException {
        return this.createAudio(string, null);
    }

    public Object createAudio(InputStream inputStream, String string) throws IOException {
        return this.createAudio(inputStream, string);
    }

    public Object createAudio(String string, Runnable runnable) throws IOException {
        return this.impl.createAudio(string, runnable);
    }

    public Object createAudio(InputStream inputStream, String string, Runnable runnable) throws IOException {
        return this.impl.createAudio(inputStream, string, runnable);
    }

    public void playAudio(Object object) {
        this.impl.playAudio(object);
    }

    public void pauseAudio(Object object) {
        this.impl.pauseAudio(object);
    }

    public void cleanupAudio(Object object) {
        this.impl.cleanupAudio(object);
    }

    public int getAudioTime(Object object) {
        return this.impl.getAudioTime(object);
    }

    public void setAudioTime(Object object, int n) {
        this.impl.setAudioTime(object, n);
    }

    public int getAudioDuration(Object object) {
        return this.impl.getAudioDuration(object);
    }

    public void setVolume(int n) {
        this.impl.setVolume(n);
    }

    public int getVolume() {
        return this.impl.getVolume();
    }

    public Object createSoftWeakRef(Object object) {
        return this.impl.createSoftWeakRef(object);
    }

    public Object extractHardRef(Object object) {
        return this.impl.extractHardRef(object);
    }

    public boolean hasNativeTheme() {
        return this.impl.hasNativeTheme();
    }

    public void installNativeTheme() {
        this.impl.installNativeTheme();
    }
}

