/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.IndexedImage;
import com.sun.lwuit.RGBImage;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.impl.LWUITImplementation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class Image {
    private Object rgbCache;
    private Object image;
    int transform;
    private boolean opaqueTested = false;
    private boolean opaque;
    private Object scaleCache;
    private boolean animated;
    private long imageTime = -1L;
    private String svgBaseURL;
    private byte[] svgData;

    protected Image(Object object) {
        this.image = object;
        this.animated = Display.getInstance().getImplementation().isAnimation(object);
    }

    Image(int[] nArray, int n, int n2) {
        this(Display.getInstance().getImplementation().createImage(nArray, n, n2));
    }

    private Hashtable getScaleCache() {
        if (this.scaleCache == null) {
            Hashtable hashtable = new Hashtable();
            this.scaleCache = Display.getInstance().createSoftWeakRef(hashtable);
            return hashtable;
        }
        Hashtable hashtable = (Hashtable)Display.getInstance().extractHardRef(this.scaleCache);
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.scaleCache = Display.getInstance().createSoftWeakRef(hashtable);
        }
        return hashtable;
    }

    Image getCachedImage(Dimension dimension) {
        Object v = this.getScaleCache().get(dimension);
        return (Image)Display.getInstance().extractHardRef(v);
    }

    void cacheImage(Dimension dimension, Image image) {
        Object object = Display.getInstance().createSoftWeakRef(image);
        this.getScaleCache().put(dimension, object);
    }

    public void lock() {
    }

    public void unlock() {
    }

    void setImage(Object object) {
        this.image = object;
    }

    void setOpaque(boolean bl) {
        this.opaque = bl;
        this.opaqueTested = true;
    }

    public static boolean isSVGSupported() {
        return Display.getInstance().getImplementation().isSVGSupported();
    }

    public Object getSVGDocument() {
        return Display.getInstance().getImplementation().getSVGDocument(this.image);
    }

    public static Image createSVG(String string, boolean bl, byte[] byArray) throws IOException {
        Image image = new Image(Display.getInstance().getImplementation().createSVGImage(string, byArray));
        image.animated = bl;
        image.svgBaseURL = string;
        image.svgData = byArray;
        return image;
    }

    public boolean isSVG() {
        return this.svgData != null;
    }

    public Object createMask() {
        int[] nArray = this.getRGBCached();
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)(nArray[i] & 0xFF);
        }
        return new IndexedImage(this.getWidth(), this.getHeight(), null, byArray);
    }

    public Image applyMask(Object object, int n, int n2) {
        int[] nArray = this.getRGB();
        byte[] byArray = ((IndexedImage)object).getImageDataByte();
        int n3 = ((IndexedImage)object).getWidth();
        int n4 = ((IndexedImage)object).getHeight();
        int n5 = this.getWidth();
        int n6 = n5 - n;
        int n7 = this.getHeight() - n2;
        if (n6 > n3) {
            n6 = n3;
        }
        if (n7 > n4) {
            n7 = n4;
        }
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n7; ++j) {
                int n8 = n + i;
                int n9 = n2 + j;
                int n10 = n8 + n9 * n5;
                int n11 = byArray[n8 + n9 * n3] & 0xFF;
                n11 = n11 << 24 & 0xFF000000;
                nArray[n10] = nArray[n10] & 0xFFFFFF | n11;
            }
        }
        return Image.createImage(nArray, n5, this.getHeight());
    }

    public Image applyMask(Object object) {
        int[] nArray = this.getRGB();
        byte[] byArray = ((IndexedImage)object).getImageDataByte();
        int n = ((IndexedImage)object).getWidth();
        int n2 = ((IndexedImage)object).getHeight();
        if (n != this.getWidth() || n2 != this.getHeight()) {
            throw new IllegalArgumentException("Mask and image sizes don't match");
        }
        for (int i = 0; i < byArray.length; ++i) {
            int n3 = byArray[i] & 0xFF;
            n3 = n3 << 24 & 0xFF000000;
            nArray[i] = nArray[i] & 0xFFFFFF | n3;
        }
        return Image.createImage(nArray, n, n2);
    }

    public Image subImage(int n, int n2, int n3, int n4, boolean bl) {
        int[] nArray = new int[n3 * n4];
        this.getRGB(nArray, 0, n, n2, n3, n4);
        Image image = new Image(Display.getInstance().getImplementation().createImage(nArray, n3, n4));
        image.opaque = this.opaque;
        image.opaqueTested = this.opaqueTested;
        return image;
    }

    public Image rotate(int n) {
        LWUITImplementation lWUITImplementation = Display.getInstance().getImplementation();
        if (lWUITImplementation.isRotationDrawingSupported()) {
            if (n >= 90) {
                int n2 = 0;
                n2 = this.transform != 0 ? (this.transform + n) % 360 : n % 360;
                n2 -= (n %= 90);
                if (n != 0) {
                    Image image = new Image(Display.getInstance().getImplementation().rotate(this.image, n));
                    image.transform = n2;
                    return image;
                }
                Image image = new Image(this.image);
                image.transform = n2;
                return image;
            }
            if (n != 0) {
                return new Image(Display.getInstance().getImplementation().rotate(this.image, n));
            }
            return this;
        }
        return new Image(Display.getInstance().getImplementation().rotate(this.image, n));
    }

    public static Image createIndexed(int n, int n2, int[] nArray, byte[] byArray) {
        IndexedImage indexedImage = new IndexedImage(n, n2, nArray, byArray);
        LWUITImplementation lWUITImplementation = Display.getInstance().getImplementation();
        if (lWUITImplementation.isNativeIndexed()) {
            return new Image(lWUITImplementation.createNativeIndexed(indexedImage));
        }
        return indexedImage;
    }

    public Image modifyAlpha(byte by) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n * n2;
        int[] nArray = this.getRGB();
        int n4 = by << 24 & 0xFF000000;
        for (int i = 0; i < n3; ++i) {
            int n5 = nArray[i] >> 24 & 0xFF;
            if (n5 == 0) continue;
            nArray[i] = nArray[i] & 0xFFFFFF | n4;
        }
        Image image = new Image(nArray, n, n2);
        image.opaqueTested = true;
        image.opaque = false;
        return image;
    }

    public Image modifyAlphaWithTranslucency(byte by) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n * n2;
        int[] nArray = this.getRGB();
        int n4 = by << 24 & 0xFF000000;
        float f = by & 0xFF;
        f = (float)(by & 0xFF) / 255.0f;
        for (int i = 0; i < n3; ++i) {
            int n5 = nArray[i] >> 24 & 0xFF;
            if (n5 == 0) continue;
            if (n5 == 255) {
                nArray[i] = nArray[i] & 0xFFFFFF | n4;
                continue;
            }
            int n6 = (int)((float)n5 * f);
            n6 = n6 << 24 & 0xFF000000;
            nArray[i] = nArray[i] & 0xFFFFFF | n6;
        }
        Image image = new Image(nArray, n, n2);
        image.opaqueTested = true;
        image.opaque = false;
        return image;
    }

    public Image modifyAlpha(byte by, int n) {
        n &= 0xFFFFFF;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = n2 * n3;
        int[] nArray = new int[n4];
        this.getRGB(nArray, 0, 0, 0, n2, n3);
        int n5 = by << 24 & 0xFF000000;
        for (int i = 0; i < n4; ++i) {
            if ((nArray[i] & 0xFF000000) == 0) continue;
            nArray[i] = nArray[i] & 0xFFFFFF | n5;
            if (n != (0xFFFFFF & nArray[i])) continue;
            nArray[i] = 0;
        }
        Image image = new Image(nArray, n2, n3);
        image.opaqueTested = true;
        image.opaque = false;
        return image;
    }

    public static Image createImage(String string) throws IOException {
        try {
            return new Image(Display.getInstance().getImplementation().createImage(string));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            System.gc();
            return new Image(Display.getInstance().getImplementation().createImage(string));
        }
    }

    public static Image createImage(Object object) {
        return new Image(object);
    }

    public static Image createImage(InputStream inputStream) throws IOException {
        try {
            return new Image(Display.getInstance().getImplementation().createImage(inputStream));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            System.gc();
            return new Image(Display.getInstance().getImplementation().createImage(inputStream));
        }
    }

    public static Image createImage(int[] nArray, int n, int n2) {
        try {
            Image image = new Image(Display.getInstance().getImplementation().createImage(nArray, n, n2));
            return image;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            System.gc();
            return new Image(Display.getInstance().getImplementation().createImage(nArray, n, n2));
        }
    }

    public static Image createImage(int n, int n2) {
        return Image.createImage(n, n2, -1);
    }

    public static boolean isAlphaMutableImageSupported() {
        return Display.getInstance().getImplementation().isAlphaMutableImageSupported();
    }

    public static Image createImage(int n, int n2, int n3) {
        try {
            return new Image(Display.getInstance().getImplementation().createMutableImage(n, n2, n3));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            System.gc();
            return new Image(Display.getInstance().getImplementation().createMutableImage(n, n2, n3));
        }
    }

    public static Image createImage(byte[] byArray, int n, int n2) {
        try {
            Object object = Display.getInstance().getImplementation().createImage(byArray, n, n2);
            if (object == null) {
                throw new IllegalArgumentException("create image failed for the given image data of length: " + n2);
            }
            return new Image(object);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            System.gc();
            return new Image(Display.getInstance().getImplementation().createImage(byArray, n, n2));
        }
    }

    public Graphics getGraphics() {
        return new Graphics(Display.getInstance().getImplementation().getNativeGraphics(this.image));
    }

    public int getWidth() {
        if (this.transform != 0 && (this.transform == 90 || this.transform == 270)) {
            return Display.getInstance().getImplementation().getImageHeight(this.image);
        }
        return Display.getInstance().getImplementation().getImageWidth(this.image);
    }

    public int getHeight() {
        if (this.transform != 0 && (this.transform == 90 || this.transform == 270)) {
            return Display.getInstance().getImplementation().getImageWidth(this.image);
        }
        return Display.getInstance().getImplementation().getImageHeight(this.image);
    }

    protected void drawImage(Graphics graphics, Object object, int n, int n2) {
        graphics.drawImage(this.image, n, n2, this.transform);
    }

    void drawImageArea(Graphics graphics, Object object, int n, int n2, int n3, int n4, int n5, int n6) {
        Display.getInstance().getImplementation().drawImageArea(object, this.image, n, n2, n3, n4, n5, n6);
    }

    void getRGB(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        Display.getInstance().getImplementation().getRGB(this.image, nArray, n, n2, n3, n4, n5);
    }

    public void toRGB(RGBImage rGBImage, int n, int n2, int n3, int n4, int n5, int n6) {
        this.getRGB(rGBImage.getRGB(), n * n2, n3, n4, n5, n6);
    }

    public int[] getRGB() {
        return this.getRGBImpl();
    }

    public int[] getRGBCached() {
        int[] nArray = this.getRGBCache();
        if (nArray == null) {
            nArray = this.getRGBImpl();
            this.rgbCache = Display.getInstance().createSoftWeakRef(nArray);
        }
        return nArray;
    }

    int[] getRGBCache() {
        if (this.rgbCache != null) {
            int[] nArray = (int[])Display.getInstance().extractHardRef(this.rgbCache);
            return nArray;
        }
        return null;
    }

    int[] getRGBImpl() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int[] nArray = new int[n * n2];
        this.getRGB(nArray, 0, 0, 0, n, n2);
        return nArray;
    }

    public Image scaledWidth(int n) {
        float f = (float)n / (float)this.getWidth();
        return this.scaled(n, Math.max(1, (int)((float)this.getHeight() * f)));
    }

    public Image scaledHeight(int n) {
        float f = (float)n / (float)this.getHeight();
        return this.scaled(Math.max(1, (int)((float)this.getWidth() * f)), n);
    }

    public Image scaledSmallerRatio(int n, int n2) {
        float f;
        float f2 = (float)n2 / (float)this.getHeight();
        if (f2 < (f = (float)n / (float)this.getWidth())) {
            return this.scaled((int)((float)this.getWidth() * f2), (int)((float)this.getHeight() * f2));
        }
        return this.scaled((int)((float)this.getWidth() * f), (int)((float)this.getHeight() * f));
    }

    public Image scaled(int n, int n2) {
        if (n == this.getWidth() && n2 == this.getHeight()) {
            return this;
        }
        if (n == -1) {
            return this.scaledHeight(n2);
        }
        if (n2 == -1) {
            return this.scaledWidth(n);
        }
        Dimension dimension = new Dimension(n, n2);
        Image image = this.getCachedImage(dimension);
        if (image != null) {
            return image;
        }
        if (this.svgData != null) {
            try {
                image = Image.createSVG(this.svgBaseURL, this.animated, this.svgData);
            }
            catch (IOException iOException) {
                image = new Image(this.image);
            }
        } else {
            image = new Image(this.image);
        }
        image.scaleCache = this.scaleCache;
        image.scale(n, n2);
        image.transform = this.transform;
        image.animated = this.animated;
        image.svgBaseURL = this.svgBaseURL;
        image.svgData = this.svgData;
        this.cacheImage(new Dimension(n, n2), image);
        return image;
    }

    public Object getImage() {
        return this.image;
    }

    public void scale(int n, int n2) {
        this.image = Display.getInstance().getImplementation().scale(this.image, n, n2);
    }

    boolean scaleArray(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        int n5 = (n2 << 16) / n3;
        int n6 = (n << 16) / n4;
        int n7 = n6 / 2;
        int n8 = n5 / 2;
        boolean bl = Display.getInstance().numColors() <= 65536 && !this.opaqueTested;
        boolean bl2 = true;
        for (int i = 0; i < n3; ++i) {
            int n9 = n8 >> 16;
            this.getRGB(nArray, 0, 0, n9, n, 1);
            for (int j = 0; j < n4; ++j) {
                int n10 = n7 >> 16;
                int n11 = j + i * n4;
                if (n11 >= 0 && n11 < nArray2.length && n10 < nArray.length) {
                    nArray2[n11] = nArray[n10];
                    bl2 = bl && bl2 && (nArray[n10] & 0xFF000000) == -16777216;
                }
                n7 += n6;
            }
            n8 += n5;
            n7 = n6 / 2;
        }
        if (bl) {
            this.opaque = bl2;
        }
        return this.opaque;
    }

    public boolean isAnimation() {
        return this.animated;
    }

    public boolean animate() {
        if (this.imageTime == -1L) {
            this.imageTime = System.currentTimeMillis();
        }
        boolean bl = Display.getInstance().getImplementation().animateImage(this.image, this.imageTime);
        this.imageTime = System.currentTimeMillis();
        return bl;
    }

    public boolean isOpaque() {
        if (!this.opaqueTested) {
            this.opaque = Display.getInstance().getImplementation().isOpaque(this, this.image);
            this.opaqueTested = true;
        }
        return this.opaque;
    }
}

