/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;

public class M3G {
    private static final M3G INSTANCE = new M3G();
    private static final boolean IS_SUPPORTED;

    private M3G() {
    }

    public static M3G getInstance() {
        return INSTANCE;
    }

    public static boolean isM3GSupported() {
        return IS_SUPPORTED;
    }

    public int getMaxTextureDimension() {
        return (Integer)Graphics3D.getProperties().get("maxTextureDimension");
    }

    public static int closestLowerPowerOf2(int n) {
        return M3G.closestHigherPowerOf2(n) >> 1;
    }

    public static int closestHigherPowerOf2(int n) {
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return ++n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderM3G(Graphics graphics, boolean bl, int n, Callback callback) {
        Graphics3D graphics3D = Graphics3D.getInstance();
        graphics3D.bindTarget(graphics.getGraphics(), bl, n);
        try {
            callback.paintM3G(graphics3D);
        }
        finally {
            graphics3D.releaseTarget();
        }
    }

    public Image2D createImage2D(int n, Image image) {
        if (image.getImage() == null) {
            Image image2 = Image.createImage(image.getWidth(), image.getHeight());
            image2.getGraphics().drawImage(image, 0, 0);
            image = image2;
        }
        return new Image2D(n, image.getImage());
    }

    static {
        boolean bl = false;
        try {
            Class.forName("javax.microedition.m3g.Graphics3D");
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IS_SUPPORTED = bl;
    }

    public static interface Callback {
        public void paintM3G(Graphics3D var1);
    }
}

