/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.ButtonGroup;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.DefaultLookAndFeel;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.UIManager;

public class RadioButton
extends Button {
    private boolean selected = false;
    private ButtonGroup group;

    public RadioButton(String string) {
        this(string, (Image)null);
    }

    public RadioButton() {
        this("");
    }

    public RadioButton(Image image) {
        this("", image);
    }

    public RadioButton(String string, Image image) {
        super(string, image);
        this.setUIID("RadioButton");
    }

    public String toString() {
        return "Radio Button " + this.getText();
    }

    int getAvaliableSpaceForText() {
        Image[] imageArray;
        if (this.isToggle()) {
            return super.getAvaliableSpaceForText();
        }
        LookAndFeel lookAndFeel = UIManager.getInstance().getLookAndFeel();
        if (lookAndFeel instanceof DefaultLookAndFeel && (imageArray = ((DefaultLookAndFeel)lookAndFeel).getRadioButtonImages()) != null) {
            int n = this.isSelected() ? 1 : 0;
            return super.getAvaliableSpaceForText() - imageArray[n].getWidth();
        }
        return super.getAvaliableSpaceForText() - (this.getHeight() + this.getGap());
    }

    public boolean isSelected() {
        return this.selected;
    }

    void setSelectedImpl(boolean bl) {
        this.selected = bl;
        this.repaint();
    }

    public void setSelected(boolean bl) {
        this.setSelectedImpl(bl);
        if (this.group != null && bl) {
            this.group.setSelected(this);
        }
    }

    public void released(int n, int n2) {
        if (!this.isSelected()) {
            this.setSelected(true);
        }
        super.released(n, n2);
    }

    public void paint(Graphics graphics) {
        if (this.isToggle()) {
            UIManager.getInstance().getLookAndFeel().drawButton(graphics, this);
        } else {
            UIManager.getInstance().getLookAndFeel().drawRadioButton(graphics, this);
        }
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getRadioButtonPreferredSize(this);
    }

    void setButtonGroup(ButtonGroup buttonGroup) {
        this.group = buttonGroup;
    }

    void fireActionEvent() {
        if (this.group != null) {
            this.group.setSelected(this);
        }
        super.fireActionEvent();
    }

    public void setGroup(String string) {
        this.putClientProperty("$group", string);
        this.initNamedGroup();
    }

    void initComponentImpl() {
        super.initComponentImpl();
        this.initNamedGroup();
    }

    private void initNamedGroup() {
        String string;
        if (this.isInitialized() && (string = this.getGroup()) != null) {
            Form form = this.getComponentForm();
            ButtonGroup buttonGroup = (ButtonGroup)form.getClientProperty("$radio" + string);
            if (buttonGroup == null) {
                buttonGroup = new ButtonGroup();
                form.putClientProperty("$radio" + string, buttonGroup);
            }
            buttonGroup.add(this);
        }
    }

    public String getGroup() {
        return (String)this.getClientProperty("$group");
    }
}

