/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.list;

import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Vector;

public class DefaultListModel
implements ListModel {
    private Vector items;
    private EventDispatcher dataListener = new EventDispatcher();
    private EventDispatcher selectionListener = new EventDispatcher();
    private int selectedIndex = 0;

    public DefaultListModel() {
        this.items = new Vector();
    }

    public DefaultListModel(Vector vector) {
        this.items = vector;
    }

    public DefaultListModel(Object[] objectArray) {
        this.items = DefaultListModel.createVector(objectArray);
    }

    private static Vector createVector(Object[] objectArray) {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(objectArray[i]);
        }
        return vector;
    }

    public Object getItemAt(int n) {
        if (n < this.getSize() && n >= 0) {
            return this.items.elementAt(n);
        }
        return null;
    }

    public int getSize() {
        return this.items.size();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void addItem(Object object) {
        this.items.addElement(object);
        this.fireDataChangedEvent(1, this.items.size());
    }

    public void setItem(int n, Object object) {
        this.items.setElementAt(object, n);
        this.fireDataChangedEvent(2, n);
    }

    public void addItemAtIndex(Object object, int n) {
        if (n <= this.items.size()) {
            this.items.insertElementAt(object, n);
            this.fireDataChangedEvent(1, n);
        }
    }

    public void removeItem(int n) {
        if (n < this.getSize() && n >= 0) {
            this.items.removeElementAt(n);
            if (n != 0) {
                this.setSelectedIndex(n - 1);
            }
            this.fireDataChangedEvent(0, n);
        }
    }

    public void removeAll() {
        while (this.getSize() > 0) {
            this.removeItem(0);
        }
    }

    public void setSelectedIndex(int n) {
        int n2 = this.selectedIndex;
        this.selectedIndex = n;
        this.selectionListener.fireSelectionEvent(n2, this.selectedIndex);
    }

    public void addDataChangedListener(DataChangedListener dataChangedListener) {
        this.dataListener.addListener(dataChangedListener);
    }

    public void removeDataChangedListener(DataChangedListener dataChangedListener) {
        this.dataListener.removeListener(dataChangedListener);
    }

    private void fireDataChangedEvent(int n, int n2) {
        this.dataListener.fireDataChangeEvent(n2, n);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListener.addListener(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionListener.removeListener(selectionListener);
    }
}

