/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.plaf;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Painter;
import com.sun.lwuit.RGBImage;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;

public class Border {
    private static Border defaultBorder = Border.createEtchedRaised(131586, 0xBBBBBB);
    private static final int TYPE_EMPTY = 0;
    private static final int TYPE_LINE = 1;
    private static final int TYPE_ROUNDED = 2;
    private static final int TYPE_ROUNDED_PRESSED = 3;
    private static final int TYPE_ETCHED_LOWERED = 4;
    private static final int TYPE_ETCHED_RAISED = 5;
    private static final int TYPE_BEVEL_RAISED = 6;
    private static final int TYPE_BEVEL_LOWERED = 7;
    private static final int TYPE_IMAGE = 8;
    private static final int TYPE_COMPOUND = 9;
    private static final int TYPE_IMAGE_HORIZONTAL = 10;
    private static final int TYPE_IMAGE_VERTICAL = 11;
    private static final int TYPE_DASHED = 12;
    private static final int TYPE_DOTTED = 13;
    private static final int TYPE_DOUBLE = 14;
    private static final int TYPE_GROOVE = 15;
    private static final int TYPE_RIDGE = 16;
    private static final int TYPE_INSET = 17;
    private static final int TYPE_OUTSET = 18;
    int type;
    Image[] images;
    boolean themeColors;
    int colorA;
    int colorB;
    int colorC;
    int colorD;
    int thickness = 0;
    int arcWidth;
    int arcHeight;
    boolean outline = true;
    Border pressedBorder;
    Border focusBorder;
    Border[] compoundBorders;
    Border outerBorder;
    String borderTitle;
    private static final int TITLE_MARGIN = 10;
    private static final int TITLE_SPACE = 5;
    private static Border empty;

    protected Border() {
    }

    public void addOuterBorder(Border border) {
        this.outerBorder = border;
    }

    public int getMinimumHeight() {
        if (this.images != null) {
            if (this.images.length < 4) {
                if (this.type == 10) {
                    return this.images[0].getHeight();
                }
                return this.images[0].getHeight() + this.images[1].getHeight();
            }
            Image image = this.images[4];
            Image image2 = this.images[7];
            return image.getHeight() + image2.getHeight();
        }
        return 0;
    }

    public int getMinimumWidth() {
        if (this.images != null) {
            if (this.images.length < 4) {
                if (this.type == 10) {
                    return this.images[0].getWidth() + this.images[1].getWidth();
                }
                return this.images[0].getWidth();
            }
            Image image = this.images[4];
            Image image2 = this.images[5];
            return image.getWidth() + image2.getWidth();
        }
        return 0;
    }

    public static Border getEmpty() {
        if (empty == null) {
            empty = new Border();
        }
        return empty;
    }

    public static Border createEmpty() {
        return new Border();
    }

    public static Border createImageBorder(Image image, Image image2, Image image3, Image image4, Image image5, Image image6, Image image7, Image image8, Image image9) {
        Border border = new Border();
        border.type = 8;
        border.images = new Image[]{image, image2, image3, image4, image5, image6, image7, image8, image9};
        return border;
    }

    public static Border createHorizonalImageBorder(Image image, Image image2, Image image3) {
        Border border = new Border();
        border.type = 10;
        border.images = new Image[]{image, image2, image3};
        return border;
    }

    public static Border createVerticalImageBorder(Image image, Image image2, Image image3) {
        Border border = new Border();
        border.type = 11;
        border.images = new Image[]{image, image2, image3};
        return border;
    }

    public static Border createImageBorder(Image image, Image image2, Image image3) {
        Border border = new Border();
        border.type = 8;
        border.images = new Image[]{image, image.rotate(180), image.rotate(270), image.rotate(90), image2, image2.rotate(90), image2.rotate(270), image2.rotate(180), image3};
        return border;
    }

    public static Border createLineBorder(int n) {
        Border border = new Border();
        border.type = 1;
        border.themeColors = true;
        border.thickness = n;
        return border;
    }

    public static Border createDottedBorder(int n, int n2) {
        return Border.createCSSBorder(13, n, n2);
    }

    public static Border createDashedBorder(int n, int n2) {
        return Border.createCSSBorder(12, n, n2);
    }

    public static Border createDoubleBorder(int n, int n2) {
        return Border.createCSSBorder(14, n, n2);
    }

    public static Border createDottedBorder(int n) {
        return Border.createCSSBorder(13, n);
    }

    public static Border createDashedBorder(int n) {
        return Border.createCSSBorder(12, n);
    }

    public static Border createDoubleBorder(int n) {
        return Border.createCSSBorder(14, n);
    }

    public static Border createOutsetBorder(int n) {
        return Border.createCSSBorder(18, n);
    }

    public static Border createOutsetBorder(int n, int n2) {
        return Border.createCSSBorder(18, n, n2);
    }

    public static Border createInsetBorder(int n) {
        return Border.createCSSBorder(17, n);
    }

    public static Border createInsetBorder(int n, int n2) {
        return Border.createCSSBorder(17, n, n2);
    }

    public static Border createGrooveBorder(int n) {
        return Border.createCSSBorder(15, n);
    }

    public static Border createGrooveBorder(int n, int n2) {
        return Border.createCSSBorder(15, n, n2);
    }

    public static Border createRidgeBorder(int n) {
        return Border.createCSSBorder(16, n);
    }

    public static Border createRidgeBorder(int n, int n2) {
        return Border.createCSSBorder(16, n, n2);
    }

    private static Border createCSSBorder(int n, int n2) {
        Border border = new Border();
        border.type = n;
        border.themeColors = true;
        border.thickness = n2;
        return border;
    }

    private static Border createCSSBorder(int n, int n2, int n3) {
        Border border = new Border();
        border.type = n;
        border.colorA = n3;
        border.thickness = n2;
        return border;
    }

    public static Border createLineBorder(int n, String string) {
        Border border = new Border();
        border.type = 1;
        border.themeColors = true;
        border.thickness = n;
        border.borderTitle = string;
        return border;
    }

    public static Border createLineBorder(int n, int n2, String string) {
        Border border = new Border();
        border.type = 1;
        border.themeColors = false;
        border.thickness = n;
        border.colorA = n2;
        border.borderTitle = string;
        return border;
    }

    public static Border createLineBorder(int n, int n2) {
        Border border = new Border();
        border.type = 1;
        border.themeColors = false;
        border.thickness = n;
        border.colorA = n2;
        return border;
    }

    public static Border createRoundBorder(int n, int n2) {
        Border border = new Border();
        border.type = 2;
        border.themeColors = true;
        border.arcHeight = n2;
        border.arcWidth = n;
        return border;
    }

    public static Border createRoundBorder(int n, int n2, boolean bl) {
        Border border = Border.createRoundBorder(n, n2);
        border.outline = bl;
        return border;
    }

    public static Border createRoundBorder(int n, int n2, int n3) {
        Border border = new Border();
        border.type = 2;
        border.themeColors = false;
        border.colorA = n3;
        border.arcHeight = n2;
        border.arcWidth = n;
        return border;
    }

    public static Border createRoundBorder(int n, int n2, int n3, boolean bl) {
        Border border = Border.createRoundBorder(n, n2, n3);
        border.outline = bl;
        return border;
    }

    public static Border createEtchedLowered() {
        Border border = new Border();
        border.type = 4;
        border.themeColors = true;
        return border;
    }

    public static Border createEtchedLowered(int n, int n2) {
        Border border = new Border();
        border.type = 4;
        border.themeColors = false;
        border.colorA = n2;
        border.colorB = n;
        return border;
    }

    public static Border createEtchedRaised() {
        Border border = new Border();
        border.type = 5;
        border.themeColors = true;
        border.thickness = 2;
        return border;
    }

    public static Border createEtchedRaised(int n, int n2) {
        Border border = new Border();
        border.type = 5;
        border.themeColors = false;
        border.colorA = n;
        border.colorB = n2;
        border.thickness = 2;
        return border;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            boolean bl;
            Border border = (Border)object;
            if (border.type == 9 && this.type == 9) {
                for (int i = 0; i <= 3; ++i) {
                    if (Border.isSame(this.compoundBorders[i], border.compoundBorders[i])) continue;
                    return false;
                }
                return true;
            }
            boolean bl2 = bl = this.themeColors == border.themeColors && this.type == border.type && this.thickness == border.thickness && this.colorA == border.colorA && this.colorB == border.colorB && this.colorC == border.colorC && this.colorD == border.colorD && this.arcWidth == border.arcWidth && this.arcHeight == border.arcHeight && this.outline == border.outline && Border.isSame(this.borderTitle, border.borderTitle) && Border.isSame(this.outerBorder, border.outerBorder);
            if (bl && this.type == 8 || this.type == 10 || this.type == 11) {
                for (int i = 0; i < this.images.length; ++i) {
                    if (this.images[i] == border.images[i]) continue;
                    return false;
                }
            }
            return bl;
        }
        return false;
    }

    private static boolean isSame(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return object == null;
        }
        return object.equals(object2);
    }

    public static Border createCompoundBorder(Border border, Border border2, Border border3, Border border4) {
        if (border != null && !border.isRectangleType() || border2 != null && !border2.isRectangleType() || border3 != null && !border3.isRectangleType() || border4 != null && !border4.isRectangleType()) {
            throw new IllegalArgumentException("Compound Border can be created only from Rectangle types Borders");
        }
        if (Border.isSame(border, border2) && Border.isSame(border, border3) && Border.isSame(border, border4)) {
            return border;
        }
        Border border5 = new Border();
        border5.type = 9;
        border5.compoundBorders = new Border[4];
        border5.compoundBorders[0] = border;
        border5.compoundBorders[2] = border2;
        border5.compoundBorders[1] = border3;
        border5.compoundBorders[3] = border4;
        border5.thickness = 0;
        for (int i = 0; i <= 3; ++i) {
            int n;
            if (border5.compoundBorders[i] == null || (n = border5.compoundBorders[i].thickness) <= border5.thickness) continue;
            border5.thickness = n;
        }
        return border5;
    }

    public boolean isBackgroundPainter() {
        return this.type == 2 || this.type == 3 || this.type == 8 || this.type == 10 || this.type == 11;
    }

    public boolean isRectangleType() {
        return this.type == 1 || this.type == 7 || this.type == 6 || this.type == 4 || this.type == 5 || this.type == 9 || this.type == 0 || this.type == 13 || this.type == 12 || this.type == 14 || this.type == 18 || this.type == 17 || this.type == 15 || this.type == 16;
    }

    public static Border createBevelLowered() {
        Border border = new Border();
        border.type = 7;
        border.themeColors = true;
        border.thickness = 2;
        return border;
    }

    public static Border createBevelLowered(int n, int n2, int n3, int n4) {
        Border border = new Border();
        border.type = 7;
        border.themeColors = false;
        border.colorA = n;
        border.colorB = n2;
        border.colorC = n3;
        border.colorD = n4;
        border.thickness = 2;
        return border;
    }

    public static Border createBevelRaised() {
        Border border = new Border();
        border.type = 6;
        border.themeColors = true;
        border.thickness = 2;
        return border;
    }

    public static Border createBevelRaised(int n, int n2, int n3, int n4) {
        Border border = new Border();
        border.type = 6;
        border.themeColors = false;
        border.colorA = n;
        border.colorB = n2;
        border.colorC = n3;
        border.colorD = n4;
        border.thickness = 2;
        return border;
    }

    public void setPressedInstance(Border border) {
        this.pressedBorder = border;
    }

    public void setFocusedInstance(Border border) {
        this.focusBorder = border;
    }

    public Border getFocusedInstance() {
        if (this.focusBorder != null) {
            return this.focusBorder;
        }
        return this;
    }

    public Border getPressedInstance() {
        if (this.pressedBorder != null) {
            return this.pressedBorder;
        }
        return this;
    }

    public Border createPressedVersion() {
        if (this.pressedBorder != null) {
            return this.pressedBorder;
        }
        switch (this.type) {
            case 1: {
                return Border.createLineBorder(this.thickness + 1, this.colorA);
            }
            case 4: {
                Border border = Border.createEtchedRaised(this.colorA, this.colorB);
                border.themeColors = this.themeColors;
                return border;
            }
            case 5: {
                Border border = Border.createEtchedLowered(this.colorA, this.colorB);
                border.themeColors = this.themeColors;
                return border;
            }
            case 6: {
                Border border = Border.createBevelLowered(this.colorA, this.colorB, this.colorC, this.colorD);
                border.themeColors = this.themeColors;
                return border;
            }
            case 7: {
                Border border = Border.createBevelRaised(this.colorA, this.colorB, this.colorC, this.colorD);
                border.themeColors = this.themeColors;
                return border;
            }
            case 2: {
                Border border = Border.createRoundBorder(this.arcWidth, this.arcHeight, this.colorA);
                border.themeColors = this.themeColors;
                border.type = 3;
                return border;
            }
            case 3: {
                Border border = Border.createRoundBorder(this.arcWidth, this.arcHeight, this.colorA);
                border.themeColors = this.themeColors;
                return border;
            }
        }
        return this;
    }

    public void paintBorderBackground(Graphics graphics, Component component) {
        int n = graphics.getColor();
        int n2 = component.getX();
        int n3 = component.getY();
        int n4 = component.getWidth();
        int n5 = component.getHeight();
        switch (this.type) {
            case 3: {
                ++n2;
                ++n3;
                n4 -= 2;
                n5 -= 2;
            }
            case 2: {
                Style style = component.getStyle();
                if (style.getBgImage() != null && style.getBackgroundType() == 1 || style.getBackgroundType() > 1) {
                    int[] nArray;
                    Object object = style.roundRectCache;
                    Image image = null;
                    if (object != null) {
                        image = (Image)Display.getInstance().extractHardRef(object);
                    }
                    if (image != null && image.getWidth() == n4 && image.getHeight() == n5) {
                        graphics.drawImage(image, n2, n3);
                        break;
                    }
                    image = Image.createImage(n4, n5);
                    Graphics graphics2 = image.getGraphics();
                    graphics2.setColor(0);
                    graphics2.fillRoundRect(0, 0, n4, n5, this.arcWidth, this.arcHeight);
                    int[] nArray2 = image.getRGBCached();
                    int n6 = nArray2[0];
                    if (style.getBackgroundType() == 1) {
                        nArray = style.getBgImage().scaled(n4, n5).getRGBCached();
                    } else {
                        Image image2 = Image.createImage(n4, n5);
                        Painter painter = style.getBgPainter();
                        if (painter == null) {
                            return;
                        }
                        painter.paint(image2.getGraphics(), new Rectangle(0, 0, n4, n5));
                        nArray = image2.getRGB();
                    }
                    for (int i = 0; i < nArray2.length; ++i) {
                        if (nArray2[i] != n6) continue;
                        nArray[i] = 0;
                    }
                    image = Image.createImage(nArray, n4, n5);
                    style.roundRectCache = Display.getInstance().createSoftWeakRef(image);
                    graphics.drawImage(image, n2, n3);
                    break;
                }
                int n7 = graphics.getColor();
                graphics.setColor(style.getBgColor());
                if (style.getBgTransparency() == -1) {
                    graphics.fillRoundRect(n2, n3, n4, n5, this.arcWidth, this.arcHeight);
                } else if (graphics.isAlphaSupported()) {
                    int n8 = graphics.getAlpha();
                    graphics.setAlpha(style.getBgTransparency() & 0xFF);
                    graphics.fillRoundRect(n2, n3, n4, n5, this.arcWidth, this.arcHeight);
                    graphics.setAlpha(n8);
                } else if (style.getBgTransparency() != 0) {
                    int[] nArray;
                    Graphics graphics3;
                    Image image = Image.createImage(n4, n5);
                    if (graphics.getColor() != 0xFFFFFF) {
                        graphics3 = image.getGraphics();
                        graphics3.setColor(graphics.getColor());
                        graphics3.fillRoundRect(0, 0, n4, n5, this.arcWidth, this.arcHeight);
                        nArray = image.getRGBCached();
                    } else {
                        graphics3 = image.getGraphics();
                        graphics3.setColor(0);
                        graphics3.fillRect(0, 0, n4, n5);
                        graphics3.setColor(graphics.getColor());
                        graphics3.fillRoundRect(0, 0, n4, n5, this.arcWidth, this.arcHeight);
                        nArray = image.getRGBCached();
                    }
                    int n9 = nArray[0];
                    int n10 = n4 * n5;
                    int n11 = (style.getBgTransparency() & 0xFF) << 24 & 0xFF000000;
                    for (int i = 0; i < n10; ++i) {
                        if (n9 == nArray[i]) {
                            nArray[i] = 0;
                            continue;
                        }
                        if ((nArray[i] & 0xFF000000) == 0) continue;
                        nArray[i] = nArray[i] & 0xFFFFFF | n11;
                    }
                    graphics.drawImage(new RGBImage(nArray, n4, n5), n2, n3);
                }
                graphics.setColor(n7);
                break;
            }
            case 8: {
                int n12 = graphics.getClipX();
                int n13 = graphics.getClipY();
                int n14 = graphics.getClipWidth();
                int n15 = graphics.getClipHeight();
                Image image = this.images[4];
                Image image3 = this.images[5];
                Image image4 = this.images[6];
                Image image5 = this.images[8];
                graphics.clipRect(n2 += image.getWidth(), n3 += image.getHeight(), n4 -= image.getWidth() + image3.getWidth(), n5 -= image.getHeight() + image4.getHeight());
                if (image5 != null) {
                    int n16 = image5.getWidth();
                    int n17 = image5.getHeight();
                    for (int i = n2; i < n2 + n4; i += n16) {
                        for (int j = n3; j < n3 + n5; j += n17) {
                            graphics.drawImage(image5, i, j);
                        }
                    }
                }
                Image image6 = this.images[0];
                Image image7 = this.images[1];
                Image image8 = this.images[2];
                Image image9 = this.images[3];
                Image image10 = this.images[7];
                graphics.setClip(n12, n13, n14, n15);
                n2 = component.getX();
                n3 = component.getY();
                n4 = component.getWidth();
                n5 = component.getHeight();
                graphics.drawImage(image, n2, n3);
                graphics.drawImage(image4, n2, n3 + n5 - image4.getHeight());
                graphics.drawImage(image3, n2 + n4 - image3.getWidth(), n3);
                graphics.drawImage(image10, n2 + n4 - image10.getWidth(), n3 + n5 - image10.getHeight());
                graphics.setClip(n12, n13, n14, n15);
                this.drawImageBorderLine(graphics, image, image3, image6, n2, n3, n4);
                graphics.setClip(n12, n13, n14, n15);
                this.drawImageBorderLine(graphics, image4, image10, image7, n2, n3 + n5 - image7.getHeight(), n4);
                graphics.setClip(n12, n13, n14, n15);
                this.drawImageBorderColumn(graphics, image, image4, image8, n2, n3, n5);
                graphics.setClip(n12, n13, n14, n15);
                this.drawImageBorderColumn(graphics, image3, image10, image9, n2 + n4 - image9.getWidth(), n3, n5);
                graphics.setClip(n12, n13, n14, n15);
                break;
            }
            case 10: {
                int n18 = graphics.getClipX();
                int n19 = graphics.getClipY();
                int n20 = graphics.getClipWidth();
                int n21 = graphics.getClipHeight();
                Image image = this.images[0];
                Image image11 = this.images[1];
                Image image12 = this.images[2];
                graphics.drawImage(image, n2, n3);
                graphics.drawImage(image11, n2 + n4 - image11.getWidth(), n3);
                graphics.clipRect(n2 += image.getWidth(), n3, n4 -= image.getWidth() + image11.getWidth(), n5);
                int n22 = image12.getWidth();
                for (int i = n2; i < n2 + n4; i += n22) {
                    graphics.drawImage(image12, i, n3);
                }
                graphics.setClip(n18, n19, n20, n21);
                break;
            }
            case 11: {
                int n23 = graphics.getClipX();
                int n24 = graphics.getClipY();
                int n25 = graphics.getClipWidth();
                int n26 = graphics.getClipHeight();
                Image image = this.images[0];
                Image image13 = this.images[1];
                Image image14 = this.images[2];
                graphics.drawImage(image, n2, n3);
                graphics.drawImage(image13, n2, n3 + n5 - image13.getHeight());
                graphics.clipRect(n2, n3 += image.getHeight(), n4, n5 -= image.getHeight() + image13.getHeight());
                int n27 = image14.getHeight();
                for (int i = n3; i < n3 + n5; i += n27) {
                    graphics.drawImage(image14, n2, i);
                }
                graphics.setClip(n23, n24, n25, n26);
                break;
            }
        }
        graphics.setColor(n);
    }

    public void paint(Graphics graphics, Component component) {
        int n = component.getX();
        int n2 = component.getY();
        int n3 = component.getWidth();
        int n4 = component.getHeight();
        if (this.outerBorder != null) {
            this.paint(graphics, n + this.thickness, n2 + this.thickness, n3 - this.thickness * 2, n4 - this.thickness * 2, component);
            this.outerBorder.paint(graphics, n, n2, n3, n4, component);
        } else {
            this.paint(graphics, n, n2, n3, n4, component);
        }
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4, Component component) {
        int n5 = graphics.getColor();
        if (!this.themeColors) {
            graphics.setColor(this.colorA);
        }
        switch (this.type) {
            case 1: {
                if (this.borderTitle == null) {
                    --n3;
                    --n4;
                    for (int i = 0; i < this.thickness; ++i) {
                        graphics.drawRect(n + i, n2 + i, n3, n4);
                        n3 -= 2;
                        n4 -= 2;
                    }
                    break;
                }
                Font font = component.getStyle().getFont();
                int n6 = font.stringWidth(this.borderTitle);
                int n7 = component.getStyle().getPadding(0);
                int n8 = n2 + (n7 - this.thickness) / 2;
                if (component.isRTL()) {
                    graphics.fillRect(n + n3 - 10, n8, 10, this.thickness);
                    graphics.fillRect(n, n8, n3 - (10 + n6 + 10), this.thickness);
                    graphics.drawString(this.borderTitle, n + n3 - (10 + n6 + 5), n2 + (n7 - font.getHeight()) / 2);
                } else {
                    graphics.fillRect(n, n8, 10, this.thickness);
                    graphics.fillRect(n + 10 + n6 + 10, n8, n3 - (10 + n6 + 10), this.thickness);
                    graphics.drawString(this.borderTitle, n + 10 + 5, n2 + (n7 - font.getHeight()) / 2);
                }
                graphics.fillRect(n, n2 + n4 - this.thickness, n3, this.thickness);
                graphics.fillRect(n, n8, this.thickness, n4);
                graphics.fillRect(n + n3 - this.thickness, n8, this.thickness, n4);
                break;
            }
            case 12: 
            case 13: {
                int n9;
                int n10;
                int n11 = this.thickness;
                if (this.type == 12) {
                    n11 = this.thickness * 3;
                }
                for (n10 = n; n10 < n + n3; n10 += n11 * 2) {
                    graphics.fillRect(n10, n2, n11, this.thickness);
                    graphics.fillRect(n10, n2 + n4 - this.thickness, n11, this.thickness);
                }
                if (n10 - n11 < n + n3) {
                    graphics.fillRect(n10 - n11, n2, n + n3 - n10 + n11, this.thickness);
                    graphics.fillRect(n10 - n11, n2 + n4 - this.thickness, n + n3 - n10 + n11, this.thickness);
                }
                for (n9 = n2; n9 < n2 + n4; n9 += n11 * 2) {
                    graphics.fillRect(n, n9, this.thickness, n11);
                    graphics.fillRect(n + n3 - this.thickness, n9, this.thickness, n11);
                }
                if (n9 - n11 >= n2 + n4) break;
                graphics.fillRect(n, n9 - n11, this.thickness, n2 + n4 - n9 + n11);
                graphics.fillRect(n + n3 - this.thickness, n9 - n11, this.thickness, n2 + n4 - n9 + n11);
                break;
            }
            case 14: {
                --n3;
                --n4;
                for (int i = 0; i < this.thickness; ++i) {
                    if (i * 100 / this.thickness <= 33 || i * 100 / this.thickness >= 66) {
                        graphics.drawRect(n + i, n2 + i, n3, n4);
                    }
                    n3 -= 2;
                    n4 -= 2;
                }
                break;
            }
            case 17: 
            case 18: {
                int n12;
                for (n12 = 0; n12 < this.thickness; ++n12) {
                    graphics.drawLine(n + n12, n2 + n12, n + n12, n2 + n4 - n12);
                    graphics.drawLine(n + n12, n2 + n12, n + n3 - n12, n2 + n12);
                }
                if (this.type == 17) {
                    graphics.lighterColor(50);
                } else {
                    graphics.darkerColor(50);
                }
                for (n12 = 0; n12 < this.thickness; ++n12) {
                    graphics.drawLine(n + n12, n2 + n4 - n12, n + n3 - n12, n2 + n4 - n12);
                    graphics.drawLine(n + n3 - n12, n2 + n12, n + n3 - n12, n2 + n4 - n12);
                }
                break;
            }
            case 15: 
            case 16: {
                int n13;
                for (n13 = 0; n13 < this.thickness / 2; ++n13) {
                    graphics.drawLine(n + n13, n2 + n13, n + n13, n2 + n4 - n13);
                    graphics.drawLine(n + n13, n2 + n13, n + n3 - n13, n2 + n13);
                }
                for (n13 = this.thickness / 2; n13 < this.thickness; ++n13) {
                    graphics.drawLine(n + n13, n2 + n4 - n13, n + n3 - n13, n2 + n4 - n13);
                    graphics.drawLine(n + n3 - n13, n2 + n13, n + n3 - n13, n2 + n4 - n13);
                }
                if (this.type == 15) {
                    graphics.lighterColor(50);
                } else {
                    graphics.darkerColor(50);
                }
                for (n13 = 0; n13 < this.thickness / 2; ++n13) {
                    graphics.drawLine(n + n13, n2 + n4 - n13, n + n3 - n13, n2 + n4 - n13);
                    graphics.drawLine(n + n3 - n13, n2 + n13, n + n3 - n13, n2 + n4 - n13);
                }
                for (n13 = this.thickness / 2; n13 < this.thickness; ++n13) {
                    graphics.drawLine(n + n13, n2 + n13, n + n13, n2 + n4 - n13);
                    graphics.drawLine(n + n13, n2 + n13, n + n3 - n13, n2 + n13);
                }
                break;
            }
            case 3: {
                ++n;
                ++n2;
                n3 -= 2;
                n4 -= 2;
            }
            case 2: {
                --n3;
                --n4;
                if (!this.outline) break;
                graphics.drawRoundRect(n, n2, n3, n4, this.arcWidth, this.arcHeight);
                break;
            }
            case 4: 
            case 5: {
                graphics.drawRect(n, n2, n3 - 2, n4 - 2);
                if (this.themeColors) {
                    if (this.type == 4) {
                        graphics.lighterColor(40);
                    } else {
                        graphics.darkerColor(40);
                    }
                } else {
                    graphics.setColor(this.colorB);
                }
                graphics.drawLine(n + 1, n2 + n4 - 3, n + 1, n2 + 1);
                graphics.drawLine(n + 1, n2 + 1, n + n3 - 3, n2 + 1);
                graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + n3 - 1, n2);
                break;
            }
            case 6: {
                if (this.themeColors) {
                    graphics.setColor(this.getBackgroundColor(component));
                    graphics.lighterColor(50);
                } else {
                    graphics.setColor(this.colorA);
                }
                graphics.drawLine(n, n2, n, n2 + n4 - 2);
                graphics.drawLine(n + 1, n2, n + n3 - 2, n2);
                if (this.themeColors) {
                    graphics.darkerColor(25);
                } else {
                    graphics.setColor(this.colorB);
                }
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 3);
                graphics.drawLine(n + 2, n2 + 1, n + n3 - 3, n2 + 1);
                if (this.themeColors) {
                    graphics.darkerColor(50);
                } else {
                    graphics.setColor(this.colorC);
                }
                graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 2);
                if (this.themeColors) {
                    graphics.darkerColor(25);
                } else {
                    graphics.setColor(this.colorD);
                }
                graphics.drawLine(n + 1, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
                graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + n4 - 3);
                break;
            }
            case 7: {
                if (this.themeColors) {
                    graphics.setColor(this.getBackgroundColor(component));
                    graphics.darkerColor(50);
                } else {
                    graphics.setColor(this.colorD);
                }
                graphics.drawLine(n, n2, n, n2 + n4 - 1);
                graphics.drawLine(n + 1, n2, n + n3 - 1, n2);
                if (this.themeColors) {
                    graphics.lighterColor(25);
                } else {
                    graphics.setColor(this.colorC);
                }
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 2);
                graphics.drawLine(n + 2, n2 + 1, n + n3 - 2, n2 + 1);
                if (this.themeColors) {
                    graphics.lighterColor(50);
                } else {
                    graphics.setColor(this.colorC);
                }
                graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 2);
                if (this.themeColors) {
                    graphics.lighterColor(25);
                } else {
                    graphics.setColor(this.colorA);
                }
                graphics.drawLine(n + 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
                graphics.drawLine(n + n3 - 2, n2 + 2, n + n3 - 2, n2 + n4 - 3);
                break;
            }
            case 9: {
                Rectangle rectangle;
                Style style = component.getStyle();
                boolean bl = true;
                boolean bl2 = true;
                if (UIManager.getInstance().getLookAndFeel().isRTL()) {
                    boolean bl3 = bl;
                    bl = bl2;
                    bl2 = bl3;
                }
                Border border = this.compoundBorders[0];
                Border border2 = this.compoundBorders[2];
                Border border3 = this.compoundBorders[1];
                Border border4 = this.compoundBorders[3];
                int n14 = 0;
                int n15 = 0;
                if (border != null) {
                    rectangle = this.saveClip(graphics);
                    n14 = border.thickness;
                    graphics.clipRect(n, n2, n3, n14);
                    border.paint(graphics, n, n2, n3, n4, component);
                    this.restoreClip(graphics, rectangle);
                }
                if (border2 != null) {
                    rectangle = this.saveClip(graphics);
                    n15 = border2.thickness;
                    graphics.clipRect(n, n2 + n4 - n15, n3, n15);
                    border2.paint(graphics, n, n2, n3, n4, component);
                    this.restoreClip(graphics, rectangle);
                }
                if (bl && border3 != null) {
                    rectangle = this.saveClip(graphics);
                    graphics.clipRect(n, n2 + n14, border3.thickness, n4 - n14 - n15);
                    border3.paint(graphics, n, n2, n3, n4, component);
                    this.restoreClip(graphics, rectangle);
                }
                if (!bl2 || border4 == null) break;
                rectangle = this.saveClip(graphics);
                graphics.clipRect(n + n3 - border4.thickness, n2 + n14, border4.thickness, n4 - n14 - n15);
                border4.paint(graphics, n, n2, n3, n4, component);
                this.restoreClip(graphics, rectangle);
                break;
            }
        }
        graphics.setColor(n5);
    }

    private Rectangle saveClip(Graphics graphics) {
        return new Rectangle(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
    }

    private void restoreClip(Graphics graphics, Rectangle rectangle) {
        graphics.setClip(rectangle.getX(), rectangle.getY(), rectangle.getSize().getWidth(), rectangle.getSize().getHeight());
    }

    private int getBackgroundColor(Component component) {
        return component.getStyle().getBgColor();
    }

    private void drawImageBorderLine(Graphics graphics, Image image, Image image2, Image image3, int n, int n2, int n3) {
        int n4 = n3 - image2.getWidth();
        if (n4 > 0) {
            int n5 = (n += image.getWidth()) + n4;
            graphics.clipRect(n, n2, n4 - image.getWidth(), image3.getHeight());
            int n6 = image3.getWidth();
            while (n < n5) {
                graphics.drawImage(image3, n, n2);
                n += n6;
            }
        }
    }

    private void drawImageBorderColumn(Graphics graphics, Image image, Image image2, Image image3, int n, int n2, int n3) {
        int n4 = n3 - image2.getHeight();
        if (n4 > 0) {
            int n5 = (n2 += image.getHeight()) + n4;
            graphics.clipRect(n, n2, image3.getWidth(), n4 - image.getHeight());
            int n6 = image3.getHeight();
            while (n2 < n5) {
                graphics.drawImage(image3, n, n2);
                n2 += n6;
            }
        }
    }

    public static void setDefaultBorder(Border border) {
        defaultBorder = border;
    }

    public static Border getDefaultBorder() {
        return defaultBorder;
    }

    public int getThickness() {
        return this.thickness;
    }

    public Border[] getCompoundBorders() {
        return this.compoundBorders;
    }

    public void lock() {
        if (this.images != null) {
            for (int i = 0; i < this.images.length; ++i) {
                if (this.images[i] == null) continue;
                this.images[i].lock();
            }
        }
    }

    public void unlock() {
        if (this.images != null) {
            for (int i = 0; i < this.images.length; ++i) {
                if (this.images[i] == null) continue;
                this.images[i].unlock();
            }
        }
    }
}

