/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.plaf;

import com.sun.lwuit.Button;
import com.sun.lwuit.Component;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.TabbedPane;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;

public abstract class LookAndFeel {
    private Component verticalScroll;
    private Component horizontalScroll;
    private Component verticalScrollThumb;
    private Component horizontalScrollThumb;
    private boolean rtl;
    private long tickerSpeed = 50L;
    private int defaultFormTintColor = 0x77000000;
    private int disableColor = 0xCCCCCC;
    private Transition defaultFormTransitionIn;
    private Transition defaultFormTransitionOut;
    private Transition defaultMenuTransitionIn;
    private Transition defaultMenuTransitionOut;
    private Transition defaultDialogTransitionIn;
    private Transition defaultDialogTransitionOut;
    private boolean defaultSmoothScrolling = true;
    private boolean focusScrolling;
    private int defaultSmoothScrollingSpeed = 150;
    private boolean fadeScrollEdge;
    private boolean fadeScrollBar;
    private int fadeScrollEdgeLength = 15;
    private Image fadeScrollTop;
    private Image fadeScrollBottom;
    private Image fadeScrollRight;
    private Image fadeScrollLeft;
    private int fadeScrollEdgeStartAlpha = 0x999999;
    private int fadeScrollEdgeEndAlpha = 0;
    private boolean reverseSoftButtons;
    private ListCellRenderer menuRenderer;
    private Image[] menuIcons = new Image[3];
    private int tactileTouchDuration = 0;
    private boolean defaultEndsWith3Points = true;
    private boolean defaultTensileDrag = true;
    private Class menuBar = class$com$sun$lwuit$MenuBar == null ? (class$com$sun$lwuit$MenuBar = LookAndFeel.class$("com.sun.lwuit.MenuBar")) : class$com$sun$lwuit$MenuBar;
    static /* synthetic */ Class class$com$sun$lwuit$MenuBar;

    public void bind(Component component) {
    }

    public void uninstall() {
    }

    public abstract void drawButton(Graphics var1, Button var2);

    public abstract void drawCheckBox(Graphics var1, Button var2);

    public abstract void drawComboBox(Graphics var1, List var2);

    public abstract void drawLabel(Graphics var1, Label var2);

    public abstract void drawList(Graphics var1, List var2);

    public abstract void drawRadioButton(Graphics var1, Button var2);

    public abstract void drawTextArea(Graphics var1, TextArea var2);

    public abstract void drawTextField(Graphics var1, TextArea var2);

    public abstract void drawTextFieldCursor(Graphics var1, TextArea var2);

    public abstract void drawTabbedPane(Graphics var1, TabbedPane var2);

    public abstract Dimension getButtonPreferredSize(Button var1);

    public abstract Dimension getCheckBoxPreferredSize(Button var1);

    public abstract Dimension getLabelPreferredSize(Label var1);

    public abstract Dimension getListPreferredSize(List var1);

    public abstract Dimension getRadioButtonPreferredSize(Button var1);

    public abstract Dimension getTextAreaSize(TextArea var1, boolean var2);

    public abstract Dimension getTextFieldPreferredSize(TextArea var1);

    public abstract Dimension getComboBoxPreferredSize(List var1);

    public void drawVerticalScroll(Graphics graphics, Component component, float f, float f2) {
        if (this.verticalScroll == null) {
            this.initScroll();
        }
        int n = 0;
        if (component.getStyle().getBorder() != null) {
            n = component.getStyle().getBorder().getThickness();
        }
        int n2 = component.getX();
        n2 = !component.isRTL() ? (n2 += component.getWidth() - this.getVerticalScrollWidth() - n) : (n2 += n);
        int n3 = component.getY();
        int n4 = component.getHeight();
        int n5 = this.getVerticalScrollWidth();
        this.drawScroll(graphics, component, f, f2, true, n2, n3, n5, n4, this.verticalScroll, this.verticalScrollThumb);
        if (this.fadeScrollEdge) {
            if (f > 0.0f) {
                if (this.fadeScrollTop == null || Display.getInstance().getDisplayWidth() != this.fadeScrollTop.getWidth()) {
                    this.fadeScrollTop = this.generateFadeImage(this.fadeScrollEdgeStartAlpha, this.fadeScrollEdgeEndAlpha, component.getStyle().getBgColor(), false, Display.getInstance().getDisplayWidth(), this.fadeScrollEdgeLength);
                }
                graphics.drawImage(this.fadeScrollTop, component.getX(), component.getY());
            }
            if (f < 1.0f - f2) {
                int n6;
                int n7 = component.getScrollY() + component.getHeight() + component.getStyle().getMargin(0) + component.getStyle().getMargin(2) + component.getStyle().getPadding(0) + component.getStyle().getPadding(2);
                if (n7 >= (n6 = component.getScrollDimension().getHeight())) {
                    return;
                }
                if (this.fadeScrollBottom == null || Display.getInstance().getDisplayWidth() != this.fadeScrollBottom.getWidth()) {
                    this.fadeScrollBottom = this.generateFadeImage(this.fadeScrollEdgeEndAlpha, this.fadeScrollEdgeStartAlpha, component.getStyle().getBgColor(), false, Display.getInstance().getDisplayWidth(), this.fadeScrollEdgeLength);
                }
                graphics.drawImage(this.fadeScrollBottom, component.getX(), component.getY() + component.getHeight() - this.fadeScrollBottom.getHeight());
            }
        }
    }

    private Image generateFadeImage(int n, int n2, int n3, boolean bl, int n4, int n5) {
        Image image = Image.createImage(n4, n5);
        image.getGraphics().fillLinearGradient(n, n2, 0, 0, n4, n5, bl);
        Object object = image.createMask();
        image = Image.createImage(n4, n5);
        Graphics graphics = image.getGraphics();
        graphics.setColor(n3);
        graphics.fillRect(0, 0, n4, n5);
        return image.applyMask(object);
    }

    public void drawHorizontalScroll(Graphics graphics, Component component, float f, float f2) {
        if (this.horizontalScroll == null) {
            this.initScroll();
        }
        int n = 0;
        if (component.getStyle().getBorder() != null) {
            n = component.getStyle().getBorder().getThickness();
        }
        int n2 = component.getX();
        int n3 = component.getY() + component.getHeight() - this.getHorizontalScrollHeight() - n;
        int n4 = component.getWidth();
        int n5 = this.getHorizontalScrollHeight();
        this.drawScroll(graphics, component, f, f2, false, n2, n3, n4, n5, this.horizontalScroll, this.horizontalScrollThumb);
        if (this.fadeScrollEdge) {
            if (f > 0.0f) {
                if (this.fadeScrollLeft == null || Display.getInstance().getDisplayHeight() != this.fadeScrollLeft.getHeight()) {
                    this.fadeScrollLeft = this.generateFadeImage(this.fadeScrollEdgeStartAlpha, this.fadeScrollEdgeEndAlpha, component.getStyle().getBgColor(), true, this.fadeScrollEdgeLength, Display.getInstance().getDisplayHeight());
                }
                graphics.drawImage(this.fadeScrollLeft, component.getX(), component.getY());
            }
            if (f < 1.0f - f2) {
                int n6;
                int n7 = component.getScrollX() + component.getWidth() + component.getStyle().getMargin(1) + component.getStyle().getMargin(3) + component.getStyle().getPadding(1) + component.getStyle().getPadding(3);
                if (n7 >= (n6 = component.getScrollDimension().getWidth())) {
                    return;
                }
                if (this.fadeScrollRight == null || Display.getInstance().getDisplayHeight() != this.fadeScrollRight.getHeight()) {
                    this.fadeScrollRight = this.generateFadeImage(this.fadeScrollEdgeEndAlpha, this.fadeScrollEdgeStartAlpha, component.getStyle().getBgColor(), true, this.fadeScrollEdgeLength, Display.getInstance().getDisplayHeight());
                }
                graphics.drawImage(this.fadeScrollRight, component.getX() + component.getWidth() - this.fadeScrollRight.getWidth(), component.getY());
            }
        }
    }

    private void drawScroll(Graphics graphics, Component component, float f, float f2, boolean bl, int n, int n2, int n3, int n4, Component component2, Component component3) {
        int n5;
        int n6;
        Style style = component2.getUnselectedStyle();
        Style style2 = component3.getUnselectedStyle();
        int n7 = style.getBgTransparency() & 0xFF;
        int n8 = style2.getBgTransparency() & 0xFF;
        if (this.fadeScrollBar) {
            style.setBgTransparency(component.getScrollOpacity(), true);
            style2.setBgTransparency(component.getScrollOpacity(), true);
        }
        int n9 = style.getMargin(component.isRTL(), 1);
        int n10 = style.getMargin(false, 0);
        component2.setX(n += n9);
        component2.setY(n2 += n10);
        component2.setWidth(n3 -= n9 + style.getMargin(component.isRTL(), 3));
        component2.setHeight(n4 -= n10 + style.getMargin(false, 2));
        int n11 = graphics.getClipX();
        int n12 = graphics.getClipY();
        int n13 = graphics.getClipWidth();
        int n14 = graphics.getClipHeight();
        component2.paintComponent(graphics);
        n9 = style2.getMargin(component.isRTL(), 1);
        n10 = style2.getMargin(false, 0);
        n += n9;
        n3 -= n9 + style2.getMargin(component.isRTL(), 3);
        n2 += n10;
        n4 -= n10 + style2.getMargin(false, 2);
        if (bl) {
            n6 = (int)((float)component.getHeight() * f2) + 2;
            n5 = (int)((float)component.getHeight() * f);
        } else {
            n6 = (int)((float)component.getWidth() * f2) + 2;
            n5 = (int)((float)component.getWidth() * f);
        }
        if (bl) {
            component3.setX(n);
            component3.setY(n2 + n5);
            component3.setWidth(n3);
            component3.setHeight(n6);
        } else {
            component3.setX(n + n5);
            component3.setY(n2);
            component3.setWidth(n6);
            component3.setHeight(n4);
        }
        graphics.setClip(n11, n12, n13, n14);
        component3.paintComponent(graphics);
        graphics.setClip(n11, n12, n13, n14);
        if (this.fadeScrollBar) {
            style.setBgTransparency(n7, true);
            style2.setBgTransparency(n8, true);
        }
    }

    public void setFG(Graphics graphics, Component component) {
        Style style = component.getStyle();
        graphics.setFont(style.getFont());
        graphics.setColor(style.getFgColor());
    }

    public int getVerticalScrollWidth() {
        if (this.verticalScroll == null) {
            this.initScroll();
        }
        Style style = this.verticalScroll.getStyle();
        return style.getMargin(false, 1) + style.getMargin(false, 3) + style.getPadding(false, 1) + style.getPadding(false, 3);
    }

    public int getHorizontalScrollHeight() {
        if (this.horizontalScroll == null) {
            this.initScroll();
        }
        Style style = this.horizontalScroll.getStyle();
        return style.getMargin(false, 0) + style.getMargin(false, 2) + style.getPadding(false, 0) + style.getPadding(false, 2);
    }

    void drawBorder(Graphics graphics, Component component, int n, int n2) {
        this.drawBorder(graphics, component, n, n, n2);
    }

    void drawBorder(Graphics graphics, Component component, int n, int n2, int n3) {
        graphics.setColor(n);
        graphics.fillRect(component.getX(), component.getY(), component.getWidth(), n3);
        graphics.fillRect(component.getX(), component.getY(), n3, component.getHeight());
        graphics.setColor(n2);
        graphics.fillRect(component.getX(), component.getY() + component.getHeight() - n3, component.getWidth(), n3);
        graphics.fillRect(component.getX() + component.getWidth() - n3, component.getY(), n3, component.getHeight());
    }

    public abstract Component getTabbedPaneCell(TabbedPane var1, String var2, Image var3, boolean var4, boolean var5, Style var6, Style var7, Style var8, int var9, int var10, Dimension var11, Dimension var12);

    public abstract void drawTabbedPaneContentPane(TabbedPane var1, Graphics var2, Rectangle var3, Dimension var4, int var5, int var6, Dimension var7, int var8, int var9);

    public Transition getDefaultFormTransitionIn() {
        return this.defaultFormTransitionIn;
    }

    public void setDefaultFormTransitionIn(Transition transition) {
        this.defaultFormTransitionIn = transition;
    }

    public Transition getDefaultFormTransitionOut() {
        return this.defaultFormTransitionOut;
    }

    public void setDefaultFormTransitionOut(Transition transition) {
        this.defaultFormTransitionOut = transition;
    }

    public Transition getDefaultMenuTransitionIn() {
        return this.defaultMenuTransitionIn;
    }

    public void setDefaultMenuTransitionIn(Transition transition) {
        this.defaultMenuTransitionIn = transition;
    }

    public Transition getDefaultMenuTransitionOut() {
        return this.defaultMenuTransitionOut;
    }

    public void setDefaultMenuTransitionOut(Transition transition) {
        this.defaultMenuTransitionOut = transition;
    }

    public Transition getDefaultDialogTransitionIn() {
        return this.defaultDialogTransitionIn;
    }

    public void setDefaultDialogTransitionIn(Transition transition) {
        this.defaultDialogTransitionIn = transition;
    }

    public Transition getDefaultDialogTransitionOut() {
        return this.defaultDialogTransitionOut;
    }

    public void setDefaultDialogTransitionOut(Transition transition) {
        this.defaultDialogTransitionOut = transition;
    }

    public int getDefaultFormTintColor() {
        return this.defaultFormTintColor;
    }

    public void setDefaultFormTintColor(int n) {
        this.defaultFormTintColor = n;
    }

    public int getDisableColor() {
        return this.disableColor;
    }

    public void setDisableColor(int n) {
        this.disableColor = n;
    }

    public boolean isDefaultSmoothScrolling() {
        return this.defaultSmoothScrolling;
    }

    public void setDefaultSmoothScrolling(boolean bl) {
        this.defaultSmoothScrolling = bl;
    }

    public int getDefaultSmoothScrollingSpeed() {
        return this.defaultSmoothScrollingSpeed;
    }

    public void setDefaultSmoothScrollingSpeed(int n) {
        this.defaultSmoothScrollingSpeed = n;
    }

    public boolean isReverseSoftButtons() {
        return this.reverseSoftButtons;
    }

    public void setReverseSoftButtons(boolean bl) {
        this.reverseSoftButtons = bl;
    }

    public Class getMenuBarClass() {
        return this.menuBar;
    }

    public void setMenuBarClass(Class clazz) {
        this.menuBar = clazz;
    }

    public ListCellRenderer getMenuRenderer() {
        return this.menuRenderer;
    }

    public void setMenuRenderer(ListCellRenderer listCellRenderer) {
        this.menuRenderer = listCellRenderer;
    }

    public void setMenuIcons(Image image, Image image2, Image image3) {
        this.menuIcons[0] = image;
        this.menuIcons[1] = image2;
        this.menuIcons[2] = image3;
    }

    public Image[] getMenuIcons() {
        return this.menuIcons;
    }

    public long getTickerSpeed() {
        return this.tickerSpeed;
    }

    public void setTickerSpeed(long l) {
        this.tickerSpeed = l;
    }

    private void initScroll() {
        this.verticalScroll = new Label();
        this.verticalScroll.setUIID("Scroll");
        this.horizontalScroll = new Label();
        this.horizontalScroll.setUIID("HorizontalScroll");
        this.verticalScrollThumb = new Label();
        this.verticalScrollThumb.setUIID("ScrollThumb");
        this.horizontalScrollThumb = new Label();
        this.horizontalScrollThumb.setUIID("HorizontalScrollThumb");
    }

    public void refreshTheme() {
        this.fadeScrollTop = null;
        this.fadeScrollBottom = null;
        this.fadeScrollRight = null;
        this.fadeScrollLeft = null;
        this.initScroll();
        if (this.menuRenderer != null && this.menuRenderer instanceof Component) {
            ((Component)((Object)this.menuRenderer)).refreshTheme();
        }
        UIManager uIManager = UIManager.getInstance();
        boolean bl = Display.getInstance().isTouchScreenDevice();
        this.fadeScrollEdge = uIManager.isThemeConstant("fadeScrollEdgeBool", false);
        this.fadeScrollEdgeLength = uIManager.getThemeConstant("fadeScrollEdgeInt", this.fadeScrollEdgeLength);
        this.fadeScrollBar = uIManager.isThemeConstant("fadeScrollBarBool", false);
        this.tickerSpeed = Long.parseLong(uIManager.getThemeConstant("tickerSpeedInt", "" + this.tickerSpeed));
        this.defaultFormTintColor = (int)Long.parseLong(uIManager.getThemeConstant("tintColor", Integer.toHexString(this.defaultFormTintColor)), 16);
        this.disableColor = Integer.parseInt(uIManager.getThemeConstant("disabledColor", Integer.toHexString(this.disableColor)), 16);
        Dialog.setDefaultDialogPosition(uIManager.getThemeConstant("dialogPosition", Dialog.getDefaultDialogPosition()));
        Dialog.setCommandsAsButtons(uIManager.isThemeConstant("dialogButtonCommandsBool", Dialog.isCommandsAsButtons()));
        List.setDefaultIgnoreFocusComponentWhenUnfocused(uIManager.isThemeConstant("ignorListFocusBool", List.isDefaultIgnoreFocusComponentWhenUnfocused()));
        if (bl) {
            Display.getInstance().setPureTouch(uIManager.isThemeConstant("pureTouchBool", Display.getInstance().isPureTouch()));
        }
        int n = Integer.parseInt(uIManager.getThemeConstant("transitionSpeedInt", "300"));
        String string = uIManager.getThemeConstant("slideDirection", "horizontal");
        String string2 = uIManager.getThemeConstant("dlgSlideDirection", "vertical");
        String string3 = uIManager.getThemeConstant("menuSlideDirection", string2);
        boolean bl2 = uIManager.isThemeConstant("slideOutDirBool", false);
        boolean bl3 = uIManager.isThemeConstant("slideInDirBool", true);
        boolean bl4 = uIManager.isThemeConstant("dlgSlideOutDirBool", false);
        boolean bl5 = uIManager.isThemeConstant("dlgSlideInDirBool", true);
        boolean bl6 = uIManager.isThemeConstant("menuSlideOutDirBool", false);
        boolean bl7 = uIManager.isThemeConstant("menuSlideInDirBool", true);
        this.defaultFormTransitionIn = this.getTransitionConstant(this.defaultFormTransitionIn, "formTransitionIn", string, n, bl3);
        this.defaultFormTransitionOut = this.getTransitionConstant(this.defaultFormTransitionOut, "formTransitionOut", string, n, bl2);
        this.defaultMenuTransitionIn = this.getTransitionConstant(this.defaultMenuTransitionIn, "menuTransitionIn", string3, n, bl7);
        this.defaultMenuTransitionOut = this.getTransitionConstant(this.defaultMenuTransitionOut, "menuTransitionOut", string3, n, bl6);
        this.defaultDialogTransitionIn = this.getTransitionConstant(this.defaultDialogTransitionIn, "dialogTransitionIn", string2, n, bl5);
        this.defaultDialogTransitionOut = this.getTransitionConstant(this.defaultDialogTransitionOut, "dialogTransitionOut", string2, n, bl4);
        this.setTouchMenus(uIManager.isThemeConstant("touchMenuBool", this.isTouchMenus()));
        this.initCommandBehaviorConstant(uIManager.getThemeConstant("commandBehavior", null));
        this.reverseSoftButtons = uIManager.isThemeConstant("reverseSoftButtonsBool", this.reverseSoftButtons);
    }

    private void initCommandBehaviorConstant(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("SoftKey")) {
                Display.getInstance().setCommandBehavior(2);
            }
            if (string.equalsIgnoreCase("Touch")) {
                Display.getInstance().setCommandBehavior(3);
            }
            if (string.equalsIgnoreCase("Bar")) {
                Display.getInstance().setCommandBehavior(4);
            }
            if (string.equalsIgnoreCase("Title")) {
                Display.getInstance().setCommandBehavior(5);
            }
            if (string.equalsIgnoreCase("Right")) {
                Display.getInstance().setCommandBehavior(6);
            }
            if (string.equalsIgnoreCase("Native")) {
                Display.getInstance().setCommandBehavior(10);
            }
        }
    }

    private Transition getTransitionConstant(Transition transition, String string, String string2, int n, boolean bl) {
        Image image = UIManager.getInstance().getThemeImageConstant(string + "Image");
        if (image != null) {
            return CommonTransitions.createTimeline(image);
        }
        String string3 = UIManager.getInstance().getThemeConstant(string, null);
        if (string3 == null) {
            return transition;
        }
        if (string3.equalsIgnoreCase("slide")) {
            if (string2.equalsIgnoreCase("horizontal")) {
                return CommonTransitions.createSlide(0, bl, n);
            }
            return CommonTransitions.createSlide(1, bl, n);
        }
        if (string3.equalsIgnoreCase("fslide")) {
            if (string2.equalsIgnoreCase("horizontal")) {
                return CommonTransitions.createFastSlide(0, bl, n);
            }
            return CommonTransitions.createFastSlide(1, bl, n);
        }
        if (string3.equalsIgnoreCase("fslide")) {
            return CommonTransitions.createFade(n);
        }
        return transition;
    }

    public boolean isTouchMenus() {
        int n = Display.getInstance().getCommandBehavior();
        return n == 3 || n == 1 && Display.getInstance().isTouchScreenDevice();
    }

    public void setTouchMenus(boolean bl) {
        if (bl) {
            Display.getInstance().setCommandBehavior(3);
        } else {
            Display.getInstance().setCommandBehavior(2);
        }
    }

    public void setRTL(boolean bl) {
        if (UIManager.localeAccessible) {
            this.rtl = bl;
            if (bl) {
                Display.getInstance().setBidiAlgorithm(true);
            }
        }
    }

    public boolean isRTL() {
        return this.rtl;
    }

    public int getTactileTouchDuration() {
        return this.tactileTouchDuration;
    }

    public void setTactileTouchDuration(int n) {
        this.tactileTouchDuration = n;
    }

    public boolean isDefaultEndsWith3Points() {
        return this.defaultEndsWith3Points;
    }

    public void setDefaultEndsWith3Points(boolean bl) {
        this.defaultEndsWith3Points = bl;
    }

    public boolean isDefaultTensileDrag() {
        return this.defaultTensileDrag;
    }

    public void setDefaultTensileDrag(boolean bl) {
        this.defaultTensileDrag = bl;
    }

    public boolean isFocusScrolling() {
        return this.focusScrolling;
    }

    public void setFocusScrolling(boolean bl) {
        this.focusScrolling = bl;
    }

    public boolean isFadeScrollEdge() {
        return this.fadeScrollEdge;
    }

    public void setFadeScrollEdge(boolean bl) {
        this.fadeScrollEdge = bl;
    }

    public boolean isFadeScrollBar() {
        return this.fadeScrollBar;
    }

    public void setFadeScrollBar(boolean bl) {
        this.fadeScrollBar = bl;
    }

    public int getFadeScrollEdgeLength() {
        return this.fadeScrollEdgeLength;
    }

    public void setFadeScrollEdgeLength(int n) {
        this.fadeScrollEdgeLength = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

