/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.util;

import com.sun.lwuit.Display;
import com.sun.lwuit.EncodedImage;
import com.sun.lwuit.Font;
import com.sun.lwuit.Image;
import com.sun.lwuit.StaticAnimation;
import com.sun.lwuit.animations.AnimationObject;
import com.sun.lwuit.animations.Timeline;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.Border;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Resources {
    static final byte MAGIC_THEME_LEGACY = -9;
    static final byte MAGIC_ANIMATION_LEGACY = -8;
    static final byte MAGIC_INDEXED_IMAGE_LEGACY = -12;
    static final byte MAGIC_FONT_LEGACY = -10;
    static final byte MAGIC_INDEXED_FONT_LEGACY = -5;
    static final byte MAGIC_IMAGE_LEGACY = -13;
    static final byte MAGIC_SVG = -11;
    static final byte MAGIC_TIMELINE = -17;
    static final byte MAGIC_FONT = -4;
    static final byte MAGIC_IMAGE = -3;
    static final byte MAGIC_L10N = -7;
    static final byte MAGIC_DATA = -6;
    static final byte MAGIC_UI = -18;
    static final byte MAGIC_HEADER = -1;
    static final byte MAGIC_PASSWORD = -2;
    private short majorVersion;
    private short minorVersion;
    private static byte[] key;
    static final byte MAGIC_THEME = -14;
    static final int BORDER_TYPE_EMPTY = 0;
    static final int BORDER_TYPE_LINE = 1;
    static final int BORDER_TYPE_ROUNDED = 2;
    static final int BORDER_TYPE_ETCHED_LOWERED = 4;
    static final int BORDER_TYPE_ETCHED_RAISED = 5;
    static final int BORDER_TYPE_BEVEL_RAISED = 6;
    static final int BORDER_TYPE_BEVEL_LOWERED = 7;
    static final int BORDER_TYPE_IMAGE = 8;
    static final int BORDER_TYPE_IMAGE_HORIZONTAL = 10;
    static final int BORDER_TYPE_IMAGE_VERTICAL = 11;
    private static Class classLoader;
    private String[] metaData;
    private static Object cachedResource;
    private static String lastLoadedName;
    private Hashtable resourceTypes = new Hashtable();
    private Hashtable resources = new Hashtable();
    private DataInputStream input;
    int keyOffset;
    static /* synthetic */ Class class$com$sun$lwuit$util$Resources;

    static void setClassLoader(Class clazz) {
        classLoader = clazz;
    }

    Resources() {
    }

    Resources(InputStream inputStream) throws IOException {
        this.openFile(inputStream);
    }

    void clear() {
        this.majorVersion = 0;
        this.minorVersion = 0;
        this.resourceTypes.clear();
        this.resources.clear();
        this.input = null;
    }

    void startingEntry(String string, byte by) {
    }

    void openFile(InputStream inputStream) throws IOException {
        this.clear();
        this.input = new DataInputStream(inputStream);
        int n = this.input.readShort();
        if (n < 0) {
            throw new IOException("Invalid resource file!");
        }
        boolean bl = false;
        this.keyOffset = 0;
        block16: for (int i = 0; i < n; ++i) {
            byte by = this.input.readByte();
            String string = this.input.readUTF();
            if (bl) {
                by = (byte)this.decode(by & 0xFF);
                char[] cArray = string.toCharArray();
                for (int j = 0; j < cArray.length; ++j) {
                    cArray[j] = (char)this.decode(cArray[j] & 0xFFFF);
                }
                string = new String(cArray);
            }
            this.startingEntry(string, by);
            switch (by) {
                case -2: {
                    this.checkKey(string);
                    bl = true;
                    continue block16;
                }
                case -1: {
                    this.readHeader();
                    continue block16;
                }
                case -14: {
                    this.setResource(string, (byte)-14, this.loadTheme(string, by == -14));
                    continue block16;
                }
                case -3: {
                    this.setResource(string, by, this.createImage());
                    continue block16;
                }
                case -4: {
                    this.setResource(string, by, this.loadFont(this.input, string, false));
                    continue block16;
                }
                case -6: {
                    this.setResource(string, by, this.createData());
                    continue block16;
                }
                case -18: {
                    this.setResource(string, by, this.createData());
                    continue block16;
                }
                case -7: {
                    this.setResource(string, by, this.loadL10N());
                    continue block16;
                }
                case -13: {
                    this.setResource(string, (byte)-3, this.createImage());
                    continue block16;
                }
                case -12: {
                    this.setResource(string, (byte)-3, this.createPackedImage8());
                    continue block16;
                }
                case -9: {
                    this.setResource(string, (byte)-14, this.loadTheme(string, by == -14));
                    continue block16;
                }
                case -10: {
                    this.setResource(string, (byte)-4, this.loadFont(this.input, string, false));
                    continue block16;
                }
                case -5: {
                    this.setResource(string, (byte)-4, this.loadFont(this.input, string, true));
                    continue block16;
                }
                case -8: {
                    this.setResource(string, (byte)-3, this.loadAnimation(this.input));
                    continue block16;
                }
                default: {
                    throw new IOException("Corrupt theme file unrecognized magic number: " + Integer.toHexString(by & 0xFF));
                }
            }
        }
    }

    public static void setPassword(String string) {
        try {
            if (string == null) {
                key = null;
                return;
            }
            key = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    void checkKey(String string) {
        if (key == null) {
            throw new IllegalStateException("This is an password protected resource");
        }
        char c = (char)this.decode(string.charAt(0));
        char c2 = (char)this.decode(string.charAt(1));
        if (c != 'l' || c2 != 'w') {
            throw new IllegalStateException("Incorrect password");
        }
    }

    private int decode(int n) {
        n = key[this.keyOffset] ^ n;
        ++this.keyOffset;
        if (this.keyOffset == key.length) {
            this.keyOffset = 0;
        }
        return n;
    }

    private void readHeader() throws IOException {
        short s = this.input.readShort();
        this.majorVersion = this.input.readShort();
        this.minorVersion = this.input.readShort();
        this.metaData = new String[this.input.readShort()];
        for (int i = 0; i < this.metaData.length; ++i) {
            this.metaData[i] = this.input.readUTF();
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String[] getMetaData() {
        return this.metaData;
    }

    public String[] getResourceNames() {
        String[] stringArray = new String[this.resourceTypes.size()];
        Enumeration enumeration = this.resourceTypes.keys();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public String[] getDataResourceNames() {
        return this.getResourceTypeNames((byte)-6);
    }

    public String[] getUIResourceNames() {
        return this.getResourceTypeNames((byte)-18);
    }

    void setResource(String string, byte by, Object object) {
        if (object == null) {
            this.resources.remove(string);
            this.resourceTypes.remove(string);
        } else {
            this.resources.put(string, object);
            this.resourceTypes.put(string, new Byte(by));
        }
    }

    public String[] getL10NResourceNames() {
        return this.getResourceTypeNames((byte)-7);
    }

    public String[] getFontResourceNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.resourceTypes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.isFont(string)) continue;
            vector.addElement(string);
        }
        return Resources.toStringArray(vector);
    }

    public String[] getThemeResourceNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.resourceTypes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.isTheme(string)) continue;
            vector.addElement(string);
        }
        return Resources.toStringArray(vector);
    }

    public String[] getImageResourceNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.resourceTypes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.isImage(string)) continue;
            vector.addElement(string);
        }
        return Resources.toStringArray(vector);
    }

    byte getResourceType(String string) {
        return (Byte)this.resourceTypes.get(string);
    }

    private String[] getResourceTypeNames(byte by) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.resourceTypes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if ((Byte)this.resourceTypes.get(string) != by) continue;
            vector.addElement(string);
        }
        return Resources.toStringArray(vector);
    }

    private static String[] toStringArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public boolean isL10N(String string) {
        byte by = (Byte)this.resourceTypes.get(string);
        return by == -7;
    }

    public boolean isTheme(String string) {
        byte by = (Byte)this.resourceTypes.get(string);
        return by == -9 || by == -14;
    }

    public boolean isFont(String string) {
        byte by = (Byte)this.resourceTypes.get(string);
        return by == -4 || by == -10 || by == -5;
    }

    public boolean isAnimation(String string) {
        byte by = (Byte)this.resourceTypes.get(string);
        return by == -8;
    }

    public boolean isData(String string) {
        byte by = (Byte)this.resourceTypes.get(string);
        return by == -6;
    }

    public boolean isUI(String string) {
        byte by = (Byte)this.resourceTypes.get(string);
        return by == -18;
    }

    public boolean isImage(String string) {
        byte by = (Byte)this.resourceTypes.get(string);
        return by == -13 || by == -8 || by == -12 || by == -3 || by == -17;
    }

    public static Resources open(String string) throws IOException {
        try {
            Object object;
            if (lastLoadedName != null && lastLoadedName.equals(string) && (object = (Resources)Display.getInstance().extractHardRef(cachedResource)) != null) {
                return object;
            }
            object = Display.getInstance().getResourceAsStream(classLoader, string);
            if (object == null) {
                throw new IOException(string + " not found");
            }
            Resources resources = new Resources((InputStream)object);
            ((InputStream)object).close();
            lastLoadedName = string;
            cachedResource = Display.getInstance().createSoftWeakRef(resources);
            return resources;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw new IOException(runtimeException.getMessage());
        }
    }

    StaticAnimation loadAnimation(DataInputStream dataInputStream) throws IOException {
        return StaticAnimation.createAnimation(dataInputStream);
    }

    public static Resources open(InputStream inputStream) throws IOException {
        return new Resources(inputStream);
    }

    public Image getImage(String string) {
        return (Image)this.resources.get(string);
    }

    public StaticAnimation getAnimation(String string) {
        return (StaticAnimation)this.resources.get(string);
    }

    public InputStream getData(String string) {
        return new ByteArrayInputStream((byte[])this.resources.get(string));
    }

    InputStream getUi(String string) {
        byte[] byArray = (byte[])this.resources.get(string);
        if (byArray == null) {
            throw new RuntimeException("UI Resource Not Found: " + string);
        }
        return new ByteArrayInputStream(byArray);
    }

    public Hashtable getL10N(String string, String string2) {
        return (Hashtable)((Hashtable)this.resources.get(string)).get(string2);
    }

    public Enumeration listL10NLocales(String string) {
        return ((Hashtable)this.resources.get(string)).keys();
    }

    public Font getFont(String string) {
        return (Font)this.resources.get(string);
    }

    public Hashtable getTheme(String string) {
        Hashtable hashtable = (Hashtable)this.resources.get(string);
        if (hashtable != null && hashtable.containsKey("uninitialized")) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string2 = (String)enumeration.nextElement();
                if (string2.endsWith("font") || string2.endsWith("Image") && !string2.endsWith("scaledImage")) {
                    object = hashtable.get(string2);
                    if (object == null) {
                        throw new IllegalArgumentException("Couldn't find resource: " + string2);
                    }
                    if (object instanceof String) {
                        Image image = string2.endsWith("Image") ? this.getImage((String)object) : this.resources.get(object);
                        if (image == null) {
                            throw new IllegalArgumentException("Theme entry for " + string2 + " could not be found: " + object);
                        }
                        hashtable.put(string2, image);
                    }
                }
                if (!string2.endsWith("order")) continue;
                object = this.confirmBorder(hashtable, string2);
                if (this.majorVersion == 0 && this.minorVersion == 0) {
                    ((Border)object).setPressedInstance(this.confirmBorder(hashtable, string2 + "Pressed"));
                    ((Border)object).setFocusedInstance(this.confirmBorder(hashtable, string2 + "Focused"));
                    hashtable.remove(string2 + "Pressed");
                    hashtable.remove(string2 + "Focused");
                }
                hashtable.put(string2, object);
            }
            hashtable.remove("uninitialized");
        }
        return hashtable;
    }

    private Border confirmBorder(Hashtable hashtable, String string) {
        Object v = hashtable.get(string);
        if (v == null) {
            return null;
        }
        if (!(v instanceof Border)) {
            String[] stringArray = (String[])v;
            if (stringArray == null) {
                throw new IllegalArgumentException("Couldn't find resource: " + string);
            }
            Border border = this.createImageBorder(stringArray);
            return border;
        }
        return (Border)v;
    }

    private Border createImageBorder(String[] stringArray) {
        if (stringArray[0].equals("h")) {
            return Border.createHorizonalImageBorder(this.getImage(stringArray[1]), this.getImage(stringArray[2]), this.getImage(stringArray[3]));
        }
        if (stringArray[0].equals("v")) {
            return Border.createVerticalImageBorder(this.getImage(stringArray[1]), this.getImage(stringArray[2]), this.getImage(stringArray[3]));
        }
        Image[] imageArray = new Image[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            imageArray[i] = this.getImage(stringArray[i]);
        }
        switch (imageArray.length) {
            case 2: {
                return Border.createImageBorder(imageArray[0], imageArray[1], null);
            }
            case 3: {
                return Border.createImageBorder(imageArray[0], imageArray[1], imageArray[2]);
            }
            case 8: {
                return Border.createImageBorder(imageArray[0], imageArray[1], imageArray[2], imageArray[3], imageArray[4], imageArray[5], imageArray[6], imageArray[7], null);
            }
        }
        return Border.createImageBorder(imageArray[0], imageArray[1], imageArray[2], imageArray[3], imageArray[4], imageArray[5], imageArray[6], imageArray[7], imageArray[8]);
    }

    Object getResourceObject(String string) {
        return this.resources.get(string);
    }

    Image createImage() throws IOException {
        if (this.majorVersion == 0 && this.minorVersion == 0) {
            byte[] byArray = new byte[this.input.readInt()];
            this.input.readFully(byArray, 0, byArray.length);
            return EncodedImage.create(byArray);
        }
        int n = this.input.readByte() & 0xFF;
        switch (n) {
            case 241: 
            case 242: {
                byte[] byArray = new byte[this.input.readInt()];
                this.input.readFully(byArray, 0, byArray.length);
                return EncodedImage.create(byArray);
            }
            case 243: {
                return this.createPackedImage8();
            }
            case 244: {
                return this.loadAnimation(this.input);
            }
            case 245: {
                int n2 = this.input.readInt();
                if (Image.isSVGSupported()) {
                    byte[] byArray = new byte[n2];
                    this.input.readFully(byArray);
                    String string = this.input.readUTF();
                    boolean bl = this.input.readBoolean();
                    this.loadSVGRatios(this.input);
                    byte[] byArray2 = new byte[this.input.readInt()];
                    if (byArray2.length > 0) {
                        this.input.readFully(byArray2, 0, byArray2.length);
                    }
                    return Image.createSVG(string, bl, byArray);
                }
                n2 = (int)((long)n2 - this.input.skip(n2));
                while (n2 > 0) {
                    n2 = (int)((long)n2 - this.input.skip(n2));
                }
                this.input.readUTF();
                this.input.readBoolean();
                this.input.readFloat();
                this.input.readFloat();
                byte[] byArray = new byte[this.input.readInt()];
                this.input.readFully(byArray, 0, byArray.length);
                return EncodedImage.create(byArray);
            }
            case 247: {
                int n3 = this.input.readInt();
                if (Image.isSVGSupported()) {
                    byte[] byArray = new byte[n3];
                    this.input.readFully(byArray);
                    String string = this.input.readUTF();
                    boolean bl = this.input.readBoolean();
                    this.readMultiImage(this.input, true);
                    return this.createSVG(bl, byArray);
                }
                n3 = (int)((long)n3 - this.input.skip(n3));
                while (n3 > 0) {
                    n3 = (int)((long)n3 - this.input.skip(n3));
                }
                String string = this.input.readUTF();
                this.input.readBoolean();
                return this.readMultiImage(this.input);
            }
            case 246: {
                return this.readMultiImage(this.input);
            }
            case 239: {
                int n4 = this.input.readInt();
                int n5 = this.input.readInt();
                int n6 = this.input.readInt();
                AnimationObject[] animationObjectArray = new AnimationObject[this.input.readShort()];
                for (int i = 0; i < animationObjectArray.length; ++i) {
                    String string = this.input.readUTF();
                    int n7 = this.input.readInt();
                    int n8 = this.input.readInt();
                    int n9 = this.input.readInt();
                    int n10 = this.input.readInt();
                    Image image = this.getImage(string);
                    animationObjectArray[i] = image == null ? AnimationObject.createAnimationImage(string, this, n9, n10) : AnimationObject.createAnimationImage(image, n9, n10);
                    animationObjectArray[i].setStartTime(n7);
                    animationObjectArray[i].setEndTime(n7 + n8);
                    int n11 = this.input.readInt();
                    if (n11 > -1) {
                        int n12 = this.input.readInt();
                        int n13 = this.input.readInt();
                        animationObjectArray[i].defineFrames(n12, n13, n11);
                    }
                    if (this.input.readBoolean()) {
                        animationObjectArray[i].defineMotionX(this.input.readInt(), n7, n8, n9, this.input.readInt());
                    }
                    if (this.input.readBoolean()) {
                        animationObjectArray[i].defineMotionY(this.input.readInt(), n7, n8, n10, this.input.readInt());
                    }
                    if (this.input.readBoolean()) {
                        animationObjectArray[i].defineWidth(this.input.readInt(), n7, n8, this.input.readInt(), this.input.readInt());
                    }
                    if (this.input.readBoolean()) {
                        animationObjectArray[i].defineHeight(this.input.readInt(), n7, n8, this.input.readInt(), this.input.readInt());
                    }
                    if (this.input.readBoolean()) {
                        animationObjectArray[i].defineOpacity(this.input.readInt(), n7, n8, this.input.readInt(), this.input.readInt());
                    }
                    if (!this.input.readBoolean()) continue;
                    animationObjectArray[i].defineOrientation(this.input.readInt(), n7, n8, this.input.readInt(), this.input.readInt());
                }
                Timeline timeline = Timeline.createTimeline(n4, animationObjectArray, new Dimension(n5, n6));
                return timeline;
            }
        }
        throw new IOException("Illegal type while creating image: " + Integer.toHexString(n));
    }

    Image createSVG(boolean bl, byte[] byArray) throws IOException {
        return Image.createSVG(null, bl, byArray);
    }

    private Image readMultiImage(DataInputStream dataInputStream) throws IOException {
        return this.readMultiImage(dataInputStream, false);
    }

    Image readMultiImage(DataInputStream dataInputStream, boolean bl) throws IOException {
        int n;
        int n2;
        EncodedImage encodedImage = null;
        int n3 = Display.getInstance().getDeviceDensity();
        int n4 = dataInputStream.readInt();
        int n5 = 0;
        int n6 = 0;
        int[] nArray = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            n = dataInputStream.readInt();
            nArray[n2] = dataInputStream.readInt();
            if (n6 == n3 || n3 < n || n < n6) continue;
            n6 = n;
            n5 = n2;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (!bl && n5 == n2) {
                byte[] byArray = new byte[n];
                dataInputStream.readFully(byArray, 0, n);
                encodedImage = EncodedImage.create(byArray);
                continue;
            }
            while (n > 0) {
                n = (int)((long)n - dataInputStream.skip(n));
            }
        }
        return encodedImage;
    }

    void loadSVGRatios(DataInputStream dataInputStream) throws IOException {
        dataInputStream.readFloat();
        dataInputStream.readFloat();
    }

    private byte[] createData() throws IOException {
        byte[] byArray = new byte[this.input.readInt()];
        this.input.readFully(byArray);
        return byArray;
    }

    Font loadFont(DataInputStream dataInputStream, String string, boolean bl) throws IOException {
        boolean bl2;
        int n;
        if (this.majorVersion == 0 && this.minorVersion == 0) {
            Image image = bl ? this.createPackedImage8() : this.createImage();
            int n2 = dataInputStream.readShort();
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = dataInputStream.readShort();
                nArray2[i] = dataInputStream.readByte();
            }
            String string2 = dataInputStream.readUTF();
            Font font = Font.getBitmapFont(string);
            if (font != null) {
                return font;
            }
            return Font.createBitmapFont(string, image, nArray, nArray2, string2);
        }
        int n3 = dataInputStream.readByte() & 0xFF;
        boolean bl3 = dataInputStream.readBoolean();
        Font font = null;
        if (bl3) {
            n = dataInputStream.readInt();
            if (Font.isTrueTypeFileSupported()) {
                font = Font.createTrueTypeFont(dataInputStream);
            } else {
                while (n > 0) {
                    n = (int)((long)n - dataInputStream.skip(n));
                }
            }
        }
        if ((n = (int)(dataInputStream.readBoolean() ? 1 : 0)) != 0) {
            String string3 = dataInputStream.readUTF();
            if (font == null && Font.isCreationByStringSupported()) {
                font = Font.create(string3);
            }
        }
        if (bl2 = dataInputStream.readBoolean()) {
            font = this.loadBitmapFont(dataInputStream, string, font);
        }
        if (font != null) {
            return font;
        }
        return Font.createSystemFont(n3 & 0x60, n3 & 7, n3 & 0x18);
    }

    void readRenderingHint(DataInputStream dataInputStream) throws IOException {
        dataInputStream.readByte();
    }

    Font loadBitmapFont(DataInputStream dataInputStream, String string, Font font) throws IOException {
        int n;
        Image image = this.createImage();
        int n2 = dataInputStream.readShort();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = dataInputStream.readShort();
        }
        for (n = 0; n < n2; ++n) {
            nArray2[n] = dataInputStream.readByte();
        }
        String string2 = dataInputStream.readUTF();
        this.readRenderingHint(dataInputStream);
        if (font == null && Font.isBitmapFontEnabled()) {
            Font font2 = Font.getBitmapFont(string);
            if (font2 != null) {
                return font2;
            }
            return Font.createBitmapFont(string, image, nArray, nArray2, string2);
        }
        return font;
    }

    Hashtable loadTheme(String string, boolean bl) throws IOException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("name", string);
        hashtable.put("uninitialized", Boolean.TRUE);
        int n = this.input.readShort();
        for (int i = 0; i < n; ++i) {
            byte by;
            String string2 = this.input.readUTF();
            if (string2.startsWith("@")) {
                hashtable.put(string2, this.input.readUTF());
                continue;
            }
            if (string2.endsWith("Color")) {
                hashtable.put(string2, Integer.toHexString(this.input.readInt()));
                continue;
            }
            if (string2.endsWith("align") || string2.endsWith("textDecoration")) {
                hashtable.put(string2, new Integer(this.input.readShort()));
                continue;
            }
            if (string2.endsWith("ransparency")) {
                hashtable.put(string2, "" + (this.input.readByte() & 0xFF));
                continue;
            }
            if (string2.endsWith("adding") || string2.endsWith("argin")) {
                int n2 = this.input.readByte() & 0xFF;
                int n3 = this.input.readByte() & 0xFF;
                int n4 = this.input.readByte() & 0xFF;
                by = this.input.readByte() & 0xFF;
                hashtable.put(string2, "" + n2 + "," + n3 + "," + n4 + "," + by);
                continue;
            }
            if (string2.endsWith("order")) {
                if (this.majorVersion == 0 && this.minorVersion == 0) {
                    hashtable.put(string2, this.createBorder(this.input, bl));
                    if (!bl) continue;
                    if (this.input.readBoolean()) {
                        hashtable.put(string2 + "Pressed", this.createBorder(this.input, true));
                    }
                    if (!this.input.readBoolean()) continue;
                    hashtable.put(string2 + "Focused", this.createBorder(this.input, true));
                    continue;
                }
                int n5 = this.input.readShort() & 0xFFFF;
                Object object = this.createBorder(this.input, n5);
                hashtable.put(string2, object);
                continue;
            }
            if (string2.endsWith("ont")) {
                Font font;
                if (this.input.readBoolean()) {
                    String string3 = this.input.readUTF();
                    font = (Font)this.resources.get(string3);
                    if (font == null) {
                        hashtable.put(string2, string3);
                        continue;
                    }
                } else {
                    font = Font.createSystemFont(this.input.readByte(), this.input.readByte(), this.input.readByte());
                }
                hashtable.put(string2, font);
                continue;
            }
            if (string2.endsWith("ackground")) {
                int n6 = this.input.readByte() & 0xFF;
                int n7 = string2.indexOf(46);
                string2 = n7 > -1 ? string2.substring(0, n7) : "";
                hashtable.put(string2 + "bgType", new Byte((byte)n6));
                switch (n6) {
                    case -12: 
                    case 241: {
                        hashtable.put(string2 + "bgImage", this.input.readUTF());
                        break;
                    }
                    case 242: 
                    case 243: 
                    case 245: {
                        String string4 = this.input.readUTF();
                        hashtable.put(string2 + "bgImage", string4);
                        by = this.input.readByte();
                        hashtable.put(string2 + "bgAlign", new Byte(by));
                        break;
                    }
                    case 246: 
                    case 247: {
                        Float f = new Float(0.5f);
                        hashtable.put(string2 + "bgGradient", new Object[]{new Integer(this.input.readInt()), new Integer(this.input.readInt()), f, f, new Float(1.0f)});
                        break;
                    }
                    case 248: {
                        int n8 = this.input.readInt();
                        int n9 = this.input.readInt();
                        float f = this.input.readFloat();
                        float f2 = this.input.readFloat();
                        float f3 = 1.0f;
                        if (this.minorVersion > 1) {
                            f3 = this.input.readFloat();
                        }
                        hashtable.put(string2 + "bgGradient", new Object[]{new Integer(n8), new Integer(n9), new Float(f), new Float(f2), new Float(f3)});
                    }
                }
                continue;
            }
            if (string2.endsWith("derive")) {
                hashtable.put(string2, this.input.readUTF());
                continue;
            }
            if (string2.endsWith("bgImage")) {
                String string5 = this.input.readUTF();
                Image image = this.getImage(string5);
                if (image == null) {
                    hashtable.put(string2, string5);
                    continue;
                }
                hashtable.put(string2, image);
                continue;
            }
            if (string2.endsWith("scaledImage")) {
                if (this.input.readBoolean()) {
                    hashtable.put(string2, "true");
                    continue;
                }
                hashtable.put(string2, "false");
                continue;
            }
            if (string2.endsWith("bgType") || string2.endsWith("bgAlign")) {
                hashtable.put(string2, new Byte(this.input.readByte()));
                continue;
            }
            if (string2.endsWith("bgGradient")) {
                if (this.minorVersion < 2) {
                    hashtable.put(string2, new Object[]{new Integer(this.input.readInt()), new Integer(this.input.readInt()), new Float(this.input.readFloat()), new Float(this.input.readFloat())});
                    continue;
                }
                hashtable.put(string2, new Object[]{new Integer(this.input.readInt()), new Integer(this.input.readInt()), new Float(this.input.readFloat()), new Float(this.input.readFloat()), new Float(this.input.readFloat())});
                continue;
            }
            throw new IOException("Error while trying to read theme property: " + string2);
        }
        return hashtable;
    }

    private Object createBorder(DataInputStream dataInputStream, int n) throws IOException {
        switch (n) {
            case 65281: {
                return Border.getEmpty();
            }
            case 65282: {
                if (dataInputStream.readBoolean()) {
                    return Border.createLineBorder(dataInputStream.readByte());
                }
                return Border.createLineBorder((int)dataInputStream.readByte(), dataInputStream.readInt());
            }
            case 65283: {
                if (dataInputStream.readBoolean()) {
                    return Border.createRoundBorder(dataInputStream.readByte(), dataInputStream.readByte());
                }
                return Border.createRoundBorder((int)dataInputStream.readByte(), (int)dataInputStream.readByte(), dataInputStream.readInt());
            }
            case 65284: {
                if (dataInputStream.readBoolean()) {
                    return Border.createEtchedLowered();
                }
                return Border.createEtchedLowered(dataInputStream.readInt(), dataInputStream.readInt());
            }
            case 65285: {
                if (dataInputStream.readBoolean()) {
                    return Border.createEtchedRaised();
                }
                return Border.createEtchedRaised(dataInputStream.readInt(), dataInputStream.readInt());
            }
            case 65287: {
                if (dataInputStream.readBoolean()) {
                    return Border.createBevelRaised();
                }
                return Border.createBevelRaised(dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt());
            }
            case 65286: {
                if (dataInputStream.readBoolean()) {
                    return Border.createBevelLowered();
                }
                return Border.createBevelLowered(dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt());
            }
            case 65288: {
                String[] stringArray = this.readImageBorder(dataInputStream);
                return stringArray;
            }
            case 65289: {
                return this.readImageBorder(dataInputStream, "h");
            }
            case 65296: {
                return this.readImageBorder(dataInputStream, "v");
            }
        }
        return null;
    }

    private Object createBorder(DataInputStream dataInputStream, boolean bl) throws IOException {
        byte by = dataInputStream.readByte();
        switch (by) {
            case 0: {
                return Border.getEmpty();
            }
            case 1: {
                if (dataInputStream.readBoolean()) {
                    return Border.createLineBorder(dataInputStream.readByte());
                }
                return Border.createLineBorder((int)dataInputStream.readByte(), dataInputStream.readInt());
            }
            case 2: {
                if (dataInputStream.readBoolean()) {
                    return Border.createRoundBorder(dataInputStream.readByte(), dataInputStream.readByte());
                }
                return Border.createRoundBorder((int)dataInputStream.readByte(), (int)dataInputStream.readByte(), dataInputStream.readInt());
            }
            case 4: {
                if (dataInputStream.readBoolean()) {
                    return Border.createEtchedLowered();
                }
                return Border.createEtchedLowered(dataInputStream.readInt(), dataInputStream.readInt());
            }
            case 5: {
                if (dataInputStream.readBoolean()) {
                    return Border.createEtchedRaised();
                }
                return Border.createEtchedRaised(dataInputStream.readInt(), dataInputStream.readInt());
            }
            case 6: {
                if (dataInputStream.readBoolean()) {
                    return Border.createBevelRaised();
                }
                return Border.createBevelRaised(dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt());
            }
            case 7: {
                if (dataInputStream.readBoolean()) {
                    return Border.createBevelLowered();
                }
                return Border.createBevelLowered(dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt());
            }
            case 8: {
                String[] stringArray = this.readImageBorder(dataInputStream);
                if (!bl) {
                    dataInputStream.readBoolean();
                }
                return stringArray;
            }
        }
        return null;
    }

    private String[] readImageBorder(DataInputStream dataInputStream, String string) throws IOException {
        String[] stringArray = new String[4];
        stringArray[0] = string;
        for (int i = 1; i < 4; ++i) {
            stringArray[i] = dataInputStream.readUTF();
        }
        return stringArray;
    }

    private String[] readImageBorder(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readByte();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = dataInputStream.readUTF();
        }
        return stringArray;
    }

    private Hashtable loadL10N() throws IOException {
        Object object;
        int n;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n2 = this.input.readShort();
        short s = this.input.readShort();
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            object = this.input.readUTF();
            stringArray[n] = object;
        }
        for (n = 0; n < s; ++n) {
            object = new Hashtable();
            String string = this.input.readUTF();
            hashtable.put(string, object);
            for (int i = 0; i < n2; ++i) {
                ((Hashtable)object).put(stringArray[i], this.input.readUTF());
            }
        }
        return hashtable;
    }

    private Image createPackedImage8() throws IOException {
        int n;
        int n2 = this.input.readByte() & 0xFF;
        if (n2 == 0) {
            n2 = 256;
        }
        int[] nArray = new int[n2];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = this.input.readInt();
        }
        n = this.input.readShort();
        short s = this.input.readShort();
        byte[] byArray = new byte[n * s];
        this.input.readFully(byArray, 0, byArray.length);
        return Image.createIndexed(n, s, nArray, byArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        classLoader = class$com$sun$lwuit$util$Resources == null ? (class$com$sun$lwuit$util$Resources = Resources.class$("com.sun.lwuit.util.Resources")) : class$com$sun$lwuit$util$Resources;
    }
}

