/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

class CanvasCounter
extends Canvas
implements CommandListener {
    private final Command START_CMD = new Command("Start", 7, 0);
    private final Command STOP_CMD = new Command("Stop", 7, 0);
    private final Command EXIT_CMD = new Command("Exit", 1, 2);
    private Pomodoro midlet;
    private Image image;
    private Image layout;
    private Image pointer;
    private static final int INTERVAL = 60000;
    private Timer tm;
    private PomodoroTimer tt;
    private Player player;

    public CanvasCounter(Pomodoro pomodoro) {
        this.midlet = pomodoro;
        try {
            this.image = Image.createImage((String)"/background.png");
            this.layout = Image.createImage((String)"/layout.png");
            this.pointer = Image.createImage((String)"/pointer.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] stringArray = Manager.getSupportedContentTypes(null);
        String string = "/ring.mp3";
        String string2 = "audio/mpeg";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != "audio/x-wav") continue;
            string = "/ring.wav";
            string2 = stringArray[i];
        }
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(string);
            this.player = Manager.createPlayer((InputStream)inputStream, (String)string2);
            this.player.realize();
        }
        catch (Exception exception) {
            pomodoro.showException(exception);
            return;
        }
        this.addCommand(this.START_CMD);
        this.addCommand(this.EXIT_CMD);
        this.setCommandListener(this);
    }

    protected void paint(Graphics graphics) {
        this.drawPomodoro(graphics);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.EXIT_CMD) {
            this.setCommandListener(null);
            this.midlet.exitMIDlet();
        } else if (command == this.START_CMD) {
            this.startTimer();
            this.repaint();
        } else if (command == this.STOP_CMD) {
            this.stopTimer();
            this.repaint();
        }
    }

    private void startTimer() {
        this.tm = new Timer();
        this.tt = new PomodoroTimer();
        this.tm.schedule((TimerTask)this.tt, 60000L, 60000L);
        this.removeCommand(this.START_CMD);
        this.addCommand(this.STOP_CMD);
        this.setCommandListener(this);
    }

    private void stopTimer() {
        this.tm.cancel();
        this.midlet.resetCounter();
        this.removeCommand(this.STOP_CMD);
        this.addCommand(this.START_CMD);
        this.setCommandListener(this);
        this.repaint();
    }

    private void drawPomodoro(Graphics graphics) {
        graphics.setColor(255, 0, 0);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.drawImage(this.layout, this.getWidth() / 2 - this.pointer.getWidth() / 2 - this.midlet.getCounter(), this.getHeight() / 2 + this.layout.getHeight() / 2, 36);
        graphics.drawImage(this.pointer, this.getWidth() / 2 - this.pointer.getWidth() / 2, this.getHeight() / 2 + this.layout.getHeight() / 2, 20);
        graphics.drawImage(this.image, 0, 0, 20);
    }

    private class PomodoroTimer
    extends TimerTask {
        private PomodoroTimer() {
        }

        public final void run() {
            CanvasCounter.this.midlet.subCounter();
            CanvasCounter.this.repaint();
            if (CanvasCounter.this.midlet.getCounter() == 0) {
                try {
                    CanvasCounter.this.player.start();
                }
                catch (Exception exception) {
                    CanvasCounter.this.midlet.showException(exception);
                    return;
                }
                CanvasCounter.this.midlet.vibrate();
                CanvasCounter.this.stopTimer();
            }
        }
    }
}

