/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public final class NokiaSound {
    Sound[] sndPlayer;
    Player[] wavPlayer;
    Player midPlayer;
    boolean bMute = false;
    boolean bSupportMid = true;
    boolean bSupportXWav = true;
    boolean bSupportOtt = true;
    int curSndIdx = 0;
    int curPriority = 100;
    public static final byte[][] TSndData = new byte[][]{{2, 74, 58, 64, 4, 0, 11, 28, -126, 116, 73, -70, 0, 0}, {2, 74, 58, 64, 4, 0, 27, 28, -126, -12, 81, 90, -96, -68, 20, 86, -120, 47, 69, 21, -96, 0}, {2, 74, 58, 64, 4, 0, 23, 28, -93, 20, 65, -86, 40, -44, 16, 82, -119, 57, 0, 0}, {2, 74, 58, 64, 4, 0, 15, 28, -77, 84, 65, -86, 44, -51, 0, 0}, {2, 74, 58, 64, 4, 0, 83, 26, -125, 80, 33, 3, -112, 33, 4, -111, -127, 8, 19, -127, 8, 17, -127, 8, 32, -28, 8, 65, 36, 96, 66, 8, 57, 2, 16, 53, 2, 16, 57, 2, 16, 73, 24, 16, -127, 56, 16, -127, 24, 16, -126, 14, 64, -124, 18, 70, 4, 32, -125, -112, 0}};
    public static final int[] TWavFileSize = new int[]{4364, 4188, 3108, 4604, 5148, 5004, 3146};
    public static final String[] TLoudPhone = new String[]{"3650", "6630"};
    public static final String[] TNoWavePhone = new String[]{"7650"};
    public static int CLICK = 0;
    public static int EVENT = 1;
    public static int ATTACK = 2;
    public static int ATTACK_SUCCESS = 3;
    public static int LEVELUP = 4;
    public static int STONE = 5;
    public static int EQUIP = 6;
    public static int INTRO = 7;

    public NokiaSound() {
        this.initSound();
    }

    public void initSound() {
        InputStream inputStream;
        int n;
        boolean bl = false;
        this.curSndIdx = 1;
        this.curPriority = 100;
        try {
            String string = System.getProperty("microedition.platform");
            if (string != null) {
                for (n = 0; n < TLoudPhone.length; ++n) {
                    if (string.indexOf(TLoudPhone[n]) == -1) continue;
                    bl = true;
                }
                for (n = 0; n < TNoWavePhone.length; ++n) {
                    if (string.indexOf(TNoWavePhone[n]) == -1) continue;
                    this.bSupportXWav = false;
                    this.bSupportMid = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bSupportXWav = false;
        if (this.bSupportMid) {
            try {
                inputStream = this.getClass().getResourceAsStream("/intro.snd");
                this.midPlayer = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
                if (this.midPlayer == null) {
                    this.bSupportMid = false;
                } else {
                    this.midPlayer.setLoopCount(1);
                }
            }
            catch (Exception exception) {
                this.midPlayer = null;
                this.bSupportMid = false;
            }
        }
        if (this.bSupportXWav) {
            try {
                this.wavPlayer = new Player[8];
                for (n = 0; n < 7; ++n) {
                    inputStream = this.getClass().getResourceAsStream("/sound" + n + ".snd");
                    this.wavPlayer[n] = Manager.createPlayer((InputStream)inputStream, (String)"audio/x-wav");
                    if (this.wavPlayer[n] == null) {
                        this.bSupportXWav = false;
                        break;
                    }
                    this.wavPlayer[n].setLoopCount(1);
                }
                if (!this.bSupportMid) {
                    this.sndPlayer = new Sound[8];
                    this.sndPlayer[7] = new Sound(TSndData[4], 1);
                    if (this.sndPlayer[7] != null) {
                        if (bl) {
                            this.sndPlayer[7].setGain(120);
                        } else {
                            this.sndPlayer[7].setGain(200);
                        }
                    }
                    return;
                }
                return;
            }
            catch (Exception exception) {
                this.bSupportXWav = false;
            }
        }
        if (this.bSupportOtt) {
            INTRO = 4;
            CLICK = 0;
            EVENT = 1;
            ATTACK = 0;
            ATTACK_SUCCESS = 0;
            LEVELUP = 2;
            STONE = 3;
            EQUIP = 3;
            try {
                this.sndPlayer = new Sound[5];
                for (n = 0; n < 5; ++n) {
                    this.sndPlayer[n] = new Sound(TSndData[n], 1);
                    if (this.sndPlayer[n] == null) continue;
                    if (bl) {
                        this.sndPlayer[n].setGain(120);
                        continue;
                    }
                    this.sndPlayer[n].setGain(200);
                }
                this.bSupportXWav = false;
            }
            catch (Exception exception) {
                this.bSupportOtt = false;
            }
        }
    }

    public void playSound(int n, int n2) {
        if (this.bMute) {
            return;
        }
        try {
            if (n == INTRO) {
                if (this.bSupportMid) {
                    if (this.midPlayer != null) {
                        this.midPlayer.start();
                    }
                } else if (this.bSupportOtt && this.sndPlayer[INTRO] != null) {
                    this.sndPlayer[INTRO].play(1);
                }
            } else {
                if (this.bSupportXWav) {
                    if (this.wavPlayer[n] != null) {
                        if (this.wavPlayer[this.curSndIdx].getState() == 400) {
                            if (this.curPriority < n2) {
                                return;
                            }
                            if (this.curSndIdx != n) {
                                this.wavPlayer[this.curSndIdx].stop();
                            }
                        }
                        if (this.wavPlayer[n].getState() != 400) {
                            this.wavPlayer[n].start();
                        }
                    }
                } else if (this.sndPlayer[n] != null) {
                    this.sndPlayer[n].play(1);
                }
                this.curSndIdx = n;
                this.curPriority = n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopSound(int n) {
        this.curPriority = 100;
        try {
            if (n == INTRO) {
                if (this.bSupportMid) {
                    if (this.midPlayer != null) {
                        this.midPlayer.stop();
                        this.midPlayer.close();
                        this.midPlayer = null;
                    }
                } else if (this.bSupportOtt && this.sndPlayer[INTRO] != null) {
                    this.sndPlayer[INTRO].stop();
                }
            } else if (this.bSupportXWav) {
                if (this.wavPlayer[n] != null) {
                    this.wavPlayer[n].stop();
                }
            } else if (this.sndPlayer[n] != null) {
                this.sndPlayer[n].stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMute(boolean bl) {
        this.bMute = bl;
    }
}

