/*
 * Decompiled with CFR 0.152.
 */
package com.sensiblemobiles.AdventureWithTed;

import com.sensiblemobiles.AdventureWithTed.AdventureWithTed;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;

public class CommanFunctions {
    public static int getStringWidth(String paramString) {
        Font localFont = Font.getDefaultFont();
        int i = localFont.stringWidth(paramString);
        return i;
    }

    public static int getPercentage(int total, int per) {
        int value = total * per / 100;
        return value;
    }

    public static Image scale(Image original, int newWidth, int newHeight) {
        int[] rawInput = new int[original.getHeight() * original.getWidth()];
        original.getRGB(rawInput, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int oWidth = original.getWidth();
        int[] oX16 = new int[newWidth + 1];
        for (int newX = 0; newX <= newWidth; ++newX) {
            oX16[newX] = (newX * oWidth << 4) / newWidth;
        }
        int[] oXStartWidth = new int[newWidth];
        int[] oXEndWidth = new int[newWidth];
        for (int newX = 0; newX < newWidth; ++newX) {
            oXStartWidth[newX] = 16 - oX16[newX] % 16;
            oXEndWidth[newX] = oX16[newX + 1] % 16;
        }
        int oHeight = original.getHeight();
        int[] oY16 = new int[newHeight + 1];
        for (int newY = 0; newY <= newHeight; ++newY) {
            oY16[newY] = (newY * oHeight << 4) / newHeight;
        }
        for (int newY = 0; newY < newHeight; ++newY) {
            int oY16Start = oY16[newY];
            int oY16End = oY16[newY + 1];
            int oYStart = oY16Start >>> 4;
            int oYEnd = oY16End >>> 4;
            int oYStartHeight = 16 - oY16Start % 16;
            int oYEndHeight = oY16End % 16;
            for (int newX = 0; newX < newWidth; ++newX) {
                int oX16Start = oX16[newX];
                int oX16End = oX16[newX + 1];
                int oXStart = oX16Start >>> 4;
                int oXEnd = oX16End >>> 4;
                int outArea = 0;
                int outColorArea = 0;
                int outAlpha = 0;
                int outRed = 0;
                int outGreen = 0;
                int outBlue = 0;
                for (int j = oYStart; j <= oYEnd; ++j) {
                    int areaHeight = 16;
                    if (oYStart == oYEnd) {
                        areaHeight = oY16End - oY16Start;
                    } else if (j == oYStart) {
                        areaHeight = oYStartHeight;
                    } else if (j == oYEnd) {
                        areaHeight = oYEndHeight;
                    }
                    if (areaHeight == 0) continue;
                    for (int i = oXStart; i <= oXEnd; ++i) {
                        int areaWidth = 16;
                        if (oXStart == oXEnd) {
                            areaWidth = oX16End - oX16Start;
                        } else if (i == oXStart) {
                            areaWidth = oXStartWidth[newX];
                        } else if (i == oXEnd) {
                            areaWidth = oXEndWidth[newX];
                        }
                        if (areaWidth == 0) continue;
                        int area = areaWidth * areaHeight;
                        outArea += area;
                        int argb = rawInput[i + j * original.getWidth()];
                        int a = argb >>> 24;
                        if (a == 0) continue;
                        area = a * area;
                        outColorArea += area;
                        int r = (argb & 0xFF0000) >>> 16;
                        int g = (argb & 0xFF00) >>> 8;
                        int b = argb & 0xFF;
                        outRed += area * r;
                        outGreen += area * g;
                        outBlue += area * b;
                    }
                }
                if (outColorArea > 0) {
                    outAlpha = outColorArea / outArea;
                    outRed /= outColorArea;
                    outGreen /= outColorArea;
                    outBlue /= outColorArea;
                }
                rawOutput[newX + newY * newWidth] = outAlpha << 24 | outRed << 16 | outGreen << 8 | outBlue;
            }
        }
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)true);
    }

    public static String[] getTextRows(String text, Font font, int width) {
        char spaceChar = ' ';
        String ispaceChar = "";
        String temp = "#";
        width -= 5;
        Vector<String> rowsVector = new Vector<String>();
        StringBuffer currentRowText = new StringBuffer();
        int prevIndex = 0;
        int currIndex = text.indexOf(spaceChar);
        if (currIndex == -1) {
            currIndex = text.length();
        }
        int rowWidth = 0;
        int tokenWidth = 0;
        int whitespaceWidth = font.stringWidth(" ");
        String currentToken = null;
        while (currIndex != -1) {
            currentToken = text.substring(prevIndex, currIndex);
            if (currIndex < text.length() - 3) {
                ispaceChar = text.substring(currIndex + 1, currIndex + 2);
            }
            ispaceChar.trim();
            tokenWidth = font.stringWidth(currentToken);
            rowWidth += tokenWidth;
            if (currentRowText.length() > 0) {
                rowWidth += whitespaceWidth;
            }
            if (currentRowText.length() > 0 && rowWidth > width || temp.equalsIgnoreCase(ispaceChar)) {
                if (temp.equalsIgnoreCase(ispaceChar)) {
                    currentRowText.append(currentToken);
                }
                rowsVector.addElement(currentRowText.toString());
                currentRowText.setLength(0);
                if (!temp.equalsIgnoreCase(ispaceChar)) {
                    currentRowText.append(currentToken);
                }
                rowWidth = tokenWidth;
            } else {
                if (currentRowText.length() > 0) {
                    currentRowText.append(spaceChar);
                }
                currentRowText.append(currentToken);
            }
            if (currIndex == text.length()) break;
            prevIndex = temp.equalsIgnoreCase(ispaceChar) ? currIndex + 2 : currIndex + 1;
            currIndex = text.indexOf(spaceChar, prevIndex);
            if (currIndex != -1) continue;
            currIndex = text.length();
        }
        if (currentRowText.length() > 0) {
            rowsVector.addElement(currentRowText.toString());
        }
        Object[] rowsArray = new String[rowsVector.size()];
        rowsVector.copyInto(rowsArray);
        return rowsArray;
    }

    public static void showAlert(String message) {
        Alert alert = new Alert("Info");
        alert.setString(message);
        AdventureWithTed.display.setCurrent((Displayable)alert);
    }

    public static int randam(int st, int end) {
        int Start = st;
        int Range = end;
        Random random = new Random();
        int no = Math.abs(random.nextInt());
        int Sno = Start + no % (Range - Start);
        return Sno;
    }

    public static Image rotateImage(Image src, float angle) {
        int sw = src.getWidth();
        int sh = src.getHeight();
        int[] srcData = new int[sw * sh];
        src.getRGB(srcData, 0, sw, 0, 0, sw, sh);
        int[] dstData = new int[sw * sh];
        double rads = (double)angle * Math.PI / 180.0;
        float sa = (float)Math.sin(rads);
        float ca = (float)Math.cos(rads);
        int isa = (int)(256.0f * sa);
        int ica = (int)(256.0f * ca);
        int my = -(sh >> 1);
        for (int i = 0; i < sh; ++i) {
            int mx = -(sw >> 1);
            for (int j = 0; j < sw; ++j) {
                int srcx = mx * ica + my * isa >> 8;
                int srcy = -mx * isa + my * ica >> 8;
                srcy += sh >> 1;
                if ((srcx += sw >> 1) < 0) {
                    srcx = 0;
                }
                if (srcy < 0) {
                    srcy = 0;
                }
                if (srcx > sw - 1) {
                    srcx = sw - 1;
                }
                if (srcy > sh - 1) {
                    srcy = sh - 1;
                }
                dstData[j + i * sw] = srcData[srcx + srcy * sw];
                ++mx;
            }
            ++my;
        }
        return Image.createRGBImage((int[])dstData, (int)sw, (int)sh, (boolean)true);
    }
}

