/*
 * Decompiled with CFR 0.152.
 */
package com.sensiblemobiles.AdventureWithTed;

import com.sensiblemobiles.AdventureWithTed.AdventureWithTed;
import com.sensiblemobiles.AdventureWithTed.CommanFunctions;
import com.sensiblemobiles.AdventureWithTed.Configuration;
import com.sensiblemobiles.AdventureWithTed.LevelManager;
import com.sensiblemobiles.AdventureWithTed.MainCanvas;
import com.sensiblemobiles.game.MainGameCanvas;
import com.sensiblemobiles.matrix.Matrix;
import java.io.IOException;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LevelSelection {
    int screenWidth;
    int screenHeight;
    Image background;
    Image UnlockLevel;
    Image LockedLevel;
    int unlocked = 1;
    Font font;
    int Xcord;
    int Ycord;
    int selectIndex = 0;
    private int MaxLevel;
    public static String levelun = "levelun";
    int topAdHeight;
    String val;
    int prvy = 0;
    int Sycord;
    String[] Level = new String[]{"/res/level/newlevel1.txt", "/res/level/newlevel2.txt", "/res/level/newlevel3.txt", "/res/level/newlevel4.txt", "/res/level/newlevel5.txt", "/res/level/newlevel6.txt", "/res/level/newlevel7.txt", "/res/level/newlevel8.txt", "/res/level/newlevel9.txt", "/res/level/newlevel0.txt", "/res/level/newlevel11.txt", "/res/level/newlevel12.txt", "/res/level/newlevel13.txt", "/res/level/newlevel14.txt", "/res/level/newlevel15.txt"};
    public int levelNo = 0;
    int[][] arr;
    private LevelManager levelManager;
    int maxRows;
    int maxCols;
    Matrix matrix;
    int buttonSize;
    int noOfButtons = 2;

    public LevelSelection(int width, int height, int maxRows, int maxCols, int maxLevel) {
        this.screenWidth = width;
        this.screenHeight = height;
        this.maxRows = maxRows;
        this.maxCols = maxCols;
        this.MaxLevel = maxLevel;
        this.topAdHeight = MainGameCanvas.mainGameCanvas.advertisements.getTopAddHeight();
        this.unlocked = this.getUnlockedLevel();
        this.font = Font.getFont((int)32, (int)1, (int)8);
        try {
            this.background = Image.createImage((String)"/res/game/background1.png");
            this.background = CommanFunctions.scale(this.background, this.screenWidth, this.screenHeight);
            this.UnlockLevel = Image.createImage((String)"/res/levelSelection/UnlockLevel.png");
            this.UnlockLevel = CommanFunctions.scale(this.UnlockLevel, this.screenWidth * 20 / 100, this.screenWidth * 20 / 100);
            this.LockedLevel = Image.createImage((String)"/res/levelSelection/LockedLevel.png");
            this.LockedLevel = CommanFunctions.scale(this.LockedLevel, this.screenWidth * 20 / 100, this.screenWidth * 20 / 100);
            if (width > height) {
                this.buttonSize = (height - height / 3) / 3;
                this.UnlockLevel = CommanFunctions.scale(this.UnlockLevel, this.buttonSize, this.buttonSize);
                this.LockedLevel = CommanFunctions.scale(this.LockedLevel, this.buttonSize, this.buttonSize);
                this.noOfButtons = width / this.buttonSize / 2;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.matrix = new Matrix(maxCols, maxRows, this.screenWidth, this.screenHeight);
        this.Xcord = width > height ? width / 3 / 3 : this.screenWidth * 20 / 100;
        this.Ycord = this.topAdHeight + 10;
        this.levelManager = new LevelManager();
    }

    public void setUnlockedLevel(int level) {
        Configuration.Set(levelun, "" + level);
    }

    public int getUnlockedLevel() {
        int unl_lev = 1;
        String temp = Configuration.Get(levelun);
        unl_lev = temp.length() > 0 ? Integer.parseInt(temp) : 1;
        return unl_lev;
    }

    public void paint(Graphics g) {
        this.unlocked = this.getUnlockedLevel();
        g.drawImage(this.background, this.screenWidth / 2, this.screenHeight / 2, 3);
        int Tycord = this.Ycord;
        int Txcord = this.Xcord;
        for (int i = 0; i < this.MaxLevel; ++i) {
            if (this.selectIndex == i) {
                g.setColor(65331);
                if (this.screenWidth > this.screenHeight) {
                    g.fillRect(Txcord, Tycord, this.buttonSize, this.buttonSize);
                } else {
                    g.fillRect(Txcord, Tycord, this.screenWidth * 20 / 100, this.screenWidth * 20 / 100);
                }
                this.Sycord = Tycord;
            }
            int levelNumber = i + 1;
            if (i < this.unlocked) {
                g.drawImage(this.UnlockLevel, Txcord, Tycord, 0);
                g.setColor(0xFFFFFF);
                g.drawString("" + levelNumber, Txcord + this.UnlockLevel.getWidth() / 2, Tycord + this.UnlockLevel.getHeight() / 2 - this.font.getHeight() / 2, 17);
            } else {
                g.drawImage(this.LockedLevel, Txcord, Tycord, 0);
            }
            Txcord += this.Xcord + this.Xcord;
            if (this.screenWidth > this.screenHeight) {
                if ((i + 1) % 4 != 0) continue;
                Txcord = this.Xcord;
                if (this.screenHeight == 360) {
                    Tycord += this.UnlockLevel.getHeight();
                    continue;
                }
                Tycord += this.Xcord + this.Xcord / 2;
                continue;
            }
            if ((i + 1) % 2 != 0) continue;
            Txcord = this.Xcord;
            Tycord += this.Xcord + this.Xcord / 2;
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -3) {
            if (this.screenWidth > this.screenHeight) {
                this.selectIndex = this.selectIndex < 1 ? this.MaxLevel - 1 : --this.selectIndex;
            } else if (this.selectIndex <= 1) {
                this.selectIndex = this.MaxLevel - 1;
                this.Ycord = this.screenHeight - (this.UnlockLevel.getHeight() + this.Xcord / 2) * this.MaxLevel / 2;
            } else {
                --this.selectIndex;
                if (this.Sycord <= this.UnlockLevel.getHeight() + this.Xcord / 2) {
                    this.Ycord += this.Xcord + this.Xcord / 2;
                }
            }
        } else if (keyCode == -4) {
            if (this.screenWidth > this.screenHeight) {
                this.selectIndex = this.selectIndex > this.MaxLevel - 1 ? 0 : ++this.selectIndex;
            } else if (this.selectIndex >= this.MaxLevel - 1) {
                this.selectIndex = 0;
                this.Ycord = this.topAdHeight + this.screenWidth * 10 / 100;
            } else {
                ++this.selectIndex;
                if (this.Sycord >= this.screenHeight - (this.UnlockLevel.getHeight() + this.Xcord / 2) * 2) {
                    this.Ycord -= this.Xcord + this.Xcord / 2;
                }
            }
        } else if (keyCode == -1) {
            if (this.screenWidth <= this.screenHeight) {
                if (this.selectIndex <= 1) {
                    this.selectIndex = this.MaxLevel - 2;
                    this.Ycord = this.screenHeight - (this.UnlockLevel.getHeight() + this.Xcord / 2) * this.MaxLevel / 2;
                } else {
                    this.selectIndex -= 2;
                    if (this.Sycord <= this.UnlockLevel.getHeight() + this.Xcord / 2) {
                        this.Ycord += this.Xcord + this.Xcord / 2;
                    }
                }
            }
        } else if (keyCode == -2) {
            if (this.screenWidth <= this.screenHeight) {
                if (this.selectIndex >= this.MaxLevel - 2) {
                    this.selectIndex = 0;
                    this.Ycord = this.topAdHeight + this.screenWidth * 10 / 100;
                } else {
                    this.selectIndex += 2;
                    if (this.Sycord >= this.screenHeight - (this.UnlockLevel.getHeight() + this.Xcord / 2) * 2) {
                        this.Ycord -= this.Xcord + this.Xcord / 2;
                    }
                }
            }
        } else if (keyCode == -5) {
            if (this.selectIndex == 13 || this.selectIndex == 0) {
                // empty if block
            }
            for (int i = 0; i < this.unlocked; ++i) {
                if (this.selectIndex != i) continue;
                MainGameCanvas.screen = 1;
                MainGameCanvas.mainGameCanvas.level = this.selectIndex + 1;
                this.arr = this.levelManager.loadLevel(this.Level[this.selectIndex], this.maxCols, this.maxRows);
                MainGameCanvas.mainGameCanvas.setLevelValues(this.arr);
                System.out.println("i am in level selection set level");
            }
        } else if (keyCode == -7) {
            MainCanvas.screen = MainCanvas.mainCanvas.MenuScreen;
            AdventureWithTed.display.setCurrent((Displayable)MainCanvas.mainCanvas);
        }
    }

    public void pointerPressed(int x, int y) {
        int Tycord = this.Ycord;
        int Txcord = this.Xcord;
        for (int i = 0; i < this.unlocked; ++i) {
            if (y > Tycord && y < Tycord + this.UnlockLevel.getHeight() && x > Txcord && x < Txcord + this.UnlockLevel.getWidth()) {
                this.selectIndex = i;
                this.keyPressed(-5);
            }
            Txcord += this.Xcord * 2;
            if ((i + 1) % 4 != 0) continue;
            Txcord = this.Xcord;
            if (this.screenHeight == 360) {
                Tycord += this.LockedLevel.getHeight();
                continue;
            }
            Tycord += this.Xcord + this.Xcord / 2;
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void SetMaxLevel(int maxLevel) {
        this.MaxLevel = maxLevel;
    }

    public int getSelectIndex() {
        return this.selectIndex;
    }
}

