/*
 * Decompiled with CFR 0.152.
 */
package com.sensiblemobiles.matrix;

import com.sensiblemobiles.AdventureWithTed.CommanFunctions;
import com.sensiblemobiles.matrix.Cell;
import com.sensiblemobiles.matrix.MatrixListner;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.TiledLayer;

public class Matrix {
    private TiledLayer gameLayer;
    private Image tiledImg;
    private int topAddH;
    private int bottamAddH;
    private int screenW;
    private int screenH;
    private int cellW;
    private int cellH;
    private int numberOfCell = 15;
    private int stepToCross = 3;
    private int tiletXcord;
    private int tiletYcord;
    private int initialTiletXcord;
    private int initialTiletYcord;
    private int maxRow = 200;
    private int maxCol = 10;
    private int maxXLength = 0;
    private int maxYLength = 0;
    private int scrollingType = 0;
    public static int scrollRTL = 1;
    public static int scrollBTT = 2;
    public static int scrollTTB = 3;
    public static int pressOnCell = 10;
    public static int matrixEnd = 22;
    public static int updatePlayerOnMatrixCallBack = 11;
    private int numOfFrameInTiledImage = 0;
    private int movingCounter = 0;
    MatrixListner matrixListner;
    public boolean isAutoMove = false;
    private boolean isResetCordintate = false;

    public Matrix(int mxcol, int mxRow, int width, int height) {
        this.screenH = width;
        this.screenW = height;
        this.maxCol = mxcol;
        this.maxRow = mxRow;
    }

    public Matrix(int width, int height, int mxcol, int mxRow, int NumOfCellOnScreen, Image timage, int nofim) {
        this.screenH = width;
        this.screenW = height;
        this.maxCol = mxcol;
        this.maxRow = mxRow;
        this.numberOfCell = NumOfCellOnScreen;
        this.tiledImg = timage;
        this.numOfFrameInTiledImage = nofim;
        this.setGames();
    }

    public Matrix(int width, int height, int mxcol, int mxRow, int NumOfCellOnScreen, MatrixListner ml, Image timage, int nofim) {
        this.screenH = height;
        this.screenW = width;
        this.maxCol = mxcol;
        this.maxRow = mxRow;
        this.numberOfCell = NumOfCellOnScreen;
        this.matrixListner = ml;
        this.tiledImg = timage;
        this.numOfFrameInTiledImage = nofim;
        this.setGames();
    }

    private void setGames() {
        int i;
        if (this.screenW > this.screenH) {
            this.bottamAddH = 0;
        }
        this.cellH = (this.screenH - (this.bottamAddH + this.topAddH)) / this.numberOfCell;
        if (this.cellH % this.stepToCross != 0) {
            for (i = this.cellH; i > 0; --i) {
                if (i % this.stepToCross != 0) continue;
                this.cellH = i;
                break;
            }
        }
        if (this.cellH * this.numberOfCell > this.screenW) {
            this.cellH = this.screenW / this.numberOfCell;
        }
        if (this.cellH % this.stepToCross != 0) {
            for (i = this.cellH; i > 0; --i) {
                if (i % this.stepToCross != 0) continue;
                this.cellH = i;
                break;
            }
        }
        this.cellW = this.cellH;
        this.maxXLength = this.cellW * this.maxCol;
        this.maxYLength = this.cellH * this.maxRow;
        this.initialTiletXcord = this.tiletXcord = (this.screenW - this.cellW * this.numberOfCell) / 2;
        this.initialTiletYcord = this.tiletYcord = (this.screenH - (this.topAddH + this.bottamAddH + this.cellH * this.numberOfCell)) / 2 + this.topAddH;
        try {
            this.tiledImg = CommanFunctions.scale(this.tiledImg, this.cellW * this.numOfFrameInTiledImage, this.cellH);
            this.gameLayer = new TiledLayer(this.maxCol, this.maxRow, this.tiledImg, this.cellW, this.cellH);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLevel(int[][] arr) {
        try {
            for (int row = 0; row < this.maxRow; ++row) {
                for (int col = 0; col < this.maxCol; ++col) {
                    this.gameLayer.setCell(col, row, arr[row][col]);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in setLevel " + e);
        }
    }

    public void setCellValue(int col, int row, int tileIndex) {
        int value = this.gameLayer.getCell(col, row);
        this.gameLayer.setCell(col, row, tileIndex);
    }

    public int getCellValue(int col, int row) {
        try {
            if (row >= 0 && row < this.maxRow && col >= 0 && col < this.maxCol) {
                return this.gameLayer.getCell(col, row);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public int getCellH() {
        return this.cellH;
    }

    public int getCellW() {
        return this.cellW;
    }

    public void paint(Graphics g) {
        this.gameLayer.paint(g);
        this.gameLayer.setPosition(this.tiletXcord, this.tiletYcord);
        if (this.isAutoMove) {
            if (this.scrollingType == scrollRTL) {
                this.tiletXcord -= this.cellW / this.stepToCross;
                if (this.isResetCordintate) {
                    if (this.tiletXcord < -(this.maxXLength - this.screenW)) {
                        this.tiletXcord = this.initialTiletXcord;
                    } else {
                        this.matrixListner.matrixResponse(matrixEnd);
                    }
                }
            } else if (this.scrollingType == scrollBTT) {
                this.tiletYcord -= this.cellH / this.stepToCross;
                if (this.isResetCordintate && this.tiletYcord < -(this.maxYLength - this.screenH)) {
                    this.tiletYcord = this.initialTiletYcord;
                }
            } else if (this.scrollingType == scrollTTB) {
                this.tiletYcord += this.cellH / this.stepToCross;
                if (this.isResetCordintate) {
                    // empty if block
                }
            }
            ++this.movingCounter;
            if (this.movingCounter % this.stepToCross == 0) {
                this.matrixListner.matrixResponse(updatePlayerOnMatrixCallBack);
            }
        }
    }

    public void makeCellSelectable(Boolean flag) {
    }

    public void setSelectedCell(int i, int j) {
    }

    public void setSelectedCellImg(Image img) {
    }

    public void setScrollType(int sct) {
        this.scrollingType = sct;
        if (this.scrollingType == scrollTTB) {
            this.initialTiletYcord = this.tiletYcord = -(this.maxYLength - this.screenH);
        }
    }

    public int scrollType() {
        return this.scrollingType;
    }

    public Cell getCurrentCell() {
        Cell cell = null;
        return cell;
    }

    public void setIsResetCordintate(boolean isResetCordintate) {
        this.isResetCordintate = isResetCordintate;
    }

    public void setAutoMove(boolean isAutoMove) {
        this.isAutoMove = isAutoMove;
    }

    public void setStepToCross(int stepToCross) {
        this.stepToCross = stepToCross;
    }

    public int getTopAddH() {
        return this.topAddH;
    }

    public int getStepToCross() {
        return this.stepToCross;
    }

    public Cell getCurrentCell(int x, int y) {
        Cell cell = null;
        int xCord = this.tiletXcord;
        int yCord = this.tiletYcord;
        for (int row = 0; row < this.numberOfCell; ++row) {
            for (int col = 0; col < this.maxRow; ++col) {
                if (x <= (xCord += this.cellW) || x >= xCord + this.cellW || y <= yCord || y >= yCord + this.cellH) continue;
                cell = new Cell();
                cell.currentCell = col;
                cell.currentRow = row;
                cell.valueofCurrentCell = this.gameLayer.getCell(col, row);
                return cell;
            }
            yCord += this.cellH;
            xCord = 0;
        }
        return cell;
    }

    public void resetXYCord() {
        this.tiletXcord = this.initialTiletXcord;
        this.tiletYcord = this.initialTiletYcord;
    }

    public TiledLayer getGameLayer() {
        return this.gameLayer;
    }

    public int getBottamAddH() {
        return this.bottamAddH;
    }

    public int getInitialTiletYcord() {
        return this.initialTiletYcord;
    }

    public int getInitialTiletXcord() {
        return this.initialTiletXcord;
    }

    public int gettiletYcord() {
        return this.tiletYcord;
    }
}

