/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.readsms;

import com.twistfuture.general.GeneralFunction;
import com.twistfuture.general.GeneralInfo;
import com.twistfuture.readsms.ListItem;
import com.twistfuture.readsms.ReadStringfromTextFile;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MessageClass
implements Runnable {
    public static Font CURRENT_FONT = Font.getFont((int)32, (int)1, (int)8);
    private static final int mWidthOfScreen = GeneralInfo.SCREEN_WIDTH;
    private static final int mHeightOfScreen = GeneralInfo.SCREEN_HEIGHT;
    private static int mXInitialCordi = GeneralInfo.MESSAGE_DRAWING_X_CORDINATE_ON_CANVAS;
    private static int mYInitialCordi = GeneralInfo.MESSAGE_DRAWING_Y_CORDINATE_ON_CANVAS;
    public static Image MESSAGE_BACKGROUND;
    private int mCurrentXCordi;
    public int mCurrentYCordi;
    private String mContentString;
    Vector mLineVector = new Vector();
    private boolean mIsMessagePressed = false;
    protected int mPointerPressedX;
    protected int mPointerPressedY;
    public static int mCurrentJokeNo;
    private int prevJockerNo;
    private Thread mDraggingThread = new Thread(this);
    private boolean mDraggingStatus;
    private Callback mCallback;
    private boolean mDragToTake = true;
    public static int mTotalNoOfJokes;
    public static int y_drag;
    private int mNoofImages;
    private int current = -1;
    private Image[] CandyImg;
    private int mheight;
    private boolean Dragstatus;

    public MessageClass(String contentString, Callback callback) {
        this.mContentString = contentString;
        this.mCallback = callback;
        this.mNoofImages = GeneralInfo.NoofImge[ListItem.Id];
        this.DrawImages();
        this.loadData(mXInitialCordi, mYInitialCordi, contentString);
    }

    public void DrawImages() {
        this.CandyImg = new Image[GeneralInfo.NoofImge[ListItem.Id]];
        for (int i = 0; i < GeneralInfo.NoofImge[ListItem.Id]; ++i) {
            this.CandyImg[i] = GeneralFunction.createImage("ncandy/" + ListItem.Id + "/" + i + ".png");
        }
    }

    public void loadData(int xcordi, int yCordi, String contentString) {
        this.mCurrentXCordi = xcordi;
        this.mCurrentYCordi = yCordi;
        this.mContentString = contentString;
        this.mLineVector.removeAllElements();
        this.mDraggingStatus = false;
        this.getLine();
        this.getFit();
        if ((CURRENT_FONT.getHeight() + GeneralInfo.mLineSpacing) * this.mLineVector.size() < mHeightOfScreen - GeneralInfo.MESSAGE_DRAWING_Y_CORDINATE_ON_CANVAS) {
            this.mCurrentYCordi = mYInitialCordi = (mHeightOfScreen - (CURRENT_FONT.getHeight() + GeneralInfo.mLineSpacing) * this.mLineVector.size()) / 2;
        }
        y_drag = this.mCurrentYCordi + (GeneralInfo.mLineSpacing + CURRENT_FONT.getHeight()) * this.mLineVector.size();
        this.startThread();
    }

    public void startThread() {
        if (this.mDraggingThread != null && this.mCurrentXCordi != mXInitialCordi) {
            this.mDraggingThread = new Thread(this);
            this.mDraggingStatus = true;
            this.mDraggingThread.start();
        }
    }

    public void getLine() {
        int tempIndex = 0;
        for (int i = 0; i < this.mContentString.length(); ++i) {
            if (this.mContentString.charAt(i) != '\n') continue;
            this.mLineVector.addElement(this.mContentString.substring(tempIndex, i).trim());
            if (this.mContentString.substring(tempIndex, i).trim().startsWith("/")) {
                this.current = this.prevJockerNo < mCurrentJokeNo ? ++this.current : --this.current;
                this.prevJockerNo = mCurrentJokeNo;
            }
            if (this.current == GeneralInfo.NoofImge[ListItem.Id]) {
                this.current = 0;
            } else if (this.current == -1) {
                this.current = GeneralInfo.NoofImge[ListItem.Id] - 1;
            }
            tempIndex = i;
        }
    }

    public void getFit() {
        block0: for (int i = 0; i < this.mLineVector.size(); ++i) {
            String tempString = (String)this.mLineVector.elementAt(i);
            if (CURRENT_FONT.stringWidth(tempString) <= mWidthOfScreen - 14) continue;
            for (int k = tempString.length() - 1; k > 0; --k) {
                String tempString1;
                if (tempString.charAt(k) != ' ' || CURRENT_FONT.stringWidth(tempString1 = tempString.substring(0, k)) >= mWidthOfScreen - 14) continue;
                this.mLineVector.setElementAt(tempString1, i);
                this.mLineVector.insertElementAt(tempString.substring(tempString1.length() + 1, tempString.length()), i + 1);
                continue block0;
            }
        }
    }

    public void paint(Graphics g) {
        g.setFont(CURRENT_FONT);
        if (this.mIsMessagePressed) {
            g.drawImage(MESSAGE_BACKGROUND, mXInitialCordi, mYInitialCordi, 0);
        }
        int height = 0;
        for (int i = 0; i < this.mLineVector.size(); ++i) {
            if (((String)this.mLineVector.elementAt(i)).startsWith("/")) {
                g.drawImage(this.CandyImg[this.current], this.mCurrentXCordi, this.mCurrentYCordi + (GeneralInfo.mLineSpacing + CURRENT_FONT.getHeight()) * i + height, 0);
                height += this.CandyImg[this.current].getHeight();
                continue;
            }
            g.drawString((String)this.mLineVector.elementAt(i), this.mCurrentXCordi, this.mCurrentYCordi + (GeneralInfo.mLineSpacing + CURRENT_FONT.getHeight()) * i + height, 0);
        }
        this.mheight = height;
        y_drag += height;
    }

    public void pointerPressed(int x, int y) {
        this.mDraggingStatus = false;
        this.mPointerPressedX = x;
        this.mPointerPressedY = y;
    }

    protected void pointerDragged(int x, int y) {
        if (this.mDragToTake) {
            if (Math.abs(x - this.mPointerPressedX) > 15) {
                this.mCurrentXCordi += 4 * (x - this.mPointerPressedX);
                this.mPointerPressedX = x;
                this.mPointerPressedY = y;
                if (this.mCurrentXCordi >= mWidthOfScreen - 100) {
                    if (mCurrentJokeNo > 0) {
                        --mCurrentJokeNo;
                    } else {
                        mCurrentJokeNo = mTotalNoOfJokes;
                        this.current = GeneralInfo.NoofImge[ListItem.Id];
                        this.prevJockerNo = 9;
                    }
                    this.mDragToTake = false;
                    this.loadData(-20, GeneralInfo.MESSAGE_DRAWING_Y_CORDINATE_ON_CANVAS, (String)ReadStringfromTextFile.mMessageVector.elementAt(mCurrentJokeNo));
                } else if (this.mCurrentXCordi < -100) {
                    if (mCurrentJokeNo < mTotalNoOfJokes) {
                        ++mCurrentJokeNo;
                    } else {
                        mCurrentJokeNo = 0;
                        this.prevJockerNo = 0;
                        this.current = -1;
                    }
                    this.mDragToTake = false;
                    this.loadData(mWidthOfScreen + 20, GeneralInfo.MESSAGE_DRAWING_Y_CORDINATE_ON_CANVAS, (String)ReadStringfromTextFile.mMessageVector.elementAt(mCurrentJokeNo));
                }
            } else {
                if (this.mPointerPressedY < y && this.mCurrentYCordi < 50) {
                    this.mCurrentYCordi += 10;
                }
                if (this.mPointerPressedY > y && this.mCurrentYCordi > -(CURRENT_FONT.getHeight() * this.mLineVector.size() + this.mheight) + 120) {
                    this.mCurrentYCordi -= 10;
                }
                this.mPointerPressedY = y;
                this.mPointerPressedX = x;
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (!this.mDraggingStatus && !this.Dragstatus) {
            this.startThread();
        }
        this.mDragToTake = true;
    }

    public static void setFont(int face, int style, int size) {
        CURRENT_FONT = Font.getFont((int)face, (int)style, (int)size);
    }

    public static Font getFont() {
        return CURRENT_FONT;
    }

    public void setXcordi(int xcordi) {
        this.mCurrentXCordi = xcordi;
    }

    public int getXCordi() {
        return this.mCurrentXCordi;
    }

    public void setYcordi(int ycordi) {
        this.mCurrentYCordi = ycordi;
    }

    public int getYCordi() {
        return this.mCurrentYCordi;
    }

    public String getContentString() {
        return this.mContentString;
    }

    public void run() {
        while (this.mDraggingStatus && Math.abs(this.mCurrentXCordi - mXInitialCordi) >= 5) {
            this.Dragstatus = true;
            this.mCurrentXCordi = this.mCurrentXCordi < mXInitialCordi ? (this.mCurrentXCordi += 10) : (this.mCurrentXCordi -= 10);
            try {
                Thread.sleep(5L);
                this.mCallback.callRepaint();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.Dragstatus = false;
    }

    public void keypressed1() {
        mCurrentJokeNo = mCurrentJokeNo > 0 ? --mCurrentJokeNo : mTotalNoOfJokes - 1;
        this.loadData(-20, GeneralInfo.MESSAGE_DRAWING_Y_CORDINATE_ON_CANVAS, (String)ReadStringfromTextFile.mMessageVector.elementAt(mCurrentJokeNo));
    }

    public void KeyPressed2() {
        mCurrentJokeNo = mCurrentJokeNo < mTotalNoOfJokes - 1 ? ++mCurrentJokeNo : 0;
        this.loadData(mWidthOfScreen + 20, GeneralInfo.MESSAGE_DRAWING_Y_CORDINATE_ON_CANVAS, (String)ReadStringfromTextFile.mMessageVector.elementAt(mCurrentJokeNo));
    }

    static {
        mCurrentJokeNo = 0;
        y_drag = 0;
    }

    public static interface Callback {
        public void callRepaint();
    }
}

