/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class Motor
implements Constraint {
    private Body a;
    private int b;
    private int c;
    private boolean d;
    private boolean e;
    private boolean f;
    private int g;
    private static FXVector h = new FXVector();
    private static FXVector i = new FXVector();
    private static FXVector j = new FXVector();
    private FXVector k = new FXVector();
    private FXVector l = new FXVector();
    private FXVector m = new FXVector();
    private FXVector n = new FXVector();
    private UserData o = null;

    public Motor(Body body, int n, int n2) {
        this.a = body;
        this.b = n;
        this.d = true;
        this.e = false;
        this.f = false;
        this.g = n2;
    }

    public Motor(Body body, int n, int n2, int n3) {
        this.a = body;
        this.b = n;
        this.c = n2;
        this.d = false;
        this.e = false;
        this.f = false;
        this.g = n3;
    }

    public Motor(Motor motor, Body[] bodyArray) {
        this.a = bodyArray != null ? bodyArray[motor.a.o] : motor.a;
        this.b = motor.b;
        this.c = motor.c;
        this.d = motor.d;
        this.e = motor.e;
        this.f = motor.f;
        this.g = motor.g;
        if (motor.o != null) {
            this.o = motor.o.copy();
        }
    }

    public void setParameter(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        this.b = n;
        this.c = n2;
        this.d = bl;
        this.e = bl2;
        this.f = bl3;
        this.n.assignFX(0, 0);
    }

    public Constraint copy(Body[] bodyArray) {
        return new Motor(this, bodyArray);
    }

    private Motor() {
    }

    public static Motor loadMotor(PhysicsFileReader object, Vector vector, UserData userData) {
        Motor motor = new Motor();
        new Motor().a = (Body)vector.elementAt(((PhysicsFileReader)object).next());
        motor.b = ((PhysicsFileReader)object).nextIntFX();
        motor.c = ((PhysicsFileReader)object).nextIntFX();
        motor.g = ((PhysicsFileReader)object).nextIntFX();
        int n = ((PhysicsFileReader)object).next();
        motor.d = (n & 1) > 0;
        motor.e = (n & 2) > 0;
        boolean bl = motor.f = (n & 4) > 0;
        if (((PhysicsFileReader)object).getVersion() > 1792) {
            object = ((PhysicsFileReader)object).nextString();
            if (userData != null) {
                motor.o = userData.createNewUserData((String)object, 4);
            }
        }
        return motor;
    }

    public void precalculate(long l) {
        if (this.d) {
            this.a.applyTorque(this.n.xFX);
            return;
        }
        h.assignFX(this.b, this.c);
        if (this.e) {
            FXMatrix fXMatrix = new FXMatrix(this.a.getRotationMatrix());
            fXMatrix.invert();
            fXMatrix.mult(h, this.l);
        } else {
            this.l.xFX = Motor.h.xFX;
            this.l.yFX = Motor.h.yFX;
        }
        if (!this.f) {
            this.m.xFX = this.l.xFX;
            this.m.yFX = this.l.yFX;
            this.m.normalize();
        }
        this.a.applyMomentum(this.n);
    }

    public boolean applyMomentum(long l) {
        if (this.d) {
            int n = (int)((long)(this.a.d - this.b) * this.a.h.n >> 24);
            Motor.j.xFX = this.n.xFX;
            this.n.xFX = Math.max(Math.min(this.n.xFX + n, this.g), -this.g);
            int n2 = this.n.xFX - Motor.j.xFX;
            this.a.applyTorque(n2);
            return n2 < 16;
        }
        this.k.xFX = this.l.xFX;
        this.k.yFX = this.l.yFX;
        if (this.f) {
            this.k.add(this.a.b, -4096L);
        } else {
            long l2 = (long)this.m.xFX * (long)this.a.b.xFX + (long)this.m.yFX * (long)this.a.b.yFX >> 12;
            this.k.add(this.m, -l2);
        }
        this.k.multFX(this.a.h.l);
        j.assign(this.n);
        this.n.xFX += this.k.xFX;
        this.n.yFX += this.k.yFX;
        this.n.minFX(this.g);
        this.n.maxFX(-this.g);
        i.assignDiff(this.n, j);
        this.a.applyMomentum(i);
        return i.fastLengthFX() < 16;
    }

    public void postStep() {
    }

    public boolean concernsBody(Body body) {
        return body.equals(this.a);
    }

    public boolean equals(Constraint constraint) {
        return constraint instanceof Motor && this.a.equals(((Motor)constraint).a) && this.b == ((Motor)constraint).b && this.c == ((Motor)constraint).c && this.d == ((Motor)constraint).d && this.e == ((Motor)constraint).e && this.g == ((Motor)constraint).g;
    }

    public int getImpulseFX() {
        return this.n.lengthFX();
    }

    public Body body() {
        return this.a;
    }

    public boolean isRotation() {
        return this.d;
    }

    public boolean isRelative() {
        return this.e;
    }

    public boolean isFixOrthogonal() {
        return this.f;
    }

    public int getMaxForceFX() {
        return this.g;
    }

    public void setMaxForceFX(int n) {
        this.g = n;
    }

    public UserData getUserData() {
        return this.o;
    }

    public void setUserData(UserData userData) {
        this.o = userData;
    }
}

