/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.Contact;
import at.emini.physics2D.Event;
import at.emini.physics2D.EventSet;
import at.emini.physics2D.ExternalForce;
import at.emini.physics2D.Joint;
import at.emini.physics2D.Landscape;
import at.emini.physics2D.Motor;
import at.emini.physics2D.MultiShape;
import at.emini.physics2D.ParticleEmitter;
import at.emini.physics2D.PhysicsEventListener;
import at.emini.physics2D.Script;
import at.emini.physics2D.Shape;
import at.emini.physics2D.ShapeSet;
import at.emini.physics2D.Spring;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class World {
    private PhysicsEventListener r;
    private FXVector s = new FXVector(0, 409600);
    private int t = 0;
    private int u = 0;
    private int v = 204;
    private long w = 0x1000000 / this.v;
    private int x = 10;
    private int y = 5;
    private boolean z = false;
    public static final int M_SHAPE_MAX_VERTICES = 12;
    protected ShapeSet a = new ShapeSet();
    private EventSet A = new EventSet();
    private Body[] B = new Body[128];
    private int C = Integer.MIN_VALUE;
    private int D = Integer.MAX_VALUE;
    int b = 0;
    Body[] c = new Body[128];
    private int E = 0;
    private int F = 0;
    private int G = this.b;
    private Landscape H = new Landscape();
    int d = 0;
    Contact[] e = new Contact[128];
    static int f = 0;
    static Contact[] g = new Contact[32];
    int h = 0;
    Constraint[] i = new Constraint[32];
    private Vector I = new Vector();
    private Vector J = new Vector();
    Script[] j = new Script[32];
    int k = 0;
    Body[] l = new Body[32];
    int[] m = new int[32];
    int[] n = new int[32];
    int[] o = new int[32];
    int p = 0;
    static int q = 0;
    private UserData K = null;

    public World() {
    }

    public World(World world) {
        if (world == null) {
            return;
        }
        this.a = world.a.copy();
        this.s.assign(world.s);
        this.t = world.t;
        this.u = world.u;
        this.C = world.C;
        this.D = world.D;
        this.v = world.v;
        this.w = world.w;
        this.x = world.x;
        this.y = world.y;
        this.addWorld(world);
        this.A = world.A.copy();
        if (world.H != null) {
            this.setLandscape(world.H.copy());
        }
        if (world.K != null) {
            this.K = world.K.copy();
        }
    }

    public UserData getUserData() {
        return this.K;
    }

    public void setUserData(UserData userData) {
        this.K = userData;
    }

    public static World loadWorld(PhysicsFileReader physicsFileReader) {
        return World.loadWorld(physicsFileReader, null);
    }

    public static World loadWorld(PhysicsFileReader physicsFileReader, UserData userData) {
        int n = physicsFileReader.getVersion();
        if ((n & 0xFF00) < 256 || (n & 0xFF00) > 2560) {
            return null;
        }
        World world = new World();
        Vector<Shape> vector = new Vector<Shape>();
        Vector<Body> vector2 = new Vector<Body>();
        int n2 = 0;
        while (n2 != -1) {
            switch (n2) {
                case 1: {
                    int n3;
                    int n4;
                    int n5 = physicsFileReader.next();
                    for (n4 = 0; n4 < n5; ++n4) {
                        vector.addElement(Shape.loadShape(physicsFileReader, userData));
                    }
                    if (n > 2048) {
                        n4 = physicsFileReader.next();
                        for (n3 = 0; n3 < n4; ++n3) {
                            vector.addElement(MultiShape.loadShape(physicsFileReader, userData, vector));
                        }
                    }
                    world.a.registerShapes(vector);
                    break;
                }
                case 2: {
                    int n4;
                    int n6 = physicsFileReader.next();
                    for (n4 = 0; n4 < n6; ++n4) {
                        Body body = Body.loadBody(physicsFileReader, vector, userData);
                        vector2.addElement(body);
                        world.addBody(body);
                    }
                    break;
                }
                case 6: {
                    world.setLandscape(Landscape.loadLandscape(physicsFileReader));
                    break;
                }
                case 3: {
                    int n4;
                    int n7 = physicsFileReader.next();
                    for (n4 = 0; n4 < n7; ++n4) {
                        world.addConstraint(World.loadConstraint(physicsFileReader, vector2, userData));
                    }
                    break;
                }
                case 4: {
                    int n3;
                    int n4;
                    int n8 = physicsFileReader.next();
                    for (n4 = 0; n4 < n8; ++n4) {
                        world.addScript(Script.loadScript(physicsFileReader));
                    }
                    world.p = physicsFileReader.next();
                    for (n4 = 0; n4 < world.p; ++n4) {
                        n3 = physicsFileReader.next();
                        int n9 = physicsFileReader.next();
                        if (n9 < 0 || n9 >= vector2.size() || n3 >= n8) continue;
                        world.m[n4] = physicsFileReader.next();
                        world.l[n4] = (Body)vector2.elementAt(physicsFileReader.next());
                    }
                    break;
                }
                case 5: {
                    int n4;
                    int n10 = physicsFileReader.next();
                    for (n4 = 0; n4 < n10; ++n4) {
                        world.addEvent(Event.loadEvent(physicsFileReader, world, userData));
                    }
                    break;
                }
                case 7: {
                    world.setGravity(physicsFileReader.nextVector());
                    if (physicsFileReader.getVersion() > 2304) {
                        world.setDampingLateralFX(physicsFileReader.nextInt());
                        world.setDampingRotationalFX(physicsFileReader.nextInt());
                    } else {
                        int n11 = 4096 - physicsFileReader.nextInt();
                        world.setDampingLateralFX(n11);
                        world.setDampingRotationalFX(n11);
                    }
                    if (physicsFileReader.getVersion() <= 1792) break;
                    String string = physicsFileReader.nextString();
                    if (userData == null) break;
                    world.K = userData.createNewUserData(string, 6);
                    break;
                }
                case 8: {
                    int n4;
                    int n12 = physicsFileReader.next();
                    for (n4 = 0; n4 < n12; ++n4) {
                        world.addParticleEmitter(ParticleEmitter.loadParticleEmitter(physicsFileReader, world, userData));
                    }
                    break;
                }
            }
            if ((n & 0xFF00) == 256) {
                if (++n2 == 4) {
                    ++n2;
                }
                if (n2 <= 5) continue;
                break;
            }
            n2 = physicsFileReader.next();
        }
        physicsFileReader.close();
        return world;
    }

    public int getTimestepFX() {
        return this.v;
    }

    public long getInverseTimestepFX() {
        return this.w;
    }

    public void setTimestepFX(int n) {
        this.v = n;
        this.w = 0x1000000 / this.v;
    }

    public void setConstraintIterations(int n) {
        this.x = n;
    }

    public void setPositionConstraintIterations(int n) {
        this.y = n;
    }

    public int getConstraintIterations() {
        return this.x;
    }

    public int getPositionConstraintIterations() {
        return this.y;
    }

    public void setConstraintIterationDynamic(boolean bl) {
        this.z = bl;
    }

    public void setPhysicsEventListener(PhysicsEventListener physicsEventListener) {
        this.r = physicsEventListener;
    }

    public void setSimulationArea(int n, int n2) {
        this.C = n << 12;
        this.D = n2 << 12;
    }

    public ShapeSet getShapeSet() {
        return this.a;
    }

    public Body[] addWorld(World world) {
        Body body;
        int n;
        Body[] bodyArray = new Body[world.E];
        for (n = 0; n < world.b; ++n) {
            body = world.c[n].copy();
            this.addBody(body);
            body.a(0);
            bodyArray[world.c[n].o] = body;
        }
        for (n = 0; n < world.h; ++n) {
            this.addConstraint(world.i[n].copy(bodyArray));
        }
        for (n = 0; n < world.k; ++n) {
            this.addScript(world.j[n].copy());
        }
        for (n = 0; n < world.p; ++n) {
            body = bodyArray[world.l[n].o];
            this.j[world.m[n]].applyToBody(body, this);
            this.n[n] = world.n[n];
            this.o[n] = world.o[n];
        }
        for (n = 0; n < world.I.size(); ++n) {
            this.addParticleEmitter(((ParticleEmitter)world.I.elementAt(n)).copy(bodyArray));
        }
        for (n = 0; n < world.J.size(); ++n) {
            this.addExternalForce(((ExternalForce)world.J.elementAt(n)).copy(bodyArray));
        }
        Vector vector = world.A.getEvents();
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            this.addEvent(((Event)vector.elementAt(i)).copy(bodyArray));
        }
        Landscape landscape = world.getLandscape();
        for (int i = 0; i < landscape.a; ++i) {
            this.H.addSegment(new FXVector(landscape.b[i]), new FXVector(landscape.c[i]), landscape.d[i]);
        }
        return bodyArray;
    }

    public void addBody(Body body) {
        if (body != null) {
            body.o = this.E++;
            this.c = World.a(this.c, this.b);
            this.c[this.b++] = body;
            this.a.registerShape(body.h);
            this.a();
            body.forceUpdate(this.v);
        }
    }

    public void setLandscape(Landscape landscape) {
        this.H = landscape;
    }

    public Landscape getLandscape() {
        return this.H;
    }

    public void addParticleEmitter(ParticleEmitter particleEmitter) {
        if (particleEmitter != null) {
            this.I.addElement(particleEmitter);
        }
    }

    public void addExternalForce(ExternalForce externalForce) {
        if (externalForce != null) {
            this.J.addElement(externalForce);
        }
    }

    public void removeBody(Body body) {
        int n;
        int n2;
        if (body.o < 0) {
            return;
        }
        for (n2 = 0; n2 < this.b; ++n2) {
            if (this.c[n2] != body) continue;
            this.c[n2] = null;
            break;
        }
        this.b = World.a((Object[])this.c, this.b);
        this.a();
        for (n2 = 0; n2 < this.p; ++n2) {
            if (this.l[n2] != body) continue;
            this.n[n2] = -1;
            this.o[n2] = -1;
            this.m[n2] = -1;
            this.l[n2] = null;
            World.b(this.n, this.p);
            World.b(this.o, this.p);
            World.b(this.m, this.p);
            this.p = World.a((Object[])this.l, this.p);
        }
        n2 = this.h;
        for (n = 0; n < n2; ++n) {
            if (!this.i[n].concernsBody(body)) continue;
            this.i[n] = null;
        }
        this.h = World.a(this.i, this.h);
        for (n2 = this.I.size() - 1; n2 >= 0; --n2) {
            if (((ParticleEmitter)this.I.elementAt(n2)).getEmitter() != body) continue;
            this.I.removeElementAt(n2);
        }
        n2 = this.d;
        for (n = 0; n < n2; ++n) {
            if (!this.e[n].concernsBody(body)) continue;
            this.e[n] = null;
        }
        this.d = World.a((Object[])this.e, this.d);
    }

    public void removeConstraint(Constraint constraint) {
        int n = this.h;
        for (int i = 0; i < n; ++i) {
            if (this.i[i] != constraint) continue;
            this.i[i] = null;
        }
        this.h = World.a(this.i, this.h);
    }

    public void removeScript(Script script) {
        int n;
        int n2 = -1;
        for (n = 0; n < this.k; ++n) {
            if (this.j[n] != script) continue;
            this.j[n] = null;
            n2 = n;
            --this.k;
            for (int i = n; i < this.k; ++i) {
                this.j[i] = this.j[i + 1];
            }
            break;
        }
        for (n = 0; n < this.p; ++n) {
            if (this.n[n] != n2) continue;
            this.n[n] = -1;
            this.o[n] = -1;
            this.m[n] = -1;
            this.l[n] = null;
            World.b(this.n, this.p);
            World.b(this.o, this.p);
            World.b(this.m, this.p);
            this.p = World.a((Object[])this.l, this.p);
            return;
        }
    }

    public void removeEvent(Event event) {
        this.A.removeEvent(event);
    }

    public void removeParticleEmitter(ParticleEmitter particleEmitter) {
        if (particleEmitter != null) {
            this.I.removeElement(particleEmitter);
        }
    }

    public void removeExternalForce(ExternalForce externalForce) {
        if (externalForce != null) {
            this.J.removeElement(externalForce);
        }
    }

    static final int[] a(int[] nArray, int n) {
        if (nArray.length <= n) {
            int[] nArray2 = new int[nArray.length + 32];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }
        return nArray;
    }

    static final short[] a(short[] sArray, int n) {
        if (sArray.length <= n) {
            short[] sArray2 = new short[sArray.length + 32];
            System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
            return sArray2;
        }
        return sArray;
    }

    private static Body[] a(Body[] bodyArray, int n) {
        if (bodyArray.length <= n) {
            Body[] bodyArray2 = new Body[bodyArray.length + 32];
            System.arraycopy(bodyArray, 0, bodyArray2, 0, bodyArray.length);
            return bodyArray2;
        }
        return bodyArray;
    }

    static final Contact[] a(Contact[] contactArray, int n) {
        if (contactArray.length <= n) {
            Contact[] contactArray2 = new Contact[contactArray.length + 32];
            System.arraycopy(contactArray, 0, contactArray2, 0, contactArray.length);
            return contactArray2;
        }
        return contactArray;
    }

    static final FXVector[] a(FXVector[] fXVectorArray, int n) {
        if (fXVectorArray.length <= n) {
            FXVector[] fXVectorArray2 = new FXVector[fXVectorArray.length + 32];
            System.arraycopy(fXVectorArray, 0, fXVectorArray2, 0, fXVectorArray.length);
            return fXVectorArray2;
        }
        return fXVectorArray;
    }

    public Body findBodyById(int n) {
        if ((n = this.bodyIndexOf(n)) < 0) {
            return null;
        }
        return this.c[n];
    }

    public Body findBodyAt(int n, int n2) {
        Body[] bodyArray = this.getBodies();
        FXVector fXVector = new FXVector();
        for (int i = 0; i < this.getBodyCount(); ++i) {
            Body body = bodyArray[i];
            fXVector.assignFX(n, n2);
            if (n < body.getAABBMinXFX() || n > body.getAABBMaxXFX() || n2 < body.getAABBMinYFX() || n2 > body.getAABBMaxYFX()) continue;
            FXVector[] fXVectorArray = body.getAxes();
            FXVector[] fXVectorArray2 = body.getVertices();
            boolean bl = true;
            for (int j = 0; j < fXVectorArray.length; ++j) {
                long l;
                long l2 = (long)fXVector.xFX * (long)fXVectorArray[j].xFX + (long)fXVector.yFX * (long)fXVectorArray[j].yFX >> 12;
                long l3 = l = (long)fXVectorArray2[0].xFX * (long)fXVectorArray[j].xFX + (long)fXVectorArray2[0].yFX * (long)fXVectorArray[j].yFX >> 12;
                for (int k = 1; k < fXVectorArray2.length; ++k) {
                    long l4 = (long)fXVectorArray2[k].xFX * (long)fXVectorArray[j].xFX + (long)fXVectorArray2[k].yFX * (long)fXVectorArray[j].yFX >> 12;
                    if (l > l4) {
                        l = l4;
                    }
                    if (l3 >= l4) continue;
                    l3 = l4;
                }
                if (l <= l2 && l3 >= l2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return body;
        }
        return null;
    }

    public int bodyIndexOf(int n) {
        for (int i = 0; i < this.b; ++i) {
            if (this.c[i].o != n) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(Constraint constraint) {
        if (constraint == null) {
            return -1;
        }
        for (int i = 0; i < this.h; ++i) {
            if (!this.i[i].equals(constraint)) continue;
            return i;
        }
        return -1;
    }

    public void addConstraint(Constraint constraint) {
        if (constraint != null) {
            Constraint[] constraintArray;
            int n = this.h;
            Constraint[] constraintArray2 = this.i;
            if (this.i.length <= n) {
                Constraint[] constraintArray3 = new Constraint[constraintArray2.length + 32];
                System.arraycopy(constraintArray2, 0, constraintArray3, 0, constraintArray2.length);
                constraintArray = constraintArray3;
            } else {
                constraintArray = constraintArray2;
            }
            this.i = constraintArray;
            this.i[this.h++] = constraint;
        }
    }

    public void addScript(Script script) {
        if (script != null) {
            Script[] scriptArray;
            int n = this.k;
            Script[] scriptArray2 = this.j;
            if (this.j.length <= n) {
                Script[] scriptArray3 = new Script[scriptArray2.length + 32];
                System.arraycopy(scriptArray2, 0, scriptArray3, 0, scriptArray2.length);
                scriptArray = scriptArray3;
            } else {
                scriptArray = scriptArray2;
            }
            this.j = scriptArray;
            this.j[this.k++] = script;
        }
    }

    public void addEvent(Event event) {
        this.A.registerEvent(event);
    }

    public void setGravity(int n) {
        this.s = new FXVector(0, n << 12);
    }

    public void setGravity(FXVector fXVector) {
        this.s = fXVector;
    }

    public void setDampingLateralFX(int n) {
        this.t = n;
    }

    public void setDampingRotationalFX(int n) {
        this.u = n;
    }

    public void tick() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Body[] bodyArray = this.c;
        Constraint[] constraintArray = this.i;
        for (n6 = 0; n6 < this.p; ++n6) {
            if (this.l[n6] == null) continue;
            this.j[this.m[n6]].a(n6, this);
        }
        for (n6 = 0; n6 < this.J.size(); ++n6) {
            ((ExternalForce)this.J.elementAt(n6)).applyForce(bodyArray, this.b, this.v);
        }
        for (n6 = this.F; n6 < this.G; ++n6) {
            Body body = bodyArray[n6];
            if (body.e && body.g) {
                body.applyAcceleration(this.s, this.v);
            }
            body.a(this.v);
        }
        World world = this;
        for (n5 = 0; n5 < world.d; ++n5) {
            world.e[n5] = null;
        }
        n5 = world.d = 0;
        world.H.a();
        world.a();
        int n7 = 0;
        int n8 = 0;
        for (n4 = world.F; n4 < world.G; ++n4) {
            n3 = world.c[n4].j;
            world.H.a(world, world.c[n4]);
            for (int i = 0; i < n8; ++i) {
                if (world.B[i] == null) continue;
                if (world.B[i].k < n3) {
                    --n7;
                    world.B[i] = null;
                    continue;
                }
                if (world.c[n4].l > world.B[i].m || world.B[i].l > world.c[n4].m) continue;
                Body body = world.B[i];
                Body body2 = world.c[n4];
                World world2 = world;
                if (!body2.e && !body.e || (body2.n & body.n) != 0 || !body2.f || !body.f) continue;
                if (body2.h instanceof MultiShape || body.h instanceof MultiShape) {
                    int n9 = 1;
                    int n10 = 1;
                    if (body2.h instanceof MultiShape) {
                        n9 = ((MultiShape)body2.h).getShapeCount();
                    }
                    if (body.h instanceof MultiShape) {
                        n10 = ((MultiShape)body.h).getShapeCount();
                    }
                    for (int j = 0; j < n9; ++j) {
                        for (int k = 0; k < n10; ++k) {
                            Contact contact = Collision.detectCollision(body2, j, body, k);
                            if (contact == null) continue;
                            world2.e = World.a(world2.e, world2.d);
                            world2.e[world2.d] = contact;
                            ++world2.d;
                        }
                    }
                    continue;
                }
                Contact contact = Collision.detectCollision(body2, body);
                if (contact == null) continue;
                world2.e = World.a(world2.e, world2.d);
                world2.e[world2.d] = contact;
                ++world2.d;
            }
            world.B = World.a(world.B, n8);
            world.B[n8++] = world.c[n4];
            if (n8 <= ++n7 << 1) continue;
            n8 = World.a((Object[])world.B, n8);
        }
        world.H.b();
        for (n4 = world.F; n4 < world.G; ++n4) {
            world.c[n4].a();
        }
        world.H.getBody();
        for (n3 = n5; n3 < world.d; ++n3) {
            Contact contact = world.e[n3];
            world.e[n3].g = false;
            contact.a.a(contact);
            contact.c.a(contact);
        }
        Contact.a(this.e, this.d);
        Contact.a(this.e, this.d, this.H);
        for (int i = 0; i < this.I.size(); ++i) {
            ((ParticleEmitter)this.I.elementAt(i)).applyAcceleration(this.s, this.v);
        }
        World world3 = this;
        for (n2 = 0; n2 < world3.I.size(); ++n2) {
            ParticleEmitter particleEmitter = (ParticleEmitter)world3.I.elementAt(n2);
            if (!particleEmitter.b) continue;
            n8 = 0;
            for (n3 = world3.F; n3 < world3.G; ++n3) {
                while (n8 < particleEmitter.a && (particleEmitter.g[n8] <= 0 || world3.c[n3].j > particleEmitter.c[n8])) {
                    ++n8;
                }
                for (n4 = n8; n4 < particleEmitter.a && (particleEmitter.g[n4] <= 0 || world3.c[n3].k > particleEmitter.c[n4]); ++n4) {
                    FXVector fXVector;
                    if (particleEmitter.g[n4] <= 0 || world3.c[n3].l >= particleEmitter.d[n4] || world3.c[n3].m <= particleEmitter.d[n4] || !world3.c[n3].f || (fXVector = Collision.a(world3.c[n3], particleEmitter.c[n4], particleEmitter.d[n4])) == null) continue;
                    particleEmitter.a(fXVector, n4);
                }
            }
            world3.H.collideParticles(particleEmitter);
        }
        for (n = 0; n < this.d; ++n) {
            this.e[n].a(this.w);
        }
        for (n = 0; n < this.h; ++n) {
            constraintArray[n].precalculate(this.w);
        }
        n = 0;
        for (q = 0; !(q >= this.x || n != 0 && this.z); ++q) {
            n = 1;
            for (n2 = 0; n2 < this.h; ++n2) {
                n &= constraintArray[n2].applyMomentum(this.w);
            }
            for (n2 = 0; n2 < this.d; ++n2) {
                n &= this.e[n2].a();
            }
        }
        for (n2 = 0; n2 < this.h; ++n2) {
            constraintArray[n2].postStep();
        }
        n2 = 4096 - this.t;
        int n11 = 4096 - this.u;
        for (n7 = this.F; n7 < this.G; ++n7) {
            bodyArray[n7].integrateVelocity(this.v);
            bodyArray[n7].a(n2, n11);
        }
        for (n7 = 0; n7 < this.d; ++n7) {
            this.e[n7].a(this.v, this.w);
        }
        long l = 0L;
        for (q = 0; q < this.y; ++q) {
            for (n11 = 0; n11 < this.d; ++n11) {
                long l2 = this.e[n11].b();
                l = l < l2 ? l2 : l;
            }
            if (l < 32L) break;
        }
        for (n11 = this.F; n11 < this.G; ++n11) {
            bodyArray[n11].integrateVirtualVelocity(this.v, this.s);
        }
        for (n11 = 0; n11 < this.I.size(); ++n11) {
            ((ParticleEmitter)this.I.elementAt(n11)).integrateParticles(this.v);
        }
        if (this.r != null) {
            this.A.checkEvents(this, this.r);
        }
    }

    private static int a(Object[] objectArray, int n) {
        int n2 = n--;
        int n3 = 0;
        while (n3 < n) {
            while (objectArray[n3] != null && n3 < n) {
                ++n3;
            }
            while (objectArray[n] == null && n3 < n) {
                --n;
            }
            if (n3 < n) {
                objectArray[n3] = objectArray[n];
                objectArray[n] = null;
            }
            if (objectArray[n] == null) {
                n2 = n;
            }
            --n;
        }
        while (n2 > 0 && objectArray[n2 - 1] == null) {
            --n2;
        }
        return n2;
    }

    static final int b(int[] nArray, int n) {
        int n2 = n--;
        int n3 = 0;
        while (n3 < n) {
            while (nArray[n3] != -1 && n3 < n) {
                ++n3;
            }
            while (nArray[n] == -1 && n3 < n) {
                --n;
            }
            if (n3 < n) {
                nArray[n3] = nArray[n];
                nArray[n] = -1;
                n2 = n;
            }
            --n;
        }
        return n2;
    }

    private final void a() {
        int n;
        for (n = 1; n < this.b; ++n) {
            Body body = this.c[n];
            for (int i = n - 1; i >= 0 && this.c[i].j > body.j; --i) {
                this.c[i + 1] = this.c[i];
            }
            this.c[i + 1] = body;
        }
        this.F = -1;
        this.G = this.b;
        for (n = 0; n < this.b; ++n) {
            if (this.F < 0 && this.c[n].k > this.C) {
                this.F = n;
            }
            if (this.c[n].j >= this.D) continue;
            this.G = n + 1;
        }
        if (this.F < 0) {
            this.F = 0;
        }
    }

    public FXVector getGravity() {
        return this.s;
    }

    public int getDampingLateralFX() {
        return this.t;
    }

    public int getDampingRotationalFX() {
        return this.u;
    }

    public static Constraint loadConstraint(PhysicsFileReader physicsFileReader, Vector vector, UserData userData) {
        switch (physicsFileReader.next()) {
            case 0: {
                return Joint.loadJoint(physicsFileReader, vector, userData);
            }
            case 1: {
                return Spring.loadSpring(physicsFileReader, vector, userData);
            }
            case 3: {
                return Motor.loadMotor(physicsFileReader, vector, userData);
            }
        }
        return null;
    }

    public Vector getEvents() {
        return this.A.getEvents();
    }

    public Vector getParticleEmitters() {
        return this.I;
    }

    public int getBodyCount() {
        return this.b;
    }

    public Body[] getBodies() {
        return this.c;
    }

    public int getBodyStartIndex() {
        return this.F;
    }

    public int getBodyEndIndex() {
        return this.G;
    }

    public int getConstraintCount() {
        return this.h;
    }

    public Constraint[] getConstraints() {
        return this.i;
    }

    public int getContactCount() {
        return this.d;
    }

    public Contact[] getContacts() {
        return this.e;
    }

    public int getScriptCount() {
        return this.k;
    }

    public Script[] getScripts() {
        return this.j;
    }

    public Script getScript(int n) {
        return this.j[n];
    }

    public Contact[] getContactsForBody(Body contactArray) {
        Contact[] contactArray2 = new Contact[8];
        int n = 0;
        contactArray = contactArray.getContacts();
        for (int i = 0; i < contactArray.length && contactArray[i] != null; ++i) {
            contactArray2[n++] = contactArray[i];
        }
        return contactArray2;
    }

    public void translate(FXVector fXVector) {
        int n = this.getBodyCount();
        Body[] bodyArray = this.getBodies();
        for (int i = 0; i < n; ++i) {
            bodyArray[i].positionFX().xFX += fXVector.xFX;
            bodyArray[i].positionFX().yFX += fXVector.yFX;
            bodyArray[i].a(0);
        }
    }

    public long getBodyTotalEnergyFX(Body body) {
        long l = body.velocityFX().lengthSquareFX() / 2;
        long l2 = (long)(-((int)((long)body.positionFX().yFX * (long)this.s.yFX) >> 12)) + (long)(-((int)((long)body.positionFX().xFX * (long)this.s.xFX) >> 12));
        return l + l2;
    }
}

