/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class MeBoy
extends MIDlet
implements CommandListener {
    public static final boolean debug = false;
    public static int rotations = 0;
    public static int maxFrameSkip = 3;
    public static boolean enableScaling = false;
    public static boolean keepProportions = false;
    public static boolean fullScreen = false;
    public static boolean disableColor = false;
    public static int lazyLoadingThreshold = 64;
    public static int suspendCounter = 1;
    public static String[] suspendIndex = new String[0];
    private List mainMenu;
    private static Display display;
    private GBCanvas gbCanvas;
    private List cartList;
    private List suspendList;
    private Form settingsForm;
    private TextField frameSkipField;
    private TextField rotationField;
    private TextField loadThresholdField;
    private ChoiceGroup scalingGroup;
    private ChoiceGroup gbcGroup;
    private static Form logForm;
    private static MeBoy instance;

    public void startApp() {
        instance = this;
        display = Display.getDisplay((MIDlet)this);
        logForm.addCommand(new Command("Return", 2, 0));
        GBCanvas.readSettings();
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"suspended", (boolean)false);
            byte[] b = rs.getRecord(1);
            rs.closeRecordStore();
            RecordStore.deleteRecordStore((String)"suspended");
            String newName = suspendCounter++ + ": (from 1.1/1.2)";
            rs = RecordStore.openRecordStore((String)("s" + newName), (boolean)true);
            rs.addRecord(b, 0, b.length);
            rs.closeRecordStore();
            MeBoy.addSuspendedGame(newName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mainMenuAction();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public static void showLog() {
        logForm.setCommandListener((CommandListener)instance);
        display.setCurrent((Displayable)logForm);
    }

    public static void showAbout() {
        Form aboutForm = new Form("About MeBoy");
        aboutForm.addCommand(new Command("Return", 2, 0));
        aboutForm.append("MeBoy 1.5 \u00a9 Bj\u00f6rn Carlin, 2005-2007.\nhttp://arktos.se/meboy/");
        aboutForm.setCommandListener((CommandListener)instance);
        display.setCurrent((Displayable)aboutForm);
    }

    public void unloadCart() {
        this.mainMenuAction();
        this.gbCanvas.releaseReferences();
        this.gbCanvas = null;
    }

    private void mainMenuAction() {
        this.mainMenu = new List("MeBoy 1.5", 3);
        this.mainMenu.append("New Game", null);
        if (suspendIndex.length > 0) {
            this.mainMenu.append("Resume Game", null);
        }
        this.mainMenu.append("Settings", null);
        this.mainMenu.append("Show log", null);
        this.mainMenu.append("About MeBoy", null);
        this.mainMenu.append("Exit", null);
        this.mainMenu.setCommandListener((CommandListener)this);
        display.setCurrent((Displayable)this.mainMenu);
    }

    private void newGameAction() {
        if (this.cartList == null) {
            this.cartList = new List("Select Game", 3);
            StringBuffer sb = new StringBuffer();
            try {
                int c;
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/carts.txt");
                while ((c = is.read()) != -1) {
                    if (c >= 32) {
                        sb.append((char)c);
                        continue;
                    }
                    if (sb.length() <= 0) continue;
                    this.cartList.append(sb.toString(), null);
                    sb.setLength(0);
                }
                if (sb.length() > 0) {
                    this.cartList.append(sb.toString(), null);
                }
                is.close();
                this.cartList.addCommand(new Command("Return", 2, 1));
                this.cartList.setCommandListener((CommandListener)this);
                display.setCurrent((Displayable)this.cartList);
            }
            catch (Exception e) {
                MeBoy.log("cartlist error:");
                MeBoy.log(e.toString());
                MeBoy.showLog();
            }
        } else {
            display.setCurrent((Displayable)this.cartList);
        }
    }

    private void resumeGameAction() {
        if (suspendIndex.length == 0) {
            this.mainMenuAction();
            return;
        }
        this.suspendList = new List("Select Game", 3);
        for (int i = 0; i < suspendIndex.length; ++i) {
            this.suspendList.append(suspendIndex[i], null);
        }
        this.suspendList.addCommand(new Command("Delete", 1, 2));
        this.suspendList.addCommand(new Command("Duplicate", 1, 2));
        this.suspendList.addCommand(new Command("Return", 2, 1));
        this.suspendList.setCommandListener((CommandListener)this);
        display.setCurrent((Displayable)this.suspendList);
    }

    public void commandAction(Command com, Displayable s) {
        String label = com.getLabel();
        if ("".equals(label) && s == this.mainMenu) {
            String item = this.mainMenu.getString(this.mainMenu.getSelectedIndex());
            if (item == "New Game") {
                this.newGameAction();
            } else if (item == "Resume Game") {
                this.resumeGameAction();
            } else if (item == "Settings") {
                this.settingsForm = new Form("Settings");
                this.frameSkipField = new TextField("Frame skip", Integer.toString(maxFrameSkip), 2, 2);
                this.settingsForm.append((Item)this.frameSkipField);
                this.rotationField = new TextField("Number of 90 deg turns", Integer.toString(rotations), 2, 2);
                this.settingsForm.append((Item)this.rotationField);
                this.loadThresholdField = new TextField("Max number of 16kB banks to load", Integer.toString(lazyLoadingThreshold), 3, 2);
                this.settingsForm.append((Item)this.loadThresholdField);
                this.scalingGroup = new ChoiceGroup("Scaling", 2, new String[]{"Scale to fit", "Keep proportions", "Start in full screen"}, null);
                this.scalingGroup.setSelectedIndex(0, enableScaling);
                this.scalingGroup.setSelectedIndex(1, keepProportions);
                this.scalingGroup.setSelectedIndex(2, fullScreen);
                this.settingsForm.append((Item)this.scalingGroup);
                this.gbcGroup = new ChoiceGroup("Gameboy Color", 2, new String[]{"Disable GBC"}, null);
                this.gbcGroup.setSelectedIndex(0, disableColor);
                this.settingsForm.append((Item)this.gbcGroup);
                this.settingsForm.addCommand(new Command("Save", 4, 1));
                this.settingsForm.setCommandListener((CommandListener)this);
                display.setCurrent((Displayable)this.settingsForm);
            } else if (item == "Show log") {
                MeBoy.log("free memory: " + Runtime.getRuntime().freeMemory() + "/" + Runtime.getRuntime().totalMemory());
                MeBoy.showLog();
            } else if (item == "About MeBoy") {
                MeBoy.showAbout();
            } else if (item == "Exit") {
                this.destroyApp(true);
                this.notifyDestroyed();
            }
        } else if ("".equals(label) && s == this.cartList) {
            String cart = this.cartList.getString(this.cartList.getSelectedIndex());
            try {
                this.gbCanvas = new GBCanvas(this, cart, false);
                display.setCurrent((Displayable)this.gbCanvas);
            }
            catch (Exception e) {
                MeBoy.log("newgame error:");
                MeBoy.log(e.toString());
                MeBoy.showLog();
            }
        } else if (label == "time" && s == this.cartList) {
            String cart = this.cartList.getString(this.cartList.getSelectedIndex());
            try {
                this.gbCanvas = new GBCanvas(this, cart, true);
                display.setCurrent((Displayable)this.gbCanvas);
            }
            catch (Exception e) {
                MeBoy.log("timing error:");
                MeBoy.log(e.toString());
                MeBoy.showLog();
            }
        } else if ("".equals(label) && s == this.suspendList) {
            try {
                this.gbCanvas = new GBCanvas(this, suspendIndex[this.suspendList.getSelectedIndex()]);
                display.setCurrent((Displayable)this.gbCanvas);
            }
            catch (Exception e) {
                MeBoy.log("resumption error:");
                MeBoy.log(e.toString());
                MeBoy.showLog();
            }
        } else if (label == "Delete") {
            try {
                int index = this.suspendList.getSelectedIndex();
                String name = suspendIndex[index];
                String[] oldIndex = suspendIndex;
                suspendIndex = new String[oldIndex.length - 1];
                System.arraycopy(oldIndex, 0, suspendIndex, 0, index);
                System.arraycopy(oldIndex, index + 1, suspendIndex, index, suspendIndex.length - index);
                GBCanvas.writeSettings();
                RecordStore.deleteRecordStore((String)("s" + name));
            }
            catch (Exception e) {
                MeBoy.log("deletion error:");
                MeBoy.log(e.toString());
                MeBoy.showLog();
            }
            this.resumeGameAction();
        } else if (label == "Duplicate") {
            try {
                int index = this.suspendList.getSelectedIndex();
                String oldName = suspendIndex[index];
                String newName = suspendCounter++ + oldName.substring(oldName.indexOf(58));
                RecordStore rs = RecordStore.openRecordStore((String)("s" + oldName), (boolean)true);
                byte[] b = rs.getRecord(1);
                rs.closeRecordStore();
                rs = RecordStore.openRecordStore((String)("s" + newName), (boolean)true);
                rs.addRecord(b, 0, b.length);
                rs.closeRecordStore();
                MeBoy.addSuspendedGame(newName);
                this.resumeGameAction();
            }
            catch (Exception e) {
                MeBoy.log("duplication error:");
                MeBoy.log(e.toString());
                MeBoy.showLog();
            }
        } else if (label == "Return") {
            if (this.gbCanvas != null) {
                display.setCurrent((Displayable)this.gbCanvas);
            } else {
                this.mainMenuAction();
            }
        } else if (s == this.settingsForm) {
            int f = Integer.parseInt(this.frameSkipField.getString());
            maxFrameSkip = Math.max(Math.min(f, 59), 0);
            rotations = Integer.parseInt(this.rotationField.getString()) & 3;
            lazyLoadingThreshold = Math.max(Integer.parseInt(this.loadThresholdField.getString()), 20);
            enableScaling = this.scalingGroup.isSelected(0);
            keepProportions = this.scalingGroup.isSelected(1);
            fullScreen = this.scalingGroup.isSelected(2);
            disableColor = this.gbcGroup.isSelected(0);
            GBCanvas.writeSettings();
            display.setCurrent((Displayable)this.mainMenu);
        }
    }

    public static void log(String s) {
        if (s == null) {
            return;
        }
        logForm.append(s + '\n');
    }

    public static void addSuspendedGame(String name) {
        String[] oldIndex = suspendIndex;
        suspendIndex = new String[oldIndex.length + 1];
        System.arraycopy(oldIndex, 0, suspendIndex, 0, oldIndex.length);
        MeBoy.suspendIndex[oldIndex.length] = name;
        GBCanvas.writeSettings();
    }

    static {
        logForm = new Form("log");
    }
}

