/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class PrimMidp
extends MIDlet
implements Runnable,
CommandListener {
    private Display display;
    private PrimCanvas canvas;
    private boolean doRestart;
    private boolean waitingAtResult = false;
    public static long[] times = new long[12];
    private static String[] names = new String[]{"Rect", "Rect Dotted", "Rect Filled", "Line", "Line Dotted", "Arc", "Arc Dotted", "Arc Filled", "Round Rect", "Round Rect Dotted", "Round Rect Filled", "String"};
    Command pauseCommand = new Command("Pause", 1, 10);
    Command stepCommand = new Command("Step", 6, 1);
    Command continueCommand = new Command("Continue", 4, 20);
    Command clearCommand = new Command("Clear", 1, 10);
    Command restartCommand = new Command("Restart", 1, 20);
    Command exitCommand = new Command("Exit", 6, 5);
    Command nextTest = new Command("Next Test", 4, 6);

    public PrimMidp() {
        this.display = Display.getDisplay((MIDlet)this);
        this.canvas = new PrimCanvas();
    }

    protected void startApp() throws MIDletStateChangeException {
        try {
            this.canvas.addCommand(this.restartCommand);
            this.canvas.addCommand(this.pauseCommand);
            this.canvas.addCommand(this.continueCommand);
            this.canvas.addCommand(this.clearCommand);
            this.canvas.addCommand(this.nextTest);
            this.canvas.addCommand(this.exitCommand);
            this.canvas.addCommand(this.stepCommand);
            this.canvas.setCommandListener(this);
            this.display.setCurrent((Displayable)this.canvas);
            this.canvas.randomCoordinates();
            Thread thread = new Thread(this);
            thread.start();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void pauseApp() {
        this.canvas.endTest();
    }

    protected void destroyApp(boolean bl) {
        this.canvas.endTest();
    }

    private void outputResultLine(Form form, String string) {
        form.append(string + "\n");
        System.out.println(string);
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        do lbl-1000:
        // 3 sources

        {
            this.doRestart = false;
            this.display.setCurrent((Displayable)this.canvas);
            try {
                this.canvas.runTest();
            }
            catch (Throwable var1_2) {
                System.out.println("tests failed with exception:");
                var1_2.printStackTrace();
            }
            if (this.doRestart) ** GOTO lbl-1000
            var1_1 = new Form("PrimMidp results");
            var1_1.addCommand(this.restartCommand);
            var1_1.addCommand(this.exitCommand);
            var1_1.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)var1_1);
            System.out.println("PrimMidp results");
            var2_3 = 0L;
            var4_4 = 0;
            while (var4_4 < PrimMidp.times.length) {
                var5_5 = PrimMidp.names[var4_4];
                this.outputResultLine(var1_1, PrimMidp.names[var4_4] + ": " + PrimMidp.times[var4_4] + " ms");
                var2_3 += PrimMidp.times[var4_4];
                ++var4_4;
            }
            this.outputResultLine(var1_1, "Total " + var2_3 + " ms");
            var5_5 = this;
            synchronized (var5_5) {
                try {
                    var6_6 = System.getProperty("primMidp.exitAtEnd");
                    if (var6_6 != null) {
                        this.destroyApp(true);
                    }
                    this.waitingAtResult = true;
                    this.wait();
                    this.waitingAtResult = false;
                }
                catch (Exception var6_7) {
                    // empty catch block
                }
            }
        } while (this.doRestart);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (command == this.restartCommand) {
            this.doRestart = true;
            this.canvas.endTest();
            PrimMidp primMidp = this;
            synchronized (primMidp) {
                if (this.waitingAtResult) {
                    this.notify();
                }
            }
        } else if (command == this.pauseCommand) {
            this.canvas.pause();
        } else if (command == this.stepCommand) {
            this.canvas.step();
        } else if (command == this.continueCommand) {
            this.canvas.cont();
        } else if (command == this.clearCommand) {
            this.canvas.clearScrn();
        } else if (command == this.nextTest) {
            this.canvas.nextTest();
        }
    }

    public class PrimCanvas
    extends Canvas {
        private Image scrnImage = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        private Graphics scrnGraphics = this.scrnImage.getGraphics();
        private boolean endTestRequested;
        private boolean paused;
        private boolean step;
        private boolean stopAtNextTest;
        private int[] data;
        private int[] colors;
        private Font[] fonts;
        private int[] textAnchors;
        private int[] imageAnchors;
        private int iterations = 1;
        private int testNum;
        private long testStartTime;
        private long wastedTime;

        public PrimCanvas() {
            String string = System.getProperty("primTest.iter");
            if (string != null) {
                try {
                    this.iterations = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("bad iter property '" + string + "'");
                    return;
                }
            }
        }

        protected void paint(Graphics graphics) {
            graphics.drawImage(this.scrnImage, 0, 0, 20);
        }

        public void runTest() {
            this.endTestRequested = false;
            this.paused = false;
            this.step = false;
            this.stopAtNextTest = false;
            int n = 1;
            while (n <= this.iterations) {
                this.testNum = 0;
                this.testStartTime = System.currentTimeMillis();
                this.wastedTime = 0L;
                this.drawRectTest(false);
                if (this.endTestRequested) {
                    return;
                }
                this.drawRectTest(true);
                if (this.endTestRequested) {
                    return;
                }
                this.drawLineTest();
                if (this.endTestRequested) {
                    return;
                }
                this.drawArcTest(false);
                if (this.endTestRequested) {
                    return;
                }
                this.drawArcTest(true);
                if (this.endTestRequested) {
                    return;
                }
                this.drawRoundRectTest(false);
                if (this.endTestRequested) {
                    return;
                }
                this.drawRoundRectTest(true);
                if (this.endTestRequested) {
                    return;
                }
                this.drawStringTest();
                if (this.endTestRequested) {
                    return;
                }
                ++n;
            }
        }

        public void randomCoordinates() {
            int n;
            this.data = new int[10000];
            Random random = new Random(0L);
            int n2 = this.getWidth();
            if (this.getHeight() > n2) {
                n2 = this.getHeight();
            }
            int n3 = 0;
            while (n3 < this.data.length) {
                this.data[n3] = (random.nextInt() & 0xFFFFFF) % n2;
                ++n3;
            }
            this.colors = new int[9];
            this.scrnGraphics.setColor(128, 128, 128);
            this.colors[0] = this.scrnGraphics.getColor();
            this.scrnGraphics.setColor(255, 255, 255);
            this.colors[1] = this.scrnGraphics.getColor();
            this.scrnGraphics.setColor(255, 255, 0);
            this.colors[2] = this.scrnGraphics.getColor();
            this.scrnGraphics.setColor(0, 0, 255);
            this.colors[3] = this.scrnGraphics.getColor();
            this.scrnGraphics.setColor(0, 255, 255);
            this.colors[4] = this.scrnGraphics.getColor();
            this.scrnGraphics.setColor(255, 0, 0);
            this.colors[5] = this.scrnGraphics.getColor();
            this.scrnGraphics.setColor(0, 255, 0);
            this.colors[6] = this.scrnGraphics.getColor();
            this.scrnGraphics.setColor(0, 0, 0);
            this.colors[7] = this.scrnGraphics.getColor();
            this.scrnGraphics.setColor(240, 240, 240);
            this.colors[8] = this.scrnGraphics.getColor();
            this.fonts = new Font[4];
            this.fonts[0] = Font.getFont((int)64, (int)0, (int)0);
            this.fonts[1] = Font.getFont((int)0, (int)1, (int)0);
            this.fonts[2] = Font.getFont((int)32, (int)2, (int)8);
            this.fonts[3] = Font.getFont((int)64, (int)1, (int)16);
            this.textAnchors = new int[9];
            int[] nArray = new int[]{4, 1, 8};
            int[] nArray2 = new int[]{16, 64, 32};
            int n4 = 0;
            while (n4 < 3) {
                n = 0;
                while (n < 3) {
                    this.textAnchors[n4 * 3 + n] = nArray[n4] | nArray2[n];
                    ++n;
                }
                ++n4;
            }
            this.imageAnchors = new int[9];
            nArray2[1] = 2;
            n = 0;
            while (n < 3) {
                int n5 = 0;
                while (n5 < 3) {
                    this.imageAnchors[n * 3 + n5] = nArray[n] | nArray2[n5];
                    ++n5;
                }
                ++n;
            }
        }

        private void sleep(int n) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void clearScrn() {
            int n = this.scrnGraphics.getColor();
            this.scrnGraphics.setColor(this.colors[8]);
            int n2 = this.scrnGraphics.getStrokeStyle();
            this.scrnGraphics.setStrokeStyle(0);
            this.scrnGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.scrnGraphics.setColor(n);
            this.scrnGraphics.setStrokeStyle(n2);
        }

        public void pause() {
            PrimCanvas primCanvas = this;
            synchronized (primCanvas) {
                this.paused = true;
                this.step = false;
                ((Object)((Object)this)).notify();
            }
        }

        public void cont() {
            PrimCanvas primCanvas = this;
            synchronized (primCanvas) {
                this.paused = false;
                ((Object)((Object)this)).notify();
            }
        }

        public void step() {
            PrimCanvas primCanvas = this;
            synchronized (primCanvas) {
                this.paused = true;
                this.step = true;
                ((Object)((Object)this)).notify();
            }
        }

        public void endTest() {
            PrimCanvas primCanvas = this;
            synchronized (primCanvas) {
                this.endTestRequested = true;
                this.cont();
            }
        }

        public void nextTest() {
            PrimCanvas primCanvas = this;
            synchronized (primCanvas) {
                this.stopAtNextTest = true;
                this.cont();
            }
        }

        private void pausePoint() {
            this.repaint();
            PrimCanvas primCanvas = this;
            synchronized (primCanvas) {
                while (this.paused & !this.step && !this.endTestRequested) {
                    long l = System.currentTimeMillis();
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.wastedTime += System.currentTimeMillis() - l;
                }
                if (this.step) {
                    this.step = false;
                }
            }
        }

        private void interTestPoint() {
            long l = System.currentTimeMillis();
            PrimMidp.times[this.testNum] = l - this.testStartTime - this.wastedTime;
            this.wastedTime = 0L;
            this.testStartTime = l;
            ++this.testNum;
            PrimCanvas primCanvas = this;
            synchronized (primCanvas) {
                if (this.stopAtNextTest) {
                    this.paused = true;
                    this.step = false;
                    this.stopAtNextTest = false;
                }
            }
            this.pausePoint();
        }

        void drawLineTest() {
            this.clearScrn();
            int[] nArray = this.data;
            this.scrnGraphics.setStrokeStyle(0);
            int n = nArray.length - 10;
            while (n >= 0) {
                this.scrnGraphics.setColor(this.colors[nArray[n + 4] & 7]);
                this.scrnGraphics.drawLine(nArray[n], nArray[n + 1], nArray[n + 2], nArray[n + 3]);
                if (this.endTestRequested) {
                    return;
                }
                this.pausePoint();
                --n;
            }
            this.interTestPoint();
            this.clearScrn();
            this.scrnGraphics.setStrokeStyle(1);
            int n2 = nArray.length - 15;
            while (n2 >= 0) {
                this.scrnGraphics.setColor(this.colors[nArray[n2 + 4] & 7]);
                this.scrnGraphics.drawLine(nArray[n2], nArray[n2 + 1], nArray[n2 + 2], nArray[n2 + 3]);
                if (this.endTestRequested) {
                    return;
                }
                this.pausePoint();
                --n2;
            }
            this.interTestPoint();
        }

        void drawArcTest(boolean bl) {
            Rect rect = new Rect();
            this.clearScrn();
            int[] nArray = this.data;
            this.scrnGraphics.setStrokeStyle(0);
            int n = nArray.length - 10;
            while (n >= 0) {
                rect.getRect(nArray, n);
                this.scrnGraphics.setColor(this.colors[nArray[n + 4] & 7]);
                if (bl) {
                    this.scrnGraphics.fillArc(rect.x, rect.y, rect.width, rect.height, nArray[n + 4] % 360, nArray[n + 5] % 360);
                } else {
                    this.scrnGraphics.drawArc(rect.x, rect.y, rect.width, rect.height, nArray[n + 4] % 360, nArray[n + 5] % 360);
                }
                if (this.endTestRequested) {
                    return;
                }
                this.pausePoint();
                --n;
            }
            if (!bl) {
                this.interTestPoint();
                this.clearScrn();
                this.scrnGraphics.setStrokeStyle(1);
                int n2 = nArray.length - 15;
                while (n2 >= 0) {
                    rect.getRect(nArray, n2);
                    this.scrnGraphics.setColor(this.colors[nArray[n2 + 4] & 7]);
                    this.scrnGraphics.drawArc(rect.x, rect.y, rect.width, rect.height, nArray[n2 + 4] % 360, nArray[n2 + 5] % 360);
                    if (this.endTestRequested) {
                        return;
                    }
                    this.pausePoint();
                    --n2;
                }
            }
            this.interTestPoint();
        }

        void drawRectTest(boolean bl) {
            Rect rect = new Rect();
            this.clearScrn();
            int[] nArray = this.data;
            this.scrnGraphics.setStrokeStyle(0);
            int n = nArray.length - 10;
            while (n >= 0) {
                rect.getRect(nArray, n);
                this.scrnGraphics.setColor(this.colors[nArray[n + 4] & 7]);
                if (bl) {
                    this.scrnGraphics.fillRect(rect.x, rect.y, rect.width, rect.height);
                } else {
                    this.scrnGraphics.drawRect(rect.x, rect.y, rect.width, rect.height);
                }
                if (this.endTestRequested) {
                    return;
                }
                this.pausePoint();
                --n;
            }
            if (!bl) {
                this.interTestPoint();
                this.clearScrn();
                this.scrnGraphics.setStrokeStyle(1);
                int n2 = nArray.length - 15;
                while (n2 >= 0) {
                    rect.getRect(nArray, n2);
                    this.scrnGraphics.setColor(this.colors[nArray[n2 + 4] & 7]);
                    this.scrnGraphics.drawRect(rect.x, rect.y, rect.width, rect.height);
                    if (this.endTestRequested) {
                        return;
                    }
                    this.pausePoint();
                    --n2;
                }
            }
            this.interTestPoint();
        }

        void drawRoundRectTest(boolean bl) {
            Rect rect = new Rect();
            this.clearScrn();
            int[] nArray = this.data;
            this.scrnGraphics.setStrokeStyle(0);
            int n = nArray.length - 10;
            while (n >= 0) {
                rect.getRect(nArray, n);
                this.scrnGraphics.setColor(this.colors[nArray[n + 4] & 7]);
                if (bl) {
                    this.scrnGraphics.fillRoundRect(rect.x, rect.y, rect.width, rect.height, 50, 50);
                } else {
                    this.scrnGraphics.drawRoundRect(rect.x, rect.y, rect.width, rect.height, 50, 50);
                }
                if (this.endTestRequested) {
                    return;
                }
                this.pausePoint();
                --n;
            }
            if (!bl) {
                this.interTestPoint();
                this.clearScrn();
                this.scrnGraphics.setStrokeStyle(1);
                int n2 = nArray.length - 15;
                while (n2 >= 0) {
                    rect.getRect(nArray, n2);
                    this.scrnGraphics.setColor(this.colors[nArray[n2 + 4] & 7]);
                    this.scrnGraphics.drawRoundRect(rect.x, rect.y, rect.width, rect.height, 50, 50);
                    if (this.endTestRequested) {
                        return;
                    }
                    this.pausePoint();
                    --n2;
                }
            }
            this.interTestPoint();
        }

        void drawStringTest() {
            this.clearScrn();
            int[] nArray = this.data;
            String string = "A quite long string to be subdivided";
            this.scrnGraphics.setStrokeStyle(0);
            int n = nArray.length - 20;
            while (n >= 0) {
                this.scrnGraphics.setColor(this.colors[nArray[n + 4] & 7]);
                this.scrnGraphics.setFont(this.fonts[n + 5 & 3]);
                this.scrnGraphics.drawString("Hello there", nArray[n], nArray[n + 1], this.textAnchors[nArray[n + 2] % 9]);
                this.scrnGraphics.drawString("abc", nArray[n + 3], nArray[n + 4], this.textAnchors[nArray[n + 5] % 9]);
                this.scrnGraphics.drawString("This is a slightly longer string", nArray[n + 6], nArray[n + 7], this.textAnchors[nArray[n + 8] % 9]);
                int n2 = nArray[n + 10] % string.length();
                int n3 = nArray[n + 11] % (string.length() - n2);
                this.scrnGraphics.drawSubstring(string, n2, n3, nArray[n + 12], nArray[n + 13], this.textAnchors[nArray[n + 14] % 9]);
                if (this.endTestRequested) {
                    return;
                }
                this.pausePoint();
                --n;
            }
            this.interTestPoint();
        }

        class Rect {
            int x;
            int y;
            int width;
            int height;

            Rect() {
            }

            void getRect(int[] nArray, int n) {
                if (nArray[n] < nArray[n + 2]) {
                    this.x = nArray[n];
                    this.width = nArray[n + 2] - nArray[n];
                } else {
                    this.x = nArray[n + 2];
                    this.width = nArray[n] - nArray[n + 2];
                }
                if (nArray[n + 1] < nArray[n + 3]) {
                    this.y = nArray[n + 1];
                    this.height = nArray[n + 3] - nArray[n + 1];
                } else {
                    this.y = nArray[n + 3];
                    this.height = nArray[n + 1] - nArray[n + 3];
                }
            }
        }
    }
}

