/*
 * Decompiled with CFR 0.152.
 */
import apple.itunes.iTunesPlayer;
import com.motorola.funlight.FunLight;
import com.motorola.funlight.Region;
import com.motorola.itunes.idle.IdleStarter;
import com.motorola.synerj.ui.PrimaryDisplay;
import com.motorola.synerj.ui.UIGraphics;
import com.telecom.FileSystemAccessor;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class MediaViewer_IV
extends UIBase {
    private Image MV_Image;
    private Image MV_IV_BackStatusImage;
    private Image MV_IV_BGStatusImage;
    private String MV_StrError;
    private boolean MV_Info;
    private boolean MV_RotateRestored;
    private boolean MV_PrFolderExists;
    public boolean MV_bException;
    private int MV_OrigWidth;
    private int MV_OrigHeight;
    private int MV_Info_Witdth;
    private int MV_Info_Height;
    private int MV_ExtraScale;
    private int[] MV_WidthArray;
    private int[] MV_HeightArray;
    private int MV_CursorX;
    private int MV_CursorY;
    private int MV_Scale;
    private int MV_Mover;
    private int MV_MaxZoomIn;
    private int MV_Img_Rotate;
    public int MV_Select;
    private String MV_ReturnStatus;
    private String MV_FilePath;
    private String MV_FileName;
    private int MV_SettingsRestored;
    private Vector MV_FileList;
    public boolean MV_SaveParams;
    public boolean MV_MaxZoomFind;
    public boolean MV_PrTurnOn;
    public boolean MV_MaximumScreen;
    public boolean MV_SlideShow;
    public boolean MV_SlideState;
    public boolean MV_FillScreen;
    private PManGif MV_Gif;
    private iTunesPlayer MV_iTP = IdleStarter.player_;
    private PrimaryDisplay MV_PrimDisp;
    private static final int STATUSBAR_HEIGHT = PrimaryDisplay.getStatusAreaHeight();
    private Timer MV_IV_Timer;
    private boolean MV_FlashScreen;

    public MediaViewer_IV(String MV_Path, int MV_Selected, Vector MV_FileMatrix, boolean MV_PrFd) {
        this.MV_FilePath = MV_Path;
        this.MV_Select = MV_Selected;
        this.MV_FileList = MV_FileMatrix;
        this.MV_PrFolderExists = MV_PrFd;
        this.MV_MaxZoomIn = 1;
        this.MV_Mover = 20;
        this.MV_ExtraScale = 14;
    }

    private void MV_IV_CreateBackImage(UIGraphics MV_UI) {
        this.MV_IV_BackStatusImage = Image.createImage((int)this.getWidth(), (int)STATUSBAR_HEIGHT);
        UIGraphics MV_ImgUI = UIGraphics.getImageGraphics((Image)this.MV_IV_BackStatusImage, (UIGraphics)MV_UI);
        MV_ImgUI.fillBackground(0, 0);
        MV_ImgUI = null;
        this.MV_IV_BGStatusImage = Image.createImage((int)this.getWidth(), (int)STATUSBAR_HEIGHT);
        MV_ImgUI = UIGraphics.getImageGraphics((Image)this.MV_IV_BGStatusImage, (UIGraphics)MV_UI);
        MV_ImgUI.setColor(MediaViewer_Settings.MV_BGColor);
        MV_ImgUI.fillRect(0, 0, this.getWidth(), STATUSBAR_HEIGHT);
        MV_ImgUI = null;
    }

    public void paint(UIGraphics MV_UI) {
        if (this.MV_Image == null) {
            MV_UI.setColor(MediaViewer_Settings.MV_BGColor);
            MV_UI.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.MV_PaintText(MV_UI, MediaViewer_UI_Lang.MV_Lang[60], MediaViewer_Settings.MV_TextColor, 2, 2);
            this.MV_IV_CreateBackImage(MV_UI);
            return;
        }
        MV_UI.setColor(MediaViewer_Settings.MV_BGColor);
        MV_UI.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.MV_MaximumScreen) {
            if (this.MV_CursorY < 0) {
                PrimaryDisplay.setStatusWallpaper((Image)this.MV_Image, (int)this.MV_CursorX, (int)(this.MV_CursorY + STATUSBAR_HEIGHT));
            } else {
                PrimaryDisplay.setStatusWallpaper((Image)this.MV_IV_BGStatusImage, (int)0, (int)0);
            }
        }
        MV_UI.drawImage(this.MV_Image, this.MV_CursorX, this.MV_CursorY, 0);
        if (this.MV_Info) {
            this.MV_PaintText(MV_UI, MediaViewer_UI_Lang.MV_Lang[61] + ":", MediaViewer_Settings.MV_TextColor, 2, 2);
            this.MV_PaintText(MV_UI, "" + this.MV_Info_Witdth + "*" + this.MV_Info_Height, MediaViewer_Settings.MV_TextColor, 2, 20);
            this.MV_PaintText(MV_UI, MediaViewer_UI_Lang.MV_Lang[62] + ":", MediaViewer_Settings.MV_TextColor, 2, 38);
            this.MV_PaintText(MV_UI, "" + this.MV_Image.getWidth() + "*" + this.MV_Image.getHeight(), MediaViewer_Settings.MV_TextColor, 2, 56);
        }
        this.MV_SlideState = true;
    }

    private void MV_PaintText(UIGraphics MV_UI, String MV_Text, int MV_TextColor, int MV_PosX, int MV_PosY) {
        MV_UI.setColor(MV_TextColor);
        MV_UI.drawString(MV_Text, MV_PosX, MV_PosY, 0);
    }

    private void MV_ExceptionListener() {
        if (this.MV_bException) {
            this.stop();
        } else {
            this.repaint();
        }
    }

    private String MV_GetString(int i2) {
        String MV_TempString = null;
        if (i2 >= 0 && i2 < this.MV_FileList.size()) {
            MV_TempString = "" + this.MV_FileList.elementAt(i2);
        }
        return MV_TempString;
    }

    private Image MV_GetImage(String MV_ImagePath, int MV_TWidth, int MV_THeight, boolean MV_FirstLoad) {
        if (!new MediaViewer_LI(MV_ImagePath, MV_TWidth, MV_THeight).MV_LI_IfExists()) {
            this.MV_bException = true;
            this.MV_StrError = "File does not exist";
            return null;
        }
        if (MV_FirstLoad) {
            if (this.MV_PrFolderExists && this.MV_PrTurnOn) {
                int[] MV_LI_Params = new MediaViewer_LI(MV_ImagePath, MV_TWidth, MV_THeight).MV_LI_GetPreviewParams(this.MV_PrFolderExists);
                this.MV_OrigWidth = this.MV_Info_Witdth = MV_LI_Params[0];
                this.MV_OrigHeight = this.MV_Info_Height = MV_LI_Params[1];
                if (this.MV_SlideShow && this.MV_FillScreen) {
                    this.MV_OrigWidth = this.getWidth();
                    this.MV_OrigHeight = this.getHeight();
                    if (this.MV_MaximumScreen) {
                        this.MV_OrigHeight += STATUSBAR_HEIGHT;
                    }
                }
                MV_LI_Params = null;
            } else {
                MediaViewer_LI MV_LIImage = new MediaViewer_LI(MV_ImagePath, MV_TWidth, MV_THeight);
                if (MV_LIImage.MV_LI_ReadImage() == null) {
                    this.MV_bException = true;
                    this.MV_StrError = "Error of load";
                    MV_LIImage = null;
                    return null;
                }
                this.MV_OrigWidth = this.MV_Info_Witdth = MV_LIImage.MV_LI_GetWidth();
                this.MV_OrigHeight = this.MV_Info_Height = MV_LIImage.MV_LI_GetHeight();
                MV_LIImage = null;
            }
            this.MV_CreateImageScales();
            return null;
        }
        if (new MediaViewer_LI(MV_ImagePath, MV_TWidth, MV_THeight).MV_LI_CheckSize()) {
            return new MediaViewer_LI(MV_ImagePath, MV_TWidth, MV_THeight).MV_LI_ReadImage();
        }
        this.MV_bException = true;
        this.MV_StrError = MediaViewer_UI_Lang.MV_Lang[145];
        return null;
    }

    private void MV_ViewImage(String MV_TempImagePath) {
        if (this.MV_SlideShow && this.MV_IV_Timer == null) {
            this.MV_IV_StartTimer(-1L);
        }
        this.MV_SlideState = false;
        this.MV_ClearImageStats();
        this.MV_GetImage(MV_TempImagePath, 1, 1, true);
        if (this.MV_bException) {
            this.MV_ExceptionListener();
        } else {
            this.MV_ReLoadImage(MV_TempImagePath, false);
        }
    }

    private boolean MV_ReLoadImage(String MV_TempImagePath, boolean MV_IsScale) {
        this.MV_Image = null;
        if (this.MV_SettingsRestored == 0) {
            if (this.MV_PrFolderExists && this.MV_SaveParams) {
                if (this.MV_SET_RestoreImageSettings(MV_TempImagePath, this.MV_FileName)) {
                    this.MV_SettingsRestored = 1;
                } else {
                    this.MV_SettingsRestored = 2;
                    if (this.MV_MaxZoomFind) {
                        this.MV_Scale = this.MV_MaxZoomIn;
                    }
                }
            } else {
                this.MV_SettingsRestored = 2;
                if (this.MV_MaxZoomFind) {
                    this.MV_Scale = this.MV_MaxZoomIn;
                }
            }
        }
        if (this.MV_SlideShow && this.MV_FillScreen) {
            this.MV_Scale = 1;
        }
        this.MV_Image = this.MV_GetImage(MV_TempImagePath, this.MV_WidthArray[this.MV_Scale], this.MV_HeightArray[this.MV_Scale], false);
        if (this.MV_bException) {
            this.MV_ExceptionListener();
            return false;
        }
        if (this.MV_SettingsRestored > 1 || MV_IsScale || this.MV_SlideShow && this.MV_FillScreen) {
            this.MV_SetScaleCursor();
        }
        this.MV_ExceptionListener();
        return true;
    }

    private void MV_CreateImageScales() {
        int MV_TempImgProportion;
        int MV_TempProportion;
        int MV_MaxZoom_Height;
        int MV_MaxZoom_Width;
        int MV_ScreenWidth = this.getWidth();
        int MV_ScreenHeight = this.getHeight();
        if (this.MV_MaximumScreen) {
            MV_ScreenHeight += STATUSBAR_HEIGHT;
        }
        if (this.MV_OrigWidth > this.MV_OrigHeight) {
            MV_MaxZoom_Width = 320;
            MV_MaxZoom_Height = 240;
            MV_TempProportion = Math.abs(MV_MaxZoom_Width / MV_MaxZoom_Height);
            MV_TempImgProportion = Math.abs(this.MV_OrigWidth / this.MV_OrigHeight);
        } else {
            MV_MaxZoom_Width = 240;
            MV_MaxZoom_Height = 320;
            MV_TempProportion = Math.abs(MV_MaxZoom_Height / MV_MaxZoom_Width);
            MV_TempImgProportion = Math.abs(this.MV_OrigHeight / this.MV_OrigWidth);
        }
        if (this.MV_OrigWidth > MV_MaxZoom_Width || this.MV_OrigHeight > MV_MaxZoom_Height) {
            if (MV_TempImgProportion == MV_TempProportion) {
                this.MV_OrigWidth = MV_MaxZoom_Width;
                this.MV_OrigHeight = MV_MaxZoom_Height;
            } else {
                while (this.MV_OrigWidth > MV_MaxZoom_Width || this.MV_OrigHeight > MV_MaxZoom_Height) {
                    this.MV_OrigWidth = Math.abs(this.MV_OrigWidth / 2);
                    this.MV_OrigHeight = Math.abs(this.MV_OrigHeight / 2);
                }
            }
            int MV_Proportion = 2000;
            MV_Proportion = this.MV_OrigWidth > this.MV_OrigHeight ? this.MV_OrigWidth * 1000 / MV_ScreenWidth : this.MV_OrigHeight * 1000 / MV_ScreenHeight;
            int MV_FirstSCW = this.MV_OrigWidth * 1000 / MV_Proportion;
            int MV_FirstSCH = this.MV_OrigHeight * 1000 / MV_Proportion;
            int[] MV_Temp_WidthArray = new int[]{MV_FirstSCW, this.MV_OrigWidth};
            this.MV_WidthArray = MV_Temp_WidthArray;
            int[] MV_Temp_HeightArray = new int[]{MV_FirstSCH, this.MV_OrigHeight};
            this.MV_HeightArray = MV_Temp_HeightArray;
        } else if (this.MV_OrigWidth >= MV_ScreenWidth || this.MV_OrigHeight >= MV_ScreenHeight) {
            int MV_Proportion = 2000;
            MV_Proportion = this.MV_OrigWidth > this.MV_OrigHeight ? this.MV_OrigWidth * 1000 / MV_ScreenWidth : this.MV_OrigHeight * 1000 / MV_ScreenHeight;
            int MV_FirstSCW = this.MV_OrigWidth * 1000 / MV_Proportion;
            int MV_FirstSCH = this.MV_OrigHeight * 1000 / MV_Proportion;
            int[] MV_Temp_WidthArray = new int[]{MV_FirstSCW, this.MV_OrigWidth};
            this.MV_WidthArray = MV_Temp_WidthArray;
            int[] MV_Temp_HeightArray = new int[]{MV_FirstSCH, this.MV_OrigHeight};
            this.MV_HeightArray = MV_Temp_HeightArray;
        } else {
            int[] MV_Temp_WidthArray = new int[]{this.MV_OrigWidth, this.MV_OrigWidth * 2};
            this.MV_WidthArray = MV_Temp_WidthArray;
            int[] MV_Temp_HeightArray = new int[]{this.MV_OrigHeight, this.MV_OrigHeight * 2};
            this.MV_HeightArray = MV_Temp_HeightArray;
        }
    }

    private void MV_SetScaleCursor() {
        int MV_Temp_Width_IMCenter = Math.abs(this.MV_Image.getWidth() / 2);
        int MV_Temp_Height_IMCenter = Math.abs(this.MV_Image.getHeight() / 2);
        int MV_Temp_Width_SCCenter = Math.abs(this.getWidth() / 2);
        int MV_Temp_Height_SCCenter = Math.abs(this.getHeight() / 2);
        if (this.MV_MaximumScreen) {
            MV_Temp_Height_SCCenter -= STATUSBAR_HEIGHT / 2;
        }
        this.MV_CursorX = MV_Temp_Width_SCCenter - MV_Temp_Width_IMCenter;
        this.MV_CursorY = MV_Temp_Height_SCCenter - MV_Temp_Height_IMCenter;
    }

    private void MV_MoveCursor(int MV_ToMove) {
        int MV_Temp_Width_IM = this.MV_Image.getWidth();
        int MV_Temp_Height_IM = this.MV_Image.getHeight();
        int MV_Temp_Width_SC = this.getWidth();
        int MV_Temp_Height_SC = this.getHeight();
        int MV_Temp = 0;
        if (MV_ToMove == 1) {
            if (MV_Temp_Height_IM < MV_Temp_Height_SC) {
                MV_Temp = this.MV_CursorY + MV_Temp_Height_IM + this.MV_Mover;
                this.MV_CursorY = MV_Temp > MV_Temp_Height_SC ? MV_Temp_Height_SC - MV_Temp_Height_IM : (this.MV_CursorY += this.MV_Mover);
            }
            if (MV_Temp_Height_IM >= MV_Temp_Height_SC) {
                MV_Temp = this.MV_CursorY + this.MV_Mover;
                this.MV_CursorY = this.MV_MaximumScreen ? (MV_Temp > -STATUSBAR_HEIGHT ? -STATUSBAR_HEIGHT : (this.MV_CursorY += this.MV_Mover)) : (MV_Temp > 0 ? 0 : (this.MV_CursorY += this.MV_Mover));
            }
        }
        if (MV_ToMove == 2) {
            if (MV_Temp_Width_IM < MV_Temp_Width_SC) {
                MV_Temp = this.MV_CursorX + MV_Temp_Width_IM + this.MV_Mover;
                this.MV_CursorX = MV_Temp > MV_Temp_Width_SC ? MV_Temp_Width_SC - MV_Temp_Width_IM : (this.MV_CursorX += this.MV_Mover);
            }
            if (MV_Temp_Width_IM >= MV_Temp_Width_SC) {
                MV_Temp = this.MV_CursorX + this.MV_Mover;
                this.MV_CursorX = MV_Temp > 0 ? 0 : (this.MV_CursorX += this.MV_Mover);
            }
        }
        if (MV_ToMove == 3) {
            if (MV_Temp_Height_IM < MV_Temp_Height_SC) {
                MV_Temp = this.MV_CursorY - this.MV_Mover;
                this.MV_CursorY = this.MV_MaximumScreen ? (MV_Temp > -STATUSBAR_HEIGHT ? (this.MV_CursorY -= this.MV_Mover) : -STATUSBAR_HEIGHT) : (MV_Temp > 0 ? (this.MV_CursorY -= this.MV_Mover) : 0);
            }
            if (MV_Temp_Height_IM >= MV_Temp_Height_SC) {
                MV_Temp = MV_Temp_Height_IM + (this.MV_CursorY - this.MV_Mover);
                this.MV_CursorY = MV_Temp > MV_Temp_Height_SC ? (this.MV_CursorY -= this.MV_Mover) : -(MV_Temp_Height_IM - MV_Temp_Height_SC);
            }
        }
        if (MV_ToMove == 4) {
            if (MV_Temp_Width_IM < MV_Temp_Width_SC) {
                MV_Temp = this.MV_CursorX - this.MV_Mover;
                this.MV_CursorX = MV_Temp > 0 ? (this.MV_CursorX -= this.MV_Mover) : 0;
            }
            if (MV_Temp_Width_IM >= MV_Temp_Width_SC) {
                MV_Temp = MV_Temp_Width_IM + (this.MV_CursorX - this.MV_Mover);
                this.MV_CursorX = MV_Temp > MV_Temp_Width_SC ? (this.MV_CursorX -= this.MV_Mover) : -(MV_Temp_Width_IM - MV_Temp_Width_SC);
            }
        }
        this.repaint();
    }

    private void MV_RotareImage(int MV_Transform) {
        try {
            if (MV_Transform == 5) {
                ++this.MV_Img_Rotate;
            } else if (MV_Transform == 6) {
                this.MV_Img_Rotate += 3;
            }
            int MV_Temp_Width = this.MV_Image.getWidth();
            int MV_Temp_Height = this.MV_Image.getHeight();
            Image MV_TempImg = Image.createImage((int)MV_Temp_Width, (int)MV_Temp_Height);
            Graphics MV_Graphics = MV_TempImg.getGraphics();
            Sprite MV_Sprite = new Sprite(this.MV_Image);
            MV_Sprite.paint(MV_Graphics);
            this.MV_Image = Image.createImage((Image)MV_TempImg, (int)0, (int)0, (int)MV_Temp_Width, (int)MV_Temp_Height, (int)MV_Transform);
            MV_TempImg = null;
            MV_Graphics = null;
            MV_Sprite = null;
            this.MV_SetScaleCursor();
        }
        catch (Exception MV_Exception) {
            this.MV_StrError = MV_Exception.getMessage();
            this.MV_bException = true;
        }
        this.MV_ExceptionListener();
    }

    private void MV_ClearImageStats() {
        this.MV_CursorX = 0;
        this.MV_CursorY = 0;
        this.MV_Scale = 0;
        this.MV_WidthArray = null;
        this.MV_HeightArray = null;
        this.MV_Image = null;
        this.MV_OrigWidth = 0;
        this.MV_OrigHeight = 0;
        this.MV_bException = false;
        this.MV_Info = false;
        this.MV_Info_Witdth = 0;
        this.MV_Info_Height = 0;
        this.MV_SettingsRestored = 0;
        this.MV_Img_Rotate = 0;
        this.MV_RotateRestored = false;
        System.gc();
    }

    public String MV_GetImageStatus(boolean MV_IfIsError) {
        if (MV_IfIsError) {
            return this.MV_StrError;
        }
        return this.MV_ReturnStatus;
    }

    public int MV_GetImageSelected() {
        return this.MV_Select;
    }

    private boolean MV_GetIsItImage(String MV_ImageName) {
        return MV_ImageName.toUpperCase().endsWith(".JPG") || MV_ImageName.toUpperCase().endsWith(".JPEG") || MV_ImageName.toUpperCase().endsWith(".GIF") || MV_ImageName.toUpperCase().endsWith(".PNG");
    }

    public void loseFocus(PrimaryDisplay MV_PD) {
        this.MV_IV_StopTimer();
        PrimaryDisplay.setStatusWallpaper((Image)this.MV_IV_BackStatusImage, (int)0, (int)0);
    }

    public void gainFocus(PrimaryDisplay MV_PD) {
        if (this.MV_Gif != null) {
            this.MV_Gif = null;
            return;
        }
        if (this.MV_PrimDisp == null) {
            this.MV_PrimDisp = MV_PD;
        }
        this.MV_PrTurnOn = MediaViewer_UI_Init.MV_SET.MV_SET_GetSetting(0);
        this.MV_SaveParams = MediaViewer_UI_Init.MV_SET.MV_SET_GetSetting(1);
        this.MV_MaxZoomFind = MediaViewer_UI_Init.MV_SET.MV_SET_GetSetting(2);
        this.MV_MaximumScreen = MediaViewer_UI_Init.MV_SET.MV_SET_GetSetting(9);
        this.MV_SlideShow = MediaViewer_UI_Init.MV_SET.MV_SET_GetSetting(10);
        this.MV_FillScreen = MediaViewer_UI_Init.MV_SET.MV_SET_GetSetting(11);
        this.MV_FileName = this.MV_GetString(this.MV_Select);
        this.MV_ViewImage(this.MV_FilePath + this.MV_FileName);
    }

    public void destroyed(PrimaryDisplay MV_PD) {
        this.MV_IV_StopTimer();
        this.MV_FlashScreenOFF();
        PrimaryDisplay.setStatusWallpaper((Image)this.MV_IV_BackStatusImage, (int)0, (int)0);
        this.MV_ClearImageStats();
    }

    public void onKeyDown(int MV_Key) {
    }

    public void onKeyLongPress(int MV_Key) {
        block7: {
            block6: {
                if (this.MV_iTP.getState() == 1) break block6;
                if (this.MV_iTP.getState() != 2) break block7;
            }
            if (MV_Key == -100) {
                this.MV_iTP.goToPreviousTrack();
            } else if (MV_Key == -101) {
                this.MV_iTP.goToNextTrack();
            }
        }
    }

    public void onKeyReleased(int MV_Key) {
    }

    public void onKeyRepeated(int MV_Key) {
    }

    public void onKeyShortPress(int MV_Key) {
        block71: {
            block70: {
                if (this.MV_iTP.getState() == 1) break block70;
                if (this.MV_iTP.getState() != 2) break block71;
            }
            if (MV_Key == -100) {
                int j2 = this.MV_iTP.getVolume();
                if (this.MV_iTP.getMaxVolume() > j2) {
                    this.MV_iTP.setVolume(++j2);
                } else {
                    this.MV_iTP.setVolume(j2);
                }
                return;
            }
            if (MV_Key == -101) {
                int k2 = this.MV_iTP.getVolume();
                if (this.MV_iTP.getMinVolume() < k2) {
                    this.MV_iTP.setVolume(--k2);
                } else {
                    this.MV_iTP.setVolume(k2);
                }
                return;
            }
        }
        if (MV_Key == -20 || MV_Key == 48) {
            if (this.MV_PrFolderExists && this.MV_SaveParams) {
                this.MV_SET_SaveImageSettings(this.MV_FilePath + this.MV_FileName, this.MV_FileName);
            }
            this.stop();
        } else if (MV_Key == -1 || MV_Key == 51) {
            ++this.MV_Scale;
            if (this.MV_Scale > this.MV_MaxZoomIn) {
                if (this.MV_Scale > this.MV_MaxZoomIn) {
                    this.MV_Scale = this.MV_MaxZoomIn;
                }
            } else if (!this.MV_ReLoadImage(this.MV_FilePath + this.MV_GetString(this.MV_Select), true)) {
                --this.MV_Scale;
            }
        } else if (MV_Key == -6 || MV_Key == 57) {
            --this.MV_Scale;
            if (this.MV_Scale < 0) {
                if (this.MV_Scale < 0) {
                    this.MV_Scale = 0;
                }
            } else {
                this.MV_ReLoadImage(this.MV_FilePath + this.MV_GetString(this.MV_Select), true);
            }
        } else if (MV_Key == 52) {
            this.MV_MoveCursor(2);
        } else if (MV_Key == 54) {
            this.MV_MoveCursor(4);
        } else if (MV_Key == 50) {
            this.MV_MoveCursor(1);
        } else if (MV_Key == 56) {
            this.MV_MoveCursor(3);
        } else if (MV_Key == -21) {
            this.MV_RotareImage(6);
        } else if (MV_Key == -22) {
            this.MV_RotareImage(5);
        } else if (MV_Key == -2) {
            String MV_TempString = "";
            --this.MV_Select;
            if (this.MV_Select >= 1 && this.MV_Select < this.MV_FileList.size()) {
                if (this.MV_Select != -1) {
                    MV_TempString = this.MV_GetString(this.MV_Select);
                }
            } else if (this.MV_Select < 1) {
                this.MV_Select = this.MV_FileList.size() - 1;
                if (this.MV_Select != -1) {
                    MV_TempString = this.MV_GetString(this.MV_Select);
                }
            }
            if (MV_TempString != "") {
                if (MV_TempString.endsWith("/") || !this.MV_GetIsItImage(MV_TempString)) {
                    this.onKeyShortPress(-2);
                } else {
                    if (this.MV_PrFolderExists && this.MV_SaveParams) {
                        this.MV_SET_SaveImageSettings(this.MV_FilePath + this.MV_FileName, this.MV_FileName);
                    }
                    this.MV_FileName = MV_TempString;
                    this.MV_ClearImageStats();
                    this.MV_ViewImage(this.MV_FilePath + MV_TempString);
                }
            }
        } else if (MV_Key == -5) {
            String MV_TempString = "";
            ++this.MV_Select;
            if (this.MV_Select >= 1 && this.MV_Select < this.MV_FileList.size()) {
                if (this.MV_Select != -1) {
                    MV_TempString = this.MV_GetString(this.MV_Select);
                }
            } else if (this.MV_Select >= this.MV_FileList.size()) {
                this.MV_Select = 1;
                if (this.MV_Select != -1) {
                    MV_TempString = this.MV_GetString(this.MV_Select);
                }
            }
            if (MV_TempString != "") {
                if (MV_TempString.endsWith("/") || !this.MV_GetIsItImage(MV_TempString)) {
                    this.onKeyShortPress(-5);
                } else {
                    if (this.MV_PrFolderExists && this.MV_SaveParams) {
                        this.MV_SET_SaveImageSettings(this.MV_FilePath + this.MV_FileName, this.MV_FileName);
                    }
                    this.MV_FileName = MV_TempString;
                    this.MV_ClearImageStats();
                    this.MV_ViewImage(this.MV_FilePath + MV_TempString);
                }
            }
        } else if (MV_Key == 53) {
            this.MV_Info = !this.MV_Info;
            this.repaint();
        } else if (MV_Key == 42) {
            if (this.MV_SlideShow) {
                this.MV_SlideShow = false;
                this.MV_FlashScreenOFF();
                this.MV_IV_StopTimer();
            } else {
                this.MV_SlideShow = true;
                this.MV_FlashScreenON();
                this.MV_IV_StartTimer(0L);
            }
        } else if (MV_Key == 49) {
            if (this.MV_FlashScreen) {
                this.MV_FlashScreenOFF();
            } else {
                this.MV_FlashScreenON();
            }
        } else if (MV_Key == 35) {
            if (!this.MV_GetString(this.MV_Select).toUpperCase().endsWith(".GIF")) {
                return;
            }
            this.MV_Gif = new PManGif(this.MV_FilePath + this.MV_GetString(this.MV_Select));
            this.MV_Gif.start();
        }
    }

    public void MV_SET_SaveImageSettings(String MV_ImagePath, String MV_ImageName) {
        FileSystemAccessor MV_fs = new FileSystemAccessor(MediaViewer_Settings.MV_SavePrPath + new MediaViewer_PW(MV_ImagePath, MV_ImageName, true).MV_PW_GetPWImageName() + MediaViewer_Settings.MV_Pr);
        if (MV_fs.exists()) {
            byte[] MV_PR_Byte = MV_fs.read();
            int MV_ByteCounter = MV_PR_Byte.length - 1;
            MV_PR_Byte[MV_ByteCounter] = (byte)(0xFF & this.MV_CursorX >> 24);
            MV_PR_Byte[--MV_ByteCounter] = (byte)(0xFF & this.MV_CursorX >> 16);
            MV_PR_Byte[--MV_ByteCounter] = (byte)(0xFF & this.MV_CursorX >> 8);
            MV_PR_Byte[--MV_ByteCounter] = (byte)(0xFF & this.MV_CursorX);
            MV_PR_Byte[--MV_ByteCounter] = (byte)(0xFF & this.MV_CursorY >> 24);
            MV_PR_Byte[--MV_ByteCounter] = (byte)(0xFF & this.MV_CursorY >> 16);
            MV_PR_Byte[--MV_ByteCounter] = (byte)(0xFF & this.MV_CursorY >> 8);
            MV_PR_Byte[--MV_ByteCounter] = (byte)(0xFF & this.MV_CursorY);
            MV_PR_Byte[--MV_ByteCounter] = (byte)(0xFF & this.MV_Scale >> 24);
            MV_PR_Byte[--MV_ByteCounter] = (byte)(0xFF & this.MV_Scale >> 16);
            MV_PR_Byte[--MV_ByteCounter] = (byte)(0xFF & this.MV_Scale >> 8);
            MV_PR_Byte[--MV_ByteCounter] = (byte)(0xFF & this.MV_Scale);
            --MV_ByteCounter;
            MV_fs.write(MV_PR_Byte);
            MV_ByteCounter = 0;
            MV_PR_Byte = null;
        }
        MV_fs = null;
        this.MV_ClearImageStats();
    }

    public boolean MV_SET_RestoreImageSettings(String MV_ImagePath, String MV_ImageName) {
        FileSystemAccessor MV_fs = new FileSystemAccessor(MediaViewer_Settings.MV_SavePrPath + new MediaViewer_PW(MV_ImagePath, MV_ImageName, true).MV_PW_GetPWImageName() + MediaViewer_Settings.MV_Pr);
        if (MV_fs.exists()) {
            byte[] MV_PR_Byte = MV_fs.read();
            int MV_ByteCounter = MV_PR_Byte.length - 1;
            byte MV_B1 = MV_PR_Byte[MV_ByteCounter];
            byte MV_B2 = MV_PR_Byte[--MV_ByteCounter];
            byte MV_B3 = MV_PR_Byte[--MV_ByteCounter];
            byte MV_B4 = MV_PR_Byte[--MV_ByteCounter];
            this.MV_CursorX = (MV_B1 & 0xFF) << 24 | (MV_B2 & 0xFF) << 16 | (MV_B3 & 0xFF) << 8 | MV_B4 & 0xFF;
            MV_B1 = MV_PR_Byte[--MV_ByteCounter];
            MV_B2 = MV_PR_Byte[--MV_ByteCounter];
            MV_B3 = MV_PR_Byte[--MV_ByteCounter];
            MV_B4 = MV_PR_Byte[--MV_ByteCounter];
            this.MV_CursorY = (MV_B1 & 0xFF) << 24 | (MV_B2 & 0xFF) << 16 | (MV_B3 & 0xFF) << 8 | MV_B4 & 0xFF;
            MV_B1 = MV_PR_Byte[--MV_ByteCounter];
            MV_B2 = MV_PR_Byte[--MV_ByteCounter];
            MV_B3 = MV_PR_Byte[--MV_ByteCounter];
            MV_B4 = MV_PR_Byte[--MV_ByteCounter];
            --MV_ByteCounter;
            this.MV_Scale = (MV_B1 & 0xFF) << 24 | (MV_B2 & 0xFF) << 16 | (MV_B3 & 0xFF) << 8 | MV_B4 & 0xFF;
            MV_ByteCounter = 0;
            MV_PR_Byte = null;
            MV_fs = null;
            return this.MV_CursorX > 0 || this.MV_CursorY > 0 || this.MV_Scale > 0;
        }
        MV_fs = null;
        return false;
    }

    private void MV_IV_StartTimer(long MV_IV_StartAt) {
        if (this.MV_IV_Timer == null) {
            this.MV_IV_Timer = new Timer();
            if (MV_IV_StartAt > -1L) {
                this.MV_IV_Timer.scheduleAtFixedRate((TimerTask)new MediaViewer_TTT(null, this, null), MV_IV_StartAt, 5000L);
            } else {
                this.MV_IV_Timer.scheduleAtFixedRate((TimerTask)new MediaViewer_TTT(null, this, null), 5000L, 5000L);
            }
        }
    }

    private void MV_IV_StopTimer() {
        if (this.MV_IV_Timer != null) {
            this.MV_IV_Timer.cancel();
            this.MV_IV_Timer = null;
        }
    }

    private void MV_FlashScreenON() {
        Region MV_Display = FunLight.getRegion((int)1);
        MV_Display.setColor(FunLight.ON);
        MV_Display.getControl();
        this.MV_FlashScreen = true;
    }

    private void MV_FlashScreenOFF() {
        FunLight.releaseControl();
        this.MV_FlashScreen = false;
    }
}

