/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;

public final class MediaViewer_YSMS_B64 {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int SIGN = -128;
    private static final byte PAD = 61;
    private static byte[] base64Alphabet;
    private static byte[] lookUpBase64Alphabet;

    public static String encode(String s2) {
        return new String(MediaViewer_YSMS_B64.encode(MediaViewer_YSMS_B64.getBytes(s2)));
    }

    static byte[] getBytes(String s2) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeUTF(s2);
            return baos.toByteArray();
        }
        catch (Exception e2) {
            return null;
        }
    }

    static byte[] encode(byte[] binaryData) {
        byte val2;
        byte val1;
        int lengthDataBits = binaryData.length * 8;
        int fewerThan24bits = lengthDataBits % 24;
        int numberTriplets = lengthDataBits / 24;
        byte[] encodedData = null;
        encodedData = fewerThan24bits != 0 ? new byte[(numberTriplets + 1) * 4] : new byte[numberTriplets * 4];
        byte k2 = 0;
        byte l2 = 0;
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        int encodedIndex = 0;
        int dataIndex = 0;
        int i2 = 0;
        for (i2 = 0; i2 < numberTriplets; ++i2) {
            dataIndex = i2 * 3;
            b1 = binaryData[dataIndex];
            b2 = binaryData[dataIndex + 1];
            b3 = binaryData[dataIndex + 2];
            l2 = (byte)(b2 & 0xF);
            k2 = (byte)(b1 & 3);
            encodedIndex = i2 * 4;
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            byte val3 = (b3 & 0xFFFFFF80) == 0 ? (byte)(b3 >> 6) : (byte)(b3 >> 6 ^ 0xFC);
            encodedData[encodedIndex] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[val2 | k2 << 4];
            encodedData[encodedIndex + 2] = lookUpBase64Alphabet[l2 << 2 | val3];
            encodedData[encodedIndex + 3] = lookUpBase64Alphabet[b3 & 0x3F];
        }
        dataIndex = i2 * 3;
        encodedIndex = i2 * 4;
        if (fewerThan24bits == 8) {
            b1 = binaryData[dataIndex];
            k2 = (byte)(b1 & 3);
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            encodedData[encodedIndex] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[k2 << 4];
            encodedData[encodedIndex + 2] = 61;
            encodedData[encodedIndex + 3] = 61;
        } else if (fewerThan24bits == 16) {
            b1 = binaryData[dataIndex];
            b2 = binaryData[dataIndex + 1];
            l2 = (byte)(b2 & 0xF);
            k2 = (byte)(b1 & 3);
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            encodedData[encodedIndex] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[val2 | k2 << 4];
            encodedData[encodedIndex + 2] = lookUpBase64Alphabet[l2 << 2];
            encodedData[encodedIndex + 3] = 61;
        }
        return encodedData;
    }

    static {
        int i2;
        base64Alphabet = new byte[255];
        lookUpBase64Alphabet = new byte[64];
        for (i2 = 0; i2 < 255; ++i2) {
            MediaViewer_YSMS_B64.base64Alphabet[i2] = -1;
        }
        for (i2 = 90; i2 >= 65; --i2) {
            MediaViewer_YSMS_B64.base64Alphabet[i2] = (byte)(i2 - 65);
        }
        for (i2 = 122; i2 >= 97; --i2) {
            MediaViewer_YSMS_B64.base64Alphabet[i2] = (byte)(i2 - 97 + 26);
        }
        for (i2 = 57; i2 >= 48; --i2) {
            MediaViewer_YSMS_B64.base64Alphabet[i2] = (byte)(i2 - 48 + 52);
        }
        MediaViewer_YSMS_B64.base64Alphabet[43] = 62;
        MediaViewer_YSMS_B64.base64Alphabet[47] = 63;
        for (i2 = 0; i2 <= 25; ++i2) {
            MediaViewer_YSMS_B64.lookUpBase64Alphabet[i2] = (byte)(65 + i2);
        }
        i2 = 26;
        int j2 = 0;
        while (i2 <= 51) {
            MediaViewer_YSMS_B64.lookUpBase64Alphabet[i2] = (byte)(97 + j2);
            ++i2;
            ++j2;
        }
        i2 = 52;
        j2 = 0;
        while (i2 <= 61) {
            MediaViewer_YSMS_B64.lookUpBase64Alphabet[i2] = (byte)(48 + j2);
            ++i2;
            ++j2;
        }
        MediaViewer_YSMS_B64.lookUpBase64Alphabet[62] = 43;
        MediaViewer_YSMS_B64.lookUpBase64Alphabet[63] = 47;
    }
}

