/*
 * Decompiled with CFR 0.152.
 */
import com.motorola.synerj.ui.PrimaryDisplay;
import com.motorola.synerj.ui.UIGraphics;
import com.telecom.FileSystemAccessor;
import java.io.IOException;
import java.util.Calendar;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.RecordControl;
import javax.microedition.media.control.VolumeControl;

public class Recorder
extends UIBase
implements PlayerListener,
Runnable {
    private String path = "/b/";
    private Player player;
    private RecordControl rc;
    private String lastName = "";
    private VolumeControl vc;
    private int level = 100;
    private String state = "closed";
    private Image imageCP;
    private Image imageState;
    private Thread thread = null;
    private boolean terminated = true;
    private long startRec = -1L;
    private Vector list = new Vector();
    private int current = 0;
    private int first = 0;
    private Image sb;
    private Image sbUp;
    private Image sbDown;
    private Image sbSeek;

    public Recorder(PrimaryDisplay primaryDisplay) {
        try {
            this.imageCP = Image.createImage((String)"/res/reccp.png");
            this.imageState = Image.createImage((String)"/res/recstate.png");
            this.sb = Image.createImage((String)"/res/sb.png");
            this.sbUp = Image.createImage((String)"/res/sbup.png");
            this.sbDown = Image.createImage((String)"/res/sbdown.png");
            this.sbSeek = Image.createImage((String)"/res/sbseek.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.createList();
    }

    public void paint(UIGraphics uIGraphics) {
        int n2 = DrawString.height + 2;
        uIGraphics.setColor(Skin.colorBackground);
        uIGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        UIBase.drawBox(uIGraphics, 0, 0, this.getWidth(), this.getHeight() - this.imageCP.getHeight());
        DrawString.drawString(uIGraphics, "Close", 4, this.getHeight() - n2 - 4);
        uIGraphics.drawImage(this.imageCP, 0, this.getHeight() - this.imageCP.getHeight(), 0);
        int n3 = 78;
        int n4 = 41;
        if (this.state.equals("started")) {
            n4 = 15;
        } else if (this.state.equals("recordStarted")) {
            n4 = 2;
        } else if (this.state.equals("stopped")) {
            n4 = 28;
        }
        uIGraphics.drawImage(this.imageState, n3, n4 += this.getHeight() - this.imageCP.getHeight(), 0);
        if (this.player != null) {
            if (this.state.equals("started")) {
                int n5;
                String string;
                int n6;
                int n7;
                long l2 = this.player.getMediaTime();
                if (l2 != -1L) {
                    n7 = (int)((l2 /= 1000000L) / 60L);
                    n6 = (int)(l2 % 60L);
                    string = this.parseDigit(n7) + ":" + this.parseDigit(n6);
                    n5 = DrawString.stringWidth(string);
                    DrawString.drawString(uIGraphics, string, 124 + (52 - n5) / 2, this.getHeight() - this.imageCP.getHeight() + 30 - DrawString.height / 2);
                }
                if ((l2 = this.player.getDuration()) != -1L) {
                    n7 = (int)((l2 /= 1000000L) / 60L);
                    n6 = (int)(l2 % 60L);
                    string = this.parseDigit(n7) + ":" + this.parseDigit(n6);
                    n5 = DrawString.stringWidth(string);
                    DrawString.drawString(uIGraphics, string, 124 + (52 - n5) / 2, this.getHeight() - this.imageCP.getHeight() + 17 - DrawString.height / 2);
                }
            } else if (this.state.equals("recordStarted")) {
                long l3 = (System.currentTimeMillis() - this.startRec) / 1000L;
                int n8 = (int)(l3 / 60L);
                int n9 = (int)(l3 % 60L);
                String string = this.parseDigit(n8) + ":" + this.parseDigit(n9);
                int n10 = DrawString.stringWidth(string);
                DrawString.drawString(uIGraphics, string, 124 + (52 - n10) / 2, 172);
            } else if (this.state.equals("volumeChanged")) {
                if (this.vc != null) {
                    long l4 = this.vc.getLevel();
                    String string = l4 + "%";
                    int n11 = DrawString.stringWidth(string);
                    DrawString.drawString(uIGraphics, string, 124 + (52 - n11) / 2, 172);
                }
                this.state = "started";
            } else {
                String string = "--:--";
                int n12 = DrawString.stringWidth(string);
                DrawString.drawString(uIGraphics, string, 124 + (52 - n12) / 2, 172);
            }
        }
        this.paintList(uIGraphics);
    }

    public void loseFocus(PrimaryDisplay primaryDisplay) {
        this.stopPlayer();
    }

    public void gainFocus(PrimaryDisplay primaryDisplay) {
        UIBase.getiTunesPlayer().stop();
    }

    public void destroyed(PrimaryDisplay primaryDisplay) {
        this.stopPlayer();
    }

    public void onKeyDown(int n2) {
    }

    public void onKeyLongPress(int n2) {
        if (n2 == 55) {
            this.stopPlayer();
            if (this.list != null && this.list.size() > 0) {
                FileSystemAccessor fileSystemAccessor = new FileSystemAccessor("" + this.list.elementAt(this.current));
                fileSystemAccessor.delete();
                fileSystemAccessor = null;
                this.list.removeElementAt(this.current);
                if (this.current >= this.list.size()) {
                    int n3 = (this.getHeight() - this.imageCP.getHeight() - 12) / DrawString.height;
                    this.current = this.list.size() - 1;
                    this.first = Math.max(this.current - n3, 0);
                }
                this.repaint();
            }
        }
    }

    public void onKeyReleased(int n2) {
    }

    public void onKeyRepeated(int n2) {
        if (n2 == -1) {
            this.onKeyShortPress(n2);
        } else if (n2 == -6) {
            this.onKeyShortPress(n2);
        }
    }

    public void onKeyShortPress(int n2) {
        int n3 = (this.getHeight() - this.imageCP.getHeight() - 12) / DrawString.height;
        if (this.vc != null) {
            switch (n2) {
                case -100: {
                    this.level += 10;
                    this.level = this.level <= 100 ? this.level : 100;
                    this.vc.setLevel(this.level);
                    break;
                }
                case -101: {
                    this.level -= 10;
                    this.level = this.level < 0 ? 0 : this.level;
                    this.vc.setLevel(this.level);
                }
            }
        }
        if (n2 == 48) {
            this.stop();
        } else if (n2 == 49) {
            this.lastName = this.path + this.getName();
            this.startRecord(this.lastName);
        } else if (n2 == 50) {
            this.stopPlayer();
        } else if (n2 == 51) {
            this.play(this.lastName);
        } else if (n2 == 53) {
            this.pause();
        } else if (n2 == -1) {
            if (this.list != null) {
                --this.current;
                if (this.current < 0) {
                    this.current = this.list.size() - 1;
                    this.first = Math.max(this.current - n3 + 1, 0);
                } else if (this.current < this.first) {
                    --this.first;
                }
            }
        } else if (n2 == -6) {
            if (this.list != null) {
                ++this.current;
                if (this.current >= this.list.size()) {
                    this.current = 0;
                    this.first = 0;
                } else if (this.current > this.first + n3 - 1) {
                    ++this.first;
                }
            }
        } else if (n2 == -20) {
            if (this.list != null && this.list.size() > 0) {
                this.play("" + this.list.elementAt(this.current));
            }
        } else if (n2 == -2) {
            int n4 = 0;
            while (n4 < 10) {
                this.onKeyShortPress(-1);
                ++n4;
            }
        } else if (n2 == -5) {
            int n5 = 0;
            while (n5 < 10) {
                this.onKeyShortPress(-6);
                ++n5;
            }
        } else if (n2 == 52) {
            this.moveBack();
        } else if (n2 == 54) {
            this.moveForward();
        }
        this.repaint();
    }

    private void moveBack() {
        block3: {
            try {
                if (this.player == null || this.rc != null || this.player.getState() != 400) break block3;
                long l2 = this.player.getMediaTime();
                long l3 = this.player.getDuration();
                if (l2 != -1L && l3 != -1L) {
                    l2 = (l2 -= l3 / 10L) < 0L ? 0L : l2;
                    this.player.setMediaTime(l2);
                }
            }
            catch (Exception exception) {}
        }
    }

    private void moveForward() {
        block3: {
            try {
                if (this.player == null || this.rc != null || this.player.getState() != 400) break block3;
                long l2 = this.player.getMediaTime();
                long l3 = this.player.getDuration();
                if (l2 != -1L && l3 != -1L) {
                    l2 = (l2 += l3 / 10L) > l3 - l3 / 10L ? l3 - l3 / 10L : l2;
                    this.player.setMediaTime(l2);
                }
            }
            catch (Exception exception) {}
        }
    }

    private void startRecord(String string) {
        this.stopPlayer();
        try {
            FileSystemAccessor fileSystemAccessor = new FileSystemAccessor(this.path);
            long l2 = fileSystemAccessor.availableSize();
            fileSystemAccessor = null;
            this.player = Manager.createPlayer((String)"capture://audio");
            this.player.realize();
            this.player.addPlayerListener((PlayerListener)this);
            this.rc = (RecordControl)this.player.getControl("RecordControl");
            this.rc.setRecordLocation("file:/" + string);
            this.rc.setRecordSizeLimit((int)l2);
            this.rc.startRecord();
            this.player.start();
            this.startRec = System.currentTimeMillis();
            this.terminated = false;
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.start();
            this.list.addElement(string);
            this.current = this.list.size() - 1;
            int n2 = (this.getHeight() - this.imageCP.getHeight() - 12) / DrawString.height;
            this.first = Math.max(this.current - n2 + 1, 0);
        }
        catch (Exception exception) {
            this.player = null;
            this.rc = null;
        }
    }

    private void play(String string) {
        block2: {
            this.stopPlayer();
            if (string.equals("")) break block2;
            try {
                this.player = Manager.createPlayer((String)("file:/" + string));
                this.player.realize();
                this.player.prefetch();
                this.player.addPlayerListener((PlayerListener)this);
                this.vc = (VolumeControl)this.player.getControl("VolumeControl");
                this.vc.setLevel(this.level);
                this.player.start();
                this.terminated = false;
                this.thread = new Thread(this);
                this.thread.setPriority(1);
                this.thread.start();
            }
            catch (Exception exception) {
                this.player = null;
            }
        }
    }

    private void pause() {
        block5: {
            try {
                if (this.player == null || this.rc != null) break block5;
                if (this.player.getState() == 400) {
                    this.player.stop();
                } else if (this.player.getState() == 300) {
                    this.player.start();
                }
            }
            catch (MediaException mediaException) {}
        }
    }

    private void commit() {
        if (this.rc != null) {
            try {
                this.rc.commit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rc = null;
        }
        this.startRec = -1L;
    }

    private void stopPlayer() {
        block6: {
            this.commit();
            if (this.vc != null) {
                this.level = this.vc.getLevel();
                this.level = this.level < 0 ? 100 : this.level;
                this.vc = null;
            }
            if (this.player != null) {
                try {
                    this.player.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.player.close();
                this.player = null;
            }
            this.terminated = true;
            if (this.thread == null) break block6;
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private String getName() {
        String string = "rec_";
        Calendar calendar = Calendar.getInstance();
        string = string + this.parseDigit(calendar.get(2) + 1);
        string = string + this.parseDigit(calendar.get(5));
        string = string + this.parseDigit(calendar.get(11));
        string = string + this.parseDigit(calendar.get(12));
        string = string + this.parseDigit(calendar.get(13));
        string = string + ".amr";
        calendar = null;
        return string;
    }

    private String parseDigit(int n2) {
        return n2 < 10 ? "0" + n2 : "" + n2;
    }

    public void playerUpdate(Player player, String string, Object object) {
        this.state = string;
        if (player == this.player) {
            if (string.equals("endOfMedia")) {
                this.stopPlayer();
            } else if (string.equals("recordError") || string.equals("error")) {
                this.stopPlayer();
            }
        }
        this.repaint();
    }

    public void run() {
        while (!this.terminated) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.repaint();
        }
        this.thread = null;
    }

    private void createList() {
        this.list.removeAllElements();
        this.current = 0;
        this.first = 0;
        FileSystemAccessor fileSystemAccessor = new FileSystemAccessor(this.path);
        String[] stringArray = fileSystemAccessor.list();
        fileSystemAccessor = null;
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].toUpperCase().endsWith(".AMR")) {
                    this.list.addElement(stringArray[n2]);
                }
                ++n2;
            }
        }
    }

    public void paintList(UIGraphics uIGraphics) {
        int n2 = 4;
        int n3 = 4;
        int n4 = this.getWidth() - 4;
        int n5 = this.getHeight() - this.imageCP.getHeight() - 4;
        uIGraphics.setColor(255, 255, 255);
        uIGraphics.fillRect(n2, n3, n4 - n2, n5 - n3);
        uIGraphics.setColor(128, 128, 128);
        uIGraphics.drawLine(n4, n5, n4, n3);
        uIGraphics.drawLine(n4, n5, n2, n5);
        uIGraphics.setColor(0, 0, 0);
        uIGraphics.drawLine(n2, n3, n4, n3);
        uIGraphics.drawLine(n2, n3, n2, n5);
        if (this.list != null && this.list.size() > 0) {
            int n6 = this.sb.getWidth();
            int n7 = this.sb.getHeight();
            n2 += 2;
            n4 -= 2;
            int n8 = DrawString.height;
            int n9 = n3 += 2;
            int n10 = (n5 -= 2) - n8;
            int n11 = this.first;
            while (n11 < this.list.size()) {
                if (n9 > n10) break;
                if (n11 == this.current) {
                    uIGraphics.setColor(128, 128, 255);
                    uIGraphics.fillRect(n2, n9, n4 - n2, n8);
                }
                uIGraphics.setClip(n2, n9, n4 - n2, n8);
                String string = "" + this.list.elementAt(n11);
                string = string.substring(string.lastIndexOf(47) + 1);
                DrawString.drawString(uIGraphics, string, n2, n9);
                uIGraphics.setClip(0, 0, this.getWidth(), this.getHeight());
                string = null;
                n9 += n8;
                ++n11;
            }
            uIGraphics.setClip(n4 + 1 - n6, n3, n6, this.getHeight() - this.imageCP.getHeight() - 12);
            n9 = n3;
            while (n9 < n5) {
                uIGraphics.drawImage(this.sb, n4 + 1 - n6, n9, 0);
                n9 += n7;
            }
            uIGraphics.setClip(0, 0, this.getWidth(), this.getHeight());
            uIGraphics.drawImage(this.sbUp, n4 + 1 - n6, n3, 0);
            uIGraphics.drawImage(this.sbDown, n4 + 1 - n6, n5 - n7, 0);
            if (this.list.size() > 1) {
                n9 = n3 + n7 + this.current * (this.getHeight() - this.imageCP.getHeight() - 12 - n7 - n7 - this.sbSeek.getHeight()) / (this.list.size() - 1);
                uIGraphics.drawImage(this.sbSeek, n4 + 1 - n6, n9, 0);
            }
        }
    }
}

