/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.itunes.idle;

import com.motorola.itunes.idle.IdleHomeKeys;
import com.motorola.itunes.idle.IdleScreenApp;
import com.motorola.synerj.svc.auf.ResourceManager;
import com.motorola.synerj.svc.user.HomeScreen;
import com.motorola.synerj.svc.user.HomeScreenListener;
import com.motorola.synerj.svc.user.Settings;
import com.motorola.synerj.ui.Colors;
import com.motorola.synerj.ui.PrimaryView;
import com.motorola.synerj.ui.Skin;
import com.motorola.synerj.ui.UIGraphics;
import com.motorola.synerj.ui.widget.Area;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;

public class IdleClock
implements HomeScreenListener {
    private Area analogArea;
    private Area digitArea;
    private int minHandColor;
    private int minShadowHandColor;
    private int hourHandColor;
    private int hourShadowHandColor;
    private int hourHandLength;
    private int minHandLength;
    private Image clockFaceImage;
    private int textColor = Colors.get((int)7);
    private boolean isOutlined;
    private boolean isUnderline;
    private int outlinedLevels;
    private int outlinedInnerColor;
    private int outlinedOuterColor;
    private int justification;
    private static final int[] cos = new int[]{1000, 995, 978, 951, 914, 866, 809, 743, 669, 588, 500, 406, 309, 208, 105, 0};
    private static final int COS_FACTOR = 1000;
    private static final int QUARTERS_PER_CYCLE = 4;
    public static final int HOURS_PER_CYCLE = 12;
    public static final int MIN_PER_CYCLE = 60;
    private static final int PARTITIONS_PER_QUARTER = 15;
    private static final int PARTITIONS_PER_HOUR = 5;
    private static final int CENTER = 0;
    private static final int RIGHT = 1;
    private static final int LEFT = 2;
    private static final long CLOCK_UPDATE_PERIOD = 20000L;
    private int clockAppearance;
    private static int[] argbColors = new int[]{0};
    private static final boolean debug_ = false;
    private static PrimaryView view_;
    private static Timer clock_update_timer_;

    public IdleClock(PrimaryView primaryView) {
        this.updateClockAppearance();
        view_ = primaryView;
        HomeScreen.getInstance().addListener((HomeScreenListener)this);
    }

    public void updateClockAppearance() {
        this.clockAppearance = HomeScreen.getClockAppearance();
        this.updateClockProperties();
    }

    private void updateClockProperties() {
        try {
            switch (this.clockAppearance) {
                case 1: {
                    this.updateDigitProperties();
                    break;
                }
                case 0: {
                    this.updateAnalogProperties();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid clock Appearance: " + this.clockAppearance);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(this.getClass().getName() + ".updateClockProperties() " + illegalArgumentException);
        }
    }

    private void updateDigitProperties() {
        this.textColor = Skin.getColorProperty((int)60);
        this.isOutlined = Skin.getBooleanProperty((int)56);
        this.isUnderline = Skin.getBooleanProperty((int)59);
        this.digitArea = Skin.getAreaProperty((int)47);
        this.justification = 2;
        if (this.isOutlined) {
            this.outlinedLevels = this.isOutlined ? Skin.getIntProperty((int)57) : 0;
            this.outlinedInnerColor = Skin.getColorProperty((int)61);
            this.outlinedOuterColor = Skin.getColorProperty((int)62);
            argbColors = new int[this.outlinedLevels];
            if (this.outlinedLevels > 1) {
                for (int i2 = 0; i2 < this.outlinedLevels - 1; ++i2) {
                    IdleClock.argbColors[i2] = this.outlinedInnerColor;
                }
                IdleClock.argbColors[this.outlinedLevels - 1] = this.outlinedOuterColor;
            } else {
                IdleClock.argbColors[0] = this.outlinedInnerColor;
            }
        } else {
            argbColors = null;
        }
    }

    private void updateAnalogProperties() {
        this.clockFaceImage = Skin.getImageProperty((int)27);
        this.minHandColor = Skin.getColorProperty((int)32);
        this.minShadowHandColor = Skin.getColorProperty((int)33);
        this.minHandLength = Skin.getIntProperty((int)31);
        this.hourHandColor = Skin.getColorProperty((int)29);
        this.hourShadowHandColor = Skin.getColorProperty((int)30);
        this.hourHandLength = Skin.getIntProperty((int)28);
        this.analogArea = Skin.getAreaProperty((int)26);
    }

    public static final String formatCurrentTime(int n2, int n3) {
        ResourceManager resourceManager = ResourceManager.getResourceManager((String)"com.motorola.synerj.framework");
        String string = resourceManager.getString(16);
        String string2 = resourceManager.getString(39);
        String string3 = "";
        String string4 = (n3 < 10 ? ":0" : ":") + n3;
        if (1 == Settings.getInstance().getTimeFormat()) {
            string3 = n2 + string4;
        } else {
            string3 = string3 + (n2 % 12 == 0 ? 12 : n2 % 12);
            string3 = string3 + string4 + ' ';
            string3 = string3 + (n2 < 12 ? string : string2);
        }
        return string3;
    }

    private void paintDigitalClock(UIGraphics uIGraphics, int n2, int n3) {
        int n4;
        Font font = uIGraphics.getFont();
        String string = IdleClock.formatCurrentTime(n2, n3) + "  ";
        int n5 = n4 = this.isOutlined ? this.outlinedLevels : 0;
        int n6 = this.digitArea.height >> 1 - font.getHeight() >> 1 - n4;
        int n7 = 40;
        uIGraphics.translate(this.digitArea.x + this.digitArea.width, this.digitArea.y + this.digitArea.height - IdleHomeKeys.STATUSBAR_HEIGHT);
        switch (this.justification) {
            case 2: {
                n5 = n4;
                break;
            }
            case 1: {
                n5 = this.digitArea.width - font.stringWidth(string) - 2 * n4;
                break;
            }
            case 0: {
                n5 = this.digitArea.width >> 1 - font.stringWidth(string) >> 1 - n4;
            }
        }
        uIGraphics.setColor(this.textColor);
        if (this.isOutlined) {
            int n8 = n5 - font.stringWidth(string);
            int n9 = n6 - font.getHeight();
            uIGraphics.drawStringOutline(string, n8, n9, argbColors);
        } else {
            uIGraphics.drawString(string, n5, n6, n7);
        }
        if (this.isUnderline) {
            uIGraphics.drawLine(n5 - n4, n6 += font.getHeight() + 2 * n4, n5 + font.stringWidth(string) + 2 * n4, n6);
        }
        uIGraphics.translate(-this.digitArea.x - this.digitArea.width, -this.digitArea.y - this.digitArea.height + IdleHomeKeys.STATUSBAR_HEIGHT);
    }

    private void paintAnalogClock(UIGraphics uIGraphics, int n2, int n3) {
        if (this.clockFaceImage == null) {
            return;
        }
        int n4 = this.analogArea.width >> 1;
        int n5 = this.analogArea.height >> 1;
        int n6 = n2 % 12 * 5 + n3 / 12;
        int n7 = this.handPositionX(n6, this.hourHandLength);
        int n8 = this.handPositionY(n6, this.hourHandLength);
        int n9 = this.handPositionX(n3, this.minHandLength);
        int n10 = this.handPositionY(n3, this.minHandLength);
        int n11 = this.analogArea.width - this.clockFaceImage.getWidth();
        uIGraphics.translate(this.analogArea.x + n11, this.analogArea.y - IdleHomeKeys.STATUSBAR_HEIGHT);
        uIGraphics.drawImage(this.clockFaceImage, n4, n5, 3);
        uIGraphics.setColor(this.hourShadowHandColor);
        int n12 = this.handShadowDX(n6);
        int n13 = this.handShadowDY(n6);
        uIGraphics.drawLine(n4 + n12, n5 + n13, n7 + n12, n8 + n13);
        uIGraphics.setColor(this.minShadowHandColor);
        n12 = this.handShadowDX(n3);
        n13 = this.handShadowDY(n3);
        uIGraphics.drawLine(n4 + n12, n5 + n13, n9 + n12, n10 + n13);
        uIGraphics.setColor(this.hourHandColor);
        uIGraphics.drawLine(n4, n5, n7, n8);
        uIGraphics.setColor(this.minHandColor);
        uIGraphics.drawLine(n4, n5, n9, n10);
        uIGraphics.translate(-this.analogArea.x - n11, -this.analogArea.y + IdleHomeKeys.STATUSBAR_HEIGHT);
    }

    private int handPositionX(int n2, int n3) {
        int n4 = 0;
        int n5 = n2 / 15 % 4;
        int n6 = n2 % 15;
        int n7 = this.analogArea.width >> 1;
        switch (n5) {
            case 0: {
                n4 = n7 + this.value(15 - n6, n3);
                break;
            }
            case 1: {
                n4 = n7 + this.value(n6, n3);
                break;
            }
            case 2: {
                n4 = n7 - this.value(15 - n6, n3);
                break;
            }
            case 3: {
                n4 = n7 - this.value(n6, n3);
            }
        }
        return n4;
    }

    private int handPositionY(int n2, int n3) {
        int n4 = 0;
        int n5 = n2 / 15 % 4;
        int n6 = n2 % 15;
        int n7 = this.analogArea.height >> 1;
        switch (n5) {
            case 0: {
                n4 = n7 - this.value(n6, n3);
                break;
            }
            case 1: {
                n4 = n7 + this.value(15 - n6, n3);
                break;
            }
            case 2: {
                n4 = n7 + this.value(n6, n3);
                break;
            }
            case 3: {
                n4 = n7 - this.value(15 - n6, n3);
            }
        }
        return n4;
    }

    private int handShadowDX(int n2) {
        return 1 - (n2 + 7) / 15 % 2;
    }

    private int handShadowDY(int n2) {
        return (n2 + 7) / 15 % 2;
    }

    private int value(int n2, int n3) {
        return n3 * cos[n2] / 1000;
    }

    public void paint(UIGraphics uIGraphics) {
        Area area = new Area(uIGraphics.getClipX(), uIGraphics.getClipY(), uIGraphics.getClipWidth(), uIGraphics.getClipHeight());
        if (this.clockAppearance == 1 && IdleScreenApp.isEmptyIntersection(this.digitArea, area) || this.clockAppearance == 0 && IdleScreenApp.isEmptyIntersection(this.analogArea, area)) {
            return;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        int n2 = calendar.get(11);
        int n3 = calendar.get(12);
        if (this.clockAppearance == 1) {
            this.paintDigitalClock(uIGraphics, n2, n3);
        } else {
            this.paintAnalogClock(uIGraphics, n2, n3);
        }
    }

    public static void setClockTimer() {
        if (clock_update_timer_ == null) {
            clock_update_timer_ = new Timer();
            clock_update_timer_.scheduleAtFixedRate((TimerTask)new ClockUpdateTask(), 0L, 20000L);
        }
    }

    public static void discardClockTimer() {
        if (clock_update_timer_ != null) {
            clock_update_timer_.cancel();
            clock_update_timer_ = null;
        }
    }

    public void clockAppearenceChanged(int n2) {
        this.updateClockAppearance();
        view_.repaint();
    }

    public void hkeySettingsChanged(int n2, int n3) {
    }

    public void iconsModeChanged(int n2) {
    }

    public void layoutChanged(int n2) {
    }

    static {
        clock_update_timer_ = null;
    }

    private static class ClockUpdateTask
    extends TimerTask {
        private ClockUpdateTask() {
        }

        public void run() {
            view_.repaint();
        }
    }
}

