/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.itunes.idle;

import apple.itunes.iTunesFactory;
import apple.itunes.iTunesPlayer;
import com.motorola.itunes.idle.IdleClock;
import com.motorola.itunes.idle.IdleDecorator;
import com.motorola.itunes.idle.IdleHomeKeys;
import com.motorola.itunes.idle.IdleStatus;
import com.motorola.synerj.apps.dial.DialEditor;
import com.motorola.synerj.apps.mmenu.MainMenu;
import com.motorola.synerj.apps.rc.RecentCalls;
import com.motorola.synerj.apps.voicerec.VoiceRecognition;
import com.motorola.synerj.fw.EventHandler;
import com.motorola.synerj.fw.EventManager;
import com.motorola.synerj.fw.Framework;
import com.motorola.synerj.fw.FrameworkSuspendListener;
import com.motorola.synerj.svc.device.Funlights;
import com.motorola.synerj.svc.user.HomeScreen;
import com.motorola.synerj.svc.user.HomeScreenListener;
import com.motorola.synerj.svc.user.Settings;
import com.motorola.synerj.svc.user.SettingsListener;
import com.motorola.synerj.ui.PrimaryDisplay;
import com.motorola.synerj.ui.PrimaryDisplayListener;
import com.motorola.synerj.ui.PrimaryView;
import com.motorola.synerj.ui.PrimaryViewBase;
import com.motorola.synerj.ui.PrimaryViewDecorator;
import com.motorola.synerj.ui.UICommandListener;
import com.motorola.synerj.ui.UIGraphics;
import com.motorola.synerj.ui.UIKeyboardListener;
import com.motorola.synerj.ui.widget.Area;
import javax.microedition.io.file.FileSystemListener;

public class IdleScreenApp
extends PrimaryView
implements UICommandListener,
FileSystemListener,
PrimaryDisplayListener,
UIKeyboardListener,
EventHandler,
HomeScreenListener,
SettingsListener,
FrameworkSuspendListener {
    private static final int COMMAND_LEFT_SOFTKEY_ID = 1;
    private static final int COMMAND_RIGHT_SOFTKEY_ID = 2;
    private static final int TRACK_SKIP_TIME = 5000;
    private static String right_softkey_label_;
    private static String left_softkey_label_;
    private static PrimaryDisplay display_;
    private static IdleClock clock_;
    private static boolean rewind_or_fast_forward_;
    private static final boolean debug_ = false;
    private static boolean switch_to_fg_mode_need_;
    private static boolean red_key_was_pressed_;
    public static iTunesPlayer player_;

    public IdleScreenApp() {
        super((PrimaryViewDecorator)new IdleDecorator());
        this.setBox(0, 0, 0, 0, PrimaryDisplay.getWidth(), PrimaryDisplay.getHeight(), 3);
        player_ = iTunesFactory.getPlayerInstance();
        this.initSoftkeys();
        this.setKeyboardListener(this);
        HomeScreen.getInstance().addListener((HomeScreenListener)this);
        Framework.addSuspendListener((FrameworkSuspendListener)this);
        Settings.getInstance().addListener((SettingsListener)this);
        IdleStatus.initIdleStatus(this);
        IdleHomeKeys.initHomeKeys(this);
        clock_ = new IdleClock(this);
        this.setCommandListener(this);
        EventManager.registerEventHandler((Object)"iTunesPlayer.SHOW_IDLE_UI", (EventHandler)this);
        EventManager.registerEventHandler((Object)"iTunesPlayer.HIDE_IDLE_UI", (EventHandler)this);
        EventManager.registerEventHandler((Object)"iTunesPlayer.STATE_CHANGED", (EventHandler)this);
        EventManager.registerEventHandler((Object)"iTunesPlayer.STATE_CHANGED", (EventHandler)IdleHomeKeys.getInstance());
        EventManager.registerEventHandler((Object)"iTunesPlayer.TIME_CHANGED", (EventHandler)IdleStatus.getInstance());
        EventManager.registerEventHandler((Object)"iTunesPlayer.TRACK_CHANGED", (EventHandler)IdleStatus.getInstance());
        EventManager.registerEventHandler((Object)"iTunesPlayer.ALBUM_ARTWORK_CHANGED", (EventHandler)IdleStatus.getInstance());
        EventManager.registerEventHandler((Object)"iTunesPlayer.VOLUME_CHANGED", (EventHandler)IdleStatus.getInstance());
        EventManager.registerEventHandler((Object)"PROXY_EVENT_RED_KEY", (EventHandler)this);
        EventManager.registerEventHandler((Object)"apps.call.Calling.CALL_ACCEPTED", (EventHandler)this);
        EventManager.registerEventHandler((Object)"apps.call.Calling.CALL_ORIGINATED", (EventHandler)this);
        EventManager.registerEventHandler((Object)"svc.device.Keyboard.KEYBOARD_LOCK_EVENT", (EventHandler)this);
        EventManager.registerEventHandler((Object)"svc.device.Display.DISPLAY_EVENT", (EventHandler)this);
    }

    protected void paint(UIGraphics uIGraphics) {
        try {
            IdleHomeKeys.paint(uIGraphics);
            IdleStatus.paint(uIGraphics);
            clock_.paint(uIGraphics);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initSoftkeys() {
        this.removeCommand(2);
        this.removeCommand(1);
        HomeScreen homeScreen = HomeScreen.getInstance();
        left_softkey_label_ = homeScreen.getName(4);
        right_softkey_label_ = homeScreen.getName(5);
        if (left_softkey_label_ != null) {
            this.setSoftkeyCommand(left_softkey_label_, 1, 0);
        }
        if (right_softkey_label_ != null && !right_softkey_label_.equals(left_softkey_label_)) {
            this.setSoftkeyCommand(right_softkey_label_, 2, 1);
        }
        this.setKeepMenuSofkeyIcon(true);
    }

    public void onCommand(int n2) {
        switch (n2) {
            case 2: {
                HomeScreen.launch((int)5);
                break;
            }
            case 1: {
                HomeScreen.launch((int)4);
                break;
            }
        }
    }

    private void showIdle() {
        Funlights.switchRythmLights((boolean)false);
        if (display_ != null) {
            display_.pushView((PrimaryViewBase)this);
            return;
        }
        display_ = PrimaryDisplay.getIdleDisplay();
        if (display_ == null) {
            throw new Error("PrimaryDisplay object is null!");
        }
        display_.start();
        display_.pushView((PrimaryViewBase)this);
        display_.setListener((PrimaryDisplayListener)this);
        IdleClock.setClockTimer();
        switch_to_fg_mode_need_ = false;
        red_key_was_pressed_ = false;
    }

    private static void hideIdle() {
        if (display_ != null) {
            display_.popView();
            display_.stop();
            display_ = null;
        }
        Funlights.switchRythmLights((boolean)true);
        IdleStatus.discardTickerTimer();
        IdleClock.discardClockTimer();
    }

    public void gainFocus(PrimaryDisplay primaryDisplay) {
        if (switch_to_fg_mode_need_) {
            player_.showPlayerUI();
            IdleScreenApp.hideIdle();
            switch_to_fg_mode_need_ = false;
            return;
        }
        IdleHomeKeys.updatePlayerState();
        IdleStatus.updateIdleStatus();
        IdleClock.setClockTimer();
        clock_.updateClockAppearance();
        this.repaint();
    }

    public void loseFocus(PrimaryDisplay primaryDisplay) {
        IdleStatus.discardTickerTimer();
        IdleClock.discardClockTimer();
    }

    public void destroyed(PrimaryDisplay primaryDisplay) {
    }

    private static void handleLeftShortPress() {
        int n2 = player_.getTrackStartTime();
        if (player_.getTrackPosition() > n2 + 5000) {
            player_.setTrackPosition(n2);
        } else if (player_.getTrackIndex() > 0 || player_.getRepeatMode() != 1) {
            player_.goToPreviousTrack();
        } else {
            player_.stop();
            player_.showPlayerUI();
            IdleScreenApp.hideIdle();
        }
    }

    private static void handleRightShortPress() {
        if (player_.getTrackIndex() < player_.getTrackCount() - 1 || player_.getRepeatMode() != 1) {
            player_.goToNextTrack();
        } else {
            player_.stop();
            player_.showPlayerUI();
            IdleScreenApp.hideIdle();
        }
    }

    public void onKeyReleased(int n2) {
        switch (n2) {
            case -23: 
            case -20: {
                MainMenu.getMainMenu().launch();
                break;
            }
            case -10: {
                RecentCalls.getRecentCalls().launch(2);
                break;
            }
            case -6: {
                break;
            }
            case -5: 
            case -2: {
                if (!rewind_or_fast_forward_) break;
                player_.stopRewindFastForward();
                break;
            }
        }
    }

    public void onKeyLongPress(int n2) {
        switch (n2) {
            case 48: {
                DialEditor.getDialEditor().launch(43);
                break;
            }
            case 35: 
            case 42: {
                DialEditor.getDialEditor().launch(n2);
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                DialEditor.getDialEditor().launchSpeedNo(n2);
                break;
            }
            case -2: {
                player_.startRewind();
                rewind_or_fast_forward_ = true;
                break;
            }
            case -5: {
                player_.startFastForward();
                rewind_or_fast_forward_ = true;
            }
        }
    }

    public void onKeyShortPress(int n2) {
        switch (n2) {
            case 35: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                DialEditor.getDialEditor().launch(n2);
                break;
            }
            case -6: {
                player_.showPlayerUI();
                IdleScreenApp.hideIdle();
                break;
            }
            case -2: {
                IdleScreenApp.handleLeftShortPress();
                break;
            }
            case -5: {
                IdleScreenApp.handleRightShortPress();
                break;
            }
            case -1: {
                if (player_.getState() == 2) {
                    player_.resume();
                    break;
                }
                player_.pause();
                break;
            }
            case -103: {
                VoiceRecognition.getVoiceRecognition().launch();
            }
        }
    }

    public void onKeyRepeated(int n2) {
        switch (n2) {
            case -100: {
                int n3 = player_.getVolume();
                if (player_.getMaxVolume() > n3) {
                    player_.setVolume(++n3);
                    break;
                }
                player_.setVolume(n3);
                break;
            }
            case -101: {
                int n4 = player_.getVolume();
                if (player_.getMinVolume() < n4) {
                    player_.setVolume(--n4);
                    break;
                }
                player_.setVolume(n4);
            }
        }
    }

    public void onKeyDown(int n2) {
        switch (n2) {
            case -100: {
                int n3 = player_.getVolume();
                if (player_.getMaxVolume() > n3) {
                    player_.setVolume(++n3);
                    break;
                }
                player_.setVolume(n3);
                break;
            }
            case -101: {
                int n4 = player_.getVolume();
                if (player_.getMinVolume() < n4) {
                    player_.setVolume(--n4);
                    break;
                }
                player_.setVolume(n4);
                break;
            }
            case -102: {
                HomeScreen.launch((int)6);
                break;
            }
        }
    }

    public void handleEvent(Object object, int n2, Object object2) {
        if ((String)object == "iTunesPlayer.SHOW_IDLE_UI") {
            this.showIdle();
        }
        if ((String)object == "PROXY_EVENT_RED_KEY" && n2 != 0) {
            player_.stop();
            IdleScreenApp.hideIdle();
            red_key_was_pressed_ = true;
        }
        if ((String)object == "iTunesPlayer.HIDE_IDLE_UI") {
            IdleScreenApp.hideIdle();
        }
        if ((String)object == "apps.call.Calling.CALL_ACCEPTED") {
            player_.pause();
        }
        if ((String)object == "apps.call.Calling.CALL_ORIGINATED") {
            player_.pause();
        }
        if ((String)object == "iTunesPlayer.STATE_CHANGED" && n2 == 0) {
            if (red_key_was_pressed_) {
                red_key_was_pressed_ = false;
                return;
            }
            if (display_.hasFocus()) {
                player_.showPlayerUI();
                IdleScreenApp.hideIdle();
            } else {
                switch_to_fg_mode_need_ = true;
            }
        }
        if ((String)object == "svc.device.Keyboard.KEYBOARD_LOCK_EVENT") {
            if (n2 == 1) {
                this.removeCommand(2);
                this.removeCommand(1);
            } else if (n2 == 0) {
                if (left_softkey_label_ != null) {
                    this.setSoftkeyCommand(left_softkey_label_, 1, 0);
                }
                if (right_softkey_label_ != null && !right_softkey_label_.equals(left_softkey_label_)) {
                    this.setSoftkeyCommand(right_softkey_label_, 2, 1);
                }
            }
        }
        if ((String)object == "svc.device.Display.DISPLAY_EVENT" && display_.hasFocus() && (n2 & 0x100) != 0 && player_.getState() == 2) {
            if ((n2 & 2) == 0 || (n2 & 1) == 0) {
                IdleStatus.discardTickerTimer();
                IdleClock.discardClockTimer();
            } else {
                IdleHomeKeys.updatePlayerState();
                IdleStatus.updateIdleStatus();
                IdleClock.setClockTimer();
            }
        }
    }

    public static boolean isEmptyIntersection(Area area, Area area2) {
        return area.width < 0 || area.height < 0 || area2.width < 0 || area2.height < 0 || area2.x + area2.width < area.x || area2.x > area.x + area.width || area2.y + area2.height < area.y || area2.y > area.y + area.height;
    }

    public void hkeySettingsChanged(int n2, int n3) {
        if (n2 == 4 || n2 == 5) {
            this.initSoftkeys();
        }
    }

    public void layoutChanged(int n2) {
    }

    public void clockAppearenceChanged(int n2) {
    }

    public void iconsModeChanged(int n2) {
    }

    public void rootChanged(int n2, String string) {
        player_.stop();
        IdleScreenApp.hideIdle();
    }

    public void dateFormatChanged(int n2) {
    }

    public void timeFormatChanged(int n2) {
    }

    public void masterClear() {
    }

    public void masterReset() {
    }

    public void creditChanged() {
    }

    public void timeChanged() {
        IdleClock.discardClockTimer();
        if (display_.hasFocus()) {
            IdleClock.setClockTimer();
        }
    }

    public void languageChanged(String string) {
        this.initSoftkeys();
    }

    public void onFrameworkSuspend() {
        player_.pause();
    }

    static {
        display_ = null;
        rewind_or_fast_forward_ = false;
        switch_to_fg_mode_need_ = false;
        red_key_was_pressed_ = false;
    }
}

