/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.itunes.idle;

import com.motorola.funlight.FunLight;
import com.motorola.itunes.idle.IdleScreenApp;
import com.motorola.itunes.idle.Light;
import com.motorola.synerj.fw.EventHandler;
import com.motorola.synerj.fw.EventManager;
import com.motorola.synerj.ui.GifAnimation;
import com.motorola.synerj.ui.PrimaryDisplay;
import com.motorola.synerj.ui.PrimaryDisplayListener;
import com.motorola.synerj.ui.UIGraphics;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;

public final class IdleStarter
extends IdleScreenApp
implements EventHandler,
PrimaryDisplayListener {
    public static boolean playAfterAccepted = true;
    public static boolean playAfterOriginated = true;
    public static boolean nextTrack = true;
    private boolean longPress = false;
    private Timer timer = null;
    private static int STATUSBAR_HEIGHT = PrimaryDisplay.getStatusAreaHeight();
    private static int aniX;
    private static GifAnimation gif;

    public IdleStarter() {
        EventManager.registerEventHandler((Object)"apps.call.Calling.CALL_ACCEPTED", (EventHandler)this);
        EventManager.registerEventHandler((Object)"apps.call.Calling.CALL_ORIGINATED", (EventHandler)this);
        EventManager.registerEventHandler((Object)"iTunesPlayer.TIME_CHANGED", (EventHandler)this);
    }

    public void handleEvent(Object object, int n2, Object object2) {
        if ((String)object == "apps.call.Calling.CALL_ACCEPTED") {
            if (playAfterAccepted) {
                if (IdleScreenApp.player_.getState() == 1) {
                    IdleScreenApp.player_.resume();
                } else {
                    IdleScreenApp.player_.pause();
                }
            } else {
                IdleScreenApp.player_.pause();
            }
        } else if ((String)object == "apps.call.Calling.CALL_ORIGINATED") {
            if (playAfterOriginated) {
                if (IdleScreenApp.player_.getState() == 1) {
                    IdleScreenApp.player_.resume();
                } else {
                    IdleScreenApp.player_.pause();
                }
            } else {
                IdleScreenApp.player_.pause();
            }
        } else if ((String)object == "iTunesPlayer.TIME_CHANGED") {
            this.repaint();
        }
        super.handleEvent(object, n2, object2);
    }

    public void onKeyDown(int n2) {
        this.longPress = false;
        if (!(n2 == -102 | n2 == -106)) {
            super.onKeyDown(n2);
        }
    }

    public void onKeyLongPress(int n2) {
        this.longPress = true;
        if (n2 == -106 || n2 == -1) {
            if (nextTrack) {
                IdleScreenApp.player_.goToNextTrack();
            } else {
                IdleScreenApp.player_.startFastForward();
            }
        } else if (!(n2 == -102 | n2 == -106)) {
            super.onKeyLongPress(n2);
        }
    }

    public void onKeyReleased(int n2) {
        if (n2 == -106 || n2 == -1) {
            if (this.longPress && !nextTrack) {
                IdleScreenApp.player_.stopRewindFastForward();
            }
        } else if (!(n2 == -102 | n2 == -106)) {
            super.onKeyReleased(n2);
        }
    }

    public void onKeyRepeated(int n2) {
        if (!(n2 == -102 | n2 == -106)) {
            super.onKeyRepeated(n2);
        }
    }

    public void onKeyShortPress(int n2) {
        this.longPress = false;
        if (n2 == -106) {
            if (IdleScreenApp.player_.getState() == 2) {
                IdleScreenApp.player_.resume();
            } else {
                IdleScreenApp.player_.pause();
            }
        } else if (n2 == -102) {
            if (this.timer == null) {
                this.startTimer();
            } else {
                this.stopTimer();
            }
        }
        if (n2 == -101) {
            super.onKeyShortPress(n2);
            if (IdleScreenApp.player_.getState() == 1 & IdleScreenApp.player_.getVolume() < 1) {
                IdleScreenApp.player_.pause();
            }
        }
        if (n2 == -100) {
            super.onKeyShortPress(n2);
            if (IdleScreenApp.player_.getVolume() > 0 & IdleScreenApp.player_.getState() == 2) {
                IdleScreenApp.player_.resume();
            }
        } else {
            super.onKeyShortPress(n2);
        }
    }

    public void loseFocus(PrimaryDisplay primaryDisplay) {
        super.loseFocus(primaryDisplay);
    }

    public void gainFocus(PrimaryDisplay primaryDisplay) {
        super.gainFocus(primaryDisplay);
    }

    public void destroyed(PrimaryDisplay primaryDisplay) {
        this.stopTimer();
        super.destroyed(primaryDisplay);
    }

    private void startTimer() {
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new Light(), 100L, 100L);
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
        FunLight.releaseControl();
    }

    protected void paint(UIGraphics uIGraphics) {
        super.paint(uIGraphics);
        if (gif != null) {
            uIGraphics.translate(0, STATUSBAR_HEIGHT);
            uIGraphics.setClip(0, 0, this.getWidth(), this.getHeight());
            if (gif != null) {
                gif.paint(uIGraphics, aniX, 24, 0);
            }
            gif.prepareNextFrame();
            if ((aniX -= gif.getWidth() / 2) > this.getWidth() - gif.getWidth()) {
                aniX = 0;
            }
            if (aniX < 0) {
                aniX = this.getWidth() - gif.getWidth();
            }
        }
    }

    static {
        try {
            InputStream inputStream = Class.forName("com.telecom.FileSystemAccessor").getResourceAsStream("/ani.gif");
            byte[] byArray = new byte[32768];
            int n2 = inputStream.read(byArray);
            inputStream = null;
            gif = GifAnimation.createAnimation((byte[])byArray, (int)0, (int)n2);
            gif.setInfinite(true);
            byArray = null;
            aniX = 176 - gif.getWidth();
        }
        catch (Exception exception) {
            gif = null;
        }
    }
}

