/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.itunes.idle;

import com.motorola.itunes.idle.IdleHomeKeys;
import com.motorola.itunes.idle.IdleScreenApp;
import com.motorola.synerj.fw.EventHandler;
import com.motorola.synerj.svc.user.HomeScreen;
import com.motorola.synerj.svc.user.HomeScreenListener;
import com.motorola.synerj.ui.PrimaryDisplay;
import com.motorola.synerj.ui.PrimaryView;
import com.motorola.synerj.ui.Skin;
import com.motorola.synerj.ui.UIGraphics;
import com.motorola.synerj.ui.settings.Settings;
import com.motorola.synerj.ui.settings.SettingsListener;
import com.motorola.synerj.ui.widget.Area;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;

public class IdleStatus
implements SettingsListener,
HomeScreenListener,
EventHandler {
    private static Area line1_area_;
    private static Area line2_area_;
    private static int line_frg_color_;
    private static boolean outline_text_;
    private static int outline_levels_;
    private static int outline_inner_color_;
    private static int outline_outer_color_;
    private static int[] argbColors_;
    private static IdleStatus singleton_;
    private static PrimaryView view_;
    private static String track_name_;
    private static Image track_albumart_;
    private static int track_albumart_shift_h_;
    private static int track_albumart_shift_v_;
    private static int track_total_time_;
    private static int track_elapsed_time_;
    private static int current_volume_;
    private static Timer volume_timer_;
    private static final long timer_delay_ = 2000L;
    private static final boolean debug_ = false;
    private static boolean show_timing_;
    private static Timer ticker_timer_;
    private static TimerTask ticker_timer_task_;
    private static final long ticker_timer_delay_ = 100L;
    private static final long ticker_timer_period_ = 100L;
    private static int ticker_shift_x_s1_;
    private static int ticker_shift_x_s2_;
    private static final int ticker_shift_step_ = 2;
    private static final int ticker_space_ = 30;
    private static Image line1_ticker_image_;
    private static int lines_shift_;
    private static int current_layout_type_;
    private static Area repaint_area_;
    private static final int ALBUM_ART_WORK_WIDTH = 50;
    private static final int ALBUM_ART_WORK_HEIGHT = 50;

    private IdleStatus() {
    }

    public static IdleStatus getInstance() {
        return singleton_;
    }

    static void initIdleStatus(PrimaryView primaryView) {
        IdleStatus.initSkinPropeties();
        if (singleton_ == null) {
            singleton_ = new IdleStatus();
            Settings.getInstance().addListener((SettingsListener)singleton_);
            HomeScreen.getInstance().addListener((HomeScreenListener)singleton_);
            current_layout_type_ = HomeScreen.getLayout();
        }
        if (primaryView == null) {
            throw new IllegalArgumentException("PrimaryView is null");
        }
        view_ = primaryView;
    }

    public static synchronized void paint(UIGraphics uIGraphics) {
        String string;
        Area area;
        Area area2 = new Area(uIGraphics.getClipX(), uIGraphics.getClipY(), uIGraphics.getClipWidth(), uIGraphics.getClipHeight());
        if (IdleScreenApp.isEmptyIntersection(repaint_area_, area2)) {
            return;
        }
        uIGraphics.translate(0, -IdleHomeKeys.STATUSBAR_HEIGHT);
        uIGraphics.setColor(line_frg_color_);
        if (track_name_ == null) {
            IdleStatus.updateTrackInfo();
        }
        if (track_total_time_ == 0) {
            IdleStatus.updateTime();
        }
        if (track_albumart_ != null) {
            uIGraphics.drawImage(track_albumart_, IdleStatus.line1_area_.x + track_albumart_shift_h_, IdleStatus.line1_area_.y + track_albumart_shift_v_, 20);
        }
        if (!IdleScreenApp.isEmptyIntersection(area2, area = new Area(IdleStatus.line1_area_.x + lines_shift_, IdleStatus.line1_area_.y - IdleHomeKeys.STATUSBAR_HEIGHT, IdleStatus.line1_area_.width - lines_shift_, IdleStatus.line1_area_.height))) {
            string = track_name_;
            IdleStatus.drawLineInArea(uIGraphics, line1_area_, string);
        }
        if (!IdleScreenApp.isEmptyIntersection(area2, (Area)(string = new Area(IdleStatus.line2_area_.x + lines_shift_, IdleStatus.line2_area_.y, IdleStatus.line2_area_.width - lines_shift_, IdleStatus.line2_area_.height)))) {
            String string2 = show_timing_ ? IdleStatus.convertTime(track_elapsed_time_) + " / " + IdleStatus.convertTime(track_total_time_) : "Volume: " + current_volume_;
            IdleStatus.drawLineInArea(uIGraphics, line2_area_, string2);
        }
        uIGraphics.translate(0, IdleHomeKeys.STATUSBAR_HEIGHT);
    }

    public void handleEvent(Object object, int n2, Object object2) {
        if ((String)object == "iTunesPlayer.TIME_CHANGED") {
            IdleStatus.updateTime();
            view_.repaint(IdleStatus.line2_area_.x + lines_shift_, IdleStatus.line2_area_.y - IdleHomeKeys.STATUSBAR_HEIGHT, IdleStatus.line2_area_.width - lines_shift_, IdleStatus.line2_area_.height);
        }
        if ((String)object == "iTunesPlayer.TRACK_CHANGED") {
            IdleStatus.updateTrackInfo();
            view_.repaint(IdleStatus.repaint_area_.x, IdleStatus.repaint_area_.y, IdleStatus.repaint_area_.width, IdleStatus.repaint_area_.height);
        }
        if ((String)object == "iTunesPlayer.ALBUM_ARTWORK_CHANGED") {
            IdleStatus.updateArtwork();
            view_.repaint(IdleStatus.repaint_area_.x, IdleStatus.repaint_area_.y, IdleStatus.repaint_area_.width, IdleStatus.repaint_area_.height);
        }
        if ((String)object == "iTunesPlayer.VOLUME_CHANGED") {
            current_volume_ = n2;
            if (volume_timer_ != null) {
                volume_timer_.cancel();
                volume_timer_ = null;
            }
            volume_timer_ = new Timer();
            volume_timer_.schedule((TimerTask)new VolumeTimerTask(), 2000L);
            show_timing_ = false;
            view_.repaint(IdleStatus.repaint_area_.x, IdleStatus.repaint_area_.y, IdleStatus.repaint_area_.width, IdleStatus.repaint_area_.height);
        }
        if ((String)object == "iTunesPlayer.STATE_CHANGED") {
            IdleStatus.discardTickerTimer();
        }
    }

    private static void initSkinPropeties() {
        line1_area_ = Skin.getAreaProperty((int)43);
        line2_area_ = Skin.getAreaProperty((int)44);
        IdleStatus.repaint_area_.x = 0;
        IdleStatus.repaint_area_.y = IdleStatus.line1_area_.y - IdleHomeKeys.STATUSBAR_HEIGHT;
        IdleStatus.repaint_area_.width = IdleHomeKeys.DISPLAY_WIDTH;
        IdleStatus.repaint_area_.height = IdleStatus.line2_area_.y - IdleStatus.line1_area_.y + IdleStatus.line2_area_.height;
        line_frg_color_ = Skin.getColorProperty((int)68);
        outline_text_ = Skin.getBooleanProperty((int)48);
        if (outline_text_) {
            outline_levels_ = Skin.getIntProperty((int)49);
            outline_inner_color_ = Skin.getColorProperty((int)53);
            outline_outer_color_ = Skin.getColorProperty((int)54);
            argbColors_ = new int[outline_levels_];
            if (outline_levels_ > 1) {
                for (int i2 = 0; i2 < outline_levels_ - 1; ++i2) {
                    IdleStatus.argbColors_[i2] = outline_inner_color_;
                }
                IdleStatus.argbColors_[IdleStatus.outline_levels_ - 1] = outline_outer_color_;
            } else {
                IdleStatus.argbColors_[0] = outline_inner_color_;
            }
        } else {
            argbColors_ = null;
        }
    }

    private static void updateTime() {
        track_total_time_ = IdleScreenApp.player_.getTrackDuration();
        track_elapsed_time_ = IdleScreenApp.player_.getTrackPosition();
    }

    private static void updateTrackInfo() {
        line1_ticker_image_ = null;
        IdleStatus.discardTickerTimer();
        track_name_ = IdleScreenApp.player_.getTrackName();
        if (!IdleScreenApp.player_.hasTrackAlbumArtwork()) {
            lines_shift_ = 0;
            track_albumart_ = null;
            track_albumart_shift_h_ = 0;
            track_albumart_shift_v_ = 0;
        } else {
            lines_shift_ = 52;
        }
        if (track_name_ == null) {
            track_name_ = "";
        } else if (Font.getDefaultFont().stringWidth(track_name_) >= IdleStatus.line1_area_.width - lines_shift_) {
            IdleStatus.setLine1TickerImage();
            IdleStatus.setTickerTimer();
        }
    }

    private static void updateArtwork() {
        track_albumart_ = IdleScreenApp.player_.getTrackAlbumArtwork(false);
        if (track_albumart_ != null) {
            track_albumart_shift_h_ = (50 - track_albumart_.getWidth()) / 2;
            track_albumart_shift_v_ = (50 - track_albumart_.getHeight()) / 2;
            if (IdleStatus.repaint_area_.height < 50) {
                IdleStatus.repaint_area_.height = 50;
            }
            view_.repaint(IdleStatus.line1_area_.x, IdleStatus.line1_area_.y, 50, 50);
        } else {
            track_albumart_shift_h_ = 0;
            track_albumart_shift_v_ = 0;
            view_.repaint(IdleStatus.repaint_area_.x, IdleStatus.repaint_area_.y, 50, 50);
        }
    }

    private static void updateVolume() {
        current_volume_ = IdleScreenApp.player_.getVolume();
    }

    private static String convertTime(int n2) {
        String string = "";
        if (n2 > 0) {
            int n3 = n2 / 1000 / 3600;
            int n4 = n2 / 1000 % 3600 / 60;
            int n5 = n2 / 1000 % 60;
            if (n3 > 0) {
                string = string + n3 + ":";
                if (n4 < 10) {
                    string = string + "0";
                }
            }
            string = string + n4 + ":";
            if (n5 < 10) {
                string = string + "0";
            }
            string = string + n5;
        } else {
            string = "0:00";
        }
        return string;
    }

    public static void updateIdleStatus() {
        IdleStatus.updateTime();
        IdleStatus.updateArtwork();
        IdleStatus.updateTrackInfo();
        IdleStatus.updateVolume();
    }

    private static void setLine1TickerImage() {
        line1_ticker_image_ = Image.createImage((int)(Font.getDefaultFont().stringWidth(track_name_) + 2), (int)IdleStatus.line1_area_.height);
        UIGraphics uIGraphics = UIGraphics.getImageGraphics((Image)line1_ticker_image_, null);
        uIGraphics.setDrawMode(false);
        uIGraphics.fillRect(0, 0, line1_ticker_image_.getWidth(), line1_ticker_image_.getHeight());
        uIGraphics.setColor(line_frg_color_);
        if (outline_text_) {
            int[] nArray = new int[]{0};
            nArray[0] = argbColors_[0];
            uIGraphics.drawStringOutline(track_name_, 0, 0, nArray);
        } else {
            uIGraphics.drawString(track_name_, 0, 0, 20);
        }
    }

    private static void drawLineInArea(UIGraphics uIGraphics, Area area, String string) {
        int n2 = uIGraphics.getClipX();
        int n3 = uIGraphics.getClipY();
        int n4 = uIGraphics.getClipWidth();
        int n5 = uIGraphics.getClipHeight();
        int n6 = area.x + lines_shift_;
        int n7 = area.y;
        int n8 = area.width - lines_shift_;
        int n9 = area.height;
        int n10 = Font.getDefaultFont().stringWidth(string);
        uIGraphics.setClip(n6, n7, n8, n9);
        if (n10 >= n8) {
            if (line1_ticker_image_ == null) {
                IdleStatus.setLine1TickerImage();
                if (ticker_timer_ == null) {
                    IdleStatus.setTickerTimer();
                }
            }
            if (ticker_shift_x_s1_ >= n10) {
                ticker_shift_x_s1_ = ticker_shift_x_s2_ - n10 - 30;
            }
            if (ticker_shift_x_s2_ >= n10) {
                ticker_shift_x_s2_ = ticker_shift_x_s1_ - n10 - 30;
            }
            int n11 = n6 - ticker_shift_x_s1_;
            int n12 = n6 - ticker_shift_x_s2_;
            if (n11 < n6 + area.width) {
                uIGraphics.drawImage(line1_ticker_image_, n11, area.y, 20);
            }
            if (n12 < n6 + area.width) {
                uIGraphics.drawImage(line1_ticker_image_, n12, area.y, 20);
            }
        } else {
            int n13 = 0;
            if (lines_shift_ == 0 && current_layout_type_ == 1) {
                n13 = (area.width - lines_shift_ - (area.x + lines_shift_) - n10) / 2;
            }
            if (outline_text_) {
                uIGraphics.drawStringOutline(string, area.x + lines_shift_ + n13, area.y, argbColors_);
            } else {
                uIGraphics.drawString(string, area.x + lines_shift_ + n13, area.y, 20);
            }
        }
        uIGraphics.setClip(n2, n3, n4, n5);
    }

    public static void setTickerTimer() {
        ticker_shift_x_s1_ = 0;
        ticker_shift_x_s2_ = -(Font.getDefaultFont().stringWidth(track_name_) + 30);
        ticker_timer_ = new Timer();
        ticker_timer_task_ = new TickerTimerTask();
        ticker_timer_.schedule(ticker_timer_task_, 100L, 100L);
    }

    public static void discardTickerTimer() {
        if (ticker_timer_task_ != null) {
            ticker_timer_task_.cancel();
            ticker_timer_task_ = null;
        }
        if (ticker_timer_ != null) {
            ticker_timer_.cancel();
            ticker_timer_ = null;
            ticker_shift_x_s1_ = 0;
            ticker_shift_x_s2_ = track_name_ != null ? -(Font.getDefaultFont().stringWidth(track_name_) + 30) : 0;
        }
    }

    public void skinChanged() {
        IdleStatus.initSkinPropeties();
    }

    public void themeChanged(String string) {
    }

    public void wallpaperChanged(String string) {
    }

    public void wallpaperLayoutChanged(int n2) {
    }

    public void colorStyleChanged() {
    }

    public void hkeySettingsChanged(int n2, int n3) {
    }

    public void clockAppearenceChanged(int n2) {
    }

    public void iconsModeChanged(int n2) {
    }

    public void layoutChanged(int n2) {
        current_layout_type_ = n2;
        view_.repaint(IdleStatus.repaint_area_.x, IdleStatus.repaint_area_.y, IdleStatus.repaint_area_.width, IdleStatus.repaint_area_.height);
    }

    static {
        argbColors_ = new int[]{0};
        track_albumart_shift_h_ = 0;
        track_albumart_shift_v_ = 0;
        show_timing_ = true;
        repaint_area_ = new Area(0, 0, PrimaryDisplay.getWidth(), PrimaryDisplay.getHeight());
    }

    private static class TickerTimerTask
    extends TimerTask {
        private TickerTimerTask() {
        }

        public void run() {
            ticker_shift_x_s1_ += 2;
            ticker_shift_x_s2_ += 2;
            view_.repaint(line1_area_.x + lines_shift_, line1_area_.y - IdleHomeKeys.STATUSBAR_HEIGHT, line1_area_.width - lines_shift_, line1_area_.height);
        }
    }

    private class VolumeTimerTask
    extends TimerTask {
        private VolumeTimerTask() {
        }

        public void run() {
            show_timing_ = true;
            view_.repaint(repaint_area_.x, repaint_area_.y, repaint_area_.width, repaint_area_.height);
        }
    }
}

