/*
 * Decompiled with CFR 0.152.
 */
package com.telecom;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;

public class FileSystemAccessor {
    private FileConnection connection;
    private String location;

    public FileSystemAccessor(String string) {
        this.location = string;
    }

    private void close() {
        try {
            this.connection.close();
            this.connection = null;
        }
        catch (Exception exception) {
            System.out.println("Close connection failed: " + exception.getMessage());
        }
    }

    private void open(int n2) {
        try {
            this.connection = (FileConnection)Connector.open((String)("file://" + this.location), (int)n2);
        }
        catch (Exception exception) {
            this.connection = null;
            System.out.println("Open connection '" + this.location + "' failed: " + exception.getMessage());
        }
    }

    private void open() {
        this.open(1);
    }

    public long availableSize() {
        long l2 = -1L;
        this.open();
        if (this.connection != null) {
            l2 = this.connection.availableSize();
            this.close();
        }
        return l2;
    }

    public boolean canRead() {
        boolean bl2 = false;
        this.open();
        if (this.connection != null) {
            bl2 = this.connection.canRead();
            this.close();
        }
        return bl2;
    }

    public boolean canWrite() {
        boolean bl2 = false;
        this.open();
        if (this.connection != null) {
            bl2 = this.connection.canWrite();
            this.close();
        }
        return bl2;
    }

    public boolean create() {
        this.open(3);
        if (this.connection != null) {
            if (this.connection.exists()) {
                this.connection.delete();
            }
            this.connection.create();
            this.close();
        }
        return true;
    }

    public boolean delete() {
        this.open(3);
        if (this.connection != null) {
            if (this.connection.exists()) {
                this.connection.delete();
            }
            this.close();
        }
        return true;
    }

    public long directorySize(boolean bl2) {
        long l2 = -1L;
        this.open();
        if (this.connection != null) {
            l2 = this.connection.directorySize(bl2);
            this.close();
        }
        return l2;
    }

    public boolean exists() {
        boolean bl2 = false;
        this.open();
        if (this.connection != null) {
            bl2 = this.connection.exists();
            this.close();
        }
        return bl2;
    }

    public long fileSize() {
        long l2 = -1L;
        this.open();
        if (this.connection != null) {
            l2 = this.connection.fileSize();
            this.close();
        }
        return l2;
    }

    public boolean isDirectory() {
        boolean bl2 = false;
        this.open();
        if (this.connection != null) {
            bl2 = this.connection.isDirectory();
            this.close();
        }
        return bl2;
    }

    public boolean isHidden() {
        boolean bl2 = false;
        this.open();
        if (this.connection != null) {
            bl2 = this.connection.isHidden();
            this.close();
        }
        return bl2;
    }

    public long lastModified() {
        long l2 = -1L;
        this.open();
        if (this.connection != null) {
            l2 = this.connection.lastModified();
            this.close();
        }
        return l2;
    }

    public String[] list() {
        String[] stringArray = null;
        this.open();
        if (this.connection != null) {
            Vector vector = new Vector();
            Enumeration enumeration = this.connection.list("*", true);
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            this.close();
            stringArray = new String[vector.size()];
            int n2 = 0;
            while (n2 < vector.size()) {
                stringArray[n2] = this.location + vector.elementAt(n2);
                ++n2;
            }
        }
        return stringArray;
    }

    public static String[] listRoots() {
        String[] stringArray = null;
        Vector vector = new Vector();
        Enumeration enumeration = FileSystemRegistry.listRoots();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        stringArray = new String[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            stringArray[n2] = "/" + vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public boolean mkdir() {
        this.open(3);
        if (this.connection != null) {
            if (!this.connection.exists()) {
                this.connection.mkdir();
            }
            this.close();
        }
        return true;
    }

    public byte[] read() {
        byte[] byArray = null;
        try {
            this.open();
            long l2 = this.connection.fileSize();
            byArray = new byte[(int)l2];
            DataInputStream dataInputStream = this.connection.openDataInputStream();
            if (l2 != (long)dataInputStream.read(byArray)) {
                byArray = null;
            }
            dataInputStream.close();
            dataInputStream = null;
            this.close();
        }
        catch (Exception exception) {
            byArray = null;
            System.out.println("Read from '" + this.location + "' failed: " + exception.getMessage());
        }
        return byArray;
    }

    public boolean rename(String string) {
        this.open(3);
        if (this.connection != null) {
            int n2 = string.lastIndexOf(47);
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            this.connection.rename(string);
            this.close();
        }
        return true;
    }

    public boolean write(byte[] byArray) {
        boolean bl2 = false;
        try {
            this.open(3);
            if (this.connection.exists()) {
                this.connection.delete();
            }
            this.connection.create();
            DataOutputStream dataOutputStream = this.connection.openDataOutputStream();
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.flush();
            dataOutputStream.close();
            this.close();
            bl2 = true;
        }
        catch (Exception exception) {
            System.out.println("Write to '" + this.location + "' failed: " + exception.getMessage());
        }
        return bl2;
    }

    public void setHidden(boolean bl2) {
        this.open(3);
        if (this.connection != null) {
            this.connection.setHidden(bl2);
            this.close();
        }
    }

    public void setReadable(boolean bl2) {
        this.open(3);
        if (this.connection != null) {
            this.connection.setReadable(bl2);
            this.close();
        }
    }

    public void setWritable(boolean bl2) {
        this.open(3);
        if (this.connection != null) {
            this.connection.setWritable(bl2);
            this.close();
        }
    }

    public long totalSize() {
        long l2 = -1L;
        this.open();
        if (this.connection != null) {
            l2 = this.connection.totalSize();
            this.close();
        }
        return l2;
    }

    public long usedSize() {
        long l2 = -1L;
        this.open();
        if (this.connection != null) {
            l2 = this.connection.usedSize();
            this.close();
        }
        return l2;
    }

    public InputStream openInputStream() {
        InputStream inputStream;
        try {
            this.open();
            inputStream = this.connection.openInputStream();
        }
        catch (Exception exception) {
            inputStream = null;
            System.out.println("openInputStream from '" + this.location + "' failed: " + exception.getMessage());
        }
        return inputStream;
    }

    public OutputStream openOutputStream() {
        OutputStream outputStream;
        try {
            this.open(3);
            if (this.connection.exists()) {
                this.connection.delete();
            }
            this.connection.create();
            outputStream = this.connection.openOutputStream();
        }
        catch (Exception exception) {
            outputStream = null;
            System.out.println("openOutputStream on '" + this.location + "' failed: " + exception.getMessage());
        }
        return outputStream;
    }

    public DataInputStream openDataInputStream() {
        DataInputStream dataInputStream;
        try {
            this.open();
            dataInputStream = this.connection.openDataInputStream();
        }
        catch (Exception exception) {
            dataInputStream = null;
            System.out.println("openDataInputStream from '" + this.location + "' failed: " + exception.getMessage());
        }
        return dataInputStream;
    }

    public DataOutputStream openDataOutputStream() {
        DataOutputStream dataOutputStream;
        try {
            this.open(3);
            if (this.connection.exists()) {
                this.connection.delete();
            }
            this.connection.create();
            dataOutputStream = this.connection.openDataOutputStream();
        }
        catch (Exception exception) {
            dataOutputStream = null;
            System.out.println("openDataOutputStream on '" + this.location + "' failed: " + exception.getMessage());
        }
        return dataOutputStream;
    }

    public void closeInputStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("closeInputStream from '" + this.location + "' failed: " + iOException.getMessage());
        }
        this.close();
    }

    public void closeOutputStream(OutputStream outputStream) {
        try {
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("closeOutputStream on '" + this.location + "' failed: " + iOException.getMessage());
        }
        this.close();
    }
}

