/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Contact;
import at.emini.physics2D.MultiShape;
import at.emini.physics2D.ParticleEmitter;
import at.emini.physics2D.Shape;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;

public class Landscape {
    private Body e;
    private Shape f;
    protected int a = 0;
    protected FXVector[] b = new FXVector[128];
    protected FXVector[] c = new FXVector[128];
    protected short[] d = new short[128];
    private int g = 0;
    private int[] h = new int[32];
    private int i = 0;
    private int j = 0;
    public static final short FACE_NONE = 0;
    public static final short FACE_LEFT = 1;
    public static final short FACE_RIGHT = 2;
    private int k = 0;
    private Contact[] l = new Contact[32];

    public Landscape() {
        this.f = new Shape(new FXVector[0]);
        this.e = new Body(0, 0, this.f, false);
    }

    public Landscape(Landscape landscape) {
        this.f = new Shape(new FXVector[0]);
        this.e = new Body(0, 0, this.f, false);
        if (landscape == null) {
            return;
        }
        this.f.k = landscape.f.k;
        this.f.j = landscape.f.j;
        this.a = landscape.a;
        this.b = new FXVector[Math.max(128, this.a)];
        this.c = new FXVector[Math.max(128, this.a)];
        this.d = new short[Math.max(128, this.a)];
        for (int i = 0; i < this.a; ++i) {
            this.b[i] = new FXVector(landscape.b[i]);
            this.c[i] = new FXVector(landscape.c[i]);
            this.d[i] = landscape.d[i];
        }
    }

    public static Landscape loadLandscape(PhysicsFileReader physicsFileReader) {
        Landscape landscape = new Landscape();
        int n = physicsFileReader.nextInt();
        for (int i = 0; i < n; ++i) {
            landscape.addSegment(physicsFileReader.nextVector(), physicsFileReader.nextVector(), (short)physicsFileReader.next());
        }
        landscape.f = Shape.loadShape(physicsFileReader, null);
        landscape.e = new Body(0, 0, landscape.f, false);
        return landscape;
    }

    public Landscape copy() {
        return new Landscape(this);
    }

    public void addSegment(FXVector fXVector, FXVector fXVector2, short s) {
        FXVector fXVector3 = fXVector.xFX < fXVector2.xFX ? fXVector : fXVector2;
        FXVector fXVector4 = fXVector.xFX < fXVector2.xFX ? fXVector2 : fXVector;
        if (fXVector2.xFX <= fXVector.xFX & s != 0) {
            s = (short)(s == 2 ? 1 : 2);
        }
        this.b = World.a(this.b, this.a);
        this.c = World.a(this.c, this.a);
        this.d = World.a(this.d, this.a);
        this.b[this.a] = fXVector3;
        this.c[this.a] = fXVector4;
        this.d[this.a] = s;
        ++this.a;
        this.c();
    }

    public void removeSegment(int n) {
        if (n < this.a) {
            this.b[n] = this.b[this.a - 1];
            this.c[n] = this.c[this.a - 1];
            this.d[n] = this.d[this.a - 1];
            --this.a;
            this.c();
        }
    }

    private void c() {
        for (int i = 1; i < this.a; ++i) {
            FXVector fXVector = this.b[i];
            FXVector fXVector2 = this.c[i];
            short s = this.d[i];
            for (int j = i - 1; j >= 0 && this.b[j].xFX > fXVector.xFX; --j) {
                this.b[j + 1] = this.b[j];
                this.c[j + 1] = this.c[j];
                this.d[j + 1] = this.d[j];
            }
            this.b[j + 1] = fXVector;
            this.c[j + 1] = fXVector2;
            this.d[j + 1] = s;
        }
    }

    protected final void a() {
        this.g = 0;
        this.h = new int[32];
        this.i = 0;
        this.j = 0;
    }

    protected final void a(World world, Body body) {
        int n;
        int n2;
        if (!body.e) {
            return;
        }
        if ((body.n & this.e.n) != 0) {
            return;
        }
        for (n2 = 0; n2 < this.i; ++n2) {
            if (this.h[n2] == -1 || this.c[this.h[n2]].xFX >= body.j) continue;
            --this.j;
            this.h[n2] = -1;
        }
        n2 = 0;
        while (this.g < this.a && this.b[this.g].xFX < body.k) {
            if (this.c[this.g].xFX < body.j) {
                ++this.g;
                continue;
            }
            n = 1;
            while (n2 < this.i) {
                if (this.h[n2] == -1) {
                    this.h[n2] = this.g;
                    ++this.j;
                    n = 0;
                    break;
                }
                ++n2;
            }
            if (n != 0) {
                this.h = World.a(this.h, this.i);
                this.h[this.i++] = this.g;
                ++this.j;
            }
            if (this.i > this.j << 1) {
                this.i = World.b(this.h, this.i);
            }
            ++this.g;
        }
        for (n = 0; n < this.i; ++n) {
            if (this.h[n] < 0 || body.l > Math.max(this.c[this.h[n]].yFX, this.b[this.h[n]].yFX) || Math.min(this.b[this.h[n]].yFX, this.c[this.h[n]].yFX) > body.m) continue;
            int n3 = this.h[n];
            Body body2 = body;
            World world2 = world;
            Landscape landscape = this;
            if (body2.h instanceof MultiShape) {
                int n4 = ((MultiShape)body2.h).getShapeCount();
                for (int i = 0; i < n4; ++i) {
                    Contact contact = Collision.a(body2, i, landscape, n3);
                    if (contact == null) continue;
                    world2.e = World.a(world2.e, world2.d);
                    world2.e[world2.d] = contact;
                    ++world2.d;
                }
                continue;
            }
            Contact contact = Collision.a(body2, landscape, n3);
            if (contact == null) continue;
            world2.e = World.a(world2.e, world2.d);
            world2.e[world2.d] = contact;
            ++world2.d;
        }
    }

    protected final void b() {
        for (int i = 0; i < this.k; ++i) {
            if (this.l[i] == null || this.l[i].g) continue;
            if (World.f < World.g.length) {
                World.g[World.f++] = this.l[i];
                this.l[i].g = true;
            }
            this.l[i] = null;
        }
        Landscape landscape = this;
        int n = landscape.k;
        int n2 = 0;
        for (int i = landscape.k - 1; n2 < i; --i) {
            while (landscape.l[n2] != null && n2 < i) {
                ++n2;
            }
            while (landscape.l[i] == null && n2 < i) {
                --i;
            }
            if (n2 >= i) continue;
            landscape.l[n2] = landscape.l[i];
            landscape.l[i] = null;
            n = i;
        }
        while (n > 0 && landscape.l[n - 1] == null) {
            --n;
        }
        landscape.k = n;
    }

    protected final void a(Contact contact) {
        this.l = World.a(this.l, this.k);
        this.l[this.k] = contact;
        ++this.k;
    }

    public Contact[] getContacts() {
        return this.l;
    }

    public final void fillVertices(FXVector[] fXVectorArray, Contact contact, int n) {
        int n2 = contact.a == this.e ? contact.b : contact.d;
        fXVectorArray[0] = this.b[n2];
        fXVectorArray[1] = this.c[n2];
    }

    protected final Contact a(Body body, int n, int n2) {
        for (int i = 0; i < this.k; ++i) {
            Contact contact = this.l[i];
            if (contact == null || (contact.a != body || n != contact.b || n2 != contact.d) && (contact.c != body || n != contact.d || n2 != contact.b)) continue;
            return this.l[i];
        }
        return null;
    }

    public void collideParticles(ParticleEmitter particleEmitter) {
        int n = 0;
        for (int i = 0; i < this.a; ++i) {
            while (n < particleEmitter.a && (particleEmitter.g[n] <= 0 || this.b[i].xFX > particleEmitter.c[n] && this.b[i].xFX > particleEmitter.e[n])) {
                ++n;
            }
            for (int j = n; j < particleEmitter.a && (particleEmitter.g[j] <= 0 || this.c[i].xFX > particleEmitter.c[j] || this.c[i].xFX > particleEmitter.e[j]); ++j) {
                FXVector fXVector;
                if (particleEmitter.g[j] <= 0 || (fXVector = Collision.a(this, i, particleEmitter.c[j], particleEmitter.d[j], particleEmitter.e[j], particleEmitter.f[j])) == null) continue;
                particleEmitter.a(fXVector, j);
            }
        }
    }

    public Body getBody() {
        return this.e;
    }

    public Shape getShape() {
        return this.f;
    }

    public int segmentCount() {
        return this.a;
    }

    public FXVector[] elementStartPoints() {
        return this.b;
    }

    public FXVector[] elementEndPoints() {
        return this.c;
    }

    public FXVector startPoint(int n) {
        return this.b[n];
    }

    public FXVector endPoint(int n) {
        return this.c[n];
    }
}

