/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class Shape {
    protected FXVector[] d;
    int[] e;
    int f = 0;
    private int a;
    int g;
    private int b;
    int h;
    long i = 0L;
    protected int j = 0;
    protected int k = 1024;
    int l = 4096;
    long m = 0x1000000L;
    long n = 4096L;
    long o = 0x1000000L;
    int p = -1;
    protected UserData q = null;
    protected FXVector r = new FXVector();
    public static final int MAX_MASS_FX = 0x1000001;

    public static Shape createRectangle(int n, int n2) {
        FXVector[] fXVectorArray = new FXVector[4];
        FXVector[] fXVectorArray2 = fXVectorArray;
        fXVectorArray[0] = new FXVector(-(n <<= 12) / 2, -(n2 <<= 12) / 2);
        fXVectorArray2[1] = new FXVector(-n / 2, n2 / 2);
        fXVectorArray2[2] = new FXVector(n / 2, n2 / 2);
        fXVectorArray2[3] = new FXVector(n / 2, -n2 / 2);
        return new Shape(fXVectorArray2);
    }

    public static Shape createCircle(int n) {
        FXVector[] fXVectorArray = new FXVector[1];
        FXVector[] fXVectorArray2 = fXVectorArray;
        fXVectorArray[0] = new FXVector(0, n << 12);
        return new Shape(fXVectorArray2);
    }

    public static Shape createRegularPolygon(int n, int n2) {
        FXVector[] fXVectorArray = new FXVector[n2];
        FXVector fXVector = new FXVector(0, n << 12);
        for (int i = 0; i < n2; ++i) {
            FXMatrix fXMatrix = FXMatrix.createRotationMatrix((int)(105414356L * (long)((i << 1) + 1) / (long)(n2 << 1)));
            fXVectorArray[n2 - 1 - i] = fXMatrix.mult(fXVector);
        }
        return new Shape(fXVectorArray);
    }

    public static Shape loadShape(PhysicsFileReader object, UserData userData) {
        int n = ((PhysicsFileReader)object).getVersion();
        if (n <= 512) {
            ((PhysicsFileReader)object).next();
        }
        int n2 = ((PhysicsFileReader)object).next();
        FXVector[] fXVectorArray = new FXVector[n2];
        for (int i = 0; i < n2; ++i) {
            fXVectorArray[i] = ((PhysicsFileReader)object).nextVector();
        }
        Shape shape = new Shape(fXVectorArray);
        shape.setElasticityFX(((PhysicsFileReader)object).nextIntFX());
        shape.setFrictionFX(((PhysicsFileReader)object).nextIntFX());
        if (n >= 1280) {
            shape.setMassFX(((PhysicsFileReader)object).nextIntFX());
        }
        if (((PhysicsFileReader)object).getVersion() > 1536) {
            object = ((PhysicsFileReader)object).nextString();
            if (userData != null) {
                shape.q = userData.createNewUserData((String)object, 2);
            }
        }
        return shape;
    }

    public Shape(FXVector[] fXVectorArray) {
        if (fXVectorArray.length > 12) {
            return;
        }
        this.d = fXVectorArray;
        this.c();
        this.setMass(1);
    }

    public Shape(Shape shape) {
        this.d = new FXVector[shape.d.length];
        System.arraycopy(shape.d, 0, this.d, 0, this.d.length);
        this.setElasticityFX(shape.j);
        this.setFrictionFX(shape.k);
        this.c();
        this.setMassFX(shape.l);
        if (shape.q != null) {
            this.q = shape.q.copy();
        }
    }

    protected Shape() {
    }

    protected final void c() {
        this.a();
        this.a = 0;
        for (int i = 0; i < this.d.length; ++i) {
            FXVector fXVector = this.d[i];
            if (fXVector.lengthSquare() <= this.a * this.a) continue;
            this.a = fXVector.lengthFX() >> 12;
        }
        this.g = this.a << 12;
        this.b();
        Shape shape = this;
        this.b = this.h = shape.g << 1;
        for (int i = 0; i < shape.e.length && shape.e[i] >= 0; i += 2) {
            long l;
            FXVector fXVector = new FXVector(shape.d[shape.e[i]]);
            fXVector.subtract(shape.d[shape.e[i + 1]]);
            fXVector.normalize();
            long l2 = l = (long)shape.d[0].xFX * (long)fXVector.yFX - (long)shape.d[0].yFX * (long)fXVector.xFX >> 12;
            for (int j = 1; j < shape.d.length; ++j) {
                long l3 = (long)shape.d[j].xFX * (long)fXVector.yFX - (long)shape.d[j].yFX * (long)fXVector.xFX >> 12;
                if (l3 < l2) {
                    l2 = l3;
                    continue;
                }
                if (l3 <= l) continue;
                l = l3;
            }
            if ((long)shape.h < l - l2) {
                shape.h = (int)(l - l2);
            }
            if ((long)shape.b <= l - l2) continue;
            shape.b = (int)(l - l2);
        }
    }

    public void correctCentroid() {
        if (this.d.length < 3) {
            return;
        }
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        int n2 = this.d.length - 1;
        while (n < this.d.length) {
            long l3 = (long)this.d[n].xFX * (long)this.d[n2].yFX - (long)this.d[n].yFX * (long)this.d[n2].xFX >> 12;
            l += l3 * (long)(this.d[n].xFX + this.d[n2].xFX) >> 12;
            l2 += l3 * (long)(this.d[n].yFX + this.d[n2].yFX) >> 12;
            n2 = n++;
        }
        l = (l << 12) / (this.i * 6L);
        l2 = (l2 << 12) / (this.i * 6L);
        for (n = 0; n < this.d.length; ++n) {
            this.d[n].subtract(new FXVector((int)l, (int)l2));
        }
        this.c();
    }

    public FXVector[] getCorners() {
        return this.d;
    }

    public int getBoundingRadiusSquare() {
        return this.a * this.a;
    }

    public int getBoundingRadiusFX() {
        return this.g;
    }

    void a() {
        if (this.d.length == 1) {
            this.e = new int[0];
            this.f = 0;
            return;
        }
        this.e = new int[this.d.length << 1];
        Vector<FXVector> vector = new Vector<FXVector>();
        int n = 0;
        int n2 = this.d.length - 1;
        while (n < this.d.length) {
            FXVector fXVector = new FXVector(this.d[n]);
            fXVector.subtract(this.d[n2]);
            fXVector.normalize();
            boolean bl = true;
            for (int i = 0; i < vector.size(); ++i) {
                FXVector fXVector2 = (FXVector)vector.elementAt(i);
                if (Math.abs((long)fXVector.xFX * (long)fXVector2.xFX + (long)fXVector.yFX * (long)fXVector2.yFX >> 12) <= 4088L) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.e[vector.size() << 1] = n;
                this.e[(vector.size() << 1) + 1] = n2;
                vector.addElement(fXVector);
            }
            n2 = n++;
        }
        this.f = vector.size() << 1;
        for (n = vector.size() << 1; n < this.e.length; ++n) {
            this.e[n] = -1;
        }
    }

    public void setFriction(int n) {
        this.k = (n << 12) / 100;
    }

    public void setFrictionFX(int n) {
        this.k = n;
    }

    public int getFrictionFX() {
        return this.k;
    }

    public void setElasticity(int n) {
        this.j = (n << 12) / 100;
    }

    public void setElasticityFX(int n) {
        this.j = n;
    }

    public int getElasticityFX() {
        return this.j;
    }

    public final void setMass(int n) {
        this.setMassFX(n << 12);
    }

    public final void setMassFX(int n) {
        if (this.i == 0L) {
            this.n = 0x1000001L;
            this.m = 0L;
            this.o = 0L;
            return;
        }
        this.l = n;
        this.m = 0x1000000000L / (long)n;
        this.b();
    }

    public int getMass() {
        return this.l >> 12;
    }

    public int getMassFX() {
        return this.l;
    }

    public int getId() {
        return this.p;
    }

    public long getAreaFX() {
        return this.i;
    }

    void b() {
        this.i = 0L;
        this.n = 0L;
        if (this.d.length == 1) {
            this.i = 52707178L * (long)((int)((long)this.g * (long)this.g) >> 24) >> 12;
            this.n = (int)((long)(this.l / 2) * (long)this.g * (long)this.g >> 24);
        } else if (this.d.length > 2) {
            for (int i = 0; i < this.d.length; ++i) {
                FXVector fXVector = this.d[i];
                FXVector fXVector2 = this.d[i + 1 >= this.d.length ? 0 : i + 1];
                long l = (long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12;
                this.i += l / 2L;
                long l2 = fXVector.xFX;
                long l3 = fXVector.yFX;
                long l4 = fXVector2.xFX;
                long l5 = fXVector2.yFX;
                long l6 = (int)((l2 * l2 + l4 * l2 + l4 * l4) / 12L >> 12);
                long l7 = (int)((l3 * l3 + l5 * l3 + l5 * l5) / 12L >> 12);
                this.n += l * (l6 + l7) >> 12;
            }
            this.n = (this.n << 12) / this.i * (long)this.l >> 12;
        }
        if (this.i > 0L) {
            long l = 0L;
            long l8 = 0L;
            int n = 0;
            int n2 = this.d.length - 1;
            while (n < this.d.length) {
                long l9 = (long)this.d[n].xFX * (long)this.d[n2].yFX - (long)this.d[n].yFX * (long)this.d[n2].xFX >> 12;
                l += l9 * (long)(this.d[n].xFX + this.d[n2].xFX) >> 12;
                l8 += l9 * (long)(this.d[n].yFX + this.d[n2].yFX) >> 12;
                n2 = n++;
            }
            l = (l << 12) / (this.i * 6L);
            l8 = (l8 << 12) / (this.i * 6L);
            this.r.assignFX((int)l, (int)l8);
        } else {
            this.r.assignFX(0, 0);
        }
        this.n += (long)this.l * (long)this.r.lengthSquareFX() >> 12;
        if (this.n == 0L) {
            this.o = Integer.MAX_VALUE;
            return;
        }
        this.o = 0x1000000000L / this.n;
    }

    protected final void a(FXVector fXVector, FXMatrix fXMatrix, FXVector[] fXVectorArray) {
        if (fXVectorArray.length < this.d.length) {
            return;
        }
        for (int i = 0; i < this.d.length; ++i) {
            fXMatrix.mult(this.d[i], fXVectorArray[i]);
            fXVectorArray[i].xFX += fXVector.xFX;
            fXVectorArray[i].yFX += fXVector.yFX;
        }
    }

    public UserData getUserData() {
        return this.q;
    }

    public void setUserData(UserData userData) {
        this.q = userData;
    }
}

