/*
 * Decompiled with CFR 0.152.
 */
package org.json.me;

import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class JSONTokener {
    private int a = 0;
    private String b;

    public JSONTokener(String string) {
        this.b = string;
    }

    public void back() {
        if (this.a > 0) {
            --this.a;
        }
    }

    public static int dehexchar(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 55;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 87;
        }
        return -1;
    }

    public boolean more() {
        return this.a < this.b.length();
    }

    public char next() {
        if (this.more()) {
            char c2 = this.b.charAt(this.a);
            ++this.a;
            return c2;
        }
        return '\u0000';
    }

    public char next(char c2) {
        char c3 = this.next();
        if (c3 != c2) {
            throw this.syntaxError("Expected '" + c2 + "' and instead saw '" + c3 + "'.");
        }
        return c3;
    }

    public String next(int n) {
        int n2 = this.a;
        int n3 = n2 + n;
        if (n3 >= this.b.length()) {
            throw this.syntaxError("Substring bounds error");
        }
        this.a += n;
        return this.b.substring(n2, n3);
    }

    public char nextClean() {
        char c2;
        block4: while (true) {
            if ((c2 = this.next()) == '/') {
                switch (this.next()) {
                    case '/': {
                        while ((c2 = this.next()) != '\n' && c2 != '\r' && c2 != '\u0000') {
                        }
                        continue block4;
                    }
                    case '*': {
                        while (true) {
                            if ((c2 = this.next()) == '\u0000') {
                                throw this.syntaxError("Unclosed comment.");
                            }
                            if (c2 != '*') continue;
                            if (this.next() == '/') continue block4;
                            this.back();
                        }
                    }
                }
                this.back();
                return '/';
            }
            if (c2 == '#') {
                while ((c2 = this.next()) != '\n' && c2 != '\r' && c2 != '\u0000') {
                }
                continue;
            }
            if (c2 == '\u0000' || c2 > ' ') break;
        }
        return c2;
    }

    public String nextString(char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        block13: while (true) {
            char c3 = this.next();
            switch (c3) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    c3 = this.next();
                    switch (c3) {
                        case 'b': {
                            stringBuffer.append('\b');
                            continue block13;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            stringBuffer.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            stringBuffer.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            stringBuffer.append((char)Integer.parseInt(this.next(4), 16));
                            continue block13;
                        }
                        case 'x': {
                            stringBuffer.append((char)Integer.parseInt(this.next(2), 16));
                            continue block13;
                        }
                    }
                    stringBuffer.append(c3);
                    continue block13;
                }
            }
            if (c3 == c2) {
                return stringBuffer.toString();
            }
            stringBuffer.append(c3);
        }
    }

    public String nextTo(char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            char c3;
            if ((c3 = this.next()) == c2 || c3 == '\u0000' || c3 == '\n' || c3 == '\r') {
                if (c3 != '\u0000') {
                    this.back();
                }
                return stringBuffer.toString().trim();
            }
            stringBuffer.append(c3);
        }
    }

    public String nextTo(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            char c2;
            if (string.indexOf(c2 = this.next()) >= 0 || c2 == '\u0000' || c2 == '\n' || c2 == '\r') {
                if (c2 != '\u0000') {
                    this.back();
                }
                return stringBuffer.toString().trim();
            }
            stringBuffer.append(c2);
        }
    }

    public Object nextValue() {
        char c2 = this.nextClean();
        switch (c2) {
            case '\"': 
            case '\'': {
                return this.nextString(c2);
            }
            case '{': {
                this.back();
                return new JSONObject(this);
            }
            case '[': {
                this.back();
                return new JSONArray(this);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c3 = c2;
        while (c2 >= ' ' && ",:]}/\\\"[{;=#".indexOf(c2) < 0) {
            stringBuffer.append(c2);
            c2 = this.next();
        }
        this.back();
        String string = stringBuffer.toString().trim();
        if (string.equals("")) {
            throw this.syntaxError("Missing value.");
        }
        if (string.toLowerCase().equals("true")) {
            return Boolean.TRUE;
        }
        if (string.toLowerCase().equals("false")) {
            return Boolean.FALSE;
        }
        if (string.toLowerCase().equals("null")) {
            return JSONObject.NULL;
        }
        if (c3 >= '0' && c3 <= '9' || c3 == '.' || c3 == '-' || c3 == '+') {
            if (c3 == '0') {
                if (string.length() > 2 && (string.charAt(1) == 'x' || string.charAt(1) == 'X')) {
                    try {
                        return new Integer(Integer.parseInt(string.substring(2), 16));
                    }
                    catch (Exception exception) {
                    }
                } else {
                    try {
                        return new Integer(Integer.parseInt(string, 8));
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                return Integer.valueOf(string);
            }
            catch (Exception exception) {
                try {
                    return new Long(Long.parseLong(string));
                }
                catch (Exception exception2) {
                    try {
                        return Double.valueOf(string);
                    }
                    catch (Exception exception3) {
                        return string;
                    }
                }
            }
        }
        return string;
    }

    public char skipTo(char c2) {
        char c3;
        int n = this.a;
        do {
            if ((c3 = this.next()) != '\u0000') continue;
            this.a = n;
            return c3;
        } while (c3 != c2);
        this.back();
        return c3;
    }

    public void skipPast(String string) {
        this.a = this.b.indexOf(string, this.a);
        if (this.a < 0) {
            this.a = this.b.length();
            return;
        }
        this.a += string.length();
    }

    public JSONException syntaxError(String string) {
        return new JSONException(string + this.toString());
    }

    public String toString() {
        return " at character " + this.a + " of " + this.b;
    }
}

