/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.utility;

import javax.microedition.lcdui.Image;

public class PixelMixingScaler {
    public static Image scaleImage(Image originalImage, int newWidth, int newHeight) {
        if (newWidth <= 0 || newHeight <= 0 || originalImage == null) {
            throw new IllegalArgumentException("Invalid width or height or the given image is null!");
        }
        int sourceWidth = originalImage.getWidth();
        int sourceHeight = originalImage.getHeight();
        int[] originalRgb = new int[sourceHeight * sourceWidth];
        originalImage.getRGB(originalRgb, 0, sourceWidth, 0, 0, sourceWidth, sourceHeight);
        int[] scaledRgb = new int[newWidth * newHeight];
        int oWidth = sourceWidth;
        int[] oX16 = new int[newWidth + 1];
        for (int newX = 0; newX <= newWidth; ++newX) {
            oX16[newX] = (newX * oWidth << 4) / newWidth;
        }
        int[] oXStartWidth = new int[newWidth];
        int[] oXEndWidth = new int[newWidth];
        for (int newX = 0; newX < newWidth; ++newX) {
            oXStartWidth[newX] = 16 - oX16[newX] % 16;
            oXEndWidth[newX] = oX16[newX + 1] % 16;
        }
        int oHeight = sourceHeight;
        int[] oY16 = new int[newHeight + 1];
        for (int newY = 0; newY <= newHeight; ++newY) {
            oY16[newY] = (newY * oHeight << 4) / newHeight;
        }
        for (int newY = 0; newY < newHeight; ++newY) {
            int oY16Start = oY16[newY];
            int oY16End = oY16[newY + 1];
            int oYStart = oY16Start >>> 4;
            int oYEnd = oY16End >>> 4;
            int oYStartHeight = 16 - oY16Start % 16;
            int oYEndHeight = oY16End % 16;
            for (int newX = 0; newX < newWidth; ++newX) {
                int oX16Start = oX16[newX];
                int oX16End = oX16[newX + 1];
                int oXStart = oX16Start >>> 4;
                int oXEnd = oX16End >>> 4;
                int outArea = 0;
                int outColorArea = 0;
                int outAlpha = 0;
                int outRed = 0;
                int outGreen = 0;
                int outBlue = 0;
                for (int j = oYStart; j <= oYEnd; ++j) {
                    int areaHeight = 16;
                    if (oYStart == oYEnd) {
                        areaHeight = oY16End - oY16Start;
                    } else if (j == oYStart) {
                        areaHeight = oYStartHeight;
                    } else if (j == oYEnd) {
                        areaHeight = oYEndHeight;
                    }
                    if (areaHeight == 0) continue;
                    for (int i = oXStart; i <= oXEnd; ++i) {
                        int areaWidth = 16;
                        if (oXStart == oXEnd) {
                            areaWidth = oX16End - oX16Start;
                        } else if (i == oXStart) {
                            areaWidth = oXStartWidth[newX];
                        } else if (i == oXEnd) {
                            areaWidth = oXEndWidth[newX];
                        }
                        if (areaWidth == 0) continue;
                        int area = areaWidth * areaHeight;
                        outArea += area;
                        int argb = originalRgb[i + j * sourceWidth];
                        int a2 = argb >>> 24;
                        if (a2 == 0) continue;
                        area = a2 * area;
                        outColorArea += area;
                        int r = (argb & 0xFF0000) >>> 16;
                        int g = (argb & 0xFF00) >>> 8;
                        int b = argb & 0xFF;
                        outRed += area * r;
                        outGreen += area * g;
                        outBlue += area * b;
                    }
                }
                if (outColorArea > 0) {
                    outAlpha = outColorArea / outArea;
                    outRed /= outColorArea;
                    outGreen /= outColorArea;
                    outBlue /= outColorArea;
                }
                scaledRgb[newX + newY * newWidth] = outAlpha << 24 | outRed << 16 | outGreen << 8 | outBlue;
            }
        }
        return Image.createRGBImage((int[])scaledRgb, (int)newWidth, (int)newHeight, (boolean)true);
    }

    public String type() {
        return "Pixel mixing";
    }
}

