/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.utility;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class PlayAudioFille
implements PlayerListener {
    public static final String FORMAT_TYPE_AMR = "audio/amr";
    public static final String FORMAT_TYPE_WAV = "audio/x-wav";
    VolumeControl volume;
    long mDuration;
    private PlayAudioFille mPlayAudioFille;
    private int mAudio_File_Id;
    String mFile_Resource_Path;
    private CallBack mCallBack;
    Player mPlayer = null;

    public PlayAudioFille(CallBack aCallback) {
        this.mCallBack = aCallback;
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("endOfMedia") && this.mCallBack != null) {
            this.mCallBack.fileReachedEndOfMedia(this.mAudio_File_Id);
        }
    }

    public Player playSample(String filename, boolean aIsLoopingOn, int aPlayerNumber, String fileformat) {
        Player player = null;
        boolean execute = true;
        if (this.mFile_Resource_Path != null) {
            execute = this.mFile_Resource_Path.compareTo(filename) != 0;
        }
        if (execute) {
            this.stopAll();
            this.mFile_Resource_Path = filename;
            this.mAudio_File_Id = aPlayerNumber;
            InputStream stream = this.getClass().getResourceAsStream("/res/" + filename);
            try {
                this.mPlayer = Manager.createPlayer((InputStream)stream, (String)fileformat);
                if (aIsLoopingOn) {
                    this.mPlayer.setLoopCount(100);
                }
                this.mPlayer.realize();
                this.volume = (VolumeControl)this.mPlayer.getControl("VolumeControl");
                this.mPlayer.prefetch();
                this.mPlayer.addPlayerListener((PlayerListener)this);
                this.mPlayer.start();
                this.mDuration = this.mPlayer.getDuration() / 1000000L;
            }
            catch (Exception e) {
                System.out.println("Error" + e.toString());
            }
        } else {
            try {
                if (this.mPlayer != null) {
                    this.mPlayer.setMediaTime(0L);
                    this.mPlayer.start();
                }
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
        }
        return player;
    }

    public void setVolume(int level) {
        this.volume.setLevel(level);
    }

    public int getVolume() {
        return this.volume.getLevel();
    }

    public int getDuration() {
        return (int)this.mDuration;
    }

    public void stopPlayer(Player player) {
        PlayAudioFille.stop(player);
    }

    private static synchronized void stop(Player player) {
        try {
            if (player.getState() == 400) {
                try {
                    player.stop();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            player.deallocate();
            player.close();
            player = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopAll() {
        if (this.mPlayer != null) {
            PlayAudioFille.stop(this.mPlayer);
            this.mPlayer = null;
            this.mFile_Resource_Path = null;
        }
    }

    public static interface CallBack {
        public void fileReachedEndOfMedia(int var1);
    }
}

