/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.utility;

import com.twistfuture.app.GeneralFunction;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ProgressBar {
    callRepaint mCallRepaint;
    private String mPrintString;
    private boolean mProgressBarStatus;
    private Thread mProgressThread;
    private int mProgressBarCounter = 0;
    private int mRectSize;
    private int mVerSpace = this.mRectSize = 10;
    private final int mRectPrintLimit;
    private int mYCordi = 70;
    private int mDrawRectColor = 0;
    private int mFillRectColor = 65280;
    private int mStringColor = this.mDrawRectColor;
    Font font = Font.getFont((int)32, (int)2, (int)0);

    public ProgressBar(String aPrintString, callRepaint aCaRepaint) {
        this.mRectPrintLimit = 5;
        this.mPrintString = aPrintString;
        this.mCallRepaint = aCaRepaint;
    }

    private void progressBarThread() {
        this.mProgressThread = new Thread(new Runnable(){

            public void run() {
                while (ProgressBar.this.mProgressBarStatus) {
                    ProgressBar.this.mProgressBarCounter++;
                    if (ProgressBar.this.mProgressBarCounter > 5) {
                        ProgressBar.this.mProgressBarCounter = 0;
                    }
                    ProgressBar.this.mCallRepaint.callRepaint();
                    GeneralFunction.sleepThread(100);
                }
            }
        });
    }

    public void paint(Graphics g) {
        if (this.mProgressBarStatus) {
            int x1;
            int i;
            g.setFont(this.font);
            int MID_X = (240 - this.font.stringWidth(this.mPrintString)) / 2;
            int MID_Y = (320 - this.font.getHeight()) / 2 + this.mYCordi;
            int x = (240 - (5 * this.mRectSize + 4 * this.mVerSpace)) / 2;
            g.setColor(this.mStringColor);
            g.drawString(this.mPrintString, MID_X, MID_Y, 0);
            int y = MID_Y + 30;
            g.setColor(this.mDrawRectColor);
            for (i = 0; i < 5; ++i) {
                x1 = x + (this.mRectSize + this.mVerSpace) * i;
                g.drawRect(x1, y, this.mRectSize, this.mRectSize);
            }
            g.setColor(this.mFillRectColor);
            for (i = 0; i < this.mProgressBarCounter; ++i) {
                x1 = x + (this.mRectSize + this.mVerSpace) * i;
                g.fillRect(x1, y, this.mRectSize, this.mRectSize);
            }
        }
    }

    public void start() {
        if (this.mProgressThread == null) {
            this.progressBarThread();
            this.mProgressBarStatus = true;
            this.mProgressThread.start();
        }
    }

    public boolean stop() {
        this.mProgressBarStatus = false;
        this.mProgressThread = null;
        return true;
    }

    public void setY(int yCordi) {
        this.mYCordi = yCordi;
    }

    public int getY() {
        return this.mYCordi;
    }

    public void setRectColor(int rectColor) {
        this.mDrawRectColor = rectColor;
    }

    public void setRectFillColor(int fillRectColor) {
        this.mFillRectColor = fillRectColor;
    }

    public void setRectSize(int rectSize) {
        this.mRectSize = rectSize;
    }

    public void setStringColor(int stringColor) {
        this.mStringColor = stringColor;
    }

    public static interface callRepaint {
        public void callRepaint();
    }
}

