/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.utility;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class ZLIB {
    static final int BLOCK_SIZE = 32000;

    ZLIB() {
    }

    public static byte[] toZLIB(byte[] raw) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 6 + raw.length / 32000 * 5);
        DataOutputStream zlib = new DataOutputStream(baos);
        int tmp = 8;
        zlib.writeByte(tmp);
        zlib.writeByte((31 - (tmp << 8) % 31) % 31);
        int pos = 0;
        while (raw.length - pos > 32000) {
            ZLIB.writeUncompressedDeflateBlock(zlib, false, raw, pos, '\u7d00');
            pos += 32000;
        }
        ZLIB.writeUncompressedDeflateBlock(zlib, true, raw, pos, (char)(raw.length - pos));
        zlib.writeInt(ZLIB.calcADLER32(raw));
        return baos.toByteArray();
    }

    private static void writeUncompressedDeflateBlock(DataOutputStream zlib, boolean last, byte[] raw, int off, char len) throws IOException {
        zlib.writeByte((byte)(last ? 1 : 0));
        zlib.writeByte((byte)(len & 0xFF));
        zlib.writeByte((byte)((len & 0xFF00) >> 8));
        zlib.writeByte((byte)(~len & 0xFF));
        zlib.writeByte((byte)((~len & 0xFF00) >> 8));
        zlib.write(raw, off, len);
    }

    private static int calcADLER32(byte[] raw) {
        int s1 = 1;
        int s2 = 0;
        for (int i = 0; i < raw.length; ++i) {
            int abs = raw[i] < 0 ? raw[i] + 256 : raw[i];
            s1 = (s1 + abs) % 65521;
            s2 = (s2 + s1) % 65521;
        }
        return (s2 << 16) + s1;
    }
}

